

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Common.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture common entries from source commcell needed for
--  |                   validation before merge in the destination commcell.
--  +========================================================================+
-- $Id: CCM_Capture_Common.sp,v 1.14.60.3 2018/07/02 03:44:01 kbora Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_Common')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_Common <<<'
	drop procedure CCM_Capture_Common
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Common')
	delete from GxQscripts where name = 'CCM_Capture_Common'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Common')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Common'
GO
print '... Creating Procedure: CCM_Capture_Common'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Common
  @i_jobId integer,
  @i_captureToVersion varchar(10)
AS
  DECLARE @errStr varchar(1024);
SET NOCOUNT ON
BEGIN TRANSACTION CCMCOMMON
DECLARE @errorCode Integer
	SET @errorCode = 0
--Code Below Here is From CCM_Capture_Common.spb
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	IF NOT EXISTS (SELECT * FROM MASTER..SYSDATABASES WHERE NAME = 'CommServ_Capture')
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- DATABASE CommServ_Capture DOES NOT EXIST'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simAllGalaxyRel
	INSERT INTO CommServ_Capture..CCM_simAllGalaxyRel
	SELECT 	*
	FROM CCM_SOURCE_simAllGalaxyRel
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_simAllGalaxyRel'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_PatchDBSPInfo
	INSERT INTO CommServ_Capture..CCM_PatchDBSPInfo
	SELECT A.*
	FROM CCM_SOURCE_PatchDBSPInfo A LEFT JOIN CommServ_Capture..CCM_PatchDBSPInfo B ON A.SPNumber = B.SPNumber
	WHERE B.SPNumber IS NULL
	-- Capture the list of the clients in the common dump
	-- for the client limit check to be done in the merge side
	IF EXISTS (SELECT 1 FROM CCMCaptureEntities WHERE jobId = @i_jobId  AND type = 7 )
	BEGIN
		DECLARE @currentValue 	NVARCHAR(MAX) = ''
		SELECT @currentValue = @currentValue + value + '_'  FROM CCMCaptureEntities
		WHERE jobId = @i_jobId
		  AND type = 7 -- EntityType_SUBCLIENT_ENTITY (CvEntitiesMsgs.h)
		SET @currentValue = LEFT(@currentValue, LEN(@currentValue)-1)
		IF OBJECT_ID('tempdb..#scList') IS NOT NULL DROP TABLE #scList
			CREATE TABLE #scList (scId INT)
		INSERT INTO #scList
		SELECT DISTINCT _id FROM SplitStringByDelimiter(@currentValue,'_')
		INSERT INTO CommServ_Capture..CCM_APP_Application
		SELECT A.* FROM CCM_SOURCE_APP_Application A INNER JOIN #scList B ON A.id = B.scId AND A.appTypeId <> 1000  -- DR Sub-Client isn't captured
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_APP_Application'
			GOTO CX_ERROR_EXIT
		END
	END
	INSERT INTO CommServ_Capture..CCM_APP_Client
	SELECT *
	FROM CCM_SOURCE_APP_Client
	WHERE id in (SELECT clientId FROM CommServ_Capture..CCM_APP_Application)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_APP_Client'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (SELECT 1 FROM CCMCaptureEntities WHERE jobId = @i_jobId  AND type = 11 )
	BEGIN
		DECLARE @MediaAgentList  NVARCHAR(MAX) = ''
		SET @MediaAgentList = ISNULL((SELECT value FROM CCMCaptureEntities WHERE jobId = @i_jobId AND type = 11),'')
		IF OBJECT_ID('tempdb..#MAList') IS NOT NULL DROP TABLE #MAList
			CREATE TABLE #MAList (Id INT)
		INSERT INTO #MAList
		SELECT DISTINCT _id FROM SplitStringByDelimiter(@MediaAgentList,'_')
		INSERT INTO CommServ_Capture..CCM_MMHost
		SELECT H.* FROM CCM_SOURCE_MMHost H INNER JOIN #MAList MA ON H.ClientId  = MA.id
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_MMHost'
			GOTO CX_ERROR_EXIT
		END
	END
	INSERT INTO CommServ_Capture..CCM_APP_Client
	SELECT *
	FROM CCM_SOURCE_APP_Client
	WHERE id in (SELECT clientId FROM CommServ_Capture..CCM_MMHost)
	  AND id not in (SELECT id FROM CommServ_Capture..CCM_APP_Client)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_APP_Client -- Media Agents'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_ClientProp
	INSERT INTO CommServ_Capture..CCM_APP_ClientProp
	SELECT * FROM CCM_SOURCE_APP_ClientProp
	WHERE componentNameId IN (SELECT id FROM CommServ_Capture..CCM_APP_Client)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_Common -- CCM_APP_ClientProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_LicUsage
	INSERT		INTO CommServ_Capture..CCM_LicUsage
	SELECT	* FROM CCM_SOURCE_LicUsage
	WHERE		CId IN ( SELECT id FROM CommServ_Capture..CCM_APP_Client )
	IF	@@ERROR > 0
	BEGIN
		SET	@errStr = 'ERROR: CCM_Capture_Common -- CCM_LicUsage'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	IF @errorCode <> 0 GOTO CX_ERROR_EXIT
	COMMIT	TRANSACTION CCMCOMMON
	SET @errStr = 'NO_ERROR'
	SELECT	0, @errStr
	RETURN  0
CX_ERROR_EXIT:
    ROLLBACK TRANSACTION CCMCOMMON
	SELECT	-1, @errStr
	RETURN  -1
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Common')
	delete from GxQscripts where name = 'CCM_Capture_Common'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Common')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Common'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Common',  '00010014006000030000', 'CCM_Capture_Common', '00010014006000030000')
GO

