

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Client_to_XML.sp] ---------- 

--  +=============================================================================================+
--  | Stored Procedure: Capture client to migrate into temp tables which will be converted to XML
--  +=============================================================================================+
-- $Id: CCM_Capture_Client_to_XML.sp,v 1.1.208.3 2018/12/27 16:38:15 vikashkumar Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Capture_Client_to_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_Client_to_XML <<<'
	drop procedure CCM_Capture_Client_to_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Client_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_Client_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Client_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Client_to_XML'
GO
print '... Creating Procedure: CCM_Capture_Client_to_XML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Capture_Client_to_XML
  @i_clientId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
--Code Below Here is From CCM_Capture_Client.spb
SET NOCOUNT ON
    -- Do not use transaction here, because it is called by another stored procedure with transaction
	---------------------------------------------------------
	IF @i_clientId > 0
	BEGIN
INSERT INTO #CCM_APP_Client
		SELECT *
		FROM CCM_SOURCE_APP_Client
		WHERE id = @i_clientId
AND NOT EXISTS (SELECT 1 FROM #CCM_APP_Client WHERE id = @i_clientId)
	END
	ELSE
	BEGIN
INSERT INTO #CCM_APP_Client
		SELECT DISTINCT A.*
FROM CCM_SOURCE_APP_Client A INNER JOIN #CCM_APP_Application B ON A.id = B.clientId
WHERE NOT EXISTS (SELECT 1 FROM #CCM_APP_Client WHERE id = A.id)
	END
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	--Update csHostName with the net_hostname of the cs client for all the clients which are pointing to this cs.
	DECLARE @csNetHostName varchar(1024)
	SELECT @csNetHostName = net_hostname FROM  CCM_SOURCE_APP_Client WHERE id = 2
UPDATE	#CCM_APP_Client
	SET		csHostName = @csNetHostName
WHERE	(specialClientFlags & 0x20) = 0 AND ISNULL(csHostName, '') <> ''
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- CommServ_Capture..CCM_APP_ClientProp
INSERT INTO #CCM_App_ClientProp
	SELECT	A.*
FROM CCM_SOURCE_APP_ClientProp A INNER JOIN #CCM_APP_Client B ON A.componentNameId = B.id
LEFT OUTER JOIN #CCM_App_ClientProp C ON A.id = C.id
	WHERE C.id IS NULL
	AND   A.attrName NOT IN ('Data Encryption',                    -- CS Specific Properties which need not be captured as CS is never migrated
						 'Data Verification',
						 'Data Multiplexing',
						 'Commcell Migration',
						 'Grid Store',
						 'Installed Content Addressed Storage',
						 'Installed DVD Support',
						 'Installed UDO Support',
						 'Installed CommCell Readiness Check',
						 'Installed Advanced FileSystem iDA Options',
						 'Installed 1-Touch Server for Windows',
						 'Installed Client Groups',
						 'Installed Advanced Copy Features',
						 'Installed Advanced Media Management Features',
						 'Installed Recovery Points',
						 'Active Directory Signon',
						 'Compliance Search',
						 'Legal Hold',
						 'Compliance Director',
						 'Tagging',
						 'Microsoft Office Sharepoint Server',
						 'CommNet Advanced Reporting',
						 'File Level Enabler for SRM',
						 'Library Sharing Across CommCells',
						 'SAP ArchiveLink',
						 'Vault Tracker AppType',
						 'GX Compliance',
						 'System Recovery Boot Server',
						 'Installed CommServe Database',
						 'PlatformDeleted 1',
						 'Commcell timezone Id',
						 'Free space available on Cache',
						 'Cache Current Usage',
						 'Cache Expected Usage',
						 'SRM Services',
						 'Installed CommServe Database',
						 'PlatformDeleted 2',
						 'PlatformDeleted 4',
						 -- skipping these MA analytics properties for temp migration, this should be enabled after name change if needed. Otherwise push MA delete fails.
						 'AnalyticSearchEngineEnabled',
						 'Analytics_index-dir',
						 'Analytics_Memory_MB',
						 'Analytics_baseport'
						  )
	AND   NOT EXISTS ( SELECT 1 from CCM_SOURCE_simAppTypeLicTypeMap where isCellLevel = 1 AND a.attrName = dbo.getlicensePropName(appTypeId))
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	/*
	By default we don’t migrate this property after SP15 update 65910, but we used to call deconfigure code which used to insert this missing property 'PlatformDeleted 4'.
	In SP16 update 68399, we stopped deconfigure call for discovers VMs so this property is missing.
	Because of this discovered V1 clients are appearing as configured post CCM.
	*/
INSERT INTO #CCM_App_ClientProp
	SELECT	A.*
FROM CCM_SOURCE_APP_ClientProp A INNER JOIN #CCM_APP_Client B ON A.componentNameId = B.id
LEFT OUTER JOIN #CCM_App_ClientProp C ON A.id = C.id
	WHERE C.id IS NULL
	AND   A.attrName = N'PlatformDeleted 4'
	AND EXISTS (SELECT 1 FROM CCM_SOURCE_APP_ClientProp D WHERE D.componentNameId = A.componentNameId AND D.attrName = N'Virtual Server Discovered Clients' AND D.attrVal = '1' AND D.modified = 0)
	AND NOT EXISTS (SELECT 1 FROM CCM_SOURCE_APP_APPlication APP WHERE APP.clientId = A.componentNameId)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
    DECLARE @WhereClause    nvarchar(1024)
SET @WhereClause = ' A INNER JOIN #CCM_App_ClientProp B ON A.ControlHostId = CAST(B.attrVal AS INT) AND B.attrName = ''Snap Control Host ID''
INNER JOIN #CCM_APP_Client C ON C.id = B.componentNameId '
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'SMControlHost', 'TEMPDB..#CCM_SMControlHost', '', @i_exportDBName, @WhereClause
    IF  @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- CommServ_Capture..CCM_APP_CredentialAssoc
INSERT INTO #CCM_APP_CredentialAssoc
	SELECT A.*
	FROM CCM_SOURCE_APP_CredentialAssoc A
INNER JOIN TEMPDB..#CCM_SMControlHost B ON A.assocId = B.CredentialId
LEFT OUTER JOIN #CCM_APP_CredentialAssoc C ON C.assocId = A.assocId
	WHERE C.assocId IS NULL
    IF  @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- CommServ_Capture..CCM_APP_Credentials
SET @WhereClause = ' A LEFT OUTER JOIN TEMPDB..#CCM_APP_Credentials B ON B.credentialId = A.credentialId
	WHERE B.credentialId IS NULL
AND EXISTS(SELECT 1 FROM #CCM_APP_CredentialAssoc C WHERE C.credentialId = A.credentialId) '
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'APP_Credentials', 'TEMPDB..#CCM_APP_Credentials', '', @i_exportDBName, @WhereClause
    IF  @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- CommServ_Capture..CCM_APP_Platform
INSERT INTO #CCM_App_Platform
	SELECT A.*
	FROM CCM_SOURCE_APP_Platform A
INNER JOIN #CCM_APP_Client B ON A.clientId = B.id
LEFT OUTER JOIN #CCM_App_Platform C ON C.clientId = A.clientId AND C.platformType = A.platformType
	WHERE C.clientId IS NULL
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-------------------------------- CAPTURE SECURITY INFO OF CLIENTS------------------------------------
	-------------------------------------------------------------------------------------------------------
	-- CommServ_Capture..CCM_PatchDBSPInfo
INSERT INTO #CCM_PatchDBSPInfo
	SELECT A.*
FROM CCM_SOURCE_PatchDBSPInfo A LEFT JOIN #CCM_PatchDBSPInfo B ON A.SPNumber = B.SPNumber
	WHERE B.SPNumber IS NULL
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	---------------------------------------------------------
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Client_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_Client_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Client_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Client_to_XML'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Client_to_XML',  '00010001020800030000', 'CCM_Capture_Client_to_XML', '00010001020800030000')
GO

