

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_Client_From_90.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_Client_From_90.sp,v 1.2.88.1 2018/03/20 00:29:48 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_Client_From_90 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_Client_From_90')
	drop procedure CCM_Capture_Client_From_90
IF EXISTS (select * from GxQscripts where name='CCM_Capture_Client_From_90')
	delete from GxQscripts where name = 'CCM_Capture_Client_From_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Client_From_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Client_From_90'
GO
print '... Creating Procedure: CCM_Capture_Client_From_90'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_Client_From_90
  @i_clientId integer
AS
--Code Below Here is From CCM_Capture_Client.spb
SET NOCOUNT ON
    -- Do not use transaction here, because it is called by another stored procedure with transaction
	---------------------------------------------------------
INSERT INTO CommServ_Capture..CCM_APP_Client
	SELECT
	*, name /*displayName*/
	FROM CCM_SOURCE_APP_Client
	WHERE id = @i_clientId
AND (SELECT count(*) FROM CommServ_Capture..CCM_APP_Client WHERE id = @i_clientId) = 0
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	--Update csHostName with the net_hostname of the cs client for all the clients which are pointing to this cs.
	DECLARE @csNetHostName varchar(1024)
	SELECT @csNetHostName = net_hostname FROM  CCM_SOURCE_APP_Client WHERE id = 2
UPDATE	CommServ_Capture..CCM_APP_Client
	SET		csHostName = @csNetHostName
WHERE	(specialClientFlags & 0x20) = 0 AND ISNULL(csHostName, '') <> ''
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- CommServ_Capture..CCM_APP_ClientProp
INSERT INTO CommServ_Capture..CCM_App_ClientProp
	SELECT
	A.*
FROM CCM_SOURCE_APP_ClientProp A INNER JOIN CommServ_Capture..CCM_APP_Client B ON A.componentNameId = B.id
LEFT OUTER JOIN CommServ_Capture..CCM_App_ClientProp C ON A.id = C.id
	WHERE B.id = @i_clientId AND C.id IS NULL
	AND   A.attrName NOT IN ('Data Encryption',                    -- CS Specific Properties which need not be captured as CS is never migrated
						 'Data Verification',
						 'Data Multiplexing',
						 'Commcell Migration',
						 'Grid Store',
						 'Installed Content Addressed Storage',
						 'Installed DVD Support',
						 'Installed UDO Support',
						 'Installed CommCell Readiness Check',
						 'Installed Advanced FileSystem iDA Options',
						 'Installed 1-Touch Server for Windows',
						 'Installed Client Groups',
						 'Installed Advanced Copy Features',
						 'Installed Advanced Media Management Features',
						 'Installed Recovery Points',
						 'Active Directory Signon',
						 'Compliance Search',
						 'Legal Hold',
						 'Compliance Director',
						 'Tagging',
						 'Microsoft Office Sharepoint Server',
						 'CommNet Advanced Reporting',
						 'File Level Enabler for SRM',
						 'Library Sharing Across CommCells',
						 'SAP ArchiveLink',
						 'Vault Tracker AppType',
						 'GX Compliance',
						 'System Recovery Boot Server',
						 'Installed CommServe Database',
						 'PlatformDeleted 1',
						 'Commcell timezone Id',
						 'Free space available on Cache',
						 'Cache Current Usage',
						 'Cache Expected Usage',
						 'SRM Services',
						 'Installed CommServe Database',
						 'PlatformDeleted 2',
						 -- skipping these MA analytics properties for temp migration, this should be enabled after name change if needed. Otherwise push MA delete fails.
						 'AnalyticSearchEngineEnabled',
						 'Analytics_index-dir',
						 'Analytics_Memory_MB',
						 'Analytics_baseport'
						  )
	AND   NOT EXISTS ( SELECT 1 from CCM_SOURCE_simAppTypeLicTypeMap where isCellLevel = 1 AND a.attrName = dbo.getlicensePropName(appTypeId))
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- CommServ_Capture..CCM_APP_Platform
INSERT INTO CommServ_Capture..CCM_App_Platform
	SELECT A.*
	FROM CCM_SOURCE_APP_Platform A
INNER JOIN CommServ_Capture..CCM_APP_Client B ON A.clientId = B.id
LEFT OUTER JOIN CommServ_Capture..CCM_App_Platform C ON C.clientId = A.clientId AND C.platformType = A.platformType
	WHERE C.clientId IS NULL
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- CommServ_Capture..CCM_PatchDBSPInfo
INSERT INTO CommServ_Capture..CCM_PatchDBSPInfo
	SELECT A.*
FROM CCM_SOURCE_PatchDBSPInfo A LEFT JOIN CommServ_Capture..CCM_PatchDBSPInfo B ON A.SPNumber = B.SPNumber
	WHERE B.SPNumber IS NULL
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	---------------------------------------------------------
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_Client_From_90')
	delete from GxQscripts where name = 'CCM_Capture_Client_From_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_Client_From_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_Client_From_90'
GO

insert into GXDBVersions values(2, 'CCM_Capture_Client_From_90',  '00010002008800010000', 'CCM_Capture_Client_From_90', '00010002008800010000')
GO

