

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_ClientGroup_Default.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client group to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_ClientGroup_Default.sp,v 1.2.80.2 2018/03/20 00:33:49 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_ClientGroup_Default <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_ClientGroup_Default')
	drop procedure CCM_Capture_ClientGroup_Default
IF EXISTS (select * from GxQscripts where name='CCM_Capture_ClientGroup_Default')
	delete from GxQscripts where name = 'CCM_Capture_ClientGroup_Default'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_ClientGroup_Default')
	delete from GXDBVersions where aliasname = 'CCM_Capture_ClientGroup_Default'
GO
print '... Creating Procedure: CCM_Capture_ClientGroup_Default'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_ClientGroup_Default
  @i_clientGroupListStr varchar(max),
  @i_excludeListStr varchar(max),
  @i_captureAssocActivityCtrl int,
  @i_captureAssocHolidays int,
  @i_captureAssocOpWindow int,
  @i_captureClientGroupAssoc int,
  @i_jobId int,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) 	OUTPUT,
  @captureXML xml 		OUTPUT
AS
--Code Below Here is From CCM_Capture_ClientGroup.spb
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	-- Create temp tables
	IF OBJECT_ID('tempdb..#CCM_App_ClientGroup') IS NOT NULL DROP TABLE #CCM_App_ClientGroup
	CREATE TABLE #CCM_App_ClientGroup
	(
		[id] [int] NOT NULL,
		[name] [nvarchar](512) NOT NULL,
		[description] [nvarchar](max) NOT NULL,
		[flag] [int] NOT NULL,
		[status] [int] NOT NULL,
		[userId] [int] NOT NULL,
		[refTime] [int] NOT NULL,
		[modified] [int] NOT NULL,
		[fwPorts] [nvarchar](255) NOT NULL,
		[origCCId] [int] NOT NULL,
		[GUID] [uniqueidentifier] ROWGUIDCOL  NULL
	)
	IF OBJECT_ID('tempdb..#CCM_App_SCGRule') IS NOT NULL DROP TABLE #CCM_App_SCGRule
	CREATE TABLE #CCM_App_SCGRule
	(
		[id] [int] NOT NULL,
		[scgId] [int] NOT NULL,
		[ruleXml] [xml] NULL,
		[ruleQuery] [nvarchar](max) NOT NULL,
		[ownerId] [int] NOT NULL,
		[created] [int] NOT NULL,
		[modified] [int] NOT NULL,
		[flag] [INT] DEFAULT 0
	)
	IF OBJECT_ID('tempdb..#CCM_APP_ClientGroupAssoc') IS NOT NULL DROP TABLE #CCM_APP_ClientGroupAssoc
	CREATE TABLE #CCM_APP_ClientGroupAssoc
	(
		[clientGroupId] [int] NOT NULL,
		[clientId] [int] NOT NULL
	)
	-------------------------------------------------------------
	-- CommServ_Capture..CCM_App_ClientGroup
	INSERT INTO #CCM_App_ClientGroup
	SELECT * FROM CCM_SOURCE_App_ClientGroup
	WHERE 	(ISNULL(@i_clientGroupListStr, '') = '' OR id IN (SELECT _ID FROM dbo.CCM_SplitStringByToken(@i_clientGroupListStr, ',')))
		AND (ISNULL(@i_excludeListStr, '') = '' OR id NOT IN (SELECT _ID FROM dbo.CCM_SplitStringByToken(@i_excludeListStr, ',')))
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_ClientGroup -- CCM_App_ClientGroup'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------
	-- CommServ_Capture..CCM_App_SCGRule
	EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'App_SCGRule', 'tempdb.dbo.#CCM_App_SCGRule','', @i_exportDBName, ' a INNER JOIN #CCM_App_ClientGroup b ON a.scgId = b.id'
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_ClientGroup -- CCM_App_SCGRule'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------
	-- CommServ_Capture..CCM_App_ClientGroupAssoc
	IF @i_captureClientGroupAssoc > 0
	BEGIN
		INSERT 	INTO #CCM_App_ClientGroupAssoc
		SELECT 	a.*
		FROM 	CCM_SOURCE_App_ClientGroupAssoc a
			INNER JOIN #CCM_App_ClientGroup b ON a.clientGroupId = b.id
INNER JOIN CCMEntitiesCaptured c ON a.clientId = c.entityId AND c.captureJobId = @i_jobId AND c.entityType = 3
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_ClientGroup -- CCM_App_ClientGroupAssoc'
			GOTO CX_ERROR_EXIT
		END
	END
	-------------------------------------------------------------
	--Populate Questions xml
	SET @captureXML =
	(
		SELECT
		(
			SELECT	CG.description as '@description',
				CG.flag	as '@flag',
				CG.origCCId	as '@origCCId',
				CG.userId as '@ownerId',
				CONVERT(varchar(max),ISNULL(SCG.ruleXml, '')) as '@scgRuleGroupXML',
				(
					SELECT 	CG.GUID as '@GUID',
28 as '@_type_',
						CG.id as '@clientGroupId',
						CG.name as '@clientGroupName'
					FOR XML PATH ('clientGroup'), TYPE
				),
				(
SELECT	3 as '@_type_',
						CGA.clientId as '@clientId'
					FROM	#CCM_App_ClientGroupAssoc CGA
					WHERE	CGA.clientGroupId = CG.id
					FOR XML PATH ('associatedClients'), TYPE
				)
			FROM	#CCM_App_ClientGroup CG
				LEFT OUTER JOIN #CCM_App_SCGRule SCG ON CG.id = SCG.scgId
			FOR XML PATH ('clientGroupsList'),TYPE
		)
		FOR XML PATH('EVGui_CCMClientGroupCaptureInfo')
	)
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_ClientGroup_Default')
	delete from GxQscripts where name = 'CCM_Capture_ClientGroup_Default'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_ClientGroup_Default')
	delete from GXDBVersions where aliasname = 'CCM_Capture_ClientGroup_Default'
GO

insert into GXDBVersions values(2, 'CCM_Capture_ClientGroup_Default',  '00010002008000020000', 'CCM_Capture_ClientGroup_Default', '00010002008000020000')
GO

