

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_ClientGroup.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client Group data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_ClientGroup.sp,v 1.3.80.2 2018/03/20 00:42:26 jiechen Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_ClientGroup')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_ClientGroup <<<'
	drop procedure CCM_Capture_ClientGroup
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_ClientGroup')
	delete from GxQscripts where name = 'CCM_Capture_ClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_ClientGroup')
	delete from GXDBVersions where aliasname = 'CCM_Capture_ClientGroup'
GO
print '... Creating Procedure: CCM_Capture_ClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_ClientGroup
  @i_clientGroupListStr varchar(max),
  @i_excludeListStr varchar(max),
  @i_captureAssocActivityCtrl int,
  @i_captureAssocHolidays int,
  @i_captureAssocOpWindow int,
  @i_captureClientGroupAssoc int,
  @i_jobId int,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
  DECLARE @captureCGXML xml;
SET NOCOUNT ON
	DECLARE @errorStr varchar(1024)
	DECLARE @errCode int
	SET @errorStr = 'ERROR: GENERAL ERROR!'
	SET @errCode = 0
	--
	-- Get the capture DB releaseId. if release is less than 9.0 then fail the job
	--
	DECLARE @l_releaseId int
	SELECT @l_releaseId = releaseId FROM CCM_SOURCE_APP_Client WHERE Id = 2
	IF	@@ERROR > 0
	BEGIN
		SET @errorStr = 'ERROR: CCM_Capture_ClientGroup -- Failed to get CommServ release'
		GOTO CX_ERROR_EXIT
	END
	IF @l_releaseId < 14
	BEGIN
		SET @errorStr  = 'ERROR: Capture from releases prior to 9.0 are not supported'
		GOTO CX_ERROR_EXIT
	END
	IF 14 = @l_releaseId
		EXEC @errCode = CCM_Capture_ClientGroup_From_90 @i_clientGroupListStr, @i_excludeListStr, @i_captureAssocActivityCtrl, @i_captureAssocHolidays,
					@i_captureAssocOpWindow, @i_captureClientGroupAssoc, @i_jobId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorStr OUTPUT, @captureXML = @captureCGXML OUTPUT
	ELSE
		EXEC @errCode = CCM_Capture_ClientGroup_Default @i_clientGroupListStr, @i_excludeListStr, @i_captureAssocActivityCtrl, @i_captureAssocHolidays,
					@i_captureAssocOpWindow, @i_captureClientGroupAssoc, @i_jobId, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errorStr OUTPUT, @captureXML = @captureCGXML OUTPUT
	IF @errCode <> 0
		GOTO CX_ERROR_EXIT
	SET @errorStr = 'NO_ERROR'
	SELECT	@captureCGXML
	RETURN (0)
CX_ERROR_EXIT:
	RAISERROR ('%s' , 16, 1, @errorStr)
	SELECT	@captureCGXML
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_ClientGroup')
	delete from GxQscripts where name = 'CCM_Capture_ClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_ClientGroup')
	delete from GXDBVersions where aliasname = 'CCM_Capture_ClientGroup'
GO

insert into GXDBVersions values(2, 'CCM_Capture_ClientGroup',  '00010003008000020000', 'CCM_Capture_ClientGroup', '00010003008000020000')
GO

