

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_APP_To_90.sp] ---------- 

-- Modified for (CCP)
--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_APP_To_90.sp,v 1.4.78.2 2018/03/20 00:35:57 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_APP_To_90 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_APP_To_90')
	drop procedure CCM_Capture_APP_To_90
IF EXISTS (select * from GxQscripts where name='CCM_Capture_APP_To_90')
	delete from GxQscripts where name = 'CCM_Capture_APP_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_APP_To_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_APP_To_90'
GO
print '... Creating Procedure: CCM_Capture_APP_To_90'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_APP_To_90
  @i_subClientId integer,
  @i_clientId integer,
  @i_captureActivityControl integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_APP.spb
SET NOCOUNT ON
	-- Do not use transaction here, because it is called by another stored procedure with transaction
	DECLARE @appTypeId INTEGER
	SET @errStr = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	IF (@i_subClientId < 0)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_APP -- Invalid subclient'
		GOTO CX_ERROR_EXIT
	END
	IF (@i_clientId <= 1)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_APP -- Invalid clientId'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	IF(@i_subClientId > 0)
	BEGIN
SET @appTypeId = ISNULL((SELECT appTypeId FROM CommServ_Capture..CCM_App_Application WHERE id = @i_subClientId),0)
		IF	(@@ERROR > 0 OR @appTypeId = 0)
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_Application'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_CommCell
INSERT INTO CommServ_Capture..CCM_App_CommCell
	SELECT
	a.id, a.number, a.clientId, a.parentId, a.aliasName, a.flags, a.refTime,
	a.userName, a.userPassword, a.smtpServer, a.timeZone, a.ipAddress, a.modified, a.ccOpMode,
	a.drIpAddress, dbo.NormalizeForXML(a.encNumber), a.csGUID, a.type
	FROM CCM_SOURCE_APP_CommCell a
	WHERE Number <> 0
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_CommCell)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_CommCell'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simAllGalaxyRel
INSERT INTO CommServ_Capture..CCM_simAllGalaxyRel
	SELECT
	id, release
	FROM CCM_SOURCE_simAllGalaxyRel a
WHERE a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_simAllGalaxyRel)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_simAllGalaxyRel'
		GOTO CX_ERROR_EXIT
	END
	-- Delete releases higher than 9.0
DELETE 	CommServ_Capture..CCM_simAllGalaxyRel
	WHERE	id > 14
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_simAllGalaxyRel - DELETE 9.0'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_LicUsage
	IF(@i_subClientId > 0)
	BEGIN
		/*
		AppType - 1001 is not a real license to be consumed - it is pseudo license - CommClient Base
		So every client should have a row in licUsage for AppType - 1001 irrespective of consume license or not
		*/
INSERT	INTO CommServ_Capture..CCM_LicUsage            -- Sub-client specific licUsage entires
		SELECT
		a.*
		FROM CCM_SOURCE_LicUsage a
		WHERE	a.CId = @i_clientId
AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)
		AND     a.AppType IN (@appTypeId, 1001, 1092)
AND     a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_LicUsage)
		AND a.AppType IN (SELECT appTypeId FROM APP_IDAName WHERE clientId = @i_clientId)
		AND @i_clientId <> 2
	END
	ELSE
	BEGIN
INSERT	INTO CommServ_Capture..CCM_LicUsage            -- Client specific licUsage entries
	    SELECT
	    a.*
	    FROM CCM_SOURCE_LicUsage a
		WHERE	a.CId = @i_clientId
AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)
AND     a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_LicUsage)
		AND a.AppType IN (SELECT appTypeId FROM APP_IDAName WHERE clientId = @i_clientId)
		AND @i_clientId <> 2
	END
	IF	@@ERROR > 0
	BEGIN
		SET	@errStr = 'ERROR: CCM_Capture_APP -- CCM_LicUsage'
		GOTO CX_ERROR_EXIT
	END
	-- Capture VSA Agent licenses by default if client is captured.
INSERT	INTO CommServ_Capture..CCM_LicUsage            -- Client specific licUsage entries
	SELECT
	a.*
	FROM CCM_SOURCE_LicUsage a
	WHERE	a.CId = @i_clientId
AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_LicUsage)
			AND	a.AppType = 106
AND EXISTS ( SELECT * FROM CCM_SOURCE_simInstalledPackages WHERE ClientId = @i_clientId AND simPackageID = 713) -- Just to make sure that we are capturing Lic table only for proxy client, not for dummy VSA clients
	IF	@@ERROR > 0
	BEGIN
		SET	@errStr = 'ERROR: CCM_Capture_APP -- CCM_LicUsage for Proxy VSA agent'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_LicUsageHistory
INSERT INTO CommServ_Capture..CCM_LicUsageHistory
	SELECT DISTINCT
	a.*
FROM CCM_SOURCE_LicUsageHistory a, CommServ_Capture..CCM_LicUsage b
	WHERE a.CId = b.CId AND a.AppType = b.AppType AND a.LicType = b.LicType
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_LicUsageHistory)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_LicUsageHistory'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_App_VMToPMMap
	SELECT a.VMClientId, a.PMClientId
	FROM   CCM_SOURCE_APP_VMToPMMap a
WHERE  (a.VMClientId in (SELECT id from CommServ_Capture..CCM_App_Client)
OR a.PMClientId in (SELECT id from CommServ_Capture..CCM_App_Client))
	AND NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_App_VMToPMMap
	        WHERE  VMClientId = a.VMClientId
	          AND  PMClientId = a.PMClientId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_VMToPMMap'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_simInstalledPackages
	IF(@i_subClientId > 0)
	BEGIN
INSERT INTO CommServ_Capture..CCM_simInstalledPackages	-- Sub-client specific simInstalledPackages entires
		SELECT	DISTINCT
						a.id,
                        a.ClientId,
    			        a.simPackageID,
						a.OpTime,
						a.OpType,
						a.UserID,
						a.HighestSP,
						cast (a.AdditionalPatches as nvarchar(max)),
						cast (a.MissingPatches as nvarchar(max)),
						a.Node,
						a.IsActive,
						a.SpMinorVersion,
						a.Baseline,
						cast (a.BaselineDeltaSP as nvarchar(max)),
						cast (a.BaselineDeltaUpdate as nvarchar(max))
		FROM CCM_SOURCE_simInstalledPackages a, CCM_SOURCE_simPackageMap b
		WHERE a.simPackageId = b.simPackageId
		  AND b.apptype = @appTypeId
		  AND a.ClientId = @i_clientId
AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)
		  AND NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_simInstalledPackages
		       WHERE  ClientId = a.ClientId
		       AND    simPackageID = a.simPackageID)
	END
	/*
	captureing VSA proxy client specific packages becuase there are no subclients associated with proxy clients
	*/
	IF EXISTS(
					SELECT 1
					FROM CCM_SOURCE_simInstalledPackages A
						INNER JOIN CCM_SOURCE_APP_IDAName B ON B.ClientId = A.ClientId
						INNER JOIN CCM_SOURCE_simPackageMap C ON C.simPackageId = A.simPackageId AND C.appType = B.AppTypeId
WHERE A.ClientId = @i_clientId AND B.appTypeId = 106
				 )
	BEGIN
INSERT INTO CommServ_Capture..CCM_simInstalledPackages		-- VSA Proxy client specific simInstalledPackages entires
	    SELECT
						a.id,
                        a.ClientId,
    			        a.simPackageID,
						a.OpTime,
						a.OpType,
						a.UserID,
						a.HighestSP,
						cast (a.AdditionalPatches as nvarchar(max)),
						cast (a.MissingPatches as nvarchar(max)),
						a.Node,
						a.IsActive,
						a.SpMinorVersion,
						a.Baseline,
						cast (a.BaselineDeltaSP as nvarchar(max)),
						cast (a.BaselineDeltaUpdate as nvarchar(max))
		FROM CCM_SOURCE_simInstalledPackages A
		INNER JOIN CCM_SOURCE_APP_IDAName B ON B.clientId = A.ClientId
		INNER JOIN CCM_SOURCE_simPackageMap C ON C.simPackageId = A.simPackageId AND C.appType = B.AppTypeId
LEFT OUTER JOIN CommServ_Capture..CCM_simInstalledPackages D ON D.ClientId = A.ClientId AND D.simPackageID = A.simPackageID
WHERE A.ClientId = @i_clientId AND B.appTypeId = 106 AND D.id IS NULL
	END
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_simInstalledPackages'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simInstalledPackagesHistory
INSERT INTO CommServ_Capture..CCM_simInstalledPackagesHistory
SELECT a.* from CCM_SOURCE_simInstalledPackagesHistory a, CommServ_Capture..CCM_simInstalledPackages b
	WHERE a.simInstalledPkgID = b.id
	AND NOT EXISTS(SELECT 1
FROM CommServ_Capture..CCM_simInstalledPackagesHistory
		 WHERE simInstalledPkgID = a.simInstalledPkgID
		 AND OpType = a.OpType
		 AND OpTime = a.OpTime)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_simInstalledPackagesHistory'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simXMLRequest
/*INSERT INTO CommServ_Capture..CCM_simXMLRequest
	SELECT a.* from CCM_SOURCE_simXMLRequest a
	WHERE a.ClientId = @i_clientId
AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_APP_Client)
	AND (SELECT COUNT(*)
FROM CommServ_Capture..CCM_simXMLRequest
		 WHERE clientId = a.clientId
		 AND OpTimeUTC = a.OpTimeUTC) = 0*/
	DECLARE @tailQuery VARCHAR(MAX)= ' a WHERE a.ClientId = '+CAST(@i_clientId AS VARCHAR(256))+'
	AND '+CAST(@i_clientId AS VARCHAR(256))+' IN (SELECT id FROM '+
	'CommServ_Capture..CCM_APP_Client'
	+')
	AND NOT EXISTS(SELECT 1
		 FROM '+
		 'CommServ_Capture..CCM_simXMLRequest'
		 +' WHERE clientId = a.clientId
		 AND OpTimeUTC = a.OpTimeUTC)'
	EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'simXMLRequest', 'CommServ_Capture..CCM_simXMLRequest', '', @i_exportDBName, @tailQuery
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_simXMLRequest'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	/*
	Most cases it should always be 1. But may not be sometimes as it happened once
	*/
	DECLARE @activityControlAppId   INTEGER
	SET @activityControlAppId = ISNULL((SELECT TOP 1 id FROM CCM_SOURCE_APP_Application WHERE appTypeId = 1000),0)
	IF (@activityControlAppId = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_App -- AppId For ActivityControl Not Found in the database'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_App_Application
	SELECT * FROM CCM_SOURCE_APP_Application
	WHERE id = @activityControlAppId
	AND @activityControlAppId NOT IN
(SELECT id FROM CommServ_Capture..CCM_App_Application)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_App -- CCM_App_Application - Insert -- Activity Control App'
                GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMJobAction
    IF @i_captureActivityControl > 0
    BEGIN
	IF(@i_subClientId > 0)
	BEGIN
INSERT INTO CommServ_Capture..CCM_JMJobAction
		SELECT DISTINCT a.clientId, a.mediaAgentID, a.appType, a.opType, a.action, a.appId , a.clientGroupId, a.enableTimeZone, a.enableTime , a.UNCenableTime
		FROM CCM_SOURCE_JMJobAction a
		WHERE (
				(appId = @i_subClientId AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0 AND clientId = 1) -- sub-client level activity control
OR (appId = @activityControlAppId AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0 AND clientId = @i_clientId AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)) -- client level activity control
OR (appId = @activityControlAppId AND mediaAgentId = 1 AND appType = @appTypeId AND clientGroupId = 0 AND clientId = @i_clientId AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)) -- app type specific activity control
			  )
		AND  NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_JMJobAction
		       WHERE  clientId       = a.clientId
				AND	  mediaAgentID   = a.mediaAgentID
				AND	  appType        = a.appType
				AND	  opType         = a.opType
				AND	  action         = a.action
				AND	  appId          = a.appId
				AND	  clientGroupId  = a.clientGroupId
				AND	  enableTimeZone = a.enableTimeZone
				AND	  enableTime     = a.enableTime
				AND   UNCenableTime  = a.UNCenableTime)
	END
	ELSE
	BEGIN
INSERT INTO CommServ_Capture..CCM_JMJobAction
		SELECT DISTINCT
		a.clientId, a.mediaAgentID, a.appType, a.opType, a.action, a.appId , a.clientGroupId, a.enableTimeZone, a.enableTime , a.UNCenableTime
		FROM CCM_SOURCE_JMJobAction a
		WHERE (
(appId = @activityControlAppId AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0 AND clientId = @i_clientId AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)) -- client level activity control
			  )
		AND  NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_JMJobAction
		       WHERE  clientId       = a.clientId
				AND   mediaAgentID   = a.mediaAgentID
				AND	  appType        = a.appType
				AND	  opType         = a.opType
				AND	  action         = a.action
				AND	  appId          = a.appId
				AND	  clientGroupId  = a.clientGroupId
				AND	  enableTimeZone = a.enableTimeZone
				AND	  enableTime     = a.enableTime
				AND   UNCenableTime  = a.UNCenableTime)
	END
	--AND (SELECT count(*) FROM CommServ_Capture..CCM_JMJobAction WHERE appId = 1 AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0 AND clientId = @i_clientId ) = 0
	--AND (SELECT count(*) FROM CommServ_Capture..CCM_JMJobAction WHERE appId = 1 AND mediaAgentId = 1 AND appType = @appTypeId AND clientGroupId = 0 AND clientId = @i_clientId ) = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_JMJobAction'
		GOTO CX_ERROR_EXIT
	END
	END
	-- CommServ_Capture..CCM_APP_SubClientProp
INSERT INTO CommServ_Capture..CCM_App_SubClientProp
	(id, componentnameId, attrName, attrType, attrVal, created, modified,ccpId)
	SELECT
	a.id, a.componentnameId, a.attrName, a.attrType, a.attrVal, a.created, a.modified, a.ccpId
	FROM   CCM_SOURCE_APP_SubClientProp a
	WHERE  a.componentNameId = @i_subClientId
AND    a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_SubClientProp)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_SubClientProp'
		GOTO CX_ERROR_EXIT
	END
	--Capture only valid properties for 'Oracle RAC Data Properties'
DELETE CommServ_Capture..CCM_App_SubClientProp
	WHERE (attrName = 'Oracle RAC Data Properties' OR attrName = 'Oracle RAC Log Properties') AND modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_SubClientProp - DELETE invalid properties for Oracle RAC'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_ScFilterFile
INSERT INTO CommServ_Capture..CCM_App_ScFilterFile
	(id,componentnameid, type, filename, created, modified, ccpId)
	SELECT
	a.id,a.componentnameid, a.type, a.filename, a.created, a.modified, a.ccpId
	FROM CCM_SOURCE_APP_ScFilterFile a
	WHERE  a.componentNameId = @i_subClientId
AND    a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_ScFilterFile)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_ScFilterFile'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_BackupSetName
INSERT INTO CommServ_Capture..CCM_App_BackupSetname
	SELECT
	a.*
	FROM CCM_SOURCE_APP_BackupSetName a
WHERE a.id IN (SELECT DISTINCT backupSet FROM CommServ_Capture..CCM_App_Application WHERE id = @i_subClientId)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_BackupSetname)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_BackupSetName'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_BackupSetProp
INSERT INTO CommServ_Capture..CCM_App_BackupSetProp
	SELECT
	a.*
	FROM CCM_SOURCE_APP_BackupSetProp a
WHERE a.componentNameId IN (SELECT id FROM CommServ_Capture..CCM_App_BackupSetname)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_BackupSetProp)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_BackupSetProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_InstanceName
INSERT INTO CommServ_Capture..CCM_App_InstanceName
	SELECT
	a.*
	FROM CCM_SOURCE_APP_InstanceName a
WHERE a.id IN (SELECT DISTINCT instance FROM CommServ_Capture..CCM_App_Application WHERE id = @i_subClientId)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_InstanceName)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_InstanceName'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_InstanceProp
INSERT INTO CommServ_Capture..CCM_App_InstanceProp
	SELECT
	a.*
	FROM CCM_SOURCE_APP_InstanceProp a
WHERE a.componentNameId IN (SELECT id FROM CommServ_Capture..CCM_App_InstanceName)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_InstanceProp)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_InstanceProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_InstFilterFile
INSERT INTO CommServ_Capture..CCM_App_InstFilterFile
			SELECT a.componentNameId, a.type, a.fileName, a.created, a.modified
	FROM CCM_SOURCE_APP_InstFilterFile a
WHERE a.componentNameId IN (SELECT id FROM CommServ_Capture..CCM_App_InstanceName)
	AND NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_App_InstFilterFile
	       WHERE  componentNameId = a.componentNameId
           AND    type            = a.type
           AND    fileName        = a.fileName
           AND    created         = a.created
           AND    modified        = a.modified)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_InstFilterFile'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_IDAName & CommServ_Capture..CCM_APP_IDAProp
	IF(@i_subClientId > 0)
	BEGIN
INSERT INTO CommServ_Capture..CCM_App_IDAName
		SELECT
		a.*
		FROM CCM_SOURCE_APP_IDAName a
		WHERE a.clientId = @i_clientId AND a.appTypeId = @appTypeId
AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_IDAName)
	END
       /*This query makes sense only in 8.0 CCM where the capture is client-based - From 9.0 capture is subclient based and
	we pass clientId <> 0 and subClientId = 0 to this stored proc only if the call is to capture client config alone
	without any associated subclient or data - so commenting this out*/
	/*ELSE
	BEGIN
INSERT INTO CommServ_Capture..CCM_App_IDAName
		SELECT
		a.*
		FROM CCM_SOURCE_APP_IDAName a
		WHERE a.clientId = @i_clientId
AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_IDAName)
	END*/
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_IDAName'
		GOTO CX_ERROR_EXIT
	END
	-- Capture VSA Agent as it do not have the subclients.
INSERT INTO CommServ_Capture..CCM_App_IDAName
	SELECT
	a.*
	FROM CCM_SOURCE_APP_IDAName a
	WHERE a.clientId = @i_clientId
AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_IDAName)
	AND   a.appTypeId = 106																-- By default capture Virtual Server Agent if Client is captured, As we dont have subclients for VSA.
	AND EXISTS ( SELECT * FROM CCM_SOURCE_simInstalledPackages WHERE ClientId = @i_clientId
AND simPackageID = 713 ) 	-- Just to make sure that we are capturing Ida table only for proxy client, not for dummy VSA clients
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_IDAName -- VSA Agent Capture'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_IDAName & CommServ_Capture..CCM_APP_IDAProp
INSERT INTO CommServ_Capture..CCM_App_IDAProp
	SELECT
	a.*
	FROM CCM_SOURCE_APP_IDAProp a
WHERE a.componentNameId IN (SELECT id FROM CommServ_Capture..CCM_App_IDAName)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_IDAProp)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_IDAProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_DCvolInfo
INSERT INTO CommServ_Capture..CCM_App_DCVolInfo
	SELECT a.* FROM CCM_SOURCE_APP_DCvolInfo a
WHERE a.componentNameId IN (SELECT id FROM CommServ_Capture..CCM_App_IDAName)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_DCVolInfo)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_DCvolInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_OracleRacInstance
INSERT INTO CommServ_Capture..CCM_App_OracleRacInstance
	SELECT a.* FROM CCM_SOURCE_APP_OracleRacInstance a
WHERE a.instaceId IN (SELECT instance FROM CommServ_Capture..CCM_App_Application where appTypeId = 80 and id = @i_subClientId)
	--AND   a.clientId = @i_clientId --clientId of Oracle RAC client never will exist in the clientId column of APP_OracleRacInstance, this column will always have clientId's of physical client which are associated with this oracle rac pseudo client (apptype  -80)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_OracleRacInstance)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_DCvolInfo'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_CustomCalendar
INSERT INTO CommServ_Capture..CCM_App_CustomCalendar
	SELECT
	a.*
	FROM CCM_SOURCE_APP_CustomCalendar a
WHERE a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_CustomCalendar)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_CustomCalendar'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_CustomCalendarMonths
INSERT INTO CommServ_Capture..CCM_App_CustomCalendarMonths
	SELECT a.* FROM CCM_SOURCE_APP_CustomCalendarMonths a
	WHERE NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_App_CustomCalendarMonths
	       WHERE  calendarId = a.calendarId
	       AND    year = a.year
	       AND    month = a.month)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_CustomCalendarMonths'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_ExtendedProperties
	--PrasadNara: Capture entries associated with client or appType or instance or backupset along with the entires associated with subclient
INSERT INTO CommServ_Capture..CCM_App_ExtendedProperties
	SELECT
	a.*
	FROM CCM_SOURCE_APP_ExtendedProperties a
LEFT OUTER JOIN CommServ_Capture..CCM_App_ExtendedProperties b
			ON 	   b.clientId = a.clientId
			AND	   b.appTypeId = a.appTypeId
			AND	   b.instance = a.instance
			AND	   b.backupSet = a.backupSet
			AND	   b.subclientId = a.subclientId
			AND	   b.attrType = a.attrType
			AND	   b.attrName = a.attrName
			AND	   cast(b.attrVal as nvarchar(max)) = cast(a.attrVal as nvarchar(max))
			AND	   b.MD5 = a.MD5
			AND	   b.created = a.created
			AND	   b.modified = a.modified
			AND	   b.ccpId = a.ccpId
	WHERE	b.clientId IS NULL
		AND a.clientid = @i_clientId
AND @i_clientId IN (SELECT id FROM CommServ_Capture..CCM_App_Client)
		AND a.appTypeId = @appTypeId
AND (a.Instance = 0 OR a.Instance = (SELECT instance FROM CommServ_Capture..CCM_App_Application WHERE id = @i_subClientId))
AND (a.BackupSet = 0 OR a.BackupSet = (SELECT backupSet FROM CommServ_Capture..CCM_App_Application WHERE id = @i_subClientId))
		AND (a.subclientId = 0 OR a.subclientId = @i_subClientId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_ExtendedProperties'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-------------------------------------------------------------------
	-- CommServ_Capture..CCM_MMNDMPHostInfo
INSERT INTO CommServ_Capture..CCM_MMNDMPHostInfo
	SELECT DISTINCT a.* from CCM_SOURCE_MMNDMPHostInfo a
INNER JOIN CommServ_Capture..CCM_App_Client b ON a.clientId = b.id
LEFT OUTER JOIN CommServ_Capture..CCM_MMNDMPHostInfo c ON a.NDMPHostId = c.NDMPHostId
	WHERE c.NDMPHostId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_MMNDMPHostInfo'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_APP_To_90')
	delete from GxQscripts where name = 'CCM_Capture_APP_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_APP_To_90')
	delete from GXDBVersions where aliasname = 'CCM_Capture_APP_To_90'
GO

insert into GXDBVersions values(2, 'CCM_Capture_APP_To_90',  '00010004007800020000', 'CCM_Capture_APP_To_90', '00010004007800020000')
GO

