

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_APP.sp] ---------- 

-- Modified for (CCP)
--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_APP.sp,v 1.60.78.4 2018/12/27 16:47:04 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_APP')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_APP <<<'
	drop procedure CCM_Capture_APP
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_APP')
	delete from GxQscripts where name = 'CCM_Capture_APP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_APP')
	delete from GXDBVersions where aliasname = 'CCM_Capture_APP'
GO
print '... Creating Procedure: CCM_Capture_APP'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_APP
  @i_captureActivityControl integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_APP.spb
SET NOCOUNT ON
	-- Do not use transaction here, because it is called by another stored procedure with transaction
	SET @errStr = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_CommCell
INSERT INTO CommServ_Capture..CCM_App_CommCell
	SELECT 	a.id, a.number, a.clientId, a.parentId, a.aliasName, a.flags, a.refTime,
	a.userName, a.userPassword, a.smtpServer, a.timeZone, a.ipAddress, a.modified, a.ccOpMode,
	a.drIpAddress, dbo.NormalizeForXML(a.encNumber), a.csGUID, a.type
	FROM CCM_SOURCE_APP_CommCell a
	WHERE Number > 0
AND  a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_App_CommCell)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_CommCell'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simAllGalaxyRel
INSERT INTO CommServ_Capture..CCM_simAllGalaxyRel
	SELECT 	a.*
	FROM CCM_SOURCE_simAllGalaxyRel a
WHERE a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_simAllGalaxyRel)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_simAllGalaxyRel'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_LicUsage
INSERT	INTO CommServ_Capture..CCM_LicUsage
	SELECT	DISTINCT a.*
FROM CCM_SOURCE_LicUsage a INNER JOIN CommServ_Capture..CCM_App_Client b ON b.id = a.CId
	WHERE a.CId <> 2
AND NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_LicUsage c WHERE c.id = a.id)
	IF	@@ERROR > 0
	BEGIN
		SET	@errStr = 'ERROR: CCM_Capture_APP -- CCM_LicUsage'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_LicUsageHistory
INSERT INTO CommServ_Capture..CCM_LicUsageHistory
	SELECT a.*
FROM CCM_SOURCE_LicUsageHistory a INNER JOIN CommServ_Capture..CCM_LicUsage b ON a.CId = b.CId AND a.AppType = b.AppType AND a.LicType = b.LicType
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_LicUsageHistory c WHERE c.id = a.id)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_LicUsageHistory'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_App_VMToPMMap
	SELECT DISTINCT a.VMClientId, a.PMClientId
FROM   CCM_SOURCE_APP_VMToPMMap a INNER JOIN CommServ_Capture..CCM_App_Client b ON a.VMClientId = b.id OR a.PMClientId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_VMToPMMap c WHERE a.VMClientId = c.VMClientId AND a.PMClientId = c.PMClientId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_VMToPMMap'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_simInstalledPackages
INSERT INTO CommServ_Capture..CCM_simInstalledPackages
	SELECT	a.*
FROM CCM_SOURCE_simInstalledPackages a INNER JOIN CommServ_Capture..CCM_App_Client b ON a.ClientId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_simInstalledPackages c WHERE c.ClientId = a.ClientId AND c.simPackageID = a.simPackageID)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_simInstalledPackages'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simInstalledPackagesHistory
INSERT INTO CommServ_Capture..CCM_simInstalledPackagesHistory
SELECT a.* from CCM_SOURCE_simInstalledPackagesHistory a INNER JOIN CommServ_Capture..CCM_simInstalledPackages b ON a.simInstalledPkgID = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_simInstalledPackagesHistory c WHERE c.id = a.id)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_simInstalledPackagesHistory'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_simXMLRequest
DECLARE @tailQuery VARCHAR(MAX)= ' a INNER JOIN CommServ_Capture..CCM_App_Client b ON a.ClientId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_simXMLRequest c WHERE c.id = a.id) '
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'simXMLRequest', 'CommServ_Capture..CCM_simXMLRequest', '', @i_exportDBName, @tailQuery
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_simXMLRequest'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	/*
	Most cases it should always be 1. But may not be sometimes as it happened once
	*/
	DECLARE @activityControlAppId   INTEGER
	SET @activityControlAppId = ISNULL((SELECT TOP 1 id FROM CCM_SOURCE_APP_Application WHERE appTypeId = 1000),0)
	IF (@activityControlAppId = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_App -- AppId For ActivityControl Not Found in the database'
		GOTO CX_ERROR_EXIT
	END
IF NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_Application WHERE id = @activityControlAppId)
	BEGIN
INSERT INTO CommServ_Capture..CCM_App_Application
		SELECT * FROM CCM_SOURCE_APP_Application
		WHERE id = @activityControlAppId
	END
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_App -- CCM_App_Application - Insert -- Activity Control App'
                GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_JMJobAction
    IF @i_captureActivityControl > 0
    BEGIN
INSERT INTO CommServ_Capture..CCM_JMJobAction
		SELECT DISTINCT a.*
FROM CCM_SOURCE_JMJobAction a, CommServ_Capture..CCM_App_Application b, CommServ_Capture..CCM_App_Client c
		WHERE (
				(a.appId = b.id AND a.appId <> @activityControlAppId AND mediaAgentId = 1 AND a.appType = 0 AND a.clientGroupId = 0 AND a.clientId = 1) -- sub-client level activity control
		     OR (a.appId = @activityControlAppId AND a.mediaAgentId = 1 AND a.appType = 0 AND a.clientGroupId = 0 AND a.clientId = b.clientId AND b.clientId = c.id ) -- client level activity control
			 OR (a.appId = @activityControlAppId AND a.mediaAgentId = 1 AND a.appType = b.appTypeId AND a.clientGroupId = 0 AND a.clientId = b.clientId AND b.clientId = c.id ) -- app type specific activity control
			  )
		AND  NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_JMJobAction
		       WHERE  clientId       = a.clientId
				AND	  mediaAgentID   = a.mediaAgentID
				AND	  appType        = a.appType
				AND	  opType         = a.opType
				AND	  appId          = a.appId
				AND	  clientGroupId  = a.clientGroupId
				AND	  instanceID     = a.instanceID
				)
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_JMJobAction INSERT 1'
			GOTO CX_ERROR_EXIT
		END
INSERT INTO CommServ_Capture..CCM_JMJobAction
		SELECT DISTINCT	a.*
FROM CCM_SOURCE_JMJobAction a, CommServ_Capture..CCM_App_Client b
		WHERE (
		        (appId = @activityControlAppId AND mediaAgentId = 1 AND appType = 0 AND clientGroupId = 0 AND clientId = b.id ) -- client level activity control
			  )
		AND  NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_JMJobAction
		       WHERE  clientId       = a.clientId
				AND	  mediaAgentID   = a.mediaAgentID
				AND	  appType        = a.appType
				AND	  opType         = a.opType
				AND	  appId          = a.appId
				AND	  clientGroupId  = a.clientGroupId
				AND	  instanceID     = a.instanceID
				)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_JMJobAction INSERT 2'
			GOTO CX_ERROR_EXIT
		END
	END
	-- CommServ_Capture..CCM_APP_SubClientProp
INSERT INTO CommServ_Capture..CCM_App_SubClientProp
	SELECT a.id, a.componentnameId, a.attrName, a.attrType, a.attrVal, a.created, a.modified, a.ccpId
FROM   CCM_SOURCE_APP_SubClientProp a (NOLOCK) INNER JOIN CommServ_Capture..CCM_App_Application b ON a.componentNameId = b.id
WHERE  NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_SubClientProp c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_SubClientProp'
		GOTO CX_ERROR_EXIT
	END
	--Capture only valid properties for 'Oracle RAC Data Properties'
DELETE CommServ_Capture..CCM_App_SubClientProp
	WHERE (attrName = 'Oracle RAC Data Properties' OR attrName = 'Oracle RAC Log Properties') AND modified <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_SubClientProp - DELETE invalid properties for Oracle RAC'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_CredentialAssoc
INSERT INTO CommServ_Capture..CCM_APP_CredentialAssoc
	SELECT A.*
	FROM CCM_SOURCE_APP_CredentialAssoc A
INNER JOIN CommServ_Capture..CCM_App_SubClientProp B ON B.attrName IN ('prepost Credential Assoc Id', 'UNCPath Credential Assoc Id') AND B.modified = 0 AND CAST(A.assocId AS VARCHAR(128)) = B.attrVal
LEFT OUTER JOIN CommServ_Capture..CCM_APP_CredentialAssoc C ON C.assocId = A.assocId
	WHERE C.assocId IS NULL
    IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_CredentialAssoc - SubClientProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_ScFilterFile
INSERT INTO CommServ_Capture..CCM_App_ScFilterFile
	SELECT a.id,a.componentnameid, a.type, a.filename, a.created, a.modified, a.ccpId
FROM CCM_SOURCE_APP_ScFilterFile a INNER JOIN CommServ_Capture..CCM_App_Application b ON a.componentNameId = b.id
WHERE  NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_ScFilterFile c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_ScFilterFile'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_BackupSetName
INSERT INTO CommServ_Capture..CCM_App_BackupSetname
	SELECT a.*
FROM CCM_SOURCE_APP_BackupSetName a INNER JOIN (SELECT DISTINCT backupSet FROM CommServ_Capture..CCM_App_Application) b ON a.id = b.backupSet
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_BackupSetname c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_BackupSetName'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_App_IndexDBInfo
SET @tailQuery = 'a INNER JOIN CommServ_Capture..CCM_App_BackupSetname APPBKP ON a.backupSetGUID = APPBKP.GUID
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_IndexDBInfo c WHERE c.backupSetGUID = a.backupSetGUID ) '
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'App_IndexDBInfo', 'CommServ_Capture..CCM_App_IndexDBInfo', '', @i_exportDBName, @tailQuery
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_App_IndexDBInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_VMBackupSet
INSERT INTO CommServ_Capture..CCM_APP_VMBackupSet
	SELECT DISTINCT a.*
FROM CCM_SOURCE_APP_VMBackupSet a INNER JOIN CommServ_Capture..CCM_App_BackupSetname b ON ( a.ParentBackupSetId = b.id OR a.ChildBackupSetId = b.id )
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_APP_VMBackupSet c WHERE c.VMClientId = a.VMClientId AND c.ParentBackupSetId = a.ParentBackupSetId AND c.ChildBackupSetId = a.ChildBackupSetId )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_VMBackupSet'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_BackupSetProp
INSERT INTO CommServ_Capture..CCM_App_BackupSetProp
	SELECT a.*
FROM CCM_SOURCE_APP_BackupSetProp a INNER JOIN CommServ_Capture..CCM_App_BackupSetname b ON a.componentNameId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_BackupSetProp c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_BackupSetProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_InstanceName
INSERT INTO CommServ_Capture..CCM_App_InstanceName
	SELECT a.*
FROM CCM_SOURCE_APP_InstanceName a INNER JOIN (SELECT DISTINCT instance FROM CommServ_Capture..CCM_App_Application) b ON a.id = b.instance
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_InstanceName c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_InstanceName'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_InstanceProp
INSERT INTO CommServ_Capture..CCM_App_InstanceProp
	SELECT a.*
FROM CCM_SOURCE_APP_InstanceProp a INNER JOIN CommServ_Capture..CCM_App_InstanceName b ON a.componentNameId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_InstanceProp c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_InstanceProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_CredentialAssoc - Virtual Server Credential Assoc
INSERT INTO CommServ_Capture..CCM_APP_CredentialAssoc
	SELECT A.*
	FROM CCM_SOURCE_APP_CredentialAssoc A
INNER JOIN CommServ_Capture..CCM_App_InstanceProp B ON B.attrName = 'Virtual Server Credential Assoc Id' AND B.modified = 0 AND CAST(A.assocId AS VARCHAR(128)) = B.attrVal
LEFT OUTER JOIN CommServ_Capture..CCM_APP_CredentialAssoc C ON C.assocId = A.assocId
	WHERE C.assocId IS NULL
    IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_CredentialAssoc - Virtual Server Credential Assoc'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_Credentials
SET @tailQuery = ' A LEFT OUTER JOIN CommServ_Capture..CCM_APP_Credentials B ON B.credentialId = A.credentialId
	WHERE B.credentialId IS NULL
AND EXISTS(SELECT 1 FROM CommServ_Capture..CCM_APP_CredentialAssoc C WHERE C.credentialId = A.credentialId) '
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'APP_Credentials', 'CommServ_Capture..CCM_APP_Credentials', '', @i_exportDBName, @tailQuery
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_Credentials'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_InstFilterFile
INSERT INTO CommServ_Capture..CCM_App_InstFilterFile
	SELECT a.*
FROM CCM_SOURCE_APP_InstFilterFile a INNER JOIN CommServ_Capture..CCM_App_InstanceName b ON a.componentNameId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_InstFilterFile c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_InstFilterFile'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_IDAName & CommServ_Capture..CCM_APP_IDAProp
INSERT INTO CommServ_Capture..CCM_App_IDAName
	SELECT DISTINCT a.*
FROM CCM_SOURCE_APP_IDAName a INNER JOIN CommServ_Capture..CCM_App_Application b ON a.clientId = b.clientId AND a.appTypeId = b.appTypeId
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_IDAName c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_IDAName'
		GOTO CX_ERROR_EXIT
	END
	-- Capture agents which do not have the subclients.
INSERT INTO CommServ_Capture..CCM_App_IDAName
	SELECT DISTINCT a.*
	FROM CCM_SOURCE_APP_IDAName a
		INNER JOIN CCM_SOURCE_simInstalledPackages Pkg ON Pkg.ClientId = a.clientId
		INNER JOIN CCM_SOURCE_simPackageMap pMap ON pMap.simPackageId = Pkg.simPackageId AND pMap.appType = a.AppTypeId
INNER JOIN CommServ_Capture..CCM_App_Client CL ON CL.id = a.clientId
	WHERE NOT EXISTS (SELECT 1 FROM CCM_SOURCE_APP_Application APP WHERE APP.appTypeId = a.AppTypeId AND APP.clientId = a.clientId )
AND NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_IDAName b WHERE a.id = b.id)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_IDAName -- VSA Agent Capture'
		GOTO CX_ERROR_EXIT
	END
	--  CommServ_Capture..CCM_APP_IDAProp
INSERT INTO CommServ_Capture..CCM_App_IDAProp
	SELECT a.*
FROM CCM_SOURCE_APP_IDAProp a INNER JOIN CommServ_Capture..CCM_App_IDAName b ON a.componentNameId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_IDAProp c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_IDAProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_DCvolInfo
INSERT INTO CommServ_Capture..CCM_App_DCVolInfo
SELECT a.* FROM CCM_SOURCE_APP_DCvolInfo a INNER JOIN CommServ_Capture..CCM_App_IDAName b ON a.componentNameId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_DCVolInfo c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_DCvolInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_APP_OracleRacInstance
INSERT INTO CommServ_Capture..CCM_App_OracleRacInstance
SELECT DISTINCT a.* FROM CCM_SOURCE_APP_OracleRacInstance a INNER JOIN CommServ_Capture..CCM_App_Application  b ON a.instaceId = b.instance AND b.appTypeId = 80
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_OracleRacInstance c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_DCvolInfo'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_CustomCalendar
INSERT INTO CommServ_Capture..CCM_App_CustomCalendar
	SELECT a.*
	FROM CCM_SOURCE_APP_CustomCalendar a
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_CustomCalendar c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_CustomCalendar'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_CustomCalendarMonths
INSERT INTO CommServ_Capture..CCM_App_CustomCalendarMonths
	SELECT a.* FROM CCM_SOURCE_APP_CustomCalendarMonths a
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_CustomCalendarMonths c WHERE c.calendarId = a.calendarId AND c.year = a.year AND c.month = a.month)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_CustomCalendarMonths'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_APP_ExtendedProperties
	--PrasadNara: Capture entries associated with client or appType or instance or backupset along with the entires associated with subclient
INSERT INTO CommServ_Capture..CCM_App_ExtendedProperties
	SELECT a.*
FROM CCM_SOURCE_APP_ExtendedProperties a, CommServ_Capture..CCM_App_Application c
	WHERE a.clientid = c.clientId
		AND a.appTypeId = c.appTypeId
		AND (a.Instance = 0 OR a.Instance = c.instance)
		AND (a.BackupSet = 0 OR a.BackupSet = c.backupSet)
		AND (a.subclientId = 0 OR a.subclientId = c.id)
AND NOT EXISTS ( SELECT 1 FROM CommServ_Capture..CCM_App_ExtendedProperties b
				WHERE   b.clientId = a.clientId
					AND	   b.appTypeId = a.appTypeId
					AND	   b.instance = a.instance
					AND	   b.backupSet = a.backupSet
					AND	   b.subclientId = a.subclientId
					AND	   b.attrType = a.attrType
					AND	   b.attrName = a.attrName
					AND	   cast(b.attrVal as nvarchar(max)) = cast(a.attrVal as nvarchar(max))
					AND	   b.MD5 = a.MD5
					AND	   b.created = a.created
					AND	   b.modified = a.modified
					AND	   b.ccpId = a.ccpId
				)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_APP_ExtendedProperties'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_PatchUpdateAgentInfo
INSERT INTO CommServ_Capture..CCM_PatchUpdateAgentInfo
SELECT a.* FROM CCM_SOURCE_PatchUpdateAgentInfo a inner join CommServ_Capture..CCM_App_Client b ON a.clientId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_PatchUpdateAgentInfo c WHERE c.id = a.id )
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_App -- CCM_PatchUpdateAgentInfo'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------
	-- CommServ_Capture..CCM_PatchMultiCache
INSERT INTO CommServ_Capture..CCM_PatchMultiCache
	SELECT a.*
FROM CCM_SOURCE_PatchMultiCache a inner join CommServ_Capture..CCM_App_Client b ON a.clientId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_PatchMultiCache c WHERE c.id = a.id )
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_App -- CCM_PatchMultiCache'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------
	-- CommServ_Capture..CCM_App_ComponentProp
INSERT INTO CommServ_Capture..CCM_App_ComponentProp
	SELECT a.*
FROM CCM_SOURCE_App_ComponentProp a INNER JOIN CommServ_Capture..CCM_App_SubClientProp b ON a.ComponentId = b.Id
AND a.ComponentType IN (7, 9)
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_ComponentProp c WHERE c.id = a.id )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_App_ComponentProp'
		GOTO CX_ERROR_EXIT
	END
	--CCM_Capture_DlpClientPass
INSERT INTO CommServ_Capture..CCM_DlpClientPass
	SELECT A.*
FROM CCM_SOURCE_DlpClientPass A INNER JOIN CommServ_Capture..CCM_App_Client B ON A.clientId = B.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_DlpClientPass c WHERE c.id = a.id )
	IF @@ERROR  > 0
	BEGIN
		   SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_Capture_DlpClientPass '
		   GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------
	-- CommServ_Capture..GRC_History
INSERT INTO CommServ_Capture..CCM_GRC_History
	SELECT a.*
	FROM CCM_SOURCE_GRC_History a
INNER JOIN CommServ_Capture..CCM_App_Client c ON a.EntityId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_GRC_History b
		ON a.EntityId = b.EntityId AND a.EntityType = b.EntityType AND a.DestCCID = b.DestCCID
	WHERE b.EntityId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- GRC_History'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------
	-- CommServ_Capture..CCM_MMNDMPHostInfo
INSERT INTO CommServ_Capture..CCM_MMNDMPHostInfo
	SELECT a.* from CCM_SOURCE_MMNDMPHostInfo a
INNER JOIN CommServ_Capture..CCM_App_Client b ON a.clientId = b.id
WHERE NOT EXISTS (SELECT 1 FROM CommServ_Capture..CCM_MMNDMPHostInfo c WHERE c.NDMPHostId = a.NDMPHostId )
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_APP -- CCM_MMNDMPHostInfo'
		GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_APP')
	delete from GxQscripts where name = 'CCM_Capture_APP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_APP')
	delete from GXDBVersions where aliasname = 'CCM_Capture_APP'
GO

insert into GXDBVersions values(2, 'CCM_Capture_APP',  '00010060007800040000', 'CCM_Capture_APP', '00010060007800040000')
GO

