

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_AG_to_80.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_AG_to_80.sp,v 1.2.72.2 2018/03/20 00:44:19 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_AG_to_80 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_AG_to_80')
	drop procedure CCM_Capture_AG_to_80
IF EXISTS (select * from GxQscripts where name='CCM_Capture_AG_to_80')
	delete from GxQscripts where name = 'CCM_Capture_AG_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_AG_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_AG_to_80'
GO
print '... Creating Procedure: CCM_Capture_AG_to_80'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_AG_to_80
  @i_subClientId integer,
  @i_clientId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_AG.spb
SET NOCOUNT ON
SET @errStr = 'ERROR: GENERAL ERROR!'
	/**************************************************************
	 * PrasadNara: 10:08 PM 9/3/2012
	 * We are calling this proc only when capturing last subclient in the dump.
	 * So making changes as required to capture all AG tables for all captured subclients in the dump.
	 **************************************************************/
	---------------------------------------------------------
	/*
	IF (@i_subClientId < 0)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_AG -- Invalid subclient'
		GOTO CX_ERROR_EXIT
	END
	IF (@i_clientId <= 1)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_AG -- Invalid clientId'
		GOTO CX_ERROR_EXIT
	END
	*/
	---------------------------------------------------------
	-- CommServ_Capture..CCM_ArchGroup
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID,
	a.origCCarchGroupId, a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays,
	a.flags, a.mediaPassword
	FROM CCM_SOURCE_ArchGroup a
INNER JOIN CommServ_Capture..CCM_ArchFile b ON a.id = b.archGroupId
INNER JOIN CommServ_Capture..CCM_App_Application c ON b.appId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup d ON a.id = d.id
	WHERE d.id IS NULL AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchFile'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- dataArchGrpID
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID,
				 a.origCCarchGroupId, a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays,
				 a.flags, a.mediaPassword
	FROM CCM_SOURCE_ArchGroup a
INNER JOIN CommServ_Capture..CCM_App_Application b ON a.id = b.dataArchGrpId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup c ON a.id = c.id
	WHERE c.id IS NULL  AND b.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_Application for dataArchGrpID'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- logArchGrpID
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID,
				 a.origCCarchGroupId, a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays,
				 a.flags, a.mediaPassword
	FROM CCM_SOURCE_ArchGroup a
INNER JOIN CommServ_Capture..CCM_App_Application b ON a.id = b.logArchGrpId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup c ON a.id = c.id
	WHERE c.id IS NULL AND b.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_Application for logArchGrpID'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- CCM_APP_BackupSetProp -- DB2 Default % SP
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID,
				 a.origCCarchGroupId, a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays,
				 a.flags, a.mediaPassword
	FROM CCM_SOURCE_ArchGroup a
WHERE a.id IN (SELECT DISTINCT attrVal FROM CommServ_Capture..CCM_App_BackupSetProp WHERE attrName like 'DB2 Default % SP')
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_ArchGroup)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_BackupSetProp for DB2 Default % SP'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- CCM_APP_InstanceProp -- DB2 Default % SP
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID,
				 a.origCCarchGroupId, a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays,
				 a.flags, a.mediaPassword
	FROM CCM_SOURCE_ArchGroup a
WHERE a.id IN (SELECT DISTINCT attrVal FROM CommServ_Capture..CCM_App_InstanceProp WHERE attrName like 'DB2 Default % SP')
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_ArchGroup)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_InstanceProp for DB2 Default % SP'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- IncrSP
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID,
				 a.origCCarchGroupId, a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays,
				 a.flags, a.mediaPassword
	FROM CCM_SOURCE_ArchGroup a
WHERE a.id IN (SELECT DISTINCT incrSP FROM CommServ_Capture..CCM_ArchGroup)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_ArchGroup)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchGroup for incrSP'
		GOTO CX_ERROR_EXIT
	END
DELETE FROM CommServ_Capture..CCM_ArchGroup
	WHERE defaultCopy = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup DELETE for defaultCopy = 0'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroupCopy
	-- Capture all copies of selected storage policy
INSERT INTO CommServ_Capture..CCM_ArchGroupCopy
	SELECT
	a.id, a.archGroupId, a.copy, a.name, a.flags, a.maxMultiplex, a.isActive, a.type, a.startTime, a.waitForIfOffline,
				 a.waitForIfBusy, a.archCheckStartTime, a.origCCcommCellID, a.origCCarchCopyId, a.sourceCopyId, a.delayedDays,
				 a.maxStreamNum, a.archCheckValidMonths, a.calendarId, a.SIDBStoreId, a.encType, a.encKeyLen, a.isSnapCopy,
				 a.isMirrorCopy, a.NWWriteSpeed, a.SIDBSnapIntervalHours, 0/*a.siloAppId*/, a.nDataInstance, a.description
	FROM CCM_SOURCE_ArchGroupCopy a
WHERE a.archGroupId IN (SELECT id FROM CommServ_Capture..CCM_ArchGroup)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
AND (a.flags & 524288) = 0
AND (a.extendedFlags & 8) = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroupCopy'
		GOTO CX_ERROR_EXIT
	END
	-- skip all GACP dependent copies for cross version
	IF exists (select * from MMConfigs where name = 'CCM_CONFIG_SKIP_GACP_COPIES_FOR_CROSS_VERSION_CCM' AND value = 1)
	BEGIN
DELETE CommServ_Capture..CCM_ArchGroupCopy
FROM CommServ_Capture..CCM_ArchGroupCopy AGC1 INNER JOIN CCM_SOURCE_ArchGroupCopy AGC2 ON AGC1.id = AGC2.id
WHERE AGC2.extendedFlags & 2 <> 0
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroupCopy -- failed to delete GACP dependent copies'
			GOTO CX_ERROR_EXIT
		END
	END
	-- CommServ_Capture..CCM_ArchAgingRule
INSERT INTO CommServ_Capture..CCM_ArchAgingRule
	SELECT
	a.copyId, a.retentionDays, a.fullCycles, a.flags, a.weekStart, a.monthStart, a.yearStart, a.archiverRetDays
	FROM CCM_SOURCE_ArchAgingRule a
WHERE a.copyId IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
AND a.copyId NOT IN (SELECT copyId FROM CommServ_Capture..CCM_ArchAgingRule)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchAgingRule'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchAgingRuleExtended
INSERT INTO CommServ_Capture..CCM_ArchAgingRuleExtended
	SELECT
	a.copyId, a.retentionDays, a.retentionRule, a.currPeriodBegin, a.currPeriodEnd
	FROM CCM_SOURCE_ArchAgingRuleExtended a
WHERE a.copyId IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
AND NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_ArchAgingRuleExtended
	     WHERE copyId = a.copyId
	       AND retentionDays = a.retentionDays
	       AND retentionRule = a.retentionRule)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchAgingRuleExtended'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchSELECTiveCopy
INSERT INTO CommServ_Capture..CCM_ArchSelectiveCopy
	SELECT
	a.copyId, a.type, a.numPeriod, a.dayNumber, a.startPeriod, a.nextPeriod
	FROM CCM_SOURCE_ArchSELECTiveCopy a
WHERE a.copyId IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
AND a.copyId NOT IN (SELECT copyId FROM CommServ_Capture..CCM_ArchSelectiveCopy)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchSELECTiveCopy'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchStream
INSERT INTO CommServ_Capture..CCM_ArchStream
	SELECT
	a.archGroupId, a.archGroupCopyId, a.stream, a.mediaGroupId, a.isActive, a.lastUsedTime
	FROM CCM_SOURCE_ArchStream a
WHERE a.archGroupCopyId IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
AND NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_ArchStream
	     WHERE stream = a.stream
	       AND archGroupCopyId = a.archGroupCopyId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchStream'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchPipeconfig
INSERT INTO CommServ_Capture..CCM_ArchPipeConfig
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchPipeconfig a
INNER JOIN CommServ_Capture..CCM_App_Application b ON a.appNumber = b.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchPipeConfig c ON a.appNumber = c.appNumber
	WHERE c.appNumber IS NULL AND b.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchPipeconfig'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchCopyToApp
	--Associated to subclient
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_Application c ON a.subClientId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopyToApp d ON d.copyId = a.copyId
			AND d.clientId = a.clientId AND d.appTypeId = a.appTypeId
			AND d.instanceId = a.instanceId AND d.backupSetId = a.backupSetId
			AND d.subClientId = a.subClientId
	WHERE d.clientId IS NULL AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to backupset
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_BackupSetname c ON a.backupSetId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopyToApp d ON d.copyId = a.copyId
			AND d.clientId = a.clientId AND d.appTypeId = a.appTypeId
			AND d.instanceId = a.instanceId AND d.backupSetId = a.backupSetId
			AND d.subClientId = a.subClientId
	WHERE d.clientId IS NULL
		AND a.subClientId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to instance
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_InstanceName c ON a.instanceId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopyToApp d ON d.copyId = a.copyId
			AND d.clientId = a.clientId AND d.appTypeId = a.appTypeId
			AND d.instanceId = a.instanceId AND d.backupSetId = a.backupSetId
			AND d.subClientId = a.subClientId
	WHERE d.clientId IS NULL
		AND a.subClientId = 0
		AND a.backupSetId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to appType
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_IDAName c ON a.appTypeId = c.appTypeId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopyToApp d ON d.copyId = a.copyId
			AND d.clientId = a.clientId AND d.appTypeId = a.appTypeId
			AND d.instanceId = a.instanceId AND d.backupSetId = a.backupSetId
			AND d.subClientId = a.subClientId
	WHERE d.clientId IS NULL
		AND a.subClientId = 0
		AND a.backupSetId = 0
		AND a.instanceId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to appType
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_Client c ON a.clientId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopyToApp d ON d.copyId = a.copyId
			AND d.clientId = a.clientId AND d.appTypeId = a.appTypeId
			AND d.instanceId = a.instanceId AND d.backupSetId = a.backupSetId
			AND d.subClientId = a.subClientId
	WHERE d.clientId IS NULL
		AND a.subClientId = 0
		AND a.backupSetId = 0
		AND a.instanceId = 0
		AND a.appTypeId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_IdxSIDBStore
	SELECT a.SIDBStoreId, a.SIDBStoreName, a.SIDBStoreAliasName, a.CommCellId, b.CopyId, a.IdxCacheId, a.IdxAccessPathId,
		 	 	 a.ClientId, a.FirstBackupTime, a.MinObjSizeKB, a.oldestEligibleObjArchiveTime, a.SignatureType, a.flags,
		 	 	 a.TotalDataSizeBytes, a.InstancedDataSizeBytes, a.Status, a.LastAccessTime, a.CreatedTime, a.SealedTime, a.origCCSIDBStoreId
	FROM CCM_SOURCE_IdxSIDBStore a INNER JOIN CCM_SOURCE_archCopySIDBStore b ON a.SIDBStoreId = b.SIDBStoreId
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy c ON b.CopyId = c.id
WHERE NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_IdxSIDBStore
	       WHERE SIDBStoreId = a.SIDBStoreId
	         AND CommCellId = a.CommCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_IdxSIDBStore'
		GOTO CX_ERROR_EXIT
	END
    --Update IdxSIDBStore with details from IdxSIDBSubStore
UPDATE 	CommServ_Capture..CCM_IdxSIDBStore
	SET		IdxCacheId 		= substore.IdxCacheId,
			IdxAccessPathId = substore.IdxAccessPathId,
			ClientId		= substore.ClientId
FROM	CommServ_Capture..CCM_IdxSIDBStore store
			INNER JOIN CCM_SOURCE_IdxSIDBSubStore substore
			ON substore.SIDBStoreId = store.SIDBStoreId and substore.CommCellId = store.CommCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_IdxSIDBStore - UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_IdxAccessPathMapping
	-- Only select the default one for current single instance store in current copy
INSERT INTO CommServ_Capture..CCM_IdxAccessPathMapping
	SELECT a.SIDBStoreId, a.SIDBStoreName, b.IdxAccessPathId, e.name, d.name, c.name, b.path, 0, '', '', ''
FROM 	CommServ_Capture..CCM_IdxSIDBStore a, CCM_SOURCE_IdxAccessPath b, CCM_SOURCE_App_Client c,
CommServ_Capture..CCM_ArchGroupCopy d, CommServ_Capture..CCM_ArchGroup e
	WHERE	a.IdxAccessPathId = b.IdxAccessPathId
	AND b.ClientId = c.Id
	AND d.ArchGroupId = e.Id
	AND	d.SIDBStoreId = a.SIDBStoreId
	AND a.SIDBStoreId > 0
AND NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_IdxAccessPathMapping
		   WHERE oldIdxAccessPathId = b.IdxAccessPathId
	       AND oldPath = b.path)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_IdxAccessPathMapping'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_DataPathMapping
INSERT INTO CommServ_Capture..CCM_DataPathMapping
	SELECT b.id, 0, a.name, b.name, 0, 0, 0, 0
FROM CommServ_Capture..CCM_ArchGroup a, CommServ_Capture..CCM_ArchGroupCopy b
	WHERE a.id = b.archGroupId
AND NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_DataPathMapping
	     WHERE oldCopyId = b.id
	     	 AND oldPolicyName = a.name
	     	 AND oldCopyName = b.name)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_DataPathMapping'
		GOTO CX_ERROR_EXIT
	END
DELETE FROM CommServ_Capture..CCM_JMJobDataStats
WHERE archGrpCopyId not IN (SELECT c.id FROM CommServ_Capture..CCM_ArchGroupCopy c) -- Avoid Job history corresponding to deleted storage policy copies
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_DataPathMapping'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_MMMediaGroup
INSERT INTO CommServ_Capture..CCM_MMMediaGroup
SELECT DISTINCT a.* from CCM_SOURCE_MMMediaGroup a INNER JOIN CommServ_Capture..CCM_ArchStream b
		ON a.MediaGroupId = b.MediaGroupId
WHERE a.MediaGroupId NOT IN (SELECT MediaGroupId FROM CommServ_Capture..CCM_MMMediaGroup)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_MMMediaGroup'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_AG_to_80')
	delete from GxQscripts where name = 'CCM_Capture_AG_to_80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_AG_to_80')
	delete from GXDBVersions where aliasname = 'CCM_Capture_AG_to_80'
GO

insert into GXDBVersions values(2, 'CCM_Capture_AG_to_80',  '00010002007200020000', 'CCM_Capture_AG_to_80', '00010002007200020000')
GO

