

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_AG_To_100.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_AG_To_100.sp,v 1.1.60.2 2018/03/20 00:36:59 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_AG_To_100 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_AG_To_100')
	drop procedure CCM_Capture_AG_To_100
IF EXISTS (select * from GxQscripts where name='CCM_Capture_AG_To_100')
	delete from GxQscripts where name = 'CCM_Capture_AG_To_100'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_AG_To_100')
	delete from GXDBVersions where aliasname = 'CCM_Capture_AG_To_100'
GO
print '... Creating Procedure: CCM_Capture_AG_To_100'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_AG_To_100
  @i_subClientId integer,
  @i_clientId integer,
  @ccmParamFlags integer,
  @i_jobId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_AG.spb
SET NOCOUNT ON
SET @errStr = 'ERROR: GENERAL ERROR!'
	/**************************************************************
	 * PrasadNara: 10:08 PM 9/3/2012
	 * We are calling this proc only when capturing last subclient in the dump.
	 * So making changes as required to capture all AG tables for all captured subclients in the dump.
	 **************************************************************/
	---------------------------------------------------------
	/*
	IF (@i_subClientId < 0)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_AG -- Invalid subclient'
		GOTO CX_ERROR_EXIT
	END
	IF (@i_clientId <= 1)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_AG -- Invalid clientId'
		GOTO CX_ERROR_EXIT
	END
	*/
	--Get Current capture jobid
	DECLARE @l_curCaptureJobId Integer
	SET @l_curCaptureJobId =  ISNULL
	(
		(
			@i_jobId
		), 0
	)
	---------------------------------------------------------
	-- CommServ_Capture..CCM_ArchGroup
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID, a.origCCarchGroupId,
	a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays, a.flags, a.mediaPassword, a.TimeZoneType, a.TimeZone
	FROM CCM_SOURCE_ArchGroup a
INNER JOIN CommServ_Capture..CCM_ArchFile b ON a.id = b.archGroupId
INNER JOIN CommServ_Capture..CCM_App_Application c ON b.appId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup d ON a.id = d.id
	WHERE d.id IS NULL AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchFile'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- dataArchGrpID
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID, a.origCCarchGroupId,
	a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays, a.flags, a.mediaPassword, a.TimeZoneType, a.TimeZone
	FROM CCM_SOURCE_ArchGroup a
INNER JOIN CommServ_Capture..CCM_App_Application b ON a.id = b.dataArchGrpId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup c ON a.id = c.id
	WHERE c.id IS NULL  AND b.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_Application for dataArchGrpID'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- logArchGrpID
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID, a.origCCarchGroupId,
	a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays, a.flags, a.mediaPassword, a.TimeZoneType, a.TimeZone
	FROM CCM_SOURCE_ArchGroup a
INNER JOIN CommServ_Capture..CCM_App_Application b ON a.id = b.logArchGrpId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup c ON a.id = c.id
	WHERE c.id IS NULL AND b.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_Application for logArchGrpID'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- CCM_APP_BackupSetProp -- DB2 Default % SP
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID, a.origCCarchGroupId,
	a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays, a.flags, a.mediaPassword, a.TimeZoneType, a.TimeZone
	FROM CCM_SOURCE_ArchGroup a
WHERE a.id IN (SELECT DISTINCT attrVal FROM CommServ_Capture..CCM_App_BackupSetProp WHERE attrName like 'DB2 Default % SP')
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_ArchGroup)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_BackupSetProp for DB2 Default % SP'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- CCM_APP_InstanceProp -- DB2 Default % SP
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID, a.origCCarchGroupId,
	a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays, a.flags, a.mediaPassword, a.TimeZoneType, a.TimeZone
	FROM CCM_SOURCE_ArchGroup a
WHERE a.id IN (SELECT DISTINCT attrVal FROM CommServ_Capture..CCM_App_InstanceProp WHERE attrName like 'DB2 Default % SP')
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_ArchGroup)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_InstanceProp for DB2 Default % SP'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- IncrSP
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID, a.origCCarchGroupId,
	a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays, a.flags, a.mediaPassword, a.TimeZoneType, a.TimeZone
	FROM CCM_SOURCE_ArchGroup a
WHERE a.id IN (SELECT DISTINCT incrSP FROM CommServ_Capture..CCM_ArchGroup)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_ArchGroup)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchGroup for incrSP'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- archFailedKilledJobInfo
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID, a.origCCarchGroupId,
	a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays, a.flags, a.mediaPassword, a.TimeZoneType, a.TimeZone
	FROM CCM_SOURCE_ArchGroup a
		INNER JOIN CCM_SOURCE_archFailedKilledJobInfo b ON a.id = b.archGrpId
INNER JOIN CommServ_Capture..CCM_App_Application c ON b.appId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup d ON a.id = d.id
	WHERE d.id IS NULL AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchGroup for archFailedKilledJobInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- JMJobSnapshotStats
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID, a.origCCarchGroupId,
	a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays, a.flags, a.mediaPassword, a.TimeZoneType, a.TimeZone
	FROM CCM_SOURCE_ArchGroup a
		INNER JOIN CCM_SOURCE_JMJobSnapshotStats b ON a.id = b.archGrpId
INNER JOIN CommServ_Capture..CCM_App_Application c ON b.appId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup d ON a.id = d.id
	WHERE d.id IS NULL AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchGroup for JMJobSnapshotStats'
		GOTO CX_ERROR_EXIT
	END
	-- We capture all the entries in archFileSIDBKeys for a captured store, so we should capture all the copies of the store. Do this only in last dump.
	IF (
SELECT COUNT(*) FROM CCMCaptureEntities WHERE  Type = 7
			AND Status = 0
			AND JobId = @l_curCaptureJobId
		) = 1
	BEGIN
INSERT 	INTO CommServ_Capture..CCM_ArchGroup
		SELECT DISTINCT
		e.id, e.defaultCopy, e.name, e.description, e.maxStreams, e.type, e.incrSP, e.origCCcommCellID, e.origCCarchGroupId,
		e.defaultSnapCopy, e.SIBlockSizeKB, e.AuxCopyAlertGB, e.AuxCopyAlertDays, e.flags, e.mediaPassword, e.TimeZoneType, e.TimeZone
		FROM 	CCMEntitiesCaptured a
INNER JOIN CCM_SOURCE_ArchGroupCopy b ON b.id = a.EntityId AND a.EntityType = 18 AND a.EntityCCId = 0 AND a.captureJobId = @l_curCaptureJobId
AND b.SIDBStoreId > 0 AND (b.dedupeFlags & 134217728) > 0
				INNER JOIN CCM_SOURCE_ArchGroupCopy c ON b.SIDBStoreId = c.SIDBStoreId AND b.id <> c.id
				INNER JOIN CCM_SOURCE_ArchGroup e ON c.archGroupId = e.Id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup d ON e.id = d.id
		WHERE 	d.id IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup for GDSP stores for previous dumps'
			GOTO CX_ERROR_EXIT
		END
INSERT 	INTO CommServ_Capture..CCM_ArchGroup
		SELECT DISTINCT
		e.id, e.defaultCopy, e.name, e.description, e.maxStreams, e.type, e.incrSP, e.origCCcommCellID, e.origCCarchGroupId,
		e.defaultSnapCopy, e.SIBlockSizeKB, e.AuxCopyAlertGB, e.AuxCopyAlertDays, e.flags, e.mediaPassword, e.TimeZoneType, e.TimeZone
FROM 	CommServ_Capture..CCM_ArchGroup a
INNER JOIN CCM_SOURCE_ArchGroupCopy b ON a.Id = b.archGroupId AND b.SIDBStoreId > 0 AND (b.dedupeFlags & 134217728) > 0
				INNER JOIN CCM_SOURCE_ArchGroupCopy c ON b.SIDBStoreId = c.SIDBStoreId AND b.id <> c.id
				INNER JOIN CCM_SOURCE_ArchGroup e ON c.archGroupId = e.Id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup d ON e.id = d.id
		WHERE 	d.id IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup for GDSP stores'
			GOTO CX_ERROR_EXIT
		END
	END
DELETE FROM CommServ_Capture..CCM_ArchGroup
	WHERE defaultCopy = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup DELETE for defaultCopy = 0'
		GOTO CX_ERROR_EXIT
	END
	-- Capture Global Dedup Policy if the copies that we are going to capture use global stores
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT
	a.id, a.defaultCopy, a.name, a.description, a.maxStreams, a.type, a.incrSP, a.origCCcommCellID, a.origCCarchGroupId,
	a.defaultSnapCopy, a.SIBlockSizeKB, a.AuxCopyAlertGB, a.AuxCopyAlertDays, a.flags, a.mediaPassword, a.TimeZoneType, a.TimeZone
	FROM CCM_SOURCE_ArchGroup a
	WHERE a.id in
	(
	SELECT DISTINCT archGroupId
	FROM    CCM_SOURCE_archGroupCopy
WHERE  SIDBStoreId in (SELECT SIDBStoreId FROM CCM_SOURCE_archGroupCopy WHERE archGroupId in (SELECT DISTINCT id from CommServ_Capture..CCM_ArchGroup))
And ( dedupeFlags & 268435456 ) > 0
	)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_ArchGroup)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup -- INSERT GLOBAL DEDUP STORAGE POLICY'
		GOTO CX_ERROR_EXIT
	END
	--Capture archMaterializeSnapShotProp
INSERT INTO CommServ_Capture..CCM_archMaterializeSnapShotProp
SELECT a.* FROM CCM_SOURCE_archMaterializeSnapshotProp a inner join CommServ_Capture..CCM_ArchGroup b ON a.archGroupId = b.id
WHERE  a.archGroupId not in (select archGroupId from CommServ_Capture..CCM_archMaterializeSnapShotProp)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archMaterializeSnapshotProp-- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroupCopy
	-- Capture all copies of selected storage policy
INSERT INTO CommServ_Capture..CCM_ArchGroupCopy
	SELECT
	a.id, a.archGroupId, a.copy, a.name, a.flags, a.maxMultiplex, a.isActive, a.type, a.startTime, a.waitForIfOffline,
				a.waitForIfBusy, a.archCheckStartTime, a.origCCcommCellID, a.origCCarchCopyId, a.sourceCopyId, a.delayedDays, a.maxStreamNum,
				a.archCheckValidMonths, a.calendarId, a.SIDBStoreId, a.encType, a.encKeyLen, a.isSnapCopy, a.isMirrorCopy, a.NWWriteSpeed,
				a.SIDBSnapIntervalHours, a.siloAppId, a.nDataInstance, a.description, a.dedupeFlags, a.blockCacheValidDays, a.nSiloStreams,
				a.silosInCache, a.siloRestoreMAClientId, a.siloRestoreClientId, a.sealStoreTaskId, 0, a.extendedFlags, a.destMediaCopyId, a.maxCacheDBSizeMB
	FROM CCM_SOURCE_ArchGroupCopy a
WHERE a.archGroupId IN (SELECT id FROM CommServ_Capture..CCM_ArchGroup)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroupCopy'
		GOTO CX_ERROR_EXIT
	END
	-- skip all GACP dependent copies for cross version
	IF exists (select * from MMConfigs where name = 'CCM_CONFIG_SKIP_GACP_COPIES_FOR_CROSS_VERSION_CCM' AND value = 1)
	BEGIN
DELETE CommServ_Capture..CCM_ArchGroupCopy
FROM CommServ_Capture..CCM_ArchGroupCopy AGC1 INNER JOIN CCM_SOURCE_ArchGroupCopy AGC2 ON AGC1.id = AGC2.id
WHERE AGC2.extendedFlags & 2 <> 0
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroupCopy -- failed to delete GACP dependent copies'
			GOTO CX_ERROR_EXIT
		END
	END
	--Set flag indicating NAS copy and do not add datapaths to those copies in destination
UPDATE CommServ_Capture..CCM_ArchGroupCopy SET flags = flags | 536870912
FROM CommServ_Capture..CCM_ArchGroupCopy a, CCM_SOURCE_MMDATAPATH b, CCM_SOURCE_MMDRIVEPOOL c
	WHERE a.id = b.CopyId
	AND b.flag & 1 > 0
	AND b.DrivePoolId = c.DrivePoolId
AND c.DrivePoolType = 3
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroupCopy -- SET flags indicating Direct-Attached NAS drivepool copy'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_ArchCopyMediaRefreshProp
	SELECT b.*
	FROM CCM_SOURCE_archGroupCopy a INNER JOIN CCM_SOURCE_archCopyMediaRefreshProp b ON a.id = b.copyId
WHERE a.id IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
AND a.id NOT IN (SELECT copyId FROM CommServ_Capture..CCM_ArchCopyMediaRefreshProp)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archCopyMediaRefreshProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchAgingRule
INSERT INTO CommServ_Capture..CCM_ArchAgingRule
	SELECT
	a.*
	FROM CCM_SOURCE_ArchAgingRule a
WHERE a.copyId IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
AND a.copyId NOT IN (SELECT copyId FROM CommServ_Capture..CCM_ArchAgingRule)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchAgingRule'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchAgingRuleExtended
INSERT INTO CommServ_Capture..CCM_ArchAgingRuleExtended
	SELECT
	a.*
	FROM CCM_SOURCE_ArchAgingRuleExtended a
WHERE a.copyId IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
AND NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_ArchAgingRuleExtended
	     WHERE copyId = a.copyId
	       AND retentionDays = a.retentionDays
	       AND retentionRule = a.retentionRule)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchAgingRuleExtended'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchSELECTiveCopy
INSERT INTO CommServ_Capture..CCM_ArchSelectiveCopy
	SELECT
	a.*
	FROM CCM_SOURCE_ArchSELECTiveCopy a
WHERE a.copyId IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
AND a.copyId NOT IN (SELECT copyId FROM CommServ_Capture..CCM_ArchSelectiveCopy)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchSELECTiveCopy'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchStream
INSERT INTO CommServ_Capture..CCM_ArchStream
	SELECT
	a.*
	FROM CCM_SOURCE_ArchStream a
WHERE a.archGroupCopyId IN (SELECT id FROM CommServ_Capture..CCM_ArchGroupCopy)
AND NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_ArchStream
	     WHERE stream = a.stream
	       AND archGroupCopyId = a.archGroupCopyId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchStream'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchPipeconfig
INSERT INTO CommServ_Capture..CCM_ArchPipeConfig
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchPipeconfig a
INNER JOIN CommServ_Capture..CCM_App_Application b ON a.appNumber = b.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchPipeConfig c ON a.appNumber = c.appNumber
	WHERE c.appNumber IS NULL AND b.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchPipeconfig'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchCopyToApp
	--Associated to subclient
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_Application c ON a.subClientId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopyToApp d ON d.copyId = a.copyId
			AND d.clientId = a.clientId AND d.appTypeId = a.appTypeId
			AND d.instanceId = a.instanceId AND d.backupSetId = a.backupSetId
			AND d.subClientId = a.subClientId
	WHERE d.clientId IS NULL AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to backupset
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_BackupSetname c ON a.backupSetId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopyToApp d ON d.copyId = a.copyId
			AND d.clientId = a.clientId AND d.appTypeId = a.appTypeId
			AND d.instanceId = a.instanceId AND d.backupSetId = a.backupSetId
			AND d.subClientId = a.subClientId
	WHERE d.clientId IS NULL
		AND a.subClientId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to instance
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_InstanceName c ON a.instanceId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopyToApp d ON d.copyId = a.copyId
			AND d.clientId = a.clientId AND d.appTypeId = a.appTypeId
			AND d.instanceId = a.instanceId AND d.backupSetId = a.backupSetId
			AND d.subClientId = a.subClientId
	WHERE d.clientId IS NULL
		AND a.subClientId = 0
		AND a.backupSetId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to appType
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_IDAName c ON a.appTypeId = c.appTypeId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopyToApp d ON d.copyId = a.copyId
			AND d.clientId = a.clientId AND d.appTypeId = a.appTypeId
			AND d.instanceId = a.instanceId AND d.backupSetId = a.backupSetId
			AND d.subClientId = a.subClientId
	WHERE d.clientId IS NULL
		AND a.subClientId = 0
		AND a.backupSetId = 0
		AND a.instanceId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to appType
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_Client c ON a.clientId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopyToApp d ON d.copyId = a.copyId
			AND d.clientId = a.clientId AND d.appTypeId = a.appTypeId
			AND d.instanceId = a.instanceId AND d.backupSetId = a.backupSetId
			AND d.subClientId = a.subClientId
	WHERE d.clientId IS NULL
		AND a.subClientId = 0
		AND a.backupSetId = 0
		AND a.instanceId = 0
		AND a.appTypeId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Capture stores which are associated to valid clients or valid migrated stores
	--(Stores created with  clientid 1 during merge for GRC with commcellid 2 and don't have any valid data)
	-- CommServ_Capture..CCM_archCopySIDBStore
INSERT INTO CommServ_Capture..CCM_ArchCopySIDBStore
	SELECT DISTINCT a.* FROM CCM_SOURCE_archCopySIDBStore a INNER JOIN CCM_SOURCE_IdxSIDBSubStore b ON a.SIDBStoreId = b.SIDBStoreId
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy c ON a.copyId = c.Id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchCopySIDBStore d ON d.CopyId = a.CopyId AND d.SIDBStoreId = a.SIDBStoreId
	WHERE d.CopyId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archCopySIDBStore'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_IdxSIDBStore (Will consider both active and sealed SIDB Stores of the copy)
INSERT INTO CommServ_Capture..CCM_IdxSIDBStore
	SELECT 	DISTINCT
	a.SIDBStoreId, a.SIDBStoreName, a.SIDBStoreAliasName, a.CommCellId,	a.IdxCacheId,	a.IdxAccessPathId, a.ClientId, a.FirstBackupTime, a.MinObjSizeKB,
	a.oldestEligibleObjArchiveTime, a.SignatureType, a.flags, a.TotalDataSizeBytes, a.InstancedDataSizeBytes,	a.Status,	a.LastAccessTime,
	a.CreatedTime, a.SealedTime, a.origCCSIDBStoreId, a.Version, a.SIDBSnapPath, a.LastSnapTime, a.LastRecoveryTime, a.SealedReason, a.SIDBSiloedTime,
	a.SIDBSiloStatus,	a.SIDBSiloJobId, SubStoreCount
FROM CCM_SOURCE_IdxSIDBStore a, CommServ_Capture..CCM_ArchCopySIDBStore b
	WHERE a.SIDBStoreId = b.SIDBStoreId
	  AND a.CommCellId = b.CommCellId
AND NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_IdxSIDBStore
	       WHERE SIDBStoreId = a.SIDBStoreId
	         AND CommCellId = a.CommCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_IdxSIDBStore'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_IdxSIDBSubStore
INSERT INTO CommServ_Capture..CCM_IdxSIDBSubStore
	SELECT DISTINCT substore.*
	FROM CCM_SOURCE_IdxSIDBSubStore substore
inner join CommServ_Capture..CCM_IdxSIDBStore store
	ON substore.SIDBStoreId = store.SIDBStoreId and substore.CommCellId = store.CommCellId
left outer join (SELECT SubStoreId,CommCellId FROM CommServ_Capture..CCM_IdxSIDBSubStore) csubstore
	ON substore.SubStoreId = csubstore.SubStoreId and substore.CommCellId = csubstore.CommCellId
	WHERE csubstore.SubStoreId is null
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_IdxSIDBSubStore'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_IdxAccessPathMapping
INSERT INTO CommServ_Capture..CCM_IdxAccessPathMapping
	SELECT A.* FROM
	(
		SELECT	DISTINCT 0 as oldIdxSIDBStoreId, 'DUMMY' as oldIdxSIDBStoreName,
				b.IdxAccessPathId as oldIdxAccessPathId, '' as oldStoragePolicyName, '' as oldCopyName,
				c.name as oldClientName, b.path as oldPath, 0 as newClientId, '' as newPath, '' as newUserName,
				'' as newPassword, 0 as isGlobal
FROM  	CommServ_Capture..CCM_IdxSIDBSubStore a
				inner join CCM_SOURCE_IdxAccessPath b ON a.IdxAccessPathId = b.IdxAccessPathId
				inner join CCM_SOURCE_App_Client c ON  b.ClientId = c.Id
		WHERE 	a.SIDBStoreId > 0
				AND a.SubStoreId > 0
	) A
left outer join (SELECT distinct oldIdxAccessPathId FROM CommServ_Capture..CCM_IdxAccessPathMapping) B
		ON A.oldIdxAccessPathId = B.oldIdxAccessPathId
	WHERE B.oldIdxAccessPathId is null
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_IdxAccessPathMapping'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_DataPathMapping
	/*
	  Till 8.0, even though the copy might have multiple data paths, only one data path will be migrated to the destination commcell.
	  The migrated data path would be set as the default datapath for the migrated storage policy copy.
	  From 9.0, all configured data paths from the source commcell will be migrated to the destination commcell. The default data path
	  of the source commcell will be the default data path in the destination commcell. Hence, we capture data path specific information
	  like library, media agent, drive pool and drive type and also the flag (which indicates as to whether the current data path is
	  default or not)
	 */
	IF( OBJECT_ID('tempdb.dbo.#l_CCM_SOURCE_MMLibrary') is null)
	begin
		select * into #l_CCM_SOURCE_MMLibrary
		from MMLibrary where 1 = 0
	end
	IF(OBJECTPROPERTY(object_ID('MMLibrary'), 'TableHasIdentity') =1)
		SET IDENTITY_INSERT #l_CCM_SOURCE_MMLibrary ON
	EXEC CCM_Export_CopyTableFromLinkedServer  @i_isExportFromLinkedServer, 'MMLibrary', 'tempdb.dbo.#l_CCM_SOURCE_MMLibrary','', @i_exportDBName, ''
	IF(OBJECTPROPERTY(object_ID('MMLibrary'), 'TableHasIdentity') =1)
		SET IDENTITY_INSERT #l_CCM_SOURCE_MMLibrary OFF
	-- Changed back to migrate only the default datapath
INSERT INTO CommServ_Capture..CCM_DataPathMapping
	SELECT DISTINCT b.id, 0, a.name, b.name, 0, 0, 0, 0, f.LibraryId, f.LibraryName, d.ClientId, g.DriveTypeId, d.DrivePoolId, c.flag
FROM CommServ_Capture..CCM_ArchGroup a, CommServ_Capture..CCM_ArchGroupCopy b,
	     CCM_SOURCE_MMDataPath c,
	     CCM_SOURCE_MMDrivePool d,
	     CCM_SOURCE_MMMasterPool e,
	     tempdb.dbo.#l_CCM_SOURCE_MMLibrary f,
	     CCM_SOURCE_MMDrive g
	WHERE a.id = b.archGroupId
	  AND b.id = c.CopyId
	  AND c.Flag & 1 > 0
	  AND c.DrivePoolId = d.DrivePoolId
	  AND d.MasterPoolId = e.MasterPoolId
	  AND e.MasterPoolId = g.MasterPoolId
	  AND e.LibraryId = f.LibraryId
AND NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_DataPathMapping
	       WHERE oldCopyId = b.id
	         AND newCopyId = 0
	         AND oldPolicyName = a.name
	         AND oldCopyName = b.name
	         AND newMediaAgentId = 0
	         AND newLibraryId = 0
	         AND newDataPathId = 0
	         AND newSpareGroupId = 0
	         AND LibraryId = f.LibraryId
	         AND LibraryName = f.LibraryName
	         AND ClientId = d.ClientId
	         AND DriveTypeId = g.DriveTypeId
	         AND DrivePoolId = d.DrivePoolId
	         AND flag = c.flag)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_DataPathMapping'
		GOTO CX_ERROR_EXIT
	END
	IF(OBJECT_ID('tempdb.dbo.#l_CCM_SOURCE_MMLibrary')  is not null)
	 drop table #l_CCM_SOURCE_MMLibrary
DELETE FROM CommServ_Capture..CCM_JMJobDataStats
WHERE archGrpCopyId not IN (SELECT c.id FROM CommServ_Capture..CCM_ArchGroupCopy c) -- Avoid Job history corresponding to deleted storage policy copies
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_DataPathMapping'
		GOTO CX_ERROR_EXIT
	END
	--Capture ArchFileSIDBKeys in only last dump
	IF (
SELECT COUNT(*) FROM CCMCaptureEntities WHERE  Type = 7
			AND Status = 0
			AND JobId = @l_curCaptureJobId
		) = 1
	BEGIN
		--CommServ_Capture..CCM_archFileSIDBKeys
		--Capture using tracking table CCMEntitiesCaptured
INSERT INTO CommServ_Capture..CCM_archFileSIDBKeys
		SELECT
		a.archFileId, a.commCellId, a.archCopyId, a.encKeyType, a.encKey, a.SIDBStoreId
		FROM CCM_SOURCE_archFileSIDBKeys a
INNER JOIN CCMEntitiesCaptured c ON a.SIDBStoreId = c.EntityId AND c.EntityType = 41  --TODO create new entity for SIDBStore and change this
			AND c.EntityCCId = 0 AND c.captureJobId = @l_curCaptureJobId
LEFT OUTER JOIN CommServ_Capture..CCM_archFileSIDBKeys d ON a.archFileId = d.archFileId AND a.commcellId = d.commcellId
			AND a.archCopyId = d.archCopyId AND a.SIDBStoreId = d.SIDBStoreId
		WHERE d.archFileId is null
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archFileSIDBKeys -- 1'
			GOTO CX_ERROR_EXIT
		END
INSERT INTO CommServ_Capture..CCM_archFileSIDBKeys
		SELECT
		a.archFileId, a.commCellId, a.archCopyId, a.encKeyType, a.encKey, a.SIDBStoreId
FROM CCM_SOURCE_archFileSIDBKeys a inner join CommServ_Capture..CCM_IdxSIDBStore b
ON a.SIDBStoreId = b.SIDBStoreId left outer join CommServ_Capture..CCM_archFileSIDBKeys c
		ON a.archFileId = c.archFileId AND a.commcellId = c.commcellId AND a.archCopyId = c.archCopyId AND a.SIDBStoreId = c.SIDBStoreId
		WHERE c.archFileId is null
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archFileSIDBKeys -- 2'
			GOTO CX_ERROR_EXIT
		END
	END
	-- CommServ_Capture..CCM_MMMediaGroup
INSERT INTO CommServ_Capture..CCM_MMMediaGroup
SELECT DISTINCT a.* from CCM_SOURCE_MMMediaGroup a INNER JOIN CommServ_Capture..CCM_ArchStream b
		ON a.MediaGroupId = b.MediaGroupId
WHERE a.MediaGroupId NOT IN (SELECT MediaGroupId FROM CommServ_Capture..CCM_MMMediaGroup)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_MMMediaGroup'
		GOTO CX_ERROR_EXIT
	END
	--Capture silo subclients
	DECLARE @newSILOApps table (appId integer)
	DECLARE @siloSubClient integer
    DECLARE @errCode integer
	INSERT @newSILOApps
    SELECT DISTINCT a.id
	FROM CCM_SOURCE_APP_Application a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.id = b.siloAppId
LEFT OUTER JOIN CommServ_Capture..CCM_App_Application c ON a.id = c.id
    WHERE c.id IS NULL AND a.appTypeId <> 1000
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- INSERT -- @newSILOApps'
		GOTO CX_ERROR_EXIT
	END
INSERT CommServ_Capture..CCM_App_Application
    SELECT DISTINCT a.* FROM CCM_SOURCE_APP_Application a
		INNER JOIN @newSILOApps b ON a.id = b.appId
LEFT OUTER JOIN CommServ_Capture..CCM_App_Application c ON a.id = c.id
    WHERE c.id IS NULL AND a.appTypeId <> 1000
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_APP_Application -- INSERT -- @newSILOApps'
		GOTO CX_ERROR_EXIT
	END
	--does distinct cause problem
	IF object_id(N'tempdb.[dbo].[#tempError]') IS NOT NULL DROP TABLE #tempError
	CREATE TABLE #tempError (errCode INTEGER, errStr VARCHAR(MAX) )
	DECLARE @STOREDPROC_QUERY VARCHAR(MAX) = 'DECLARE @errCode INT , @errStr VARCHAR(MAX) ; '
	DECLARE @ERROR_HANDLE_QUERY VARCHAR(MAX) = ' IF @errCode <> 0 BEGIN INSERT INTO #tempError VALUES (@errCode, @errStr) ; RAISERROR (''%s'' , 16, 1 ,@errStr)  ; END ; '
	SELECT @STOREDPROC_QUERY +=
		'EXEC @errCode = CCM_Capture_APP_to_100 '+CONVERT(VARCHAR,appId)+',2,1, ' + CAST( @i_isExportFromLinkedServer AS varchar(10)) + ' , '+  @i_exportDBName + ' , @errStr = @errStr	OUTPUT	; '	+ @ERROR_HANDLE_QUERY
	FROM @newSILOApps
	BEGIN TRY
		EXEC (@STOREDPROC_QUERY)
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errCode = errCode , @errStr = errStr FROM #tempError
		GOTO CX_ERROR_EXIT
	END CATCH
/*
	DECLARE SILOSubClientsCursor CURSOR LOCAL FOR
    SELECT DISTINCT appId FROM @newSILOApps
    OPEN SILOSubClientsCursor
    FETCH NEXT FROM SILOSubClientsCursor
    INTO @siloSubClient
    WHILE (@@FETCH_STATUS = 0)
    BEGIN
		EXEC @errCode = CCM_Capture_APP_to_100 @siloSubClient,2,1, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errStr	OUTPUT
		IF	@errCode <> 0	GOTO CX_ERROR_EXIT
    FETCH NEXT FROM SILOSubClientsCursor
    INTO @siloSubClient
	END
    CLOSE SILOSubClientsCursor
    DEALLOCATE SILOSubClientsCursor
*/
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_AG_To_100')
	delete from GxQscripts where name = 'CCM_Capture_AG_To_100'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_AG_To_100')
	delete from GXDBVersions where aliasname = 'CCM_Capture_AG_To_100'
GO

insert into GXDBVersions values(2, 'CCM_Capture_AG_To_100',  '00010001006000020000', 'CCM_Capture_AG_To_100', '00010001006000020000')
GO

