

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_AG.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_AG.sp,v 1.46.72.5 2018/12/27 16:34:22 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_AG')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_AG <<<'
	drop procedure CCM_Capture_AG
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_AG')
	delete from GxQscripts where name = 'CCM_Capture_AG'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_AG')
	delete from GXDBVersions where aliasname = 'CCM_Capture_AG'
GO
print '... Creating Procedure: CCM_Capture_AG'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_Capture_AG
  @ccmParamFlags integer,
  @i_jobId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_AG.spb
SET NOCOUNT ON
SET @errStr = 'ERROR: GENERAL ERROR!'
	--Get Current capture jobid
	DECLARE @l_curCaptureJobId Integer
	SET @l_curCaptureJobId =  ISNULL
	(
		(
			@i_jobId
		), 0
	)
	---------------------------------------------------------
	-- CommServ_Capture..CCM_ArchGroup
INSERT INTO CommServ_Capture..CCM_ArchGroup
SELECT DISTINCT a.* FROM CCM_SOURCE_ArchGroup a INNER JOIN ( SELECT DISTINCT archGroupId FROM CommServ_Capture..CCM_ArchFile ) AS b ON a.id = b.archGroupId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchFile'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- dataArchGrpID
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT a.*
	FROM CCM_SOURCE_ArchGroup a
INNER JOIN CommServ_Capture..CCM_App_Application b ON a.id = b.dataArchGrpId OR a.id = b.logArchGrpId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup c ON a.id = c.id
	WHERE c.id IS NULL AND b.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_Application for dataArchGrpID'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- CCM_APP_BackupSetProp -- DB2 Default % SP
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT a.*
FROM CCM_SOURCE_ArchGroup a INNER JOIN CommServ_Capture..CCM_App_BackupSetProp b ON a.id = b.attrVal AND attrName = 'DB2 Default % SP'
WHERE NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_ArchGroup b WHERE b.id = a.id)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_BackupSetProp for DB2 Default % SP'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- CCM_APP_InstanceProp -- DB2 Default % SP
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT a.*
FROM CCM_SOURCE_ArchGroup a INNER JOIN CommServ_Capture..CCM_App_InstanceProp b ON a.id = b.attrVal AND attrName = 'DB2 Default % SP'
WHERE NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_ArchGroup b WHERE b.id = a.id)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_APP_InstanceProp for DB2 Default % SP'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- IncrSP
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT 	a.*
FROM CCM_SOURCE_ArchGroup a INNER JOIN CommServ_Capture..CCM_ArchGroup b ON a.id = b.incrSP
WHERE NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_ArchGroup b WHERE b.id = a.id)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchGroup for incrSP'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- logSP
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT 	a.*
FROM CCM_SOURCE_ArchGroup a INNER JOIN CommServ_Capture..CCM_ArchGroup b ON a.id = b.logSP
WHERE NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_ArchGroup b WHERE b.id = a.id)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchGroup for logSP'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- archFailedKilledJobInfo
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT a.*
	FROM CCM_SOURCE_ArchGroup a
		INNER JOIN (SELECT DISTINCT archGrpId, appId FROM CCM_SOURCE_archFailedKilledJobInfo ) AS b ON a.id = b.archGrpId
INNER JOIN CommServ_Capture..CCM_App_Application c ON b.appId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup d ON a.id = d.id
	WHERE d.id IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchGroup for archFailedKilledJobInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroup -- JMJobSnapshotStats
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT
	a.*
	FROM CCM_SOURCE_ArchGroup a
		INNER JOIN (SELECT DISTINCT archGrpId, appId FROM CCM_SOURCE_JMJobSnapshotStats ) AS b ON a.id = b.archGrpId
INNER JOIN CommServ_Capture..CCM_App_Application c ON b.appId = c.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup d ON a.id = d.id
	WHERE d.id IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup from CCM_ArchGroup for JMJobSnapshotStats'
		GOTO CX_ERROR_EXIT
	END
	-- We capture all the entries in archFileSIDBKeys for a captured store, so we should capture all the copies of the store. Do this only in last dump.
	IF (
SELECT COUNT(1) FROM CCMCaptureEntities WHERE  Type = 7
			AND Status = 0
			AND JobId = @l_curCaptureJobId
		) = 1
	BEGIN
INSERT 	INTO CommServ_Capture..CCM_ArchGroup
		SELECT DISTINCT e.*
		FROM 	CCMEntitiesCaptured a
INNER JOIN CCM_SOURCE_ArchGroupCopy b ON b.id = a.EntityId AND a.EntityType = 18 AND a.EntityCCId = 0 AND a.captureJobId = @l_curCaptureJobId
AND b.SIDBStoreId > 0 AND (b.dedupeFlags & 134217728) > 0
				INNER JOIN CCM_SOURCE_ArchGroupCopy c ON b.SIDBStoreId = c.SIDBStoreId AND b.id <> c.id
				INNER JOIN CCM_SOURCE_ArchGroup e ON c.archGroupId = e.Id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup d ON e.id = d.id
		WHERE 	d.id IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup for GDSP stores for previous dumps'
			GOTO CX_ERROR_EXIT
		END
INSERT 	INTO CommServ_Capture..CCM_ArchGroup
		SELECT DISTINCT e.*
FROM 	CommServ_Capture..CCM_ArchGroup a
INNER JOIN CCM_SOURCE_ArchGroupCopy b ON a.Id = b.archGroupId AND b.SIDBStoreId > 0 AND (b.dedupeFlags & 134217728) > 0
				INNER JOIN CCM_SOURCE_ArchGroupCopy c ON b.SIDBStoreId = c.SIDBStoreId AND b.id <> c.id
				INNER JOIN CCM_SOURCE_ArchGroup e ON c.archGroupId = e.Id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup d ON e.id = d.id
		WHERE 	d.id IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup for GDSP stores'
			GOTO CX_ERROR_EXIT
		END
	END
DELETE FROM CommServ_Capture..CCM_ArchGroup
	WHERE defaultCopy = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup DELETE for defaultCopy = 0'
		GOTO CX_ERROR_EXIT
	END
	-- Capture Global Secondary Copy Policy if the copies that we are going to capture are associate with GSCP
INSERT INTO CommServ_Capture..CCM_ArchGroup
SELECT DISTINCT a.*	FROM CCM_SOURCE_ArchGroup a, CCM_SOURCE_archGroupCopy AGC, CommServ_Capture..CCM_ArchGroup AGDB, CCM_SOURCE_archGroupCopy AGC1
	WHERE AGDB.id = AGC1.archGroupId
	AND AGC1.destMediaCopyId = AGC.id
	AND AGC.archGroupId = a.id
AND a.flags & 16384 = 16384
AND AGC.extendedFlags & 1 = 1
AND NOT EXISTS (SELECT id FROM CommServ_Capture..CCM_ArchGroup where id = a.id)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup -- INSERT GLOBAL SECONDARY COPY STORAGE POLICY'
		GOTO CX_ERROR_EXIT
	END
	-- Capture GDSP and GSP if dependent copies are captured
INSERT INTO CommServ_Capture..CCM_ArchGroup
	SELECT DISTINCT D.*
FROM CommServ_Capture..CCM_ArchGroup A	INNER JOIN CCM_SOURCE_archGroupCopy B ON B.archGroupId = A.id
		INNER JOIN CCM_SOURCE_archCopyToGlobalPolicy C ON C.copyId = B.id
		INNER JOIN CCM_SOURCE_ArchGroup D ON D.id = C.globalPolicyId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchGroup E ON D.id = E.id
	WHERE  E.id IS NULL
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroup -- INSERT Global Storage Policy'
		GOTO CX_ERROR_EXIT
	END
	--Capture archMaterializeSnapShotProp
INSERT INTO CommServ_Capture..CCM_archMaterializeSnapShotProp
SELECT a.* FROM CCM_SOURCE_archMaterializeSnapshotProp a inner join CommServ_Capture..CCM_ArchGroup b ON a.archGroupId = b.id
WHERE  a.archGroupId not in (select archGroupId from CommServ_Capture..CCM_archMaterializeSnapShotProp)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archMaterializeSnapshotProp-- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchGroupCopy
	-- Capture all copies of selected storage policy
INSERT INTO CommServ_Capture..CCM_ArchGroupCopy
	SELECT 	a.*
FROM CCM_SOURCE_ArchGroupCopy a INNER JOIN CommServ_Capture..CCM_ArchGroup b ON a.archGroupId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroupCopy'
		GOTO CX_ERROR_EXIT
	END
	--Set flag indicating NAS copy and do not add datapaths to those copies in destination
UPDATE CommServ_Capture..CCM_ArchGroupCopy SET flags = flags | 536870912
FROM CommServ_Capture..CCM_ArchGroupCopy a, CCM_SOURCE_MMDATAPATH b, CCM_SOURCE_MMDRIVEPOOL c
	WHERE a.id = b.CopyId
	AND b.flag & 1 > 0
	AND b.DrivePoolId = c.DrivePoolId
AND c.DrivePoolType = 3
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchGroupCopy -- SET flags indicating Direct-Attached NAS drivepool copy'
		GOTO CX_ERROR_EXIT
	END
	-- Capture archCopyToGlobalPolicy
INSERT INTO CommServ_Capture..CCM_archCopyToGlobalPolicy
	SELECT A.*
FROM CCM_SOURCE_archCopyToGlobalPolicy A  INNER JOIN CommServ_Capture..CCM_ArchGroupCopy B ON A.copyId = B.id
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archCopyToGlobalPolicy -- INSERT'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_ArchCopyMediaRefreshProp
	SELECT a.*
FROM CCM_SOURCE_archCopyMediaRefreshProp a INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archCopyMediaRefreshProp'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchAgingRule
INSERT INTO CommServ_Capture..CCM_ArchAgingRule
	SELECT a.*
FROM CCM_SOURCE_ArchAgingRule a INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchAgingRule'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchAgingRuleExtended
INSERT INTO CommServ_Capture..CCM_ArchAgingRuleExtended
	SELECT a.*
FROM CCM_SOURCE_ArchAgingRuleExtended a INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchAgingRuleExtended'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_archAppCopyAgingRule
INSERT INTO CommServ_Capture..CCM_archAppCopyAgingRule
	SELECT A.*
FROM CCM_SOURCE_archAppCopyAgingRule A INNER JOIN CommServ_Capture..CCM_App_Application B ON A.appId = B.id
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archAppCopyAgingRule'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_archAppCopyAgingRuleExtended
INSERT INTO CommServ_Capture..CCM_archAppCopyAgingRuleExtended
	SELECT A.*
FROM CCM_SOURCE_archAppCopyAgingRuleExtended A INNER JOIN CommServ_Capture..CCM_App_Application B ON A.appId = B.id
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archAppCopyAgingRuleExtended'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchSELECTiveCopy
INSERT INTO CommServ_Capture..CCM_ArchSelectiveCopy
	SELECT a.*
FROM CCM_SOURCE_ArchSELECTiveCopy a INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchSELECTiveCopy'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchStream
INSERT INTO CommServ_Capture..CCM_ArchStream
SELECT a.* 	FROM CCM_SOURCE_ArchStream a INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.archGroupCopyId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchStream'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchPipeconfig
INSERT INTO CommServ_Capture..CCM_ArchPipeConfig
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchPipeconfig a
INNER JOIN CommServ_Capture..CCM_App_Application b ON a.appNumber = b.id
LEFT OUTER JOIN CommServ_Capture..CCM_ArchPipeConfig c ON a.appNumber = c.appNumber
    WHERE c.appNumber IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchPipeconfig'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchCopyToApp
	--Associated to subclient
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_Application c ON a.subClientId = c.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to backupset
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_BackupSetname c ON a.backupSetId = c.id
	WHERE a.subClientId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to instance
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_InstanceName c ON a.instanceId = c.id
	WHERE a.subClientId = 0
		AND a.backupSetId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to appType
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_IDAName c ON a.appTypeId = c.appTypeId
	WHERE a.subClientId = 0
		AND a.backupSetId = 0
		AND a.instanceId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Associated to appType
INSERT INTO CommServ_Capture..CCM_ArchCopyToApp
	SELECT DISTINCT a.* FROM CCM_SOURCE_ArchCopyToApp a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.copyId = b.id
INNER JOIN CommServ_Capture..CCM_App_Client c ON a.clientId = c.id
	WHERE a.subClientId = 0
		AND a.backupSetId = 0
		AND a.instanceId = 0
		AND a.appTypeId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	-- don't capture association from clientGroup view
DELETE FROM CommServ_Capture..CCM_ArchCopyToApp
	WHERE clientGroupID > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyToApp'
		GOTO CX_ERROR_EXIT
	END
	--Capture stores which are associated to valid clients or valid migrated stores
	--(Stores created with  clientid 1 during merge for GRC with commcellid 2 and don't have any valid data)
	-- CommServ_Capture..CCM_archCopySIDBStore
INSERT INTO CommServ_Capture..CCM_ArchCopySIDBStore
	SELECT DISTINCT a.* FROM CCM_SOURCE_archCopySIDBStore a INNER JOIN CCM_SOURCE_IdxSIDBSubStore b ON a.SIDBStoreId = b.SIDBStoreId
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy c ON a.copyId = c.Id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archCopySIDBStore'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_IdxSIDBStore (Will consider both active and sealed SIDB Stores of the copy)
INSERT INTO CommServ_Capture..CCM_IdxSIDBStore
	SELECT 	DISTINCT a.*
FROM CCM_SOURCE_IdxSIDBStore a, CommServ_Capture..CCM_ArchCopySIDBStore b
	WHERE a.SIDBStoreId = b.SIDBStoreId
	  AND a.CommCellId = b.CommCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_IdxSIDBStore'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_IdxSIDBSubStore
INSERT INTO CommServ_Capture..CCM_IdxSIDBSubStore
	SELECT substore.*
	FROM CCM_SOURCE_IdxSIDBSubStore substore
inner join CommServ_Capture..CCM_IdxSIDBStore store
	ON substore.SIDBStoreId = store.SIDBStoreId and substore.CommCellId = store.CommCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_IdxSIDBSubStore'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_IdxAccessPathMapping
INSERT INTO CommServ_Capture..CCM_IdxAccessPathMapping
	SELECT A.* FROM
	(
		SELECT	DISTINCT 0 as oldIdxSIDBStoreId, 'DUMMY' as oldIdxSIDBStoreName,
				b.IdxAccessPathId as oldIdxAccessPathId, '' as oldStoragePolicyName, '' as oldCopyName,
				c.name as oldClientName, b.path as oldPath, 0 as newClientId, '' as newPath, '' as newUserName,
				'' as newPassword, 0 as isGlobal
FROM  	CommServ_Capture..CCM_IdxSIDBSubStore a
				inner join CCM_SOURCE_IdxAccessPath b ON a.IdxAccessPathId = b.IdxAccessPathId
				inner join CCM_SOURCE_App_Client c ON  b.ClientId = c.Id
		WHERE 	a.SIDBStoreId > 0
				AND a.SubStoreId > 0
	) A
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_IdxAccessPathMapping'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_DataPathMapping
	/*
	  Till 8.0, even though the copy might have multiple data paths, only one data path will be migrated to the destination commcell.
	  The migrated data path would be set as the default datapath for the migrated storage policy copy.
	  From 9.0, all configured data paths from the source commcell will be migrated to the destination commcell. The default data path
	  of the source commcell will be the default data path in the destination commcell. Hence, we capture data path specific information
	  like library, media agent, drive pool and drive type and also the flag (which indicates as to whether the current data path is
	  default or not)
	 */
	IF( OBJECT_ID('tempdb.dbo.#l_CCM_SOURCE_MMLibrary') is null)
	begin
		select * into #l_CCM_SOURCE_MMLibrary
		from MMLibrary where 1 = 0
	end
	IF(OBJECTPROPERTY(object_ID('MMLibrary'), 'TableHasIdentity') =1)
		SET IDENTITY_INSERT #l_CCM_SOURCE_MMLibrary ON
	EXEC CCM_Export_CopyTableFromLinkedServer  @i_isExportFromLinkedServer, 'MMLibrary', 'tempdb.dbo.#l_CCM_SOURCE_MMLibrary','', @i_exportDBName, ''
	IF(OBJECTPROPERTY(object_ID('MMLibrary'), 'TableHasIdentity') =1)
		SET IDENTITY_INSERT #l_CCM_SOURCE_MMLibrary OFF
	-- Changed back to migrate only the default datapath
INSERT INTO CommServ_Capture..CCM_DataPathMapping
	SELECT DISTINCT b.id, 0, a.name, b.name, 0, 0, 0, 0, f.LibraryId, f.LibraryName, d.ClientId, g.DriveTypeId, d.DrivePoolId, c.flag
FROM CommServ_Capture..CCM_ArchGroup a, CommServ_Capture..CCM_ArchGroupCopy b,
	     CCM_SOURCE_MMDataPath c,
	     CCM_SOURCE_MMDrivePool d,
	     CCM_SOURCE_MMMasterPool e,
	     tempdb.dbo.#l_CCM_SOURCE_MMLibrary f,
	     CCM_SOURCE_MMDrive g
	WHERE a.id = b.archGroupId
	  AND b.id = c.CopyId
	  AND c.Flag & 1 > 0
	  AND c.DrivePoolId = d.DrivePoolId
	  AND d.MasterPoolId = e.MasterPoolId
	  AND e.MasterPoolId = g.MasterPoolId
	  AND e.LibraryId = f.LibraryId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_DataPathMapping'
		GOTO CX_ERROR_EXIT
	END
	IF(OBJECT_ID('tempdb.dbo.#l_CCM_SOURCE_MMLibrary')  is not null)
	 drop table #l_CCM_SOURCE_MMLibrary
DELETE FROM CommServ_Capture..CCM_JMJobDataStats
WHERE archGrpCopyId not IN (SELECT c.id FROM CommServ_Capture..CCM_ArchGroupCopy c) -- Avoid Job history corresponding to deleted storage policy copies
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_DataPathMapping'
		GOTO CX_ERROR_EXIT
	END
	--Capture ArchFileSIDBKeys in only last dump
	IF (
SELECT COUNT(*) FROM CCMCaptureEntities WHERE  Type = 7
			AND Status = 0
			AND JobId = @l_curCaptureJobId
		) = 1
	BEGIN
		--CommServ_Capture..CCM_archFileSIDBKeys
		--Capture using tracking table CCMEntitiesCaptured
INSERT INTO CommServ_Capture..CCM_archFileSIDBKeys
		SELECT a.*
		FROM CCM_SOURCE_archFileSIDBKeys a
INNER JOIN CCMEntitiesCaptured c ON a.SIDBStoreId = c.EntityId AND c.EntityType = 41  --TODO create new entity for SIDBStore and change this
			AND c.EntityCCId = 0 AND c.captureJobId = @l_curCaptureJobId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archFileSIDBKeys -- 1'
			GOTO CX_ERROR_EXIT
		END
INSERT INTO CommServ_Capture..CCM_archFileSIDBKeys
		SELECT a.*
FROM CCM_SOURCE_archFileSIDBKeys a inner join CommServ_Capture..CCM_IdxSIDBStore b
ON a.SIDBStoreId = b.SIDBStoreId left outer join CommServ_Capture..CCM_archFileSIDBKeys c
		ON a.archFileId = c.archFileId AND a.commcellId = c.commcellId AND a.archCopyId = c.archCopyId AND a.SIDBStoreId = c.SIDBStoreId
		WHERE c.archFileId is null
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archFileSIDBKeys -- 2'
			GOTO CX_ERROR_EXIT
		END
INSERT INTO CommServ_Capture..CCM_archEncKeys
		SELECT keys.*
FROM 	CommServ_Capture..CCM_archFileSIDBKeys	a INNER JOIN CCM_SOURCE_archEncKeys keys ON a.EncKeyId = keys.EncKeyId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_archEncKeys -- 1'
			GOTO CX_ERROR_EXIT
		END
	END
	-- CommServ_Capture..CCM_MMMediaGroup
INSERT INTO CommServ_Capture..CCM_MMMediaGroup
SELECT DISTINCT a.* from CCM_SOURCE_MMMediaGroup a INNER JOIN CommServ_Capture..CCM_ArchStream b
		ON a.MediaGroupId = b.MediaGroupId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_MMMediaGroup'
		GOTO CX_ERROR_EXIT
	END
	--Capture silo subclients
	DECLARE @newSILOApps table (appId integer)
	DECLARE @siloSubClient integer
    DECLARE @errCode integer
	INSERT @newSILOApps
    SELECT DISTINCT a.id
	FROM CCM_SOURCE_APP_Application a
INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.id = b.siloAppId
LEFT OUTER JOIN CommServ_Capture..CCM_App_Application c ON a.id = c.id
    WHERE c.id IS NULL AND a.appTypeId <> 1000
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- INSERT -- @newSILOApps'
		GOTO CX_ERROR_EXIT
	END
INSERT CommServ_Capture..CCM_App_Application
    SELECT DISTINCT a.* FROM CCM_SOURCE_APP_Application a
		INNER JOIN @newSILOApps b ON a.id = b.appId
LEFT OUTER JOIN CommServ_Capture..CCM_App_Application c ON a.id = c.id
    WHERE c.id IS NULL AND a.appTypeId <> 1000
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_APP_Application -- INSERT -- @newSILOApps'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (SELECT 1 FROM @newSILOApps)
    BEGIN
IF NOT EXISTS(SELECT 1 FROM CommServ_Capture..CCM_App_Client WHERE id = 2)
		BEGIN
			EXEC @errCode = CCM_Capture_Client 2, @i_isExportFromLinkedServer, @i_exportDBName
			IF  @errCode <> 0 OR @@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AG -- Capture SILO client failed.'
				GOTO CX_ERROR_EXIT
			END
		END
        EXEC @errCode = CCM_CAPTURE_APP 0, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errStr OUTPUT
        IF  @errCode <> 0 OR @@ERROR > 0
        BEGIN
            SET @errStr = 'ERROR: CCM_Capture_AG -- Capture SILO application failed.'
            GOTO CX_ERROR_EXIT
        END
    END
	-- CommServ_Capture..CCM_ArchCopyEncProperties
INSERT 	INTO CommServ_Capture..CCM_ArchCopyEncProperties
	SELECT 	a.*
FROM 	CCM_SOURCE_ArchCopyEncProperties a INNER JOIN CommServ_Capture..CCM_ArchGroupCopy b ON a.CopyId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchCopyEncProperties'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchEncKeyProviderAssoc
INSERT 	INTO CommServ_Capture..CCM_ArchEncKeyProviderAssoc
	SELECT 	a.*
FROM 	CCM_SOURCE_ArchEncKeyProviderAssoc a INNER JOIN CommServ_Capture..CCM_ArchCopyEncProperties b ON a.EntityId = b.CopyId AND a.EntityType = 18
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchEncKeyProviderAssoc'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchEncKeyProvider
INSERT 	INTO CommServ_Capture..CCM_ArchEncKeyProvider
	SELECT 	a.*
FROM 	CCM_SOURCE_ArchEncKeyProvider a INNER JOIN (SELECT DISTINCT KeyProviderId FROM CommServ_Capture..CCM_ArchEncKeyProviderAssoc) AS b ON a.KeyProviderId = b.KeyProviderId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AG -- CCM_ArchEncKeyProvider'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_AG')
	delete from GxQscripts where name = 'CCM_Capture_AG'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_AG')
	delete from GXDBVersions where aliasname = 'CCM_Capture_AG'
GO

insert into GXDBVersions values(2, 'CCM_Capture_AG',  '00010046007200050000', 'CCM_Capture_AG', '00010046007200050000')
GO

