

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_AF_to_XML.sp] ---------- 

--  +=============================================================================================================================+
--  | Stored Procedure: Capture client application data to migrate data into temp db tables which will later be converted into xml
--  +=============================================================================================================================+
-- $Id: CCM_Capture_AF_to_XML.sp,v 1.5.58.4 2018/12/27 16:48:46 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Capture_AF_to_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Capture_AF_to_XML <<<'
	drop procedure CCM_Capture_AF_to_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Capture_AF_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_AF_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_AF_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_AF_to_XML'
GO
print '... Creating Procedure: CCM_Capture_AF_to_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_AF_to_XML
  @time_from integer,
  @time_to integer,
  @ccmParamFlags integer,
  @i_jobId integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--Code Below Here is From CCM_Capture_AF.spb
SET NOCOUNT ON
    DECLARE @errCode INT
	SET @errStr = 'ERROR: GENERAL ERROR!'
	DECLARE @currentEndTrackTime int
	SET 	@currentEndTrackTime = ISNULL((SELECT trackingTime FROM GRC_SubclientTrackingInfo WITH (NOLOCK) WHERE jobId = @i_jobId AND subclientId = 0), 0)
	-- CommServ_Capture..CCM_ArchFile
INSERT into #CCM_ArchFile
	SELECT a.id, a.name, a.commCellId, a.archGroupId, a.objName1,
                a.flags, a.appId, a.fileType, a.cTime, a.jobId,
                a.backupLevel, a.isValid, a.cloudId, a.contentIndexTime, a.nPushedItems
FROM CCM_SOURCE_ArchFile a WITH (NOLOCK) INNER JOIN #CCM_App_Application c WITH (NOLOCK) ON a.appId = c.id AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile'
		GOTO CX_ERROR_EXIT
	END
	-- Don't capture index archive files for which there are no backupsets being migrated.
DELETE #CCM_ArchFile
FROM #CCM_ArchFile A WITH (NOLOCK) INNER JOIN #CCM_App_SubClientProp B WITH (NOLOCK) ON A.appId = B.componentNameId AND B.attrName LIKE 'Index SubClient' AND B.attrVal = 1
LEFT OUTER JOIN #CCM_App_BackupSetname C WITH (NOLOCK) ON A.name LIKE '%'+CAST(C.GUID AS NVARCHAR(1024))+'%'
	WHERE C.id IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- Delete index archive files failed.'
		GOTO CX_ERROR_EXIT
	END
	IF (@time_from > 0) AND (@time_to > 0) AND (@time_from > @time_to)
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- INVALID TIME RANGE'
		GOTO CX_ERROR_EXIT
	END
	IF (@time_from > 0) OR (@time_to > 0)
		OR
		(
(1 = (@ccmParamFlags & 1)) AND
			(
EXISTS(SELECT 1 FROM GRC_SubclientTrackingInfo a WITH (NOLOCK) INNER JOIN #CCM_App_Application b WITH (NOLOCK) ON a.jobId = @i_jobId AND a.subclientId = b.id AND a.trackingTime > 0) OR
				@currentEndTrackTime > 0
			)
		)
	BEGIN
		IF OBJECT_ID('tempdb..#jobsToCapture') IS NOT NULL DROP TABLE #jobsToCapture
			CREATE TABLE #jobsToCapture (jobId integer, commcellId integer, startTime integer, endTime integer)
		CREATE INDEX jobsToCapture_jobId_CommCellId_StartTime ON #jobsToCapture (jobId, commCellId, startTime)
		CREATE INDEX jobsToCapture_jobId_CommCellId_EndTime ON #jobsToCapture (jobId, commCellId, endTime)
		INSERT INTO #jobsToCapture
		SELECT a.jobId, a.commCellId, MIN(a.cTime), MAX(a.cTime)
FROM #CCM_ArchFile a WITH (NOLOCK) INNER JOIN #CCM_App_Application b WITH (NOLOCK)
			ON a.appId = b.id
		GROUP BY a.jobId, a.commCellId
IF (1 = (@ccmParamFlags & 1))
		BEGIN
IF EXISTS(SELECT 1 FROM GRC_SubclientTrackingInfo a INNER JOIN #CCM_App_Application b ON a.jobId = @i_jobId AND a.subclientId = b.id AND a.trackingTime > 0)
DELETE #CCM_ArchFile
FROM #CCM_ArchFile a WITH (NOLOCK) , #jobsToCapture b, #CCM_App_Application c WITH (NOLOCK) , GRC_SubclientTrackingInfo d WITH (NOLOCK)
				WHERE a.jobId = b.jobId
				AND a.commCellId = b.commCellId
				AND a.appId = c.id
				AND c.id = d.subClientId
				AND d.jobId = @i_jobId
				AND d.trackingTime > 0
				AND	b.startTime < d.trackingTime
				AND NOT EXISTS(SELECT 1 FROM #GRC_JOBS_TO_CAPTURE MJ WHERE a.jobId = MJ.jobId AND a.commCellId = MJ.commCellId)
			IF @currentEndTrackTime > 0
DELETE #CCM_ArchFile
FROM #CCM_ArchFile a WITH (NOLOCK) , #jobsToCapture b, #CCM_App_Application c WITH (NOLOCK)
				WHERE a.jobId = b.jobId
				AND a.commCellId = b.commCellId
				AND a.appId = c.id
				AND	b.endTime > @currentEndTrackTime
				AND NOT EXISTS(SELECT 1 FROM #GRC_JOBS_TO_CAPTURE MJ WHERE a.jobId = MJ.jobId AND a.commCellId = MJ.commCellId)
		END
		ELSE
		BEGIN
			IF @time_from > 0
DELETE #CCM_ArchFile
FROM #CCM_ArchFile a WITH (NOLOCK) , #jobsToCapture b, #CCM_App_Application c WITH (NOLOCK)
				WHERE a.jobId = b.jobId
				AND a.commCellId = b.commCellId
				AND a.appId = c.id
				AND	b.startTime < @time_from
			IF @time_to > 0
DELETE #CCM_ArchFile
FROM #CCM_ArchFile a WITH (NOLOCK) , #jobsToCapture b, #CCM_App_Application c WITH (NOLOCK)
				WHERE a.jobId = b.jobId
				AND a.commCellId = b.commCellId
				AND a.appId = c.id
				AND	b.endTime > @time_to
		END
		TRUNCATE TABLE #jobsToCapture
	END
	DECLARE @parentJobs        TABLE(jobId integer, commcellId integer)
	DECLARE @childJobs         TABLE(jobId integer, commcellId integer)
	DECLARE @parent_count      INTEGER
	DECLARE @child_count       INTEGER
	--IF (@time_from > 0) OR (@time_to > 0)
	--BEGIN
		-- CommServ_Capture..CCM_ArchFile (jobId) will give the list of jobs to be captured in a particular
		-- request
		DECLARE @to_capture_parent TABLE(jobId integer, commcellId integer)
		DECLARE @to_capture_child  TABLE(jobId integer, commcellId integer)
		INSERT INTO @childJobs
		SELECT DISTINCT a.childJobId, a.commCellId
FROM CCM_SOURCE_JMJobDataLink a WITH (NOLOCK) , #CCM_ArchFile b WITH (NOLOCK)
		WHERE a.parentJobId = b.jobId AND a.commCellId = b.commCellId
		AND NOT EXISTS(SELECT 1
FROM   #CCM_ArchFile c WITH (NOLOCK)
		     WHERE  a.childJobId = c.jobId
		       AND  a.commCellId = c.commCellId)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- @childJobs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO @parentJobs
		SELECT DISTINCT a.parentJobId, a.commCellId
FROM CCM_SOURCE_JMJobDataLink a WITH (NOLOCK) , #CCM_ArchFile b WITH (NOLOCK)
		WHERE a.childJobId = b.jobId AND a.commCellId = b.commCellId
		AND NOT EXISTS(SELECT 1
FROM   #CCM_ArchFile c WITH (NOLOCK)
		     WHERE  a.parentJobId = c.jobId
		       AND  a.commCellId  = c.commCellId)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- @parentJobs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		SET @parent_count = (SELECT COUNT(1) FROM @parentJobs)
		SET @child_count = (SELECT COUNT(1) FROM @childJobs)
		WHILE (@parent_count > 0 OR @child_count > 0)
		BEGIN
			INSERT INTO @to_capture_parent
			SELECT jobId, commCellId
			FROM @parentJobs
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @to_capture_parent -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO @to_capture_child
			SELECT jobId, commCellId
			FROM @childJobs
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @to_capture_child -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			DELETE FROM @parentJobs
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @parentJobs -- DELETE'
				GOTO CX_ERROR_EXIT
			END
			DELETE FROM @childJobs
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @childJobs -- DELETE'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO @parentJobs
			SELECT DISTINCT a.parentJobId, a.commCellId
			FROM   CCM_SOURCE_JMJobDataLink a WITH (NOLOCK) , @to_capture_child b
			WHERE  a.childJobId = b.jobId AND a.commCellId = b.commCellId
			AND NOT EXISTS(SELECT 1
			        FROM @to_capture_parent c
			        WHERE c.jobId = a.parentJobId
			          AND c.commCellId = a.commCellId)
            AND  NOT EXISTS(SELECT 1
FROM #CCM_ArchFile d WITH (NOLOCK)
                    WHERE d.jobId = a.parentJobId
                      AND d.commCellId = a.commCellId)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @parentJobs -- INSERT -- loop'
				GOTO CX_ERROR_EXIT
			END
            INSERT INTO @childJobs
            SELECT DISTINCT a.childJobId, a.commCellId
            FROM   CCM_SOURCE_JMJobDataLink a WITH (NOLOCK) , @to_capture_parent b
            WHERE  a.parentJobId = b.jobId AND a.commCellId = b.commCellId
            AND  NOT EXISTS(SELECT 1
                    FROM @to_capture_child c
                    WHERE c.jobId = a.childJobId
                      AND c.commCellId = a.commCellId)
			AND  NOT EXISTS(SELECT 1
FROM #CCM_ArchFile d WITH (NOLOCK)
					WHERE d.jobID = a.childJobId
					  AND d.commCellId = a.commCellId)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @childJobs -- INSERT -- loop'
				GOTO CX_ERROR_EXIT
			END
			SET @parent_count = (SELECT COUNT(1) FROM @parentJobs)
			SET @child_count = (SELECT COUNT(1) FROM @childJobs)
		END
		-- @to_capture_parent and @to_capture_child has the list of jobs to be captured
		-- proceed with rest of CCM_Capture_AF.sp and CCM_Capture_Job.sp
		-- CommServ_Capture..CCM_ArchFile
INSERT into #CCM_ArchFile
		SELECT 	a.id, a.name, a.commCellId, a.archGroupId, a.objName1,
				a.flags, a.appId, a.fileType, a.cTime, a.jobId,
				a.backupLevel, a.isValid, a.cloudId, a.contentIndexTime, a.nPushedItems
		FROM CCM_SOURCE_ArchFile a WITH (NOLOCK)  INNER JOIN @to_capture_parent b
		ON a.jobId = b.jobId AND a.commCellId = b.commCellId
LEFT OUTER JOIN #CCM_ArchFile c WITH (NOLOCK)
		ON  c.id = a.id AND c.commCellId = a.commCellId
		WHERE c.id is null
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @to_capture_parent -- INSERT -- loop'
			GOTO CX_ERROR_EXIT
		END
		-- CommServ_Capture..CCM_ArchFile
INSERT into #CCM_ArchFile
		SELECT 	a.id, a.name, a.commCellId, a.archGroupId, a.objName1,
				a.flags, a.appId, a.fileType, a.cTime, a.jobId,
				a.backupLevel, a.isValid, a.cloudId, a.contentIndexTime, a.nPushedItems
		FROM CCM_SOURCE_ArchFile a WITH (NOLOCK)  INNER JOIN @to_capture_child b
		ON a.jobId = b.jobId AND a.commCellId = b.commCellId
LEFT OUTER JOIN #CCM_ArchFile c WITH (NOLOCK)
        ON  c.id = a.id AND c.commCellId = a.commCellId
		WHERE c.id is null
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @to_capture_parent -- INSERT -- loop'
			GOTO CX_ERROR_EXIT
		END
	--END
	-- For running jobs, do not consider all completed dependent jobs
    /*
       --------------------------------------------------------------------------------------------
             Job Types                                Action
       --------------------------------------------------------------------------------------------
         J1                           Stand alone running job, delete corresponding Archive Files
         J1 and J2 runing             Dependent jobs running, delete corresponding Archive Files
         J1 and J2 completed          Dependent jobs completed, no delete action is required
         J1 running J2 completed      Delete corresponding Archive Files
         J1 completed J2 running      Delete corresponding Archive Files
       --------------------------------------------------------------------------------------------
     */
 	DECLARE @to_delete_child   TABLE(jobId integer, commcellId integer)
	DECLARE @to_delete_parent  TABLE(jobId integer, commcellId integer)
    DELETE FROM @childJobs
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @childJobs -- DELETE'
		GOTO CX_ERROR_EXIT
	END
    DELETE FROM @parentJobs
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @parentJobs -- DELETE'
		GOTO CX_ERROR_EXIT
	END
    INSERT INTO @childJobs
    SELECT DISTINCT b.childJobId, b.commCellId
FROM   CCM_SOURCE_JMJobInfo a WITH (NOLOCK) , CCM_SOURCE_JMJobDataLink b WITH (NOLOCK) , #CCM_ArchFile c WITH (NOLOCK)
    WHERE  a.jobId = b.parentJobId
    AND    a.commCellId = b.commCellId
    AND    b.childJobId = c.jobId
    AND    b.commCellId = c.commCellId
    INSERT INTO @parentJobs
    SELECT DISTINCT b.parentJobId, b.commCellId
FROM   CCM_SOURCE_JMJobInfo a WITH (NOLOCK) , CCM_SOURCE_JMJobDataLink b WITH (NOLOCK) , #CCM_ArchFile c WITH (NOLOCK)
    WHERE  a.jobId = b.childJobId
    AND    a.commCellId = b.commCellId
    AND    b.parentJobId = c.jobId
    AND    b.commCellId = c.commCellId
    SET @parent_count = (SELECT COUNT(1) FROM @parentJobs)
    SET @child_count = (SELECT COUNT(1) FROM @childJobs)
    WHILE (@parent_count > 0 OR @child_count > 0)
    BEGIN
		INSERT INTO @to_delete_parent
		SELECT * FROM @parentJobs
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @to_delete_parent -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO @to_delete_child
		SELECT * FROM @childJobs
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @to_delete_child -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM @parentJobs
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @parentJobs -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM @childJobs
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @childJobs -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO @childJobs
		SELECT DISTINCT b.childJobId, b.commCellId
FROM   @to_delete_parent a, CCM_SOURCE_JMJobDataLink b WITH (NOLOCK) , #CCM_ArchFile c WITH (NOLOCK)
		WHERE  a.jobId = b.parentJobId
		AND    a.commCellId = b.commCellId
		AND    b.childJobId = c.jobId
		AND    b.commCellId = c.commCellId
		AND  NOT EXISTS(SELECT 1
		        FROM   @to_delete_child d
		        WHERE   d.jobId = b.childJobId
		        AND     d.commCellId = b.commCellId)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @childJobs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
        INSERT INTO @parentJobs
        SELECT DISTINCT b.parentJobId, b.commCellId
FROM   @to_delete_child a, CCM_SOURCE_JMJobDataLink b WITH (NOLOCK) , #CCM_ArchFile c WITH (NOLOCK)
        WHERE  a.jobId = b.childJobId
        AND    a.commCellId = b.commCellId
        AND    b.parentJobId = c.jobId
        AND    b.commCellId = c.commCellId
        AND  NOT EXISTS(SELECT 1
                FROM   @to_delete_parent d
                WHERE  d.jobId = b.parentJobId
                AND    d.commCellId = b.commCellId)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @parentJobs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		SET @parent_count = (SELECT COUNT(1) FROM @parentJobs)
		SET @child_count = (SELECT COUNT(1) FROM @childJobs)
    END
	-- Do not migrate backup data of running job
DELETE	#CCM_ArchFile
FROM	#CCM_ArchFile a WITH (NOLOCK) , CCM_SOURCE_JMJobInfo b WITH (NOLOCK) , #CCM_App_Application c WITH (NOLOCK)
	WHERE	a.commCellId = b.commCellId AND a.jobId = b.jobId
	AND a.appId = c.id AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE'
		GOTO CX_ERROR_EXIT
	END
DELETE #CCM_ArchFile
FROM   #CCM_ArchFile a, @to_delete_child b
	WHERE  a.commCellId = b.commCellId AND a.jobId = b.jobId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE -- Dependent Child jobs'
		GOTO CX_ERROR_EXIT
	END
DELETE #CCM_ArchFile
FROM   #CCM_ArchFile a, @to_delete_parent b
	WHERE  a.commCellId = b.commCellId AND a.jobId = b.jobId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE -- Dependent Parent jobs'
		GOTO CX_ERROR_EXIT
	END
	--SILO BackupSet and ArchFiles
	DECLARE @siloedStores table (storeId integer)
	DECLARE @newSILOApps table (appId integer)
	DECLARE @siloArchFiles table(archFileId integer,appId integer,jobId integer,commCellId integer)
    DECLARE @siloSubClient integer
        SET @errCode = 0
	INSERT @siloedStores
	SELECT DISTINCT d.SIDBStoreId
FROM #CCM_ArchFile a
	inner join CCM_SOURCE_archchunkmapping b WITH (NOLOCK)  ON a.id = b.archFileId and a.commCellId = b.commCellId
	inner join CCM_SOURCE_archChunk c  WITH (NOLOCK) ON b.archChunkId = c.id and b.commCellId = c.commCellId
	inner join CCM_SOURCE_MMVolume d WITH (NOLOCK) ON c.volumeId = d.VolumeId and d.SiloStatus > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- INSERT -- @siloedStores'
		GOTO CX_ERROR_EXIT
	END
	INSERT @siloArchFiles
	SELECT DISTINCT d.id, d.appId, d.jobId, d.commCellId
	FROM @siloedStores a
	inner join CCM_SOURCE_mmvolume b WITH (NOLOCK)  ON a.storeId = b.SIDBStoreId
	inner join CCM_SOURCE_archFileSiloVolume c WITH (NOLOCK)  ON b.VolumeId = c.siloVolumeId
	inner join CCM_SOURCE_archFile d WITH (NOLOCK) ON c.archFileId = d.id and c.commCellId = d.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- INSERT -- @siloArchFiles'
		GOTO CX_ERROR_EXIT
	END
	INSERT @siloArchFiles
	SELECT DISTINCT a.id, a.appId, a.jobId, a.commCellId
	FROM CCM_SOURCE_archFile a WITH (NOLOCK) , @siloArchFiles b
	WHERE a.jobId = b.jobId
	AND a.commCellId = b.commCellId
	AND NOT EXISTS (SELECT * FROM @siloArchFiles WHERE archFileId = a.id AND commCellId = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- INSERT -- @siloArchFiles'
		GOTO CX_ERROR_EXIT
	END
INSERT #CCM_ArchFile
	SELECT 	a.id, a.name, a.commCellId, a.archGroupId, a.objName1,
			a.flags, a.appId, a.fileType, a.cTime, a.jobId,
			a.backupLevel, a.isValid, a.cloudId, a.contentIndexTime, a.nPushedItems
	FROM CCM_SOURCE_ArchFile a WITH (NOLOCK) , @siloArchFiles b
	WHERE a.id = b.archFileId AND a.commCellId = b.commCellId
	AND NOT EXISTS(SELECT 1
FROM   #CCM_ArchFile b
           WHERE  b.id = a.id
           AND    b.commCellId = a.commCellId)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- INSERT -- CCM_ArchFile -SILO ARCHFILES'
		GOTO CX_ERROR_EXIT
	END
	--End of SILO BackupSet and ArchFiles
	--Skip Migration of Data belonging to SRM Analytics policy
DELETE FROM #CCM_ArchFile
WHERE archGroupId in (SELECT id From CCM_SOURCE_archGroup where type = 4)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE ArchFiles of SRM Analytics Policy'
		GOTO CX_ERROR_EXIT
	END
	--Skip capturing data belongs to other migrated commcells for ROBO job
	DECLARE @captureOnlyLocalData integer = 0
	SET @captureOnlyLocalData = ISNULL((SELECT value from MMConfigs where name = 'CCM_CONFIG_CAPTURE_ONLY_LOCAL_DATA_FOR_GRC'),1)
IF ((@ccmParamFlags & 1) = 1 AND @captureOnlyLocalData = 1)
	BEGIN
DELETE FROM #CCM_ArchFile
		WHERE CommCellId NOT IN (0,2)
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE ArchFiles of other migrated commcells'
			GOTO CX_ERROR_EXIT
		END
	END
	--Don't capture current cycle jobs.
	IF EXISTS(SELECT 1 FROM MMConfigs WHERE name = 'CCM_CONFIG_DONOT_CAPTURE_JOBS_IN_CURRENT_CYCLE' AND value = 1)
	BEGIN
		DELETE 	AF
FROM 	#CCM_ArchFile AF
				INNER JOIN CCM_SOURCE_APP_SubClientProp APP WITH (NOLOCK)  ON AF.appId = APP.componentNameId AND APP.attrName = 'sys:full cycle num' AND APP.modified = 0
				INNER JOIN CCM_SOURCE_JMBkpStats JM WITH (NOLOCK) ON AF.jobId = JM.jobId AND AF.commCellId = JM.commCellId AND JM.fullCycleNum = APP.attrVal AND JM.appId = APP.componentNameId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- Failed to delete current full cycle'
			GOTO CX_ERROR_EXIT
		END
	END
	--Capture all subclients which are not captured and archFiles are captrued.
	DECLARE @lt_SQLChainSubClients TABLE (appId int, clientId int)
	DECLARE @SQLChainClientId INT
	INSERT INTO @lt_SQLChainSubClients
SELECT DISTINCT a.appId, b.clientId FROM #CCM_ArchFile a INNER JOIN CCM_SOURCE_APP_Application b ON a.appId = b.id
WHERE NOT EXISTS (SELECT 1 FROM #CCM_App_Application WITH (NOLOCK) WHERE id = a.appId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- @lt_SQLChainSubClients -- INSERT'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO #CCM_App_Application
	SELECT 	a.*
	FROM 	CCM_SOURCE_APP_Application a
			INNER JOIN @lt_SQLChainSubClients b ON a.id = b.appId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_App_Application -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	DECLARE SQLChainSubclients_CUR CURSOR LOCAL FORWARD_ONLY FOR
	SELECT DISTINCT clientId FROM @lt_SQLChainSubClients
	OPEN SQLChainSubclients_CUR
	FETCH NEXT FROM SQLChainSubclients_CUR INTO @SQLChainClientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		--Capture client
        EXEC @errCode = CCM_Capture_Client_to_XML @SQLChainClientId, @i_isExportFromLinkedServer, @i_exportDBName
		IF	@errCode <> 0 OR @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_Capture_Client'
			GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM SQLChainSubclients_CUR INTO @SQLChainClientId
	END
	IF EXISTS (SELECT 1 FROM @lt_SQLChainSubClients)
	BEGIN
		EXEC @errCode = CCM_CAPTURE_APP_to_XML 0, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errStr OUTPUT
		IF	@errCode <> 0 OR @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_Capture_App'
			GOTO CX_ERROR_EXIT
		END
	END
	CLOSE SQLChainSubclients_CUR
	DEALLOCATE SQLChainSubclients_CUR
	---- CommServ_Capture..CCM_archIndexingAged
INSERT INTO #CCM_archIndexingAged
	SELECT A.*
FROM CCM_SOURCE_archIndexingAged A INNER JOIN #CCM_ArchFile B ON A.archFileId = B.id AND A.commCellId = B.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_archIndexingAged'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchFileOracle
INSERT into #CCM_ArchFileOracle
SELECT AFO.* FROM #CCM_ArchFile AF WITH (NOLOCK)  INNER JOIN CCM_SOURCE_ArchFileOracle AFO WITH (NOLOCK)
	ON AF.id = AFO.archFileId AND AF.commCellId = AFO.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileOracleBackupPiece'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchFileOracleBackupPiece
INSERT into #CCM_archFileOracleBackupPiece
	SELECT AFO.archFileId, AFO.commCellId, AFO.instanceId, AFO.backupPiece,  AFO.offset
FROM #CCM_ArchFileOracle AF WITH (NOLOCK)  INNER JOIN CCM_SOURCE_ArchFileOracleBackupPiece AFO WITH (NOLOCK)
	ON AF.archFileId = AFO.archFileId AND AF.commCellId = AFO.commCellId AND AF.instanceId = AFO.instanceId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileOracleBackupPiece'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchFileCopy
INSERT into #CCM_ArchFileCopy
SELECT a.* FROM CCM_SOURCE_ArchFileCopy a WITH (NOLOCK)  INNER JOIN #CCM_ArchFile b WITH (NOLOCK)
	ON a.archFileId = b.id AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileCopy'
		GOTO CX_ERROR_EXIT
	END
	--Skip jobs which are not in GRC job list to capture for ROBO job
IF ((@ccmParamFlags & 1) = 1 AND OBJECT_ID('tempdb.dbo.#GRC_JOBS_TO_CAPTURE') IS NOT NULL)
	IF EXISTS(SELECT 1 FROM #GRC_JOBS_TO_CAPTURE)
	BEGIN
		DELETE 	DelAFC
FROM 	#CCM_ArchFileCopy DelAFC
		WHERE 	NOT EXISTS(SELECT 1 FROM #GRC_JOBS_TO_CAPTURE WHERE copyId = DelAFC.archCopyId)
				AND NOT EXISTS
				(
					SELECT 	1
FROM 	#CCM_ArchFile a WITH (NOLOCK)
LEFT OUTER JOIN #CCM_ArchFileCopy b WITH (NOLOCK) ON a.id = b.archFileId AND a.commCellId = b.commCellId
							LEFT OUTER JOIN #GRC_JOBS_TO_CAPTURE c ON b.archCopyId = c.copyId
					WHERE 	a.id = DelAFC.archFileId and a.commCellId = DelAFC.commCellId
					GROUP BY a.id HAVING COUNT(c.copyId) = 0
				)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileCopy -- DELETE Non restricted jobs'
			GOTO CX_ERROR_EXIT
		END
	END
	-- CommServ_Capture..CCM_ArchFileCopyDedup
INSERT into #CCM_archFileCopyDedup
SELECT AFCD.* FROM #CCM_ArchFileCopy AFC WITH (NOLOCK)  inner join CCM_SOURCE_ArchFileCopyDedup AFCD WITH (NOLOCK)
	ON AFC.archFileId = AFCD.archFileId AND AFC.commCellId = AFCD.commCellId AND AFC.archCopyId = AFCD.archCopyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileCopyDedup'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchChunkMapping
INSERT into #CCM_ArchChunkMapping
	SELECT a.*
FROM CCM_SOURCE_ArchChunkMapping a WITH (NOLOCK)  INNER JOIN #CCM_ArchFileCopy b WITH (NOLOCK)
	ON a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.archCopyId = b.archCopyId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchChunkMapping'
		GOTO CX_ERROR_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
	CREATE TABLE #tempChunk (id bigint, commCellId int, primary key (id, commcellid))
	INSERT	INTO #tempChunk
	SELECT	archChunkId, chunkcommCellId
FROM	#CCM_ArchChunkMapping WITH (NOLOCK)
	GROUP BY archChunkId, chunkcommCellId
	-- CommServ_Capture..CCM_ArchChunk
INSERT into #CCM_ArchChunk
	SELECT a.*
	FROM CCM_SOURCE_ArchChunk a WITH (NOLOCK) INNER JOIN #tempChunk b ON a.id = b.id AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchChunk'
		GOTO CX_ERROR_EXIT
	END
	-- SILO Backup information tables
	-- CommServ_Capture..CCM_ArchChunkToSILO
INSERT	INTO #CCM_ArchChunkToSilo
	SELECT	a.* FROM CCM_SOURCE_ArchChunkToSILO a WITH (NOLOCK) INNER JOIN #tempChunk b ON a.archChunkId = b.Id AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchChunkToSILO'
		GOTO CX_ERROR_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- Delete -- #tempChunk'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchFileSiloVolume
INSERT	INTO #CCM_ArchFileSiloVolume
SELECT	a.* FROM CCM_SOURCE_ArchFileSiloVolume a WITH (NOLOCK) INNER JOIN #CCM_ArchFile b WITH (NOLOCK) ON a.archFileId = b.id AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileSiloVolume'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_OracleTableSpaces
INSERT into #CCM_OracleTableSpaces
	SELECT a.*
FROM CCM_SOURCE_OracleTableSpaces a WITH (NOLOCK)  INNER JOIN #CCM_App_InstanceName b WITH (NOLOCK)  ON a.InstId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_OracleTableSpaces'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_OracleObjects
INSERT into #CCM_OracleObjects
SELECT a.* FROM CCM_SOURCE_OracleObjects a WITH (NOLOCK) INNER JOIN #CCM_App_InstanceName b WITH (NOLOCK) ON a.InstId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_OracleObjects'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_OracleDataFiles
INSERT into #CCM_OracleDataFiles
SELECT a.* FROM CCM_SOURCE_OracleDataFiles a WITH (NOLOCK) INNER JOIN #CCM_App_InstanceName b WITH (NOLOCK) ON a.InstId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_OracleDataFiles'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_OraclePluggableDBs
	DECLARE @tailQuery VARCHAR(MAX)
SET @tailQuery = ' A INNER JOIN #CCM_App_InstanceName B ON B.id = A.InstId '
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'OraclePluggableDBs', 'TEMPDB..#CCM_OraclePluggableDBs', '', @i_exportDBName, @tailQuery
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_OraclePluggableDBs'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchDB2Log
INSERT into #CCM_ArchDB2Log
SELECT a.* FROM CCM_SOURCE_ArchDB2Log a WITH (NOLOCK) INNER JOIN #CCM_ArchFile b WITH (NOLOCK) ON a.archFileId = b.id AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchDB2Log'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SybArchFileInfo
INSERT into #CCM_SybArchFileInfo
SELECT DISTINCT a.* FROM CCM_SOURCE_SybArchFileInfo a WITH (NOLOCK) INNER JOIN #CCM_ArchFile b WITH (NOLOCK)
	ON a.archFileId = b.id AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SybArchFileInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SybTransLog
INSERT into #CCM_SybTransLog
SELECT DISTINCT a.* FROM CCM_SOURCE_SybTransLog a WITH (NOLOCK) INNER JOIN #CCM_SybArchFileInfo b WITH (NOLOCK) ON a.sybArchFileId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SybTransLog'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SybSystemDevices
INSERT into #CCM_SybSystemDevices
SELECT distinct a.* FROM CCM_SOURCE_SybSystemDevices a WITH (NOLOCK), #CCM_SybArchFileInfo b WITH (NOLOCK)
	WHERE a.sybBackupJobId_h = 0
	AND a.sybBackupJobId_l = b.sybBackupJobId_l
	AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SybSystemDevices'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_sybSystemUsages
INSERT into #CCM_SybSystemUsages
SELECT distinct a.* FROM CCM_SOURCE_sybSystemUsages a WITH (NOLOCK), #CCM_SybArchFileInfo b WITH (NOLOCK)
	WHERE a.sybBackupJobId_h = 0
	AND a.sybBackupJobId_l = b.sybBackupJobId_l
	AND a.commCellId = b.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sybSystemUsages'
		GOTO CX_ERROR_EXIT
	END
	/*
	Only Following tables are used by SQL Server IDA in 9.0 as per kiran nittur
	So removing capture of other sql tables
	*sqlDbBackupInfo
	*sqlFileBackupInfo
	*sqlNames
	*sqlNames2
	*sqlarchiveInfo
	*Sqllogmarks
	*/
	---------------------------------------------------------
	-- New SQL tables added in 6.1
	-- CommServ_Capture..CCM_sqlDbBackupInfo
MERGE #CCM_SqlDBBackupInfo as target
	USING CCM_SOURCE_sqlDbBackupInfo as source
	ON (source.id = target.id)
	WHEN NOT MATCHED BY target
AND source.appId in (SELECT id FROM #CCM_App_Application)
	AND ISNULL(source.type, '') <> ''
	THEN INSERT VALUES (source.id, source.backup_set_id, source.majorVersion, source.minorVersion,
	source.buildVersion, source.database_creation_date, source.backup_start_Date, source.backup_finish_Date,
	source.type,source.instanceId,source.appId, source.backup_size, source.dbId, source.first_lsn, source.last_lsn,
	source.checkpoint_lsn, source.full_bkup_lsn,source.sqlNameId,source.sqlLastLogBackup,
	source.sqlVssFullbackupTime, source.is_copy, source.backupmethod,
	source.backupvendor, source.jobid, source.replica_id, source.group_database_id, source.first_recovery_fork_guid, source.last_recovery_fork_guid, source.differential_base_guid,
	source.database_guid, source.fork_point_lsn, source.differential_base_lsn, source.compressed_backup_size, source.begins_log_chain, source.has_backup_checksums, source.database_bkup_lsn);
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlDbBackupInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_sqlFileBackupInfo
INSERT	into #CCM_SqlFileBackupInfo
SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlFileBackupInfo a WITH (NOLOCK) INNER JOIN #CCM_SqlDBBackupInfo b WITH (NOLOCK) ON a.sqlDbBackupInfoId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlFileBackupInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_sqlNames
INSERT	into #CCM_SqlNames
SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlNames a WITH (NOLOCK) INNER JOIN #CCM_SqlDBBackupInfo b WITH (NOLOCK) ON a.id = b.sqlNameId AND a.type = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlNames -- sqlNameId'
		GOTO CX_ERROR_EXIT
	END
INSERT	into #CCM_SqlNames
SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlNames a WITH (NOLOCK) INNER JOIN #CCM_SqlFileBackupInfo b WITH (NOLOCK) ON a.id = b.sqlNameFgId AND a.type = 2
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlNames -- sqlNameFgId'
		GOTO CX_ERROR_EXIT
	END
INSERT	into #CCM_SqlNames
SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlNames a WITH (NOLOCK) INNER JOIN #CCM_SqlFileBackupInfo b WITH (NOLOCK) ON a.id = b.sqlNamePhyId AND a.type = 3
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlNames -- sqlNamePhyId'
		GOTO CX_ERROR_EXIT
	END
INSERT	into #CCM_SqlNames
SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlNames a WITH (NOLOCK) INNER JOIN #CCM_SqlFileBackupInfo b WITH (NOLOCK) ON a.id = b.sqlNameLogId AND a.type = 4
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlNames -- sqlNameLogId'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_sqlNames2
INSERT	into #CCM_SqlNames2
SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlNames2 a WITH (NOLOCK) INNER JOIN #CCM_SqlNames b WITH (NOLOCK) ON a.id = b.sqlid
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlNames2 -- sqlNameId'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_sqlarchiveInfo
INSERT	into #CCM_SqlArchiveInfo
	SELECT DISTINCT	a.*
FROM CCM_SOURCE_sqlarchiveInfo a WITH (NOLOCK) INNER JOIN #CCM_SqlDBBackupInfo b WITH (NOLOCK) ON a.sqlDbBackupFileId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlarchiveInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_Sqllogmarks
INSERT	into #CCM_SqlLogMarks
SELECT	DISTINCT a.* FROM CCM_SOURCE_Sqllogmarks a WITH (NOLOCK) INNER JOIN #CCM_App_InstanceName b WITH (NOLOCK) ON a.instanceId = b.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_Sqllogmarks'
		GOTO CX_ERROR_EXIT
	END
	-- Capture code for subclient level index pruning
INSERT into #CCM_App_IndexCheckpointInfo
    SELECT  a.*
FROM CCM_SOURCE_App_IndexCheckpointInfo a WITH (NOLOCK) INNER JOIN #CCM_ArchFile c WITH (NOLOCK) ON a.afileId = c.id AND a.commCellId = c.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_APP_INDEXCHECKPOINTINFO'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	--IF (Cursor_Status('LOCAL', 'SILOSubClientsCursor') >= -1)
	--BEGIN
	--	CLOSE SILOSubClientsCursor
	--	DEALLOCATE SILOSubClientsCursor
	--END
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_AF_to_XML')
	delete from GxQscripts where name = 'CCM_Capture_AF_to_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_AF_to_XML')
	delete from GXDBVersions where aliasname = 'CCM_Capture_AF_to_XML'
GO

insert into GXDBVersions values(2, 'CCM_Capture_AF_to_XML',  '00010005005800040000', 'CCM_Capture_AF_to_XML', '00010005005800040000')
GO

