

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Capture_AF_To_100.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Capture client application data to migrate.
--  +========================================================================+
-- $Id: CCM_Capture_AF_To_100.sp,v 1.1.60.2 2018/03/20 00:29:11 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Capture_AF_To_100 <<<'

IF EXISTS (select * from sysobjects where name='CCM_Capture_AF_To_100')
	drop procedure CCM_Capture_AF_To_100
IF EXISTS (select * from GxQscripts where name='CCM_Capture_AF_To_100')
	delete from GxQscripts where name = 'CCM_Capture_AF_To_100'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_AF_To_100')
	delete from GXDBVersions where aliasname = 'CCM_Capture_AF_To_100'
GO
print '... Creating Procedure: CCM_Capture_AF_To_100'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Capture_AF_To_100
  @i_subClientId integer,
  @i_clientId integer,
  @time_from integer,
  @time_to integer,
  @ccmParamFlags integer,
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024),
  @errStr varchar(1024) OUTPUT
AS
--#define CCM_DB_ARCHFILEORACLE						CommServ_Capture..CCM_ArchFileOracle
--Code Below Here is From CCM_Capture_AF.spb
SET NOCOUNT ON
        DECLARE @errCode INT
	SET @errStr = 'ERROR: GENERAL ERROR!'
	/**************************************************************
	 * PrasadNara: 10:08 PM 9/3/2012
	 * We are calling this proc only when capturing last subclient in the dump.
	 * So making changes as required to capture all archive tables for all captured subclients in the dump.
	 **************************************************************/
	---------------------------------------------------------
	/*
	IF (@i_subClientId < 0)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_AF -- Invalid subclient'
		GOTO CX_ERROR_EXIT
	END
	IF (@i_clientId <= 1)
	BEGIN
	    SET @errStr = 'ERROR: CCM_Capture_AF -- Invalid clientId'
		GOTO CX_ERROR_EXIT
	END
	*/
	---------------------------------------------------------
	-- CommServ_Capture..CCM_ArchFile
INSERT into CommServ_Capture..CCM_ArchFile
	SELECT 	a.id, a.name, a.commCellId, a.archGroupId, a.objName1,
			a.flags, a.appId, a.fileType, a.cTime, a.jobId,
			a.backupLevel, a.isValid, a.cloudId, a.contentIndexTime, a.nPushedItems
FROM CCM_SOURCE_ArchFile a LEFT OUTER JOIN CommServ_Capture..CCM_ArchFile b
    ON  b.id = a.id AND b.commCellId = a.commCellId
INNER JOIN CommServ_Capture..CCM_App_Application c ON a.appId = c.id
	WHERE b.id is null AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile'
		GOTO CX_ERROR_EXIT
	END
	-- Don't capture index archive files for which there are no backupsets being migrated.
DELETE CommServ_Capture..CCM_ArchFile
FROM CommServ_Capture..CCM_ArchFile A INNER JOIN CommServ_Capture..CCM_App_SubClientProp B ON A.appId = B.componentNameId AND B.attrName LIKE 'Index SubClient' AND B.attrVal = 1
LEFT OUTER JOIN CommServ_Capture..CCM_App_BackupSetname C ON A.name LIKE '%'+CAST(C.GUID AS NVARCHAR(1024))+'%'
	WHERE C.id IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- Delete index archive files failed.'
		GOTO CX_ERROR_EXIT
	END
	IF (@time_from > 0) AND (@time_to > 0) AND (@time_from > @time_to)
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- INVALID TIME RANGE'
		GOTO CX_ERROR_EXIT
	END
	IF (@time_from > 0) OR (@time_to > 0)
	BEGIN
		DECLARE @jobToCapture TABLE(jobId integer, commcellId integer, startTime integer, endTime integer)
		INSERT INTO @jobToCapture
		SELECT a.jobId, a.commCellId, MIN(a.cTime), MAX(a.cTime)
FROM CommServ_Capture..CCM_ArchFile a INNER JOIN CommServ_Capture..CCM_App_Application b
			ON a.appId = b.id
		WHERE b.appTypeId <> 1000
		GROUP BY a.jobId, a.commCellId
		BEGIN
			IF @time_from > 0
DELETE CommServ_Capture..CCM_ArchFile
FROM CommServ_Capture..CCM_ArchFile a, @jobToCapture b, CommServ_Capture..CCM_App_Application c
				WHERE a.jobId = b.jobId
				AND a.commCellId = b.commCellId
				AND a.appId = c.id
				AND	b.startTime < @time_from
				AND c.appTypeId <> 1000
			IF @time_to > 0
DELETE CommServ_Capture..CCM_ArchFile
FROM CommServ_Capture..CCM_ArchFile a, @jobToCapture b, CommServ_Capture..CCM_App_Application c
				WHERE a.jobId = b.jobId
				AND a.commCellId = b.commCellId
				AND a.appId = c.id
				AND	b.endTime > @time_to
				AND c.appTypeId <> 1000
		END
		DELETE @jobToCapture
	END
/*
	-- mklose - commenting this out, as we now do support restores of data prior to 5.0
	-- and data created with an evaluation license - at least filesystem data.
	-- This was fixed as part of the 3.7.1 restorability for Shell
	-- Do not migrate backup data before 5.0 or with evaluation license
DELETE FROM CommServ_Capture..CCM_ArchFile
	WHERE COMMCELLID = 2 AND ID <= (SELECT ISNULL(next_l, 0) FROM GXCounter WHERE name = 'startMigAFile')
	AND appId = @i_subClientId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE'
		GOTO CX_ERROR_EXIT
	END
*/
	DECLARE @parentJobs        TABLE(jobId integer, commcellId integer)
	DECLARE @childJobs         TABLE(jobId integer, commcellId integer)
	DECLARE @parent_count      INTEGER
	DECLARE @child_count       INTEGER
	--IF (@time_from > 0) OR (@time_to > 0)
	--BEGIN
		-- CommServ_Capture..CCM_ArchFile (jobId) will give the list of jobs to be captured in a particular
		-- request
		DECLARE @to_capture_parent TABLE(jobId integer, commcellId integer)
		DECLARE @to_capture_child  TABLE(jobId integer, commcellId integer)
		INSERT INTO @childJobs
		SELECT DISTINCT a.childJobId, a.commCellId
FROM CCM_SOURCE_JMJobDataLink a, CommServ_Capture..CCM_ArchFile b
		WHERE a.parentJobId = b.jobId AND a.commCellId = b.commCellId
		AND NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_ArchFile c
		     WHERE  a.childJobId = c.jobId
		       AND  a.commCellId = c.commCellId)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- @childJobs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO @parentJobs
		SELECT DISTINCT a.parentJobId, a.commCellId
FROM CCM_SOURCE_JMJobDataLink a, CommServ_Capture..CCM_ArchFile b
		WHERE a.childJobId = b.jobId AND a.commCellId = b.commCellId
		AND NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_ArchFile c
		     WHERE  a.parentJobId = c.jobId
		       AND  a.commCellId  = c.commCellId)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- @parentJobs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		SET @parent_count = (SELECT COUNT(*) FROM @parentJobs)
		SET @child_count = (SELECT COUNT(*) FROM @childJobs)
		WHILE (@parent_count > 0 OR @child_count > 0)
		BEGIN
			INSERT INTO @to_capture_parent
			SELECT jobId, commCellId
			FROM @parentJobs
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @to_capture_parent -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO @to_capture_child
			SELECT jobId, commCellId
			FROM @childJobs
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @to_capture_child -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			DELETE FROM @parentJobs
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @parentJobs -- DELETE'
				GOTO CX_ERROR_EXIT
			END
			DELETE FROM @childJobs
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @childJobs -- DELETE'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO @parentJobs
			SELECT DISTINCT a.parentJobId, a.commCellId
			FROM   CCM_SOURCE_JMJobDataLink a, @to_capture_child b
			WHERE  a.childJobId = b.jobId AND a.commCellId = b.commCellId
			AND NOT EXISTS(SELECT 1
			        FROM @to_capture_parent c
			        WHERE c.jobId = a.parentJobId
			          AND c.commCellId = a.commCellId)
            AND  NOT EXISTS(SELECT 1
FROM CommServ_Capture..CCM_ArchFile d
                    WHERE d.jobId = a.parentJobId
                      AND d.commCellId = a.commCellId)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @parentJobs -- INSERT -- loop'
				GOTO CX_ERROR_EXIT
			END
            INSERT INTO @childJobs
            SELECT DISTINCT a.childJobId, a.commCellId
            FROM   CCM_SOURCE_JMJobDataLink a, @to_capture_parent b
            WHERE  a.parentJobId = b.jobId AND a.commCellId = b.commCellId
            AND  NOT EXISTS(SELECT 1
                    FROM @to_capture_child c
                    WHERE c.jobId = a.childJobId
                      AND c.commCellId = a.commCellId)
			AND  NOT EXISTS(SELECT 1
FROM CommServ_Capture..CCM_ArchFile d
					WHERE d.jobID = a.childJobId
					  AND d.commCellId = a.commCellId)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Capture_AF -- @childJobs -- INSERT -- loop'
				GOTO CX_ERROR_EXIT
			END
			SET @parent_count = (SELECT COUNT(*) FROM @parentJobs)
			SET @child_count = (SELECT COUNT(*) FROM @childJobs)
		END
		-- @to_capture_parent and @to_capture_child has the list of jobs to be captured
		-- proceed with rest of CCM_Capture_AF.sp and CCM_Capture_Job.sp
		-- CommServ_Capture..CCM_ArchFile
INSERT into CommServ_Capture..CCM_ArchFile
		SELECT 	a.id, a.name, a.commCellId, a.archGroupId, a.objName1,
				a.flags, a.appId, a.fileType, a.cTime, a.jobId,
				a.backupLevel, a.isValid, a.cloudId, a.contentIndexTime, a.nPushedItems
		FROM CCM_SOURCE_ArchFile a INNER JOIN @to_capture_parent b
		ON a.jobId = b.jobId AND a.commCellId = b.commCellId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchFile c
		ON  c.id = a.id AND c.commCellId = a.commCellId
		WHERE c.id is null
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @to_capture_parent -- INSERT -- loop'
			GOTO CX_ERROR_EXIT
		END
		-- CommServ_Capture..CCM_ArchFile
INSERT into CommServ_Capture..CCM_ArchFile
		SELECT 	a.id, a.name, a.commCellId, a.archGroupId, a.objName1,
				a.flags, a.appId, a.fileType, a.cTime, a.jobId,
				a.backupLevel, a.isValid, a.cloudId, a.contentIndexTime, a.nPushedItems
		FROM CCM_SOURCE_ArchFile a INNER JOIN @to_capture_child b
		ON a.jobId = b.jobId AND a.commCellId = b.commCellId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchFile c
        ON  c.id = a.id AND c.commCellId = a.commCellId
		WHERE c.id is null
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @to_capture_parent -- INSERT -- loop'
			GOTO CX_ERROR_EXIT
		END
	--END
	-- For running jobs, do not consider all completed dependent jobs
    /*
       --------------------------------------------------------------------------------------------
             Job Types                                Action
       --------------------------------------------------------------------------------------------
         J1                           Stand alone running job, delete corresponding Archive Files
         J1 and J2 runing             Dependent jobs running, delete corresponding Archive Files
         J1 and J2 completed          Dependent jobs completed, no delete action is required
         J1 running J2 completed      Delete corresponding Archive Files
         J1 completed J2 running      Delete corresponding Archive Files
       --------------------------------------------------------------------------------------------
     */
 	DECLARE @to_delete_child   TABLE(jobId integer, commcellId integer)
	DECLARE @to_delete_parent  TABLE(jobId integer, commcellId integer)
    DELETE FROM @childJobs
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @childJobs -- DELETE'
		GOTO CX_ERROR_EXIT
	END
    DELETE FROM @parentJobs
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @parentJobs -- DELETE'
		GOTO CX_ERROR_EXIT
	END
    INSERT INTO @childJobs
    SELECT DISTINCT b.childJobId, b.commCellId
FROM   CCM_SOURCE_JMJobInfo a, CCM_SOURCE_JMJobDataLink b, CommServ_Capture..CCM_ArchFile c
    WHERE  a.jobId = b.parentJobId
    AND    a.commCellId = b.commCellId
    AND    b.childJobId = c.jobId
    AND    b.commCellId = c.commCellId
    INSERT INTO @parentJobs
    SELECT DISTINCT b.parentJobId, b.commCellId
FROM   CCM_SOURCE_JMJobInfo a, CCM_SOURCE_JMJobDataLink b, CommServ_Capture..CCM_ArchFile c
    WHERE  a.jobId = b.childJobId
    AND    a.commCellId = b.commCellId
    AND    b.parentJobId = c.jobId
    AND    b.commCellId = c.commCellId
    SET @parent_count = (SELECT COUNT(*) FROM @parentJobs)
    SET @child_count = (SELECT COUNT(*) FROM @childJobs)
    WHILE (@parent_count > 0 OR @child_count > 0)
    BEGIN
		INSERT INTO @to_delete_parent
		SELECT * FROM @parentJobs
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @to_delete_parent -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO @to_delete_child
		SELECT * FROM @childJobs
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @to_delete_child -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM @parentJobs
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @parentJobs -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM @childJobs
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @childJobs -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO @childJobs
		SELECT DISTINCT b.childJobId, b.commCellId
FROM   @to_delete_parent a, CCM_SOURCE_JMJobDataLink b, CommServ_Capture..CCM_ArchFile c
		WHERE  a.jobId = b.parentJobId
		AND    a.commCellId = b.commCellId
		AND    b.childJobId = c.jobId
		AND    b.commCellId = c.commCellId
		AND  NOT EXISTS(SELECT 1
		        FROM   @to_delete_child d
		        WHERE   d.jobId = b.childJobId
		        AND     d.commCellId = b.commCellId)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @childJobs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
        INSERT INTO @parentJobs
        SELECT DISTINCT b.parentJobId, b.commCellId
FROM   @to_delete_child a, CCM_SOURCE_JMJobDataLink b, CommServ_Capture..CCM_ArchFile c
        WHERE  a.jobId = b.childJobId
        AND    a.commCellId = b.commCellId
        AND    b.parentJobId = c.jobId
        AND    b.commCellId = c.commCellId
        AND  NOT EXISTS(SELECT 1
                FROM   @to_delete_parent d
                WHERE  d.jobId = b.parentJobId
                AND    d.commCellId = b.commCellId)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- @parentJobs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		SET @parent_count = (SELECT COUNT(*) FROM @parentJobs)
		SET @child_count = (SELECT COUNT(*) FROM @childJobs)
    END
	-- Do not migrate backup data of running job
DELETE	CommServ_Capture..CCM_ArchFile
FROM	CommServ_Capture..CCM_ArchFile a, CCM_SOURCE_JMJobInfo b, CommServ_Capture..CCM_App_Application c
	WHERE	a.commCellId = b.commCellId AND a.jobId = b.jobId
	AND a.appId = c.id AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE'
		GOTO CX_ERROR_EXIT
	END
DELETE CommServ_Capture..CCM_ArchFile
FROM   CommServ_Capture..CCM_ArchFile a, @to_delete_child b
	WHERE  a.commCellId = b.commCellId AND a.jobId = b.jobId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE -- Dependent Child jobs'
		GOTO CX_ERROR_EXIT
	END
DELETE CommServ_Capture..CCM_ArchFile
FROM   CommServ_Capture..CCM_ArchFile a, @to_delete_parent b
	WHERE  a.commCellId = b.commCellId AND a.jobId = b.jobId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE -- Dependent Parent jobs'
		GOTO CX_ERROR_EXIT
	END
	--SILO BackupSet and ArchFiles
	DECLARE @siloedStores table (storeId integer)
	DECLARE @newSILOApps table (appId integer)
	DECLARE @siloArchFiles table(archFileId integer,appId integer,jobId integer,commCellId integer)
    DECLARE @siloSubClient integer
        SET @errCode = 0
	INSERT @siloedStores
	SELECT DISTINCT d.SIDBStoreId
FROM CommServ_Capture..CCM_ArchFile a
	inner join CCM_SOURCE_archchunkmapping b ON a.id = b.archFileId and a.commCellId = b.commCellId
	inner join CCM_SOURCE_archChunk c ON b.archChunkId = c.id and b.commCellId = c.commCellId
	inner join CCM_SOURCE_MMVolume d ON c.volumeId = d.VolumeId and d.SiloStatus > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- INSERT -- @siloedStores'
		GOTO CX_ERROR_EXIT
	END
	INSERT @siloArchFiles
	SELECT DISTINCT d.id, d.appId, d.jobId, d.commCellId
	FROM @siloedStores a
	inner join CCM_SOURCE_mmvolume b ON a.storeId = b.SIDBStoreId
	inner join CCM_SOURCE_archFileSiloVolume c ON b.VolumeId = c.siloVolumeId
	inner join CCM_SOURCE_archFile d ON c.archFileId = d.id and c.commCellId = d.commCellId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- INSERT -- @siloArchFiles'
		GOTO CX_ERROR_EXIT
	END
	INSERT @siloArchFiles
	SELECT DISTINCT a.id, a.appId, a.jobId, a.commCellId
	FROM CCM_SOURCE_archFile a, @siloArchFiles b
	WHERE a.jobId = b.jobId
	AND a.commCellId = b.commCellId
	AND NOT EXISTS (SELECT * FROM @siloArchFiles WHERE archFileId = a.id AND commCellId = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- INSERT -- @siloArchFiles'
		GOTO CX_ERROR_EXIT
	END
INSERT CommServ_Capture..CCM_ArchFile
	SELECT 	a.id, a.name, a.commCellId, a.archGroupId, a.objName1,
			a.flags, a.appId, a.fileType, a.cTime, a.jobId,
			a.backupLevel, a.isValid, a.cloudId, a.contentIndexTime, a.nPushedItems
	FROM CCM_SOURCE_ArchFile a, @siloArchFiles b
	WHERE a.id = b.archFileId AND a.commCellId = b.commCellId
	AND NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_ArchFile b
           WHERE  b.id = a.id
           AND    b.commCellId = a.commCellId)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- INSERT -- CCM_ArchFile -SILO ARCHFILES'
		GOTO CX_ERROR_EXIT
	END
	--End of SILO BackupSet and ArchFiles
	/*--Delete jobs which are not in restricted job list
	IF (OBJECT_ID('tempdb.dbo.#CCM_Restricted_Capture_Entities') IS NOT NULL)
IF EXISTS(SELECT * FROM #CCM_Restricted_Capture_Entities WHERE EntityType = 23)
	BEGIN
DELETE	CommServ_Capture..CCM_ArchFile
FROM	CommServ_Capture..CCM_ArchFile a LEFT OUTER JOIN #CCM_Restricted_Capture_Entities b
ON a.jobId = b.EntityId AND a.commCellId = b.commCellId AND b.EntityType = 23
		WHERE	b.EntityId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE Non restricted jobs'
			GOTO CX_ERROR_EXIT
		END
	END
	*/
	--Skip Migration of Data belonging to SRM Analytics policy
DELETE FROM CommServ_Capture..CCM_ArchFile
WHERE archGroupId in (SELECT id From CCM_SOURCE_archGroup where type = 4)
	IF @@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE ArchFiles of SRM Analytics Policy'
		GOTO CX_ERROR_EXIT
	END
	--Skip capturing data belongs to other migrated commcells for ROBO job
	DECLARE @captureOnlyLocalData integer = 0
	SET @captureOnlyLocalData = ISNULL((SELECT value from MMConfigs where name = 'CCM_CONFIG_CAPTURE_ONLY_LOCAL_DATA_FOR_GRC'),1)
	IF ((@ccmParamFlags & 1) = 1 AND @captureOnlyLocalData = 1)
	BEGIN
DELETE FROM CommServ_Capture..CCM_ArchFile
		WHERE CommCellId NOT IN (0,2)
		IF @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE ArchFiles of other migrated commcells'
			GOTO CX_ERROR_EXIT
		END
	END
	--Don't capture current cycle jobs.
	IF EXISTS(SELECT 1 FROM MMConfigs WHERE name = 'CCM_CONFIG_DONOT_CAPTURE_JOBS_IN_CURRENT_CYCLE' AND value = 1)
	BEGIN
		DELETE 	AF
FROM 	CommServ_Capture..CCM_ArchFile AF
				INNER JOIN CCM_SOURCE_APP_SubClientProp APP ON AF.appId = APP.componentNameId AND APP.attrName = 'sys:full cycle num' AND APP.modified = 0
				INNER JOIN CCM_SOURCE_JMBkpStats JM ON AF.jobId = JM.jobId AND AF.commCellId = JM.commCellId AND JM.fullCycleNum = APP.attrVal AND JM.appId = APP.componentNameId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- Failed to delete current full cycle'
			GOTO CX_ERROR_EXIT
		END
	END
	--Capture all subclients which are not captured and archFiles are captrued.
	DECLARE @lt_SQLChainSubClients TABLE (appId int, clientId int)
	DECLARE @SQLChainAppId INT
	DECLARE @SQLChainClientId INT
	INSERT INTO @lt_SQLChainSubClients
SELECT DISTINCT a.appId, b.clientId FROM CommServ_Capture..CCM_ArchFile a INNER JOIN CCM_SOURCE_APP_Application b ON a.appId = b.id
	WHERE a.appId <> @i_subClientId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- @lt_SQLChainSubClients -- INSERT'
		GOTO CX_ERROR_EXIT
	END
INSERT INTO CommServ_Capture..CCM_App_Application
	SELECT 	a.*
	FROM 	CCM_SOURCE_APP_Application a
			INNER JOIN @lt_SQLChainSubClients b ON a.id = b.appId
LEFT OUTER JOIN CommServ_Capture..CCM_App_Application c ON a.id = c.id
	WHERE 	c.id IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_App_Application -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	DECLARE SQLChainSubclients_CUR CURSOR LOCAL FORWARD_ONLY FOR
	SELECT appId, clientId FROM @lt_SQLChainSubClients
	OPEN SQLChainSubclients_CUR
	FETCH NEXT FROM SQLChainSubclients_CUR INTO @SQLChainAppId,  @SQLChainClientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		--Capture client
        EXEC @errCode = CCM_Capture_Client_to_100 @SQLChainClientId
		IF	@errCode <> 0 OR @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_Capture_Client'
			GOTO CX_ERROR_EXIT
		END
        EXEC @errCode = CCM_CAPTURE_APP_TO_100 @SQLChainAppId, @SQLChainClientId, 0, @i_isExportFromLinkedServer, @i_exportDBName, @errStr = @errStr OUTPUT
		IF	@errCode <> 0 OR @@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_Capture_App'
			GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM SQLChainSubclients_CUR INTO @SQLChainAppId,  @SQLChainClientId
	END
	CLOSE SQLChainSubclients_CUR
	DEALLOCATE SQLChainSubclients_CUR
	---- CommServ_Capture..CCM_archIndexingAged
	--#ifndef CAPTURE_TO_80_CCM
	---- CommServ_Capture..CCM_ArchFileOracle
	--INSERT into CCM_DB_ARCHFILEORACLE
	--SELECT A.*
	--FROM CCM_SOURCE_ArchFileOracle A inner join CCM_DB_ARCHFILE B
	--	ON A.archFileId = B.Id AND A.commCellId = B.commCellId
	--	left outer join CCM_DB_ARCHFILEORACLE C
	--	ON A.archFileId = C.archFileId AND A.commCellId = C.commCellId
	--WHERE C.archFileId is null
	--IF	@@ERROR > 0
	--BEGIN
	--	SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileOracle'
	--	GOTO CX_ERROR_EXIT
	--END
	--#endif
	-- CommServ_Capture..CCM_ArchFileCopy
INSERT into CommServ_Capture..CCM_ArchFileCopy
SELECT a.* FROM CCM_SOURCE_ArchFileCopy a INNER JOIN CommServ_Capture..CCM_ArchFile b
	ON a.archFileId = b.id AND a.commCellId = b.commCellId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchFileCopy c
	ON  c.archFileId = a.archFileId AND    c.commCellId = a.commCellId
	     AND    c.archCopyId = a.archCopyId
	WHERE c.archFileId IS NULL
	--Following condition is not needed since capture db contains archfiles of current subclient and silo subclients.
	--AND (b.appId = @i_subClientId OR b.appId in (SELECT distinct appId FROM @siloArchFiles))
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileCopy'
		GOTO CX_ERROR_EXIT
	END
	--Skip jobs which are not in GRC job list to capture for ROBO job
	IF ((@ccmParamFlags & 1) = 1 AND OBJECT_ID('tempdb.dbo.#GRC_JOBS_TO_CAPTURE') IS NOT NULL)
		IF EXISTS(SELECT * FROM #GRC_JOBS_TO_CAPTURE)
	BEGIN
		DELETE 	DelAFC
FROM 	CommServ_Capture..CCM_ArchFileCopy DelAFC
		WHERE 	NOT EXISTS(SELECT 1 FROM #GRC_JOBS_TO_CAPTURE WHERE copyId = DelAFC.archCopyId)
				AND NOT EXISTS
				(
					SELECT 	1
FROM 	CommServ_Capture..CCM_ArchFile a
LEFT OUTER JOIN CommServ_Capture..CCM_ArchFileCopy b ON a.id = b.archFileId AND a.commCellId = b.commCellId
							LEFT OUTER JOIN #GRC_JOBS_TO_CAPTURE c ON b.archCopyId = c.copyId
					WHERE 	a.id = DelAFC.archFileId and a.commCellId = DelAFC.commCellId
					GROUP BY a.id HAVING COUNT(c.copyId) = 0
				)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileCopy -- DELETE Non restricted jobs'
			GOTO CX_ERROR_EXIT
		END
	END
	-- skip all GACP dependent copy jobs for cross version
	IF exists (select * from MMConfigs where name = 'CCM_CONFIG_SKIP_GACP_COPIES_FOR_CROSS_VERSION_CCM' AND value = 1)
	BEGIN
DELETE CommServ_Capture..CCM_ArchFileCopy
FROM CommServ_Capture..CCM_ArchFileCopy A INNER JOIN CCM_SOURCE_archGroupCopy B ON A.archCopyId = B.id
WHERE B.extendedFlags & 2 <> 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileCopy -- DELETE GACP dependent copy jobs.'
			GOTO CX_ERROR_EXIT
		END
	END
	-- CommServ_Capture..CCM_ArchFileCopyDedup
INSERT into CommServ_Capture..CCM_archFileCopyDedup
SELECT AFCD.* FROM CommServ_Capture..CCM_ArchFileCopy AFC inner join CCM_SOURCE_ArchFileCopyDedup AFCD
	ON AFC.archFileId = AFCD.archFileId AND AFC.archCopyId = AFCD.archCopyId AND AFC.commCellId = AFCD.commCellId
left outer join CommServ_Capture..CCM_archFileCopyDedup CCM_AFCD
	ON AFCD.archFileId = CCM_AFCD.archFileId AND AFCD.archCopyId = CCM_AFCD.archCopyId AND AFCD.commCellId = CCM_AFCD.commCellId
	where CCM_AFCD.archFileId is null
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileCopyDedup'
		GOTO CX_ERROR_EXIT
	END
	/*--Skip capturing of copies which are not in restricted copy list
	IF (OBJECT_ID('tempdb.dbo.#CCM_Restricted_Capture_Entities') IS NOT NULL)
IF EXISTS(SELECT * FROM #CCM_Restricted_Capture_Entities WHERE EntityType = 18)
	BEGIN
DELETE	CommServ_Capture..CCM_ArchFileCopy
FROM	CommServ_Capture..CCM_ArchFileCopy a LEFT OUTER JOIN #CCM_Restricted_Capture_Entities b
ON a.archCopyId = b.EntityId AND a.commCellId = b.commCellId AND b.EntityType = 18
		WHERE	b.EntityId IS NULL
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFile -- DELETE Non restricted jobs'
			GOTO CX_ERROR_EXIT
		END
	END
	*/
	-- CommServ_Capture..CCM_ArchChunkMapping
INSERT into CommServ_Capture..CCM_ArchChunkMapping
	SELECT
	distinct a.archChunkId, a.archFileId, a.commCellId, a.archCopyId, a.chunkNumber, a.physicalOffset,
					a.logicalOffset, a.physicalSize, a.logicalSize, a.flags, a.modifiedTime,a.dedupedSize,a.agedBy, a.chunkCommcellId, a.jobId
FROM CCM_SOURCE_ArchChunkMapping a INNER JOIN CommServ_Capture..CCM_ArchFileCopy b
	ON a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.archCopyId = b.archCopyId
LEFT OUTER JOIN CommServ_Capture..CCM_ArchChunkMapping c
	ON  c.archChunkId = a.archChunkId AND    c.chunkCommcellId = a.chunkCommcellId
	   AND    c.archFileId  = a.archFileId AND    c.commCellId  = a.commCellId
	WHERE c.archChunkId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchChunkMapping'
		GOTO CX_ERROR_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
	CREATE TABLE #tempChunk (id bigint, commCellId int, primary key (id, commcellid))
	INSERT	INTO #tempChunk
	SELECT
	DISTINCT archChunkId, chunkcommCellId
FROM	CommServ_Capture..CCM_ArchChunkMapping
	-- CommServ_Capture..CCM_ArchChunk
INSERT into CommServ_Capture..CCM_ArchChunk
	SELECT
	a.*
	FROM CCM_SOURCE_ArchChunk a, #tempChunk b
	WHERE	a.id = b.id AND a.commCellId = b.commCellId
	AND NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_ArchChunk c
	        WHERE  c.id = a.id
	        AND    c.commCellId = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchChunk'
		GOTO CX_ERROR_EXIT
	END
	-- SILO Backup information tables
	-- CommServ_Capture..CCM_ArchChunkToSILO
INSERT	INTO CommServ_Capture..CCM_ArchChunkToSilo
	SELECT	a.* FROM CCM_SOURCE_ArchChunkToSILO a, #tempChunk b
	WHERE	a.archChunkId = b.Id AND a.commCellId = b.commCellId
	AND  NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_ArchChunkToSilo c
	         WHERE  c.archChunkId = a.archChunkId
	         AND    c.commCellId  = a.commCellId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchChunkToSILO'
		GOTO CX_ERROR_EXIT
	END
	DELETE #tempChunk
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- Delete -- #tempChunk'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchFileSiloVolume
INSERT	INTO CommServ_Capture..CCM_ArchFileSiloVolume
SELECT	a.* FROM CCM_SOURCE_ArchFileSiloVolume a, CommServ_Capture..CCM_ArchFile b
	WHERE a.archFileId = b.id AND a.commCellId = b.commCellId
	AND NOT EXISTS(SELECT 1
FROM   CommServ_Capture..CCM_ArchFileSiloVolume c
	         WHERE  c.archFileId = a.archFileId
	         AND    c.commCellId  = a.commCellId
	         AND	c.siloVolumeId = a.siloVolumeId)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchFileSiloVolume'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- CommServ_Capture..CCM_OracleTableSpaces
INSERT into CommServ_Capture..CCM_OracleTableSpaces
	SELECT DISTINCT
	a.id, a.name, a.instId, a.bkpNode, a.status, a.created, a.deleteFlag, a.deleted, a.modified, a.opType, a.backupsetId, a.tablespaceId, a.maxDBdataSize, a.freeDBDataSize
	FROM CCM_SOURCE_OracleTableSpaces a
WHERE a.InstId IN (SELECT id FROM CommServ_Capture..CCM_App_InstanceName)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_OracleTableSpaces)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_OracleTableSpaces'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_OracleObjects
INSERT into CommServ_Capture..CCM_OracleObjects
	SELECT DISTINCT a.* FROM CCM_SOURCE_OracleObjects a
WHERE a.InstId IN (SELECT id FROM CommServ_Capture..CCM_App_InstanceName)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_OracleObjects)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_OracleObjects'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_OracleDataFiles
INSERT into CommServ_Capture..CCM_OracleDataFiles
	SELECT DISTINCT a.* FROM CCM_SOURCE_OracleDataFiles a
WHERE a.InstId IN (SELECT id FROM CommServ_Capture..CCM_App_InstanceName)
AND   a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_OracleDataFiles)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_OracleDataFiles'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_OraclePluggableDBs
	DECLARE @tailQuery VARCHAR(MAX)
SET @tailQuery = ' A LEFT OUTER JOIN CommServ_Capture..CCM_OraclePluggableDBs B ON B.pdbId = A.pdbId
WHERE B.pdbId IS NULL AND EXISTS (SELECT 1 FROM CommServ_Capture..CCM_App_InstanceName C WHERE C.id = A.InstId )'
EXEC CCM_Export_CopyTableFromLinkedServer @i_isExportFromLinkedServer, 'OraclePluggableDBs', 'CommServ_Capture..CCM_OraclePluggableDBs', '', @i_exportDBName, @tailQuery
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_OraclePluggableDBs'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_ArchDB2Log
INSERT into CommServ_Capture..CCM_ArchDb2Log
SELECT a.* FROM CCM_SOURCE_ArchDB2Log a, CommServ_Capture..CCM_ArchFile b, CommServ_Capture..CCM_App_Application c
	WHERE a.archFileId = b.id AND a.commCellId = b.commCellId
	AND b.appId = c.id AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_ArchDB2Log'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SybArchFileInfo
INSERT into CommServ_Capture..CCM_sybArchFileInfo
SELECT distinct a.* FROM CCM_SOURCE_SybArchFileInfo a, CommServ_Capture..CCM_ArchFile b, CommServ_Capture..CCM_App_Application c
	WHERE a.archFileId = b.id AND a.commCellId = b.commCellId
	AND b.appId = c.id AND c.appTypeId <> 1000
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SybArchFileInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SybTransLog
INSERT into CommServ_Capture..CCM_SybTransLog
	SELECT DISTINCT a.* FROM CCM_SOURCE_SybTransLog a
WHERE a.sybArchFileId IN (SELECT id FROM CommServ_Capture..CCM_sybArchFileInfo)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SybTransLog)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SybTransLog'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SybSystemDevices
INSERT into CommServ_Capture..CCM_SybSystemDevices
SELECT distinct a.* FROM CCM_SOURCE_SybSystemDevices a, CommServ_Capture..CCM_sybArchFileInfo b
	WHERE a.sybBackupJobId_h = 0
	AND a.sybBackupJobId_l = b.sybBackupJobId_l
	AND a.commCellId = b.commCellId
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SybSystemDevices)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SybSystemDevices'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_sybSystemUsages
INSERT into CommServ_Capture..CCM_SybSystemUsages
SELECT distinct a.* FROM CCM_SOURCE_sybSystemUsages a, CommServ_Capture..CCM_sybArchFileInfo b
	WHERE a.sybBackupJobId_h = 0
	AND a.sybBackupJobId_l = b.sybBackupJobId_l
	AND a.commCellId = b.commCellId
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SybSystemUsages)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sybSystemUsages'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	/*
	Only Following tables are used by SQL Server IDA in 9.0 as per kiran
	So removing capture of other
	*sqlDbBackupInfo
	*sqlFileBackupInfo
	*sqlNames
	*sqlNames2
	*sqlarchiveInfo
	*Sqllogmarks
	*/
	/*
	-- CommServ_Capture..CCM_SqlServer
INSERT into CommServ_Capture..CCM_SqlServer
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlServer a
	WHERE a.clientId = @i_clientId
AND a.instanceId IN (SELECT instance FROM CommServ_Capture..CCM_APP_Application WHERE id = @i_subClientId)
AND a.instanceId NOT IN (SELECT instanceId FROM CommServ_Capture..CCM_SqlServer)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlServer'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlVersion
INSERT into CommServ_Capture..CCM_SqlVersion
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlVersion a
WHERE a.id IN (SELECT sqlVersionId FROM CommServ_Capture..CCM_SqlServer)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlVersion)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlVersion'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlDatabase
INSERT into CommServ_Capture..CCM_SqlDatabase
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlDatabase a
WHERE a.sqlServerId IN (SELECT instanceId FROM CommServ_Capture..CCM_SqlServer)
AND a.backupSetId NOT IN (SELECT backupSetId FROM CommServ_Capture..CCM_SqlDatabase)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlDatabase'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlBackupSet
INSERT into CommServ_Capture..CCM_SqlBackupSet
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlBackupSet a
WHERE a.sqlDatabaseId IN (SELECT backupSetId FROM CommServ_Capture..CCM_SqlDatabase)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlBackupSet)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlBackupSet'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlVersion
INSERT into CommServ_Capture..CCM_SqlVersion
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlVersion a
WHERE a.id IN (SELECT sqlVersionId FROM CommServ_Capture..CCM_SqlBackupSet)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlVersion)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlVersion using sqlVersionId'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlVersion
INSERT into CommServ_Capture..CCM_SqlVersion
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlVersion a
WHERE a.id IN (SELECT mtfVersionId FROM CommServ_Capture..CCM_SqlBackupSet)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlVersion)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlVersion using mtfVersionId'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlArchiveSet
INSERT into CommServ_Capture..CCM_SqlArchiveSet
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlArchiveSet a
WHERE a.sqlBackupSetId IN (SELECT id FROM CommServ_Capture..CCM_SqlBackupSet)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlArchiveSet)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlArchiveSet'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlBackupFile
INSERT into CommServ_Capture..CCM_SqlBackupFile
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlBackupFile a
WHERE a.sqlBackupSetId IN (SELECT id FROM CommServ_Capture..CCM_SqlBackupSet)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlBackupFile)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlBackupFile'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlFileGroup
INSERT into CommServ_Capture..CCM_SqlFileGroup
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlFileGroup a
WHERE a.sqlDatabaseId IN (SELECT backupSetId FROM CommServ_Capture..CCM_SqlDatabase)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlFileGroup)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlFileGroup'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlFile
INSERT into CommServ_Capture..CCM_SqlFile
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlFile a
WHERE a.sqlFileGroupId IN (SELECT id FROM CommServ_Capture..CCM_SqlFileGroup)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlFile)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlFile'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlFileSubClient
INSERT into CommServ_Capture..CCM_SqlFileSubClient
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlFileSubClient a
WHERE a.sqlDatabaseId IN (SELECT backupSetId FROM CommServ_Capture..CCM_SqlDatabase)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlFileSubClient)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlFileSubClient'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlFileSubClientGroup
INSERT into CommServ_Capture..CCM_SqlFileSubClientGroup
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlFileSubClientGroup a
WHERE a.sqlFileSubClientId IN (SELECT id FROM CommServ_Capture..CCM_SqlFileSubClient)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlFileSubClientGroup)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlFileSubClientGroup'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlLsns
INSERT into CommServ_Capture..CCM_SqlLsns
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlLsns a
WHERE a.sqlDatabaseId IN (SELECT backupSetId FROM CommServ_Capture..CCM_SqlDatabase)
AND a.sqlBackupSetId NOT IN (SELECT sqlBackupSetId FROM CommServ_Capture..CCM_SqlLsns)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlLsns'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_SqlLogMarkNames
INSERT into CommServ_Capture..CCM_SqlLogMarkNames
	SELECT DISTINCT a.* FROM CCM_SOURCE_SqlLogMarkNames a
WHERE a.sqlDatabaseId IN (SELECT backupSetId FROM CommServ_Capture..CCM_SqlDatabase)
AND a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlLogMarkNames)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_SqlLogMarkNames'
		GOTO CX_ERROR_EXIT
	END
	*/
	/*
	Only Following tables are used by SQL Server IDA in 9.0 as per kiran nittur
	So removing capture of other sql tables
	*sqlDbBackupInfo
	*sqlFileBackupInfo
	*sqlNames
	*sqlNames2
	*sqlarchiveInfo
	*Sqllogmarks
	*/
	---------------------------------------------------------
	-- New SQL tables added in 6.1
	-- CommServ_Capture..CCM_sqlDbBackupInfo
MERGE CommServ_Capture..CCM_sqlDBBackupInfo as target
	USING CCM_SOURCE_sqlDbBackupInfo as source
	ON (source.id = target.id)
	WHEN NOT MATCHED BY target
	--AND source.instanceId in (SELECT id FROM CCM_DB_APP_INSTANCENAME)
AND source.appId in (SELECT id FROM CommServ_Capture..CCM_App_Application)
	AND ISNULL(source.type, '') <> ''
	THEN INSERT VALUES (source.id, source.backup_set_id, source.majorVersion, source.minorVersion,
	source.buildVersion, source.database_creation_date, source.backup_start_Date, source.backup_finish_Date,
	source.type,source.instanceId,source.appId, source.backup_size, source.dbId, source.first_lsn, source.last_lsn,
	source.checkpoint_lsn, source.full_bkup_lsn,source.sqlNameId,source.sqlLastLogBackup,
	source.sqlVssFullbackupTime, source.is_copy, source.backupmethod,
	source.backupvendor, source.jobid, source.replica_id, source.group_database_id, source.first_recovery_fork_guid, source.last_recovery_fork_guid, source.differential_base_guid,
	source.database_guid, source.fork_point_lsn, source.differential_base_lsn, source.compressed_backup_size, source.begins_log_chain, source.has_backup_checksums);
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlDbBackupInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_sqlFileBackupInfo
INSERT	into CommServ_Capture..CCM_sqlFileBackupInfo
	SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlFileBackupInfo a
WHERE	a.sqlDbBackupInfoId in (SELECT DISTINCT id FROM CommServ_Capture..CCM_sqlDBBackupInfo)
AND     a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_sqlFileBackupInfo)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlFileBackupInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_sqlNames
INSERT	into CommServ_Capture..CCM_SqlNames
	SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlNames a
WHERE	a.id in (SELECT DISTINCT sqlNameId FROM CommServ_Capture..CCM_sqlDBBackupInfo)
	AND		a.type = 1
AND     a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlNames)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlNames -- sqlNameId'
		GOTO CX_ERROR_EXIT
	END
INSERT	into CommServ_Capture..CCM_SqlNames
	SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlNames a
WHERE	a.id in (SELECT DISTINCT sqlNameFgId FROM CommServ_Capture..CCM_sqlFileBackupInfo)
	AND		a.type = 2
AND     a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlNames)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlNames -- sqlNameFgId'
		GOTO CX_ERROR_EXIT
	END
INSERT	into CommServ_Capture..CCM_SqlNames
	SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlNames a
WHERE	a.id in (SELECT DISTINCT sqlNamePhyId FROM CommServ_Capture..CCM_sqlFileBackupInfo)
	AND		a.type = 3
AND     a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlNames)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlNames -- sqlNamePhyId'
		GOTO CX_ERROR_EXIT
	END
INSERT	into CommServ_Capture..CCM_SqlNames
	SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlNames a
WHERE	a.id in (SELECT DISTINCT sqlNameLogId FROM CommServ_Capture..CCM_sqlFileBackupInfo)
	AND		a.type = 4
AND     a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlNames)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlNames -- sqlNameLogId'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_sqlNames2
INSERT	into CommServ_Capture..CCM_SqlNames2
	SELECT	DISTINCT a.* FROM CCM_SOURCE_sqlNames2 a
WHERE	a.id in (SELECT DISTINCT sqlid FROM CommServ_Capture..CCM_SqlNames)
AND     a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlNames2)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlNames2 -- sqlNameId'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_sqlarchiveInfo
INSERT	into CommServ_Capture..CCM_sqlArchiveInfo
		SELECT
			a.*
		FROM
CCM_SOURCE_sqlarchiveInfo a LEFT OUTER JOIN CommServ_Capture..CCM_sqlArchiveInfo b
			ON b.sqlDbBackupFileId = a.sqlDbBackupFileId AND b.commCellId = a.commCellId AND
				b.aFileId = a.aFileId AND b.aFileOffset = a.aFileOffset
			AND   b.backupJobId = a.backupJobId
JOIN CommServ_Capture..CCM_sqlDBBackupInfo ON a.sqlDbBackupFileId = CommServ_Capture..CCM_sqlDBBackupInfo.id
		WHERE b.sqlDbBackupFileId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_sqlarchiveInfo'
		GOTO CX_ERROR_EXIT
	END
	-- CommServ_Capture..CCM_Sqllogmarks
INSERT	into CommServ_Capture..CCM_SqlLogMarks
	SELECT	DISTINCT a.* FROM CCM_SOURCE_Sqllogmarks a
WHERE	a.instanceId in (SELECT id FROM CommServ_Capture..CCM_App_InstanceName)
AND     a.id NOT IN (SELECT id FROM CommServ_Capture..CCM_SqlLogMarks)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_Sqllogmarks'
		GOTO CX_ERROR_EXIT
	END
	-- Capture code for subclient level index pruning
INSERT into CommServ_Capture..CCM_App_IndexCheckpointInfo
    SELECT  a.*
FROM CCM_SOURCE_App_IndexCheckpointInfo a LEFT OUTER JOIN CommServ_Capture..CCM_App_IndexCheckpointInfo b
    ON  b.afileId = a.afileId AND b.commCellId = a.commCellId
INNER JOIN CommServ_Capture..CCM_ArchFile c ON a.afileId = c.id AND a.commCellId = c.commCellId
    WHERE b.afileId is null
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Capture_AF -- CCM_APP_INDEXCHECKPOINTINFO'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	--IF (Cursor_Status('LOCAL', 'SILOSubClientsCursor') >= -1)
	--BEGIN
	--	CLOSE SILOSubClientsCursor
	--	DEALLOCATE SILOSubClientsCursor
	--END
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Capture_AF_To_100')
	delete from GxQscripts where name = 'CCM_Capture_AF_To_100'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Capture_AF_To_100')
	delete from GXDBVersions where aliasname = 'CCM_Capture_AF_To_100'
GO

insert into GXDBVersions values(2, 'CCM_Capture_AF_To_100',  '00010001006000020000', 'CCM_Capture_AF_To_100', '00010001006000020000')
GO

