

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_ArchdeleteBackupByMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCM_ArchdeleteBackupByMedia.sp,v $ $Id: CCM_ArchdeleteBackupByMedia.sp,v 1.8.34.3 2019/12/21 21:47:58 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_ArchDeleteBackupByMedia')
BEGIN
	print '>>> Drop Stored Procedure: CCM_ArchDeleteBackupByMedia <<<'
	drop procedure CCM_ArchDeleteBackupByMedia
END
IF EXISTS (select * from GxQscripts where name='CCM_ArchDeleteBackupByMedia')
	delete from GxQscripts where name = 'CCM_ArchDeleteBackupByMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_ArchDeleteBackupByMedia')
	delete from GXDBVersions where aliasname = 'CCM_ArchDeleteBackupByMedia'
GO
print '... Creating Procedure: CCM_ArchDeleteBackupByMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_ArchDeleteBackupByMedia
  @i_mediaId integer
AS
  DECLARE @o_jobId integer
  DECLARE @o_appId integer
  DECLARE @o_appTypeId integer
  DECLARE @o_backupSetId integer
  DECLARE @o_forceNextBkpFull integer
DECLARE @i_cleanDB integer
DECLARE @i_seconds integer
DECLARE @l_agedByFlag integer
DECLARE @cleanDB integer
DECLARE @retVal integer
DECLARE @l_copyId integer
DECLARE @l_notAged integer
DECLARE @l_isMagnetic integer
DECLARE @l_now integer
DECLARE @l_datetime datetime
DECLARE	@magneticBytes bigint
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @i_cleanDB = 1 --For CCM always clean DB
SET @i_seconds = 0 --For CCM always 0
IF @i_seconds > 0
SET @l_agedByFlag = 8192
ELSE
SET @l_agedByFlag = 4096
SET	@cleanDB = @i_cleanDB
SET @l_copyId = 0
SET @l_notAged = 0
SET @l_isMagnetic = 0
SET @l_datetime = GetUTCDate()
SET @l_now = dbo.GetUnixTime(@l_datetime)
SET @retVal = 0
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
BEGIN TRY
	--********************** Create table variables **********************************/
	DECLARE @tblVol	TABLE (volumeId INT, recordingFormatId INT)
	DECLARE @tblAC	TABLE (
		id bigint, commCellId INT, createTime INT, flags INT,
		PRIMARY KEY (id, commCellId))
	DECLARE @tblBCDIndexAF TABLE(
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	DECLARE @tblJobsWithBCDIndex TABLE(
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	INSERT	INTO @tblVol
	SELECT	VolumeId, RecordingFormatId FROM Commserv_Merge..CCM_MMVolume WITH (NOLOCK)
	WHERE	MediaId = @i_mediaId
IF EXISTS (SELECT * FROM @tblVol WHERE recordingFormatId = 10001)
	   SET @l_isMagnetic = 1
	INSERT	INTO @tblAC
	SELECT	A.id, A.commCellId, A.createTime, A.flags
	FROM	Commserv_Merge..CCM_archChunk A WITH (NOLOCK), @tblVol B
	WHERE	A.volumeId = B.volumeId
	IF NOT EXISTS (SELECT * FROM @tblAC)
		GOTO CX_EXIT
	ELSE
	IF @i_seconds > 0
	BEGIN
		-- for overwriting a media if all chunks are older than @i_seconds
IF EXISTS (SELECT * FROM @tblAC WHERE createTime > @i_seconds AND (flags & 256) = 0)
		BEGIN
			SET @l_notAged = 1
			GOTO CX_EXIT
		END
	END
	-- No tombstoning for magnetic media, always deleting aged data.
	-- Used only for deleting content of a mount path!
	IF @l_isMagnetic = 1
	   SET @cleanDB = 1
	--********************** Create table variables **********************************/
	DECLARE @tblJobCopy TABLE (
		jobId INT, commCellId INT, fileType INT, appId INT,
		archGroupId INT, archCopyId INT, sourceCopyId INT,
		flags INT, isValidAF INT,
		PRIMARY KEY (jobId, commCellId, fileType, archCopyId))
	DECLARE @tblJob TABLE (
		jobId INT, commCellId INT, appId INT, deleted INT, forceNextBkpFull INT)
	--********************** Populate table variables ********************************/
	INSERT	INTO #ToBeAgedAFC
	SELECT	A.archFileId, A.commCellId, A.archCopyId
	FROM	Commserv_Merge..CCM_archChunkMapping A WITH (NOLOCK), @tblAC B
	WHERE	A.archChunkId = B.id AND A.commCellId = B.commCellId
	GROUP BY A.archFileId, A.commCellId, A.archCopyId
	INSERT	INTO @tblJobCopy
	SELECT	A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, B.archCopyId, 0, 0, MAX(A.isValid)
	FROM	Commserv_Merge..CCM_archFile A WITH (NOLOCK), #ToBeAgedAFC B
	WHERE	A.id = B.archFileId AND A.commCellId = B.commCellId
	GROUP BY A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, B.archCopyId
	/*
	-- Exit if this media contains valid data of a warm storage policy
	IF EXISTS (
		SELECT	*
		FROM	Commserv_Merge..CCM_archGroupCopy A WITH (NOLOCK), (SELECT DISTINCT archCopyId FROM @tblJobCopy) B
WHERE	A.id =  B.archCopyId AND (A.flags & 16777216) <> 0
	)
	BEGIN
		SET @l_notAged = 4
		GOTO CX_EXIT
	END
	*/
	/*
	-- Exit if this media contains valid data of a running/active job
	IF EXISTS (
		SELECT	*
		FROM	Commserv_Merge..CCM_JMJobInfo A WITH (NOLOCK), @tblJobCopy B
		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
			AND B.isValidAF <> -1
	)
	BEGIN
		SET @l_notAged = 2
		GOTO CX_EXIT
	END
	*/
	/*
	-- Exit if this media contains jobs of SILO AppId
	IF EXISTS (
		SELECT	T.*
		FROM	@tblJobCopy T, Commserv_Merge..CCM_JMJobDataStats JDS WITH (NOLOCK)
		WHERE	T.jobId = JDS.jobId
		AND 	T.commCellId = JDS.commCellId
		AND		T.archGroupId = JDS.archGrpId
		AND		T.archCopyId = JDS.archGrpCopyId
		AND		JDS.appId IN (SELECT DISTINCT siloAppId FROM Commserv_Merge..CCM_archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
		AND		JDS.status <> 1000
	)
	BEGIN
		SET @l_notAged = 3
		GOTO CX_EXIT
	END
	*/
	TRUNCATE TABLE #ToBeAgedAFC
	INSERT	INTO #ToBeAgedAFC
	SELECT	A.id, A.commCellId, B.archCopyId
	FROM	Commserv_Merge..CCM_archFile A WITH (NOLOCK), @tblJobCopy B
	WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND A.archGroupId = B.archGroupId
		-- If a valid data or index archive file is aged, the entire job is aged
		-- except for log and replaced index archive files.
AND (B.fileType NOT IN (4, 34) OR A.fileType = B.fileType)
		-- If the media has only isValidAF=-1 archive file of a job, don't touch other archive files of this job.
		AND (B.isValidAF <> -1 OR A.isValid = -1)
	GROUP BY A.id, A.commCellId, B.archCopyId
	DELETE	@tblJobCopy WHERE isValidAF = -1
	-- Regular Index Archive Files after movement to media
	INSERT INTO @tblBCDIndexAF
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, 0
	FROM 		Commserv_Merge..CCM_JMJobDataStats JDS WITH (NOLOCK), @tblJobCopy b, Commserv_Merge..CCM_archFile AF WITH (NOLOCK)
	WHERE		JDS.jobId = b.jobId
	AND			JDS.commCellId = b.commCellId
	AND			JDS.archGrpCopyId = b.archCopyId
	AND			JDS.jobId = AF.jobId
	AND			JDS.commCellId = AF.commCellId
	AND			JDS.dataType = AF.fileType
AND 		JDS.dataType IN (2)
AND			(AF.flags & (4 | 4096)) > 0
AND			b.fileType IN (1, 4, 2)
	INSERT INTO @tblJobsWithBCDIndex
SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, JDS.disabled & 256
	FROM 		Commserv_Merge..CCM_JMJobDataStats JDS WITH (NOLOCK), @tblBCDIndexAF TT
	WHERE		JDS.jobId = TT.jobId
	AND			JDS.commCellId = TT.commCellId
AND 		JDS.dataType IN (1, 4)
	AND			JDS.archGrpCopyId = TT.copyId
	UPDATE  @tblJobsWithBCDIndex
SET 		flags = 256
	FROM 		@tblJobsWithBCDIndex TT, @tblJobCopy b
	WHERE		TT.jobId = b.jobId
	AND			TT.commCellId = b.commCellId
AND 		((TT.fileType = b.fileType) OR b.fileType IN (2))
	AND			TT.copyId = b.archCopyId
	UPDATE  @tblBCDIndexAF
	SET 		flags = ISNULL(b.flags, 256)
	FROM 		@tblBCDIndexAF TT LEFT OUTER JOIN (	SELECT jobId, commCellId, copyId, MIN(flags & 256) AS flags
																							FROM @tblJobsWithBCDIndex
																							GROUP BY jobId, commCellId, copyId) b
	ON			TT.jobId = b.jobId
	AND			TT.commCellId = b.commCellId
	AND			TT.copyId = b.copyId
	--Do not prune BCD/Regular Index Archive File created after Snap movement to media if Data or Log is NOT AGED
	DELETE #ToBeAgedAFC
	FROM #ToBeAgedAFC T, @tblBCDIndexAF TT, Commserv_Merge..CCM_archFile A WITH (NOLOCK)
	WHERE	A.jobId = TT.jobId
	AND 	A.commCellId = TT.commCellId
	AND		A.fileType = TT.fileType
AND		TT.flags & 256 = 0
	AND		T.archCopyId = TT.copyId
	AND		T.archFileId = A.id
	AND		T.commCellId = A.commCellId
	--Prune BCD/Regular Index Archive File created after Snap movement to media if Data and Log are AGED
	INSERT	INTO #ToBeAgedAFC
	SELECT	A.id, A.commCellId, TT.copyId
	FROM	Commserv_Merge..CCM_archFile A WITH (NOLOCK), Commserv_Merge..CCM_archFileCopy B WITH (NOLOCK), @tblBCDIndexAF TT
	WHERE	A.jobId = TT.jobId
	AND 	A.commCellId = TT.commCellId
	AND		A.fileType = TT.fileType
AND		TT.flags & 256 = 256
	AND 	A.id = B.archFileId
	AND		A.commCellId = B.commCellId
	AND		B.archCopyId = TT.copyId
AND		B.flags & 256 = 0
	AND		NOT EXISTS (SELECT * FROM #ToBeAgedAFC as T
							WHERE	T.archFileId = A.id
							AND		T.commCellId = A.commCellId
							AND		T.archCopyId = TT.copyId)
	--Get all jobs that will be AGED
	INSERT	INTO @tblJobCopy
	SELECT	A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, C.archCopyId, 0, 0, MAX(A.isValid)
	FROM	Commserv_Merge..CCM_archFile A WITH (NOLOCK), Commserv_Merge..CCM_archFileCopy B WITH (NOLOCK), #ToBeAgedAFC C
	WHERE	A.id = B.archFileId
	AND 	A.commCellId = B.commCellId
	AND		A.id = C.archFileId
	AND 	A.commCellId = C.commCellId
	AND		B.archCopyId = C.archCopyId
	AND		NOT EXISTS (SELECT * FROM @tblJobCopy as T
							WHERE T.jobId = A.jobId
							AND 	T.commCellId = A.commCellId
							AND		T.fileType = A.fileType
							AND		T.archCopyId = C.archCopyId)
	GROUP BY A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, C.archCopyId
	INSERT	INTO @tblJob
	SELECT	DISTINCT jobId, commCellId, appId, 1, 0
	FROM	@tblJobCopy
	--IF @cleanDB = 0
	--BEGIN
EXEC @retVal = CCM_ArchFileSetAgedViaTable 4096, @l_now
		IF @retVal <> 0 GOTO CX_EXIT
		-- Tombstone chunks which have no archive file.
UPDATE	Commserv_Merge..CCM_archChunk WITH(PAGLOCK) SET flags = (a.flags | 256), modifiedTime = @l_now, agedBy = (agedBy | @l_agedByFlag)
		FROM	Commserv_Merge..CCM_archChunk a, @tblAC b
WHERE	a.id = b.id AND a.commCellId = b.commCellId AND (a.flags & 256) = 0
		UPDATE	Commserv_Merge..CCM_JMJobDataStats WITH(PAGLOCK)
SET		disabled = (a.disabled | 256), agedTime = @l_now, modifiedTime = @l_now, agedBy = (agedBy | @l_agedByFlag)
		FROM	Commserv_Merge..CCM_JMJobDataStats a, @tblJobCopy b
		WHERE	a.jobId = b.jobId AND a.commCellId = b.commCellId
			AND a.archGrpCopyId = b.archCopyId
			AND a.dataType = b.fileType
AND a.disabled & 256 = 0
		/*UPDATE	Commserv_Merge..CCM_CNJobDataCostHistory WITH (PAGLOCK)
		SET		TombStoned = 1, TombStonedTime = @l_datetime, Modified = @l_datetime
		FROM	@tblJobCopy T, Commserv_Merge..CCM_CNJobDataCostHistory J
		WHERE	J.JobID = T.jobId
			AND J.DataType = T.fileType
			AND J.ArchGrpCopyID = T.archCopyId AND J.CommCellID = T.commCellId
			AND J.TombStoned = 0*/
	--END
	--ELSE
	--BEGIN
		EXEC @retVal = CCM_ArchFileDeleteViaTable 0, @magneticBytes OUTPUT
		IF @retVal <> 0 GOTO CX_EXIT
		-- Delete chunks which have no archive file.
		DELETE	Commserv_Merge..CCM_archChunk WITH(PAGLOCK)
		FROM	Commserv_Merge..CCM_archChunk a, @tblAC b
		WHERE	a.id = b.id AND a.commCellId = b.commCellId
		UPDATE	Commserv_Merge..CCM_JMJobDataStats WITH(PAGLOCK)
SET		status = 1000, disabled = (a.disabled | 256),
				agedTime = @l_now, mediaDeletedTime = @l_now, modifiedTime = @l_now, agedBy = (agedBy | @l_agedByFlag)
		FROM	Commserv_Merge..CCM_JMJobDataStats a, @tblJobCopy b
		WHERE	a.jobId = b.jobId AND a.commCellId = b.commCellId
			AND a.archGrpCopyId = b.archCopyId
			AND a.dataType = b.fileType
			AND a.status <> 1000
		/*
		UPDATE	Commserv_Merge..CCM_CNJobDataCostHistory WITH (PAGLOCK)
		SET		TombStoned = 1, TombStonedTime = (case when J.TombStoned = 0 then @l_datetime else J.TombStonedTime end),
				Pruned = 1, PrunedTime = @l_datetime, Modified = @l_datetime
		FROM	@tblJobCopy T, Commserv_Merge..CCM_CNJobDataCostHistory J
		WHERE	J.JobID = T.jobId
		AND J.dataType = T.fileType
			AND J.ArchGrpCopyID = T.archCopyId AND J.CommCellID = T.commCellId
			AND J.Pruned = 0
		*/
		-- Set dataStatus = 2 when a job has been deleted from media from all copies
		UPDATE	@tblJob
		SET		deleted = 0
		FROM	Commserv_Merge..CCM_JMJobDataStats A WITH (NOLOCK), @tblJob B
		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
 			AND A.status NOT IN (101, 1000)
		UPDATE	Commserv_Merge..CCM_JMBkpStats WITH (PAGLOCK)
		SET		dataStatus = 2, agedTime = (case when J.agedTime = 0 then @l_now else J.agedTime end),
				mediaDeletedTime = @l_now, modifiedTime = @l_now
		FROM	Commserv_Merge..CCM_JMBkpStats J, @tblJob T
		WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
 			AND J.dataStatus <> 2 AND T.deleted = 1
		UPDATE	Commserv_Merge..CCM_JMAdminJobStatsTable WITH (PAGLOCK)
		SET		dataStatus = 2
		FROM	Commserv_Merge..CCM_JMAdminJobStatsTable J, @tblJob T
		WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
 			AND J.dataStatus <> 2 AND T.deleted = 1
	--END
	SELECT TOP 1 @l_copyId = archCopyId FROM @tblJobCopy
	/* @i_seconds - always 0 - for CCM
	IF @i_seconds > 0
	BEGIN
		-- for overwriting a media
		-- Disable not fully copied jobs on destination copies.
		CREATE TABLE #ToBeDisabledJob (
			jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT,
			PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
		INSERT	INTO #ToBeDisabledJob
		SELECT	jobId, archGroupId, archCopyId, fileType, commCellId
		FROM	@tblJobCopy
		EXEC CCM_archDisallowMultipleJobForCopy @l_now
		DROP TABLE #ToBeDisabledJob
	END
	*/
	-- Set copy aging rule flags dirty bit to AM_AGING_FLAGS_EXT_DIRTY
	-- This is to indicate the need to calculate retentionFlags in JMJobDataStats table
	UPDATE	Commserv_Merge..CCM_ArchAgingRule WITH(PAGLOCK) SET flags = flags | 2
	WHERE	copyId = @l_copyId AND flags & 2 = 0
	IF @@ERROR <> 0 GOTO CX_EXIT
	DECLARE @volumeToDelete table(id integer)
	INSERT INTO @volumeToDelete
	SELECT DISTINCT volumeId from Commserv_Merge..CCM_MMVolume where MediaId = @i_mediaId
	DELETE FROM Commserv_Merge..CCM_MMVolume where VolumeId in (SELECT DISTINCT id from @volumeToDelete)
	DELETE FROM Commserv_Merge..CCM_archFileSiloVolume WHERE siloVolumeId in (SELECT DISTINCT id from @volumeToDelete)
	DELETE Commserv_Merge..CCM_archFileSiloVolume FROM #ToBeAgedAFC afc inner join Commserv_Merge..CCM_archFileSiloVolume afs
	ON afs.archFileId = afc.archFileId AND afs.commCellId = afc.commCellId
	DELETE FROM Commserv_Merge..CCM_MMMediaSide WHERE MediaId = @i_mediaId
	DELETE FROM Commserv_Merge..CCM_MMMedia WHERE MediaId = @i_mediaId
	DELETE FROM @volumeToDelete
	-- For "Delete Contents"
	/*
	IF @i_cleanDB = 0
	BEGIN
		-- If any valid data which belong to the last full cycle are pruned from primary copy because of
		-- "Delete Contents", the next backup should be a full backup.
		IF EXISTS (SELECT * FROM Commserv_Merge..CCM_archGroup WHERE defaultCopy = @l_copyId)
		BEGIN
			UPDATE	@tblJob SET forceNextBkpFull = 1
			FROM	@tblJob a LEFT JOIN
					(SELECT	DISTINCT x.appId
					FROM	(SELECT	appId, MAX(jobId) AS jobId FROM @tblJob GROUP BY appId) x,
							Commserv_Merge..CCM_JMBkpStats y WITH (NOLOCK)
					WHERE	y.appId = x.appId AND y.jobId > x.jobId
						AND y.status IN (1, 3, 14) AND y.bkpLevel IN (1, 64, 128, 16384, 1024, 32768)
					) b
				ON	b.appId = a.appId
			WHERE	b.appId IS NULL
		END
		-- Disallow pruned jobs for copy
		DECLARE @tblCopyToSet TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT)
		INSERT INTO @tblCopyToSet
		EXEC CCM_ArchDestinationCopyList @l_copyId
		DELETE FROM @tblCopyToSet WHERE copyId = @l_copyId
		IF EXISTS (SELECT * FROM @tblCopyToSet)
		BEGIN
			INSERT	INTO @tblJobCopy
			SELECT	DISTINCT J.jobId, J.commCellId, J.dataType, B.appId, J.archGrpId, J.archGrpCopyId,
					C.sourceCopyId, 1, 0
			FROM	Commserv_Merge..CCM_JMJobDataStats J WITH (NOLOCK), @tblJobCopy B, @tblCopyToSet C
			WHERE	J.jobId = B.jobId AND J.archGrpCopyId = C.copyId
				AND J.dataType = B.fileType
				AND J.commCellId = B.commCellId
AND J.status IN (101, 102, 103) AND (J.disabled & (1 + 256)) = 0
			IF @@ROWCOUNT > 0
			BEGIN
				DELETE	FROM @tblJobCopy
				WHERE	jobId NOT IN (SELECT DISTINCT jobId FROM @tblJobCopy WHERE flags = 0)
				SELECT	@retVal = 0
				WHILE @@ROWCOUNT > 0
					UPDATE	@tblJobCopy SET flags = 1
					WHERE	flags = 0 AND sourceCopyId IN (SELECT Commserv_Merge..CCM_archCopyId FROM @tblJobCopy WHERE flags = 1)
				UPDATE 	Commserv_Merge..CCM_JMJobDataStats
SET		disabled = (J.disabled | 1), modifiedTime = @l_now
				FROM	Commserv_Merge..CCM_JMJobDataStats J, @tblJobCopy T
				WHERE	J.jobId = T.jobId AND J.archGrpCopyId = T.archCopyId AND J.commCellId = T.commCellId
					AND J.dataType = T.fileType
AND T.flags = 1 AND J.archGrpCopyId <> @l_copyId
AND J.disabled & 1 = 0
			END
		END
	END
	*/
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET	@retVal = (SELECT ERROR_NUMBER())
END CATCH
--*********************************** Going to exit **********************************/
CX_EXIT:
DROP TABLE #ToBeAgedAFC
IF @retVal <> 0 OR @l_notAged <> 0
BEGIN
	--SELECT	-1, @retVal, @l_notAged, 0, 0
	RETURN (-1)
END
ELSE
BEGIN
	--SELECT	T.jobId, T.appId, A.appTypeId, A.backupSet, T.forceNextBkpFull
	--FROM	@tblJob T, Commserv_Merge..CCM_APP_Application A WITH (NOLOCK)
	--WHERE	A.id = T.appId
	--ORDER BY T.appId, T.forceNextBkpFull DESC
	RETURN (0)
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_ArchdeleteBackupByMedia')
	delete from GxQscripts where name = 'CCM_ArchdeleteBackupByMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_ArchdeleteBackupByMedia')
	delete from GXDBVersions where aliasname = 'CCM_ArchdeleteBackupByMedia'
GO

insert into GXDBVersions values(2, 'CCM_ArchdeleteBackupByMedia',  '00010008003400030000', 'CCM_ArchdeleteBackupByMedia', '00010008003400030000')
GO

