

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_ArchFileSetAgedViaTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCM_ArchFileSetAgedViaTable.sp,v $ $Id: CCM_ArchFileSetAgedViaTable.sp,v 1.6.60.3 2018/03/20 00:46:07 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_ArchFileSetAgedViaTable <<<'

IF EXISTS (select * from sysobjects where name='CCM_ArchFileSetAgedViaTable')
	drop procedure CCM_ArchFileSetAgedViaTable
IF EXISTS (select * from GxQscripts where name='CCM_ArchFileSetAgedViaTable')
	delete from GxQscripts where name = 'CCM_ArchFileSetAgedViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_ArchFileSetAgedViaTable')
	delete from GXDBVersions where aliasname = 'CCM_ArchFileSetAgedViaTable'
GO
print '... Creating Procedure: CCM_ArchFileSetAgedViaTable'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_ArchFileSetAgedViaTable
  @i_agedByFlag integer,
  @i_agedTime integer
AS
DECLARE @retVal	integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET		@retVal = 0
DECLARE	@hasMagnetic INT
SET		@hasMagnetic = 0
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
*/
CREATE TABLE #ToBeAgedACM (
	archChunkId BIGINT, archFileId INT, commCellId INT, archCopyId INT, physicalSize BIGINT,
	PRIMARY KEY (archChunkId, archFileId, commCellId, archCopyId))
CREATE TABLE #ToBeAgedAC (
	archChunkId BIGINT, commCellId INT, archCopyId INT, volumeId INT, version INT,
	cclip varchar(255), physicalSize BIGINT, SIDBStoreId INT, isMagnetic INT, MountPathId INT,
 	PRIMARY KEY (archChunkId, commCellId))
BEGIN TRY
	-- Get chunks of pruneable archive files
	INSERT	INTO #ToBeAgedACM
	SELECT	ACM.archChunkId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize
	FROM	#ToBeAgedAFC T, Commserv_Merge..CCM_archChunkMapping ACM WITH(NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
AND ACM.flags & 256 = 0
	INSERT	INTO #ToBeAgedAC
	SELECT	AC.id, AC.commCellId, T.archCopyId, AC.volumeId, AC.version, AC.cclip, AC.physicalSize, 0, 0, 0
	FROM	(SELECT DISTINCT archChunkId, commCellId, archCopyId FROM #ToBeAgedACM) T,
			Commserv_Merge..CCM_archChunk AC WITH(NOLOCK)
	WHERE	AC.id = T.archChunkId AND AC.commCellId = T.commCellId
AND AC.flags & 256 = 0
	-- Mark archive files and chunks as aged
	UPDATE	Commserv_Merge..CCM_archFileCopy WITH (PAGLOCK)
SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = @i_agedByFlag
	FROM	#ToBeAgedAFC T, Commserv_Merge..CCM_archFileCopy A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
AND A.flags & 256 = 0
	-- Mark SMVolume as prunable
	UPDATE	Commserv_Merge..CCM_SMVolume WITH (PAGLOCK)
SET		PruneFlags = 3
	FROM	#ToBeAgedAFC T, Commserv_Merge..CCM_SMVolume A
	WHERE	A.archFileId = T.archFileId
		AND A.commCellId = T.commCellId
		AND A.CopyId = T.archCopyId
AND A.PruneFlags IN (0, 1, 2)
	UPDATE	Commserv_Merge..CCM_archChunkMapping WITH (PAGLOCK)
SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = @i_agedByFlag
	FROM	#ToBeAgedAFC T, Commserv_Merge..CCM_archChunkMapping A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
AND A.flags & 256 = 0
	-- Flag magnetic chunks
	UPDATE	#ToBeAgedAC
	SET		isMagnetic = 1, SIDBStoreId = V.SIDBStoreId, MountPathId = MP.MountPathId
	FROM	#ToBeAgedAC T, Commserv_Merge..CCM_MMVolume V WITH (NOLOCK), Commserv_Merge..CCM_MMMountPath MP WITH (NOLOCK)
WHERE	T.volumeId = V.VolumeId AND V.RecordingFormatId = 10001
		AND	V.MediaSideId = MP.MediaSideId
	IF @@ERROR = 0 AND @@ROWCOUNT > 0
		SET @hasMagnetic = 1
	-- For archive files prior to 5.0
	/*IF @hasMagnetic = 1
	INSERT	INTO MMDeletedAF
	SELECT	A.archFileId, B.volumeId, 0, 0, A.archCopyId, B.cclip, SUM(A.physicalSize),
			0, B.MountPathId, 0, A.commCellId, @i_agedTime, 0, 0, 0, 0, 0, 0
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.commCellId = B.commCellId
		AND B.version < 3 AND B.isMagnetic = 1
	GROUP	BY A.archFileId, B.volumeId, A.archCopyId, B.cclip, A.commCellId, B.MountPathId
	-- For CV-Single-Instanced archive files
	INSERT	INTO MMDeletedAF
	SELECT	A.archFileId, B.volumeId, 0, 0, A.archCopyId, B.cclip, A.physicalSize,
			A.archChunkId, B.MountPathId, B.SIDBStoreId, A.commCellId, @i_agedTime, 0, 0, 0, 0, 0, B.CommCellId
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.commCellId = B.commCellId
		AND B.SIDBStoreId > 0
	*/
	-- Filter out chunks having non-aged archive files
	DELETE	#ToBeAgedAC
	FROM	#ToBeAgedAC T, Commserv_Merge..CCM_ArchChunkMapping A WITH (NOLOCK)
	WHERE	A.archChunkId = T.archChunkId AND A.commCellId = T.commCellId
AND A.flags & 256 = 0
	UPDATE	Commserv_Merge..CCM_archChunk WITH (PAGLOCK)
SET		flags = (A.flags | 256), modifiedTime = @i_agedTime, agedBy = @i_agedByFlag
	FROM	#ToBeAgedAC T, Commserv_Merge..CCM_archChunk A
	WHERE	A.id = T.archChunkId AND A.commCellId = T.commCellId
AND A.flags & 256 = 0
	/*IF @hasMagnetic = 1
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, cclip, physicalSize,
			archChunkId, #ToBeAgedAC.MountPathId, 0, 0, @i_agedTime, 0, 0, 0, 0, 0, commCellId
	FROM	#ToBeAgedAC
	WHERE	isMagnetic = 1 AND SIDBStoreId = 0 AND version >= 3
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, '', SUM(physicalSize),
			0, 0, 0, 0, @i_agedTime, 0, 0, 0, 0, 0, commCellId
	FROM	#ToBeAgedAC
	WHERE	isMagnetic = 0 AND SIDBStoreId = 0
	GROUP BY volumeId, archCopyId, commCellId*/
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retVal = (SELECT ERROR_NUMBER())
END CATCH
DROP TABLE #ToBeAgedACM
DROP TABLE #ToBeAgedAC
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_ArchFileSetAgedViaTable')
	delete from GxQscripts where name = 'CCM_ArchFileSetAgedViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_ArchFileSetAgedViaTable')
	delete from GXDBVersions where aliasname = 'CCM_ArchFileSetAgedViaTable'
GO

insert into GXDBVersions values(2, 'CCM_ArchFileSetAgedViaTable',  '00010006006000030000', 'CCM_ArchFileSetAgedViaTable', '00010006006000030000')
GO

