

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_ArchFileDeleteViaTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCM_ArchFileDeleteViaTable.sp,v $ $Id: CCM_ArchFileDeleteViaTable.sp,v 1.3.60.4 2018/12/30 04:36:08 kbora Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_ArchFileDeleteViaTable')
BEGIN
	print '>>> Drop Stored Procedure: CCM_ArchFileDeleteViaTable <<<'
	drop procedure CCM_ArchFileDeleteViaTable
END
IF EXISTS (select * from GxQscripts where name='CCM_ArchFileDeleteViaTable')
	delete from GxQscripts where name = 'CCM_ArchFileDeleteViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_ArchFileDeleteViaTable')
	delete from GXDBVersions where aliasname = 'CCM_ArchFileDeleteViaTable'
GO
print '... Creating Procedure: CCM_ArchFileDeleteViaTable'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_ArchFileDeleteViaTable
  @i_dummy integer,
  @magneticBytes bigint	OUTPUT
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET		@retVal = 0
DECLARE	@hasMagnetic INT
SET		@hasMagnetic = 0
DECLARE	@currentTime INT
SET		@currentTime = dbo.GetUnixTime(GETUTCDATE())
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
*/
CREATE TABLE #ToBeAgedACM (
	archChunkId BIGINT, archFileId INT, commCellId INT, archCopyId INT, physicalSize BIGINT, isAged INT,
	PRIMARY KEY (archChunkId, archFileId, commCellId, archCopyId))
CREATE TABLE #ToBeAgedAC (
	archChunkId BIGINT, commCellId INT, archCopyId INT, volumeId INT, version INT,
	cclip varchar(255), physicalSize BIGINT, isAged INT,
	SIDBStoreId INT, isMagnetic INT, MountPathId INT, allAFsAged INT,
 	PRIMARY KEY (archChunkId, commCellId))
CREATE TABLE #NotAgedAC (archChunkId BIGINT, commCellId INT, isAged INT)
BEGIN TRY
	-- Get chunks of pruneable archive files
	INSERT	INTO #ToBeAgedACM
SELECT	ACM.archChunkId, ACM.archFileId, ACM.commCellId, ACM.archCopyId, ACM.physicalSize, (ACM.flags & 256)
	FROM	#ToBeAgedAFC T, Commserv_Merge..CCM_archChunkMapping ACM WITH(NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
	INSERT	INTO #ToBeAgedAC
SELECT	AC.id, AC.commCellId, T.archCopyId, AC.volumeId, AC.version, AC.cclip, AC.physicalSize, (AC.flags & 256),
0, 0, 0, (1 + 256)
	FROM	(SELECT DISTINCT archChunkId, commCellId, archCopyId FROM #ToBeAgedACM) T,
			Commserv_Merge..CCM_archChunk AC WITH(NOLOCK)
	WHERE	AC.id = T.archChunkId AND AC.commCellId = T.commCellId
	-- Delete archFileCopy and archChunkMapping entries
	DELETE	Commserv_Merge..CCM_archFileCopy WITH (PAGLOCK)
	FROM	#ToBeAgedAFC T, Commserv_Merge..CCM_archFileCopy A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
	DELETE Commserv_Merge..CCM_archChunkMapping WITH (PAGLOCK)
	FROM	#ToBeAgedAFC T, Commserv_Merge..CCM_archChunkMapping A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = T.archCopyId
	-- Filter out archive files which still exist in some copy
	DELETE	#ToBeAgedAFC
	FROM	#ToBeAgedAFC T, Commserv_Merge..CCM_archFileCopy A WITH (NOLOCK)
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId
	-- Remove archive files which do not exist in any copy from archFile table.
	DELETE	Commserv_Merge..CCM_archFile WITH(PAGLOCK)
	FROM	#ToBeAgedAFC T, Commserv_Merge..CCM_archFile A
	WHERE	A.id = T.archFileId AND A.commCellId = T.commCellId
	-- Remove from sybase table also.
	DELETE	Commserv_Merge..CCM_SybArchFileInfo
	FROM	#ToBeAgedAFC T, Commserv_Merge..CCM_SybArchFileInfo A
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId
	---------------------------------------------------------
	-- Prune snap records after archfilecopy table is pruned
	---------------------------------------------------------
	declare @tblRtn table (retVal int)
	insert into @tblRtn
	EXEC @retVal = CCM_archPruneVolSnaps 0
	if @retVal <> 0 GOTO CX_EXIT
	---------------------------------------------------------
	-- Flag magnetic chunks
	UPDATE	#ToBeAgedAC
	SET 	isMagnetic = 1, SIDBStoreId = V.SIDBStoreId, MountPathId = MP.MountPathId
	FROM	#ToBeAgedAC T, Commserv_Merge..CCM_MMVolume V WITH (NOLOCK), Commserv_Merge..CCM_MMMountPath MP WITH (NOLOCK)
	WHERE	T.volumeId = V.VolumeId
AND V.RecordingFormatId = 10001
		AND V.MediaSideId = MP.MediaSideId
	IF @@ERROR = 0 AND @@ROWCOUNT > 0
		SET @hasMagnetic = 1
	-- For archive files prior to 5.0
	/*IF @hasMagnetic = 1
	INSERT	INTO Commserv_Merge..CCM_MMDeletedAF
	SELECT	A.archFileId, B.volumeId, 0, 0, A.archCopyId, B.cclip, SUM(A.physicalSize),
			0, B.MountPathId, 0, A.commCellId, @currentTime
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.commCellId = B.commCellId
		AND A.isAged = 0
		AND B.isMagnetic = 1
		AND B.version < 3
	GROUP	BY A.archFileId, B.volumeId, A.archCopyId, B.cclip, A.commCellId, B.MountPathId
	-- For CV-Single-Instanced archive files
	INSERT	INTO Commserv_Merge..CCM_MMDeletedAF
	SELECT	A.archFileId, B.volumeId, 0, 0, A.archCopyId, B.cclip, A.physicalSize,
			A.archChunkId, B.MountPathId, B.SIDBStoreId, A.commCellId, @currentTime
	FROM	#ToBeAgedACM A, #ToBeAgedAC B
	WHERE	A.archChunkId = B.archChunkId AND A.commCellId = B.commCellId
		AND A.isAged = 0
		AND B.SIDBStoreId > 0
	*/
	-- Flag if remaining archive files are all aged:
	-- allAFsAged = LOCAL_NO_AF_REMAIN_FLAG if no entry remain in archChunkMapping table for a chunk.
	-- allAFsAged = CVA_AGED_DATA_FLAG if all remaning archChunkMapping table entries are aged.
	-- allAFsAged = 0 if some remaining archChunkMapping table entries are not aged.
	INSERT	INTO #NotAgedAC
SELECT	A.archChunkId, A.commCellId, MIN(A.flags & 256)
	FROM	#ToBeAgedAC T, Commserv_Merge..CCM_archChunkMapping A WITH (NOLOCK)
	WHERE	A.archChunkId = T.archChunkId AND A.commCellId = T.commCellId
	GROUP BY A.archChunkId, A.commCellId
	UPDATE	#ToBeAgedAC
	SET		allAFsAged = (T.allAFsAged & N.isAged)
	FROM	#ToBeAgedAC T, #NotAgedAC N
	WHERE	T.archChunkId = N.archChunkId AND T.commCellId = N.commCellId
	-- Filter out chunks which still have non-aged archive files.
	DELETE	#ToBeAgedAC
	WHERE	allAFsAged = 0
	-- Delete chunks which have no more archive files.
	DELETE	Commserv_Merge..CCM_archChunk WITH (PAGLOCK)
	FROM	#ToBeAgedAC T, Commserv_Merge..CCM_archChunk A
	WHERE	A.id = T.archChunkId AND A.commCellId = T.commCellId
AND	T.allAFsAged & 1 <> 0
	-- Set aged flag if only aged archive files remain in a chunk.
	UPDATE	Commserv_Merge..CCM_archChunk
SET		flags = (A.flags | 256), agedBy = (agedBy | 2048), modifiedTime = @currentTime
	FROM	#ToBeAgedAC T, Commserv_Merge..CCM_archChunk A
	WHERE	A.id = T.archChunkId AND A.commCellId = T.commCellId
AND	A.flags & 256 = 0
AND	T.allAFsAged = 256
	/*IF @hasMagnetic = 1
	INSERT	INTO Commserv_Merge..CCM_MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, cclip, physicalSize,
			archChunkId, #ToBeAgedAC.MountPathId, 0, commCellId, @currentTime
	FROM	#ToBeAgedAC
	WHERE	isAged = 0
		AND isMagnetic = 1
		AND version >= 3
		AND SIDBStoreId = 0
	INSERT	INTO Commserv_Merge..CCM_MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, '', SUM(physicalSize),
			0, 0, 0, commCellId, @currentTime
	FROM	#ToBeAgedAC
	WHERE	isAged = 0
		AND isMagnetic = 0
		AND SIDBStoreId = 0
	GROUP BY volumeId, archCopyId, commCellId
	*/
	SET @magneticBytes = (
		SELECT	SUM(physicalSize)
		FROM	#ToBeAgedAC
		WHERE	isAged = 0
			AND isMagnetic = 1)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retVal = (SELECT ERROR_NUMBER())
END CATCH
CX_EXIT:
DROP TABLE #ToBeAgedACM
DROP TABLE #ToBeAgedAC
DROP TABLE #NotAgedAC
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_ArchFileDeleteViaTable')
	delete from GxQscripts where name = 'CCM_ArchFileDeleteViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_ArchFileDeleteViaTable')
	delete from GXDBVersions where aliasname = 'CCM_ArchFileDeleteViaTable'
GO

insert into GXDBVersions values(2, 'CCM_ArchFileDeleteViaTable',  '00010003006000040000', 'CCM_ArchFileDeleteViaTable', '00010003006000040000')
GO

