

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMSetQuestionsXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Stored Precedure: Populates questions xml in GRC_CommCellProp table.
--	| 					If questions xml already exist then merges the input xml with existing xml.
--  +========================================================================+
-- $Id: CCMSetQuestionsXML.sp,v 1.3.58.2 2018/03/20 00:43:13 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMSetQuestionsXML <<<'

IF EXISTS (select * from sysobjects where name='CCMSetQuestionsXML')
	drop procedure CCMSetQuestionsXML
IF EXISTS (select * from GxQscripts where name='CCMSetQuestionsXML')
	delete from GxQscripts where name = 'CCMSetQuestionsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMSetQuestionsXML')
	delete from GXDBVersions where aliasname = 'CCMSetQuestionsXML'
GO
print '... Creating Procedure: CCMSetQuestionsXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMSetQuestionsXML
  @i_CommCellId int,
  @i_QuestionsXML xml
AS
  DECLARE @o_errorCode int
  DECLARE @o_errorStr varchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN
	DECLARE 	@l_oldQuestionsXML				XML
	DECLARE 	@l_newQuestionsXML				XML
	DECLARE		@l_oldCCNumber					BIGINT
	DECLARE		@l_oldCCName					VARCHAR(1024)
	DECLARE		@l_oldCCGuid					VARCHAR(36)
	DECLARE		@l_newCCNumber					BIGINT
	DECLARE		@l_newCCName					VARCHAR(1024)
	DECLARE		@l_newCCGuid					VARCHAR(36)
	IF OBJECT_ID('tempdb..#lt_ClientNameQuestions') IS NOT NULL DROP TABLE #lt_ClientNameQuestions
	CREATE TABLE #lt_ClientNameQuestions	(
												OldClientName 				VARCHAR(1024),
												OldClientHostName 			VARCHAR(1024)
											)
	IF OBJECT_ID('tempdb..#lt_IdxAccessPathQuestions') IS NOT NULL DROP TABLE #lt_IdxAccessPathQuestions
	CREATE TABLE #lt_IdxAccessPathQuestions	(
												SourceSIDBID						INT,
												SourceSIDBName						VARCHAR(1024),
												SourceAccessPathId					INT,
												StoragePoliceName					VARCHAR(1024),
												CopyName							VARCHAR(1024),
												SourceAccessPathMediaAgentName		VARCHAR(1024),
												SourceAccessPath					VARCHAR(1024),
												IsGlobalStoreFlag					INT
											)
	IF OBJECT_ID('tempdb..#lt_DataPathQuestions') IS NOT NULL DROP TABLE #lt_DataPathQuestions
	CREATE TABLE #lt_DataPathQuestions		(
												SourceCopyId						INT,
												StoragePoliceName					VARCHAR(1024),
												CopyName							VARCHAR(1024),
												SourceLibraryId						INT,
												LibraryAliasName_MustInput			VARCHAR(1024),
												SourceHostId						VARCHAR(1024),
												DriveTypeId							INT,
												DrivePoolId							INT,
												Flag								BIGINT
											)
	IF OBJECT_ID('tempdb..#lt_MountPathLibQuestions') IS NOT NULL DROP TABLE #lt_MountPathLibQuestions
	CREATE TABLE #lt_MountPathLibQuestions	(
												mountPathId int,
												mountPathName varchar(512),
												mountPathType int,
												libraryId int,
												libraryName nvarchar(128),
												deviceId int,
												deviceName nvarchar(128)
											)
	IF OBJECT_ID('tempdb..#lt_DevicePathQuestions') IS NOT NULL DROP TABLE #lt_DevicePathQuestions
	CREATE TABLE #lt_DevicePathQuestions	(
												DeviceId 			INT,
												Id 					INT,
												Path 				VARCHAR(1024),
												UserName 			VARCHAR(1024),
												UserPassword 		VARCHAR(2048)
											)
	--Populate temp tables with questions from new XML
	EXEC CCMReadQuestionsXML @i_QuestionsXML, @CCNumber = @l_newCCNumber OUTPUT, @CCName = @l_newCCName OUTPUT, @CCGuid = @l_newCCGuid OUTPUT
	IF @@ERROR <> 0
	BEGIN
		SET @o_errorStr = 'Failed to read questions from new XML'
		GOTO EXIT_PROC
	END
	-- Get old question xml from DB
	SELECT	@l_oldQuestionsXML = stringVal
	FROM	GRC_CommCellProp
	WHERE	CommCellId = @i_CommCellId
AND propId = 16
	IF ISNULL(CONVERT(nvarchar(max), @l_oldQuestionsXML), '') <> ''
	BEGIN
		--Populate temp tables with questions from existing XML
		EXEC CCMReadQuestionsXML @l_oldQuestionsXML, @CCNumber = @l_oldCCNumber OUTPUT, @CCName = @l_oldCCName OUTPUT, @CCGuid = @l_oldCCGuid OUTPUT
		IF @@ERROR <> 0
		BEGIN
			SET @o_errorStr = 'Failed to read questions from old XML'
			GOTO EXIT_PROC
		END
		IF(@l_oldCCGuid <> @l_newCCGuid)
		BEGIN
			SET @o_errorStr = 'Invalid Questions XML. XML in Database belongs to CommServe[' + @l_oldCCName + '] is different from passed in XML CommServe [' + @l_newCCName + ']'
			GOTO EXIT_PROC
		END
	END
	SET @l_newQuestionsXML =
	(
		--CommCell Info
		SELECT (
			SELECT 	@l_newCCNumber AS 'Number',
					@l_newCCName	  AS 'Name',
					@l_newCCGuid   AS 'GUID'
			FOR XML PATH('CommCell'),TYPE
		),
		--ClientName Questions
		(
			SELECT	OldClientName,
					OldClientHostName
			FROM #lt_ClientNameQuestions FOR XML PATH('Client'),TYPE
		),
		--IdxAccessPath Questions
		(
			SELECT	SourceSIDBID,
					SourceSIDBName,
					SourceAccessPathId,
					StoragePoliceName,
					CopyName,
					SourceAccessPathMediaAgentName,
					SourceAccessPath,
					IsGlobalStoreFlag
			FROM #lt_IdxAccessPathQuestions FOR XML PATH('AccessPath'),TYPE
		),
		--DataPath Questions
		(
			SELECT	SourceCopyId,
					StoragePoliceName,
					CopyName,
					SourceLibraryId,
					LibraryAliasName_MustInput,
					SourceHostId,
					DriveTypeId,
					DrivePoolId,
					Flag
			FROM #lt_DataPathQuestions FOR XML PATH('DataPath'),TYPE
		),
		--MountPath Questions
		(
			SELECT 	mountPathId as MountPathId,
					mountPathName as MountPathName,
					mountPathType as MountPathType,
					libraryId as LibraryId,
					libraryName as LibraryName,
					deviceId as DeviceId,
					deviceName as DeviceName,
					(
						SELECT temp.*
						FROM
						(
							SELECT 0 as Id, '' as Path, '' as UserName, '' as UserPassword
							WHERE NOT EXISTS(SELECT 1 FROM #lt_DevicePathQuestions WHERE deviceId = mpq.deviceId)
							UNION ALL
							SELECT Id, Path, UserName, UserPassword
							FROM #lt_DevicePathQuestions WHERE deviceId = mpq.deviceId
						) as temp
						FOR XML PATH ('DeviceControllerPath'),TYPE
					)
			FROM #lt_MountPathLibQuestions mpq FOR XML PATH ('MountPathQuestion'),TYPE
		)
		FOR XML PATH('CommserveData')
	)
	-- Insert or Update new question xml in DB
IF EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE CommCellId = @i_CommCellId AND propId = 16)
	BEGIN
		UPDATE	GRC_CommCellProp
		SET		stringVal = CONVERT(nvarchar(max), @l_newQuestionsXML)
		WHERE	CommCellId = @i_CommCellId
AND propId = 16
	END
	ELSE
	BEGIN
		INSERT INTO	GRC_CommCellProp
SELECT @i_CommCellId, 16, 1 /*PROPERTY_STRING*/, 0, 0, CONVERT(nvarchar(max), @l_newQuestionsXML), dbo.GetUnixTime(GetUtcdate()), 0
	END
	IF @@ERROR <> 0
	BEGIN
		SET @o_errorStr = 'Failed to insert or update questions xml in DataBase'
		GOTO EXIT_PROC
	END
	SELECT 0, ''
	RETURN 0
EXIT_PROC:
	RAISERROR (@o_errorStr , 16, 1)
	SELECT -1, @o_errorStr
	RETURN -1
END
GO

IF EXISTS (select * from GxQscripts where name = 'CCMSetQuestionsXML')
	delete from GxQscripts where name = 'CCMSetQuestionsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMSetQuestionsXML')
	delete from GXDBVersions where aliasname = 'CCMSetQuestionsXML'
GO

insert into GXDBVersions values(2, 'CCMSetQuestionsXML',  '00010003005800020000', 'CCMSetQuestionsXML', '00010003005800020000')
GO

