

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMSetLibrariesAccessible.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCMSetLibrariesAccessible.sp,v $ $Id: CCMSetLibrariesAccessible.sp,v 1.13.40.6 2018/06/26 05:46:41 aselvanayagam Exp $";
-- =============================================
-- Author:		Prasad Nara
-- Create date: 09/27/2012
-- Description:	Creates LibraryController, DrivePool and DeviceController for the migrated libraries
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMSetLibrariesAccessible <<<'

IF EXISTS (select * from sysobjects where name='CCMSetLibrariesAccessible')
	drop procedure CCMSetLibrariesAccessible
IF EXISTS (select * from GxQscripts where name='CCMSetLibrariesAccessible')
	delete from GxQscripts where name = 'CCMSetLibrariesAccessible'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMSetLibrariesAccessible')
	delete from GXDBVersions where aliasname = 'CCMSetLibrariesAccessible'
GO
print '... Creating Procedure: CCMSetLibrariesAccessible'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMSetLibrariesAccessible
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @mediaAgentId integer = 0,
  @reserveParam integer = 0
AS
  DECLARE @errorCode INTEGER
  DECLARE @errStr varchar(4000)
SET XACT_ABORT ON
SET NOCOUNT ON
BEGIN TRY
-- Do not use transaction here, because the caller will call this stored procedure with transaction
--BEGIN TRANSACTION TRAN_Library_Accesible
	----------------------------------------------------------------
	--Set the Migrated MA for the migrated libraries in answers tables
	--We set the migrated MA new id in CCMMountPathAnswers table SourceMediaAgentId column
	--Using this we can identify which libraries to map
	IF @mediaAgentId > 1
	BEGIN
		UPDATE CCMLibraryAnswers
		SET TargetMediaAgentId = @mediaAgentId,
flags = flags | 1
		FROM CCMLibraryAnswers a
			INNER JOIN CCMMountPathAnswers b ON a.TargetLibraryId = b.TargetLibraryId
			INNER JOIN MMLibrary c ON a.TargetLibraryId = c.LibraryId
		WHERE  c.LibraryTypeId = 3 --Magnetic
			AND a.allowEdit = 1
			AND a.TargetMediaAgentId IN (0,1)
			AND b.SourceMediaAgentId = @mediaAgentId
		IF	@@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- CCMLibraryAnswers -- TargetMediaAgentId'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCMMountPathAnswers
		SET TargetDeviceMediaAgentId = b.TargetMediaAgentId
		FROM CCMMountPathAnswers a
			INNER JOIN CCMLibraryAnswers b ON a.TargetLibraryId = b.TargetLibraryId
WHERE (b.flags & 1) > 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- CCMMountPathAnswers -- TargetMediaAgentId'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCMDevicePathAnswers
		SET TargetMediaAgentId = c.TargetMediaAgentId
		FROM CCMDevicePathAnswers a
			INNER JOIN CCMMountPathAnswers b ON a.SourceDeviceId = b.SourceDeviceId AND a.SourceCommCellGUID = b.SourceCommCellGUID
			INNER JOIN CCMLibraryAnswers c ON b.TargetLibraryId = c.TargetLibraryId
WHERE (c.flags & 1) > 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- CCMDevicePathAnswers -- TargetMediaAgentId'
			GOTO CX_ERROR_EXIT
		END
	END
	----------------------------------------------------------------
	--Create LibraryController and DrivePool
	DECLARE @GRCLibrary_new_LibraryId				integer
	DECLARE @GRCLibrary_new_MediaAgentId			integer
	DECLARE @GRCLibrary_new_MediaAgentName			varchar(512)
	DECLARE @GRCLibrary_new_MasterPoolId			integer
	DECLARE @GRCLibrary_new_DrivePoolId				integer
	DECLARE @GRCLibrary_new_LibraryControllerId		integer
	DECLARE CCM_GRCLibraryCursor Cursor LOCAL For
	SELECT	b.LibraryId, a.TargetMediaAgentId, c.MasterPoolId
	FROM CCMLibraryAnswers a
		INNER JOIN MMLibrary b ON a.TargetLibraryId = b.LibraryId
		INNER JOIN MMMasterPool c ON b.LibraryId = c.LibraryId
		LEFT OUTER JOIN MMDrivePool d ON c.MasterPoolId = d.MasterPoolId
	WHERE a.TargetMediaAgentId > 1 AND d.DrivePoolId IS NULL
	OPEN CCM_GRCLibraryCursor
	FETCH NEXT FROM CCM_GRCLibraryCursor
	INTO @GRCLibrary_new_LibraryId, @GRCLibrary_new_MediaAgentId, @GRCLibrary_new_MasterPoolId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		--Mark library as online when it is attached to a MA
		UPDATE MMLibrary
SET LibraryStatusReason = 46003,
			LibrarySoftState = 1,
			LibraryEnabled = 1
		WHERE LibraryId = @GRCLibrary_new_LibraryId
--AND LibraryStatusReason = 46011
			  AND LibrarySoftState = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- MMLibrary -- Status'
			GOTO CX_ERROR_EXIT
		END
		--Merge MMDrivePool
		SELECT @GRCLibrary_new_MediaAgentName = name
		FROM App_Client
		WHERE id = @GRCLibrary_new_MediaAgentId
		INSERT INTO MMDrivePool
		VALUES ('DrivePool('+@GRCLibrary_new_MediaAgentName+')', 1, 1,
				0, 10001, -1, '', 0, 1, '',
				@GRCLibrary_new_MediaAgentId, @GRCLibrary_new_MasterPoolId,
				0, -1, 0, 2, 0)
		IF	@@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- MMDrivePool -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		SELECT @GRCLibrary_new_DrivePoolId = SCOPE_IDENTITY()
		--Update DrivePoolName
		UPDATE MMDrivePool
		SET DrivePoolName = DrivePoolName + CONVERT(varchar, @GRCLibrary_new_DrivePoolId)
		WHERE DrivePoolId = @GRCLibrary_new_DrivePoolId
		IF	@@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- MMDrivePool -- UPDATE Name'
			GOTO CX_ERROR_EXIT
		END
		--Merge MMLibraryController
		INSERT INTO MMLibraryController
		SELECT 	'LmsLibrary'+ convert(varchar, @GRCLibrary_new_LibraryId) + '_',
				@GRCLibrary_new_MediaAgentId, 1, 1, 4,
				1, @GRCLibrary_new_LibraryId, 0, 'MAGNETIC'
		IF	@@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- MMLibraryController -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		SELECT @GRCLibrary_new_LibraryControllerId = SCOPE_IDENTITY()
		--Update LibrarController Name
		UPDATE MMLibraryController
		SET LibraryControllerName = LibraryControllerName + CONVERT(varchar, @GRCLibrary_new_LibraryControllerId)
		WHERE LibraryControllerId = @GRCLibrary_new_LibraryControllerId
		IF	@@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- MMLibraryController -- UPDATE Name'
			GOTO CX_ERROR_EXIT
		END
		-- Now that the answer has been used to create a Library
		-- do not allow the edit of the answer from GUI
		-- Do this for only Libraries attached to a MA at Destination
		UPDATE CommServ..CCMLibraryAnswers
		SET allowEdit = 0
		WHERE TargetLibraryId = @GRCLibrary_new_LibraryId
		IF	@@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- CCMLibraryAnswers -- UPDATE -- allowEdit'
			GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM CCM_GRCLibraryCursor
		INTO @GRCLibrary_new_LibraryId, @GRCLibrary_new_MediaAgentId, @GRCLibrary_new_MasterPoolId
	END
	CLOSE CCM_GRCLibraryCursor
	DEALLOCATE CCM_GRCLibraryCursor
	--Create DeviceController
	DECLARE @MMDevice_DeviceId INTEGER
	DECLARE @MMDevice_newDeviceId INTEGER
	DECLARE @MMDevice_newOrigCCId INTEGER
	DECLARE	@MMDevice_sourceCommCellGUID nvarchar(40)
	DECLARE @MMDevice_newMediaAgentId INTEGER
	DECLARE @MMDevice_newDevicePath varchar(1024)
	DECLARE @MMDevice_newuserName varchar(1024)
	DECLARE @MMDevice_newPassword varchar(2048)
	DECLARE @MMDevice_newDeviceAccess INTEGER
	DECLARE CCM_MMDevicePathCursor Cursor LOCAL For
	SELECT 	DISTINCT e.sourceDeviceId, c.DeviceId, e.sourceCommCellGUID, a.origCCCommCellId, b.TargetMediaAgentId,
			case when e.MountPathType = 0 then e.TargetMountPathName else f.TargetDevicePath end,
			case when e.MountPathType = 0 then e.TargetMountPathUserName else f.TargetDevicePathUserName end,
			case when e.MountPathType = 0 then e.TargetMountPathPassword else f.TargetDevicePathPassword end
	FROM MMMountPath a
		INNER JOIN CCMLibraryAnswers b ON a.LibraryId = b.TargetLibraryId
		INNER JOIN CCMMountPathAnswers e ON b.TargetLibraryId = e.TargetLibraryId AND a.MountPathName = e.TargetMountPathName AND a.MountPathId = e.TargetMountPathId
		INNER JOIN MMMountPathToStorageDevice c ON a.MountPathId = c.MountPathId
		LEFT OUTER JOIN CCMDevicePathAnswers f ON e.SourceDeviceId = f.SourceDeviceId AND e.SourceCommCellGUID = f.SourceCommCellGUID
		LEFT OUTER JOIN MMDeviceController d ON c.DeviceId = d.DeviceId
	WHERE b.TargetMediaAgentId > 1 AND d.DeviceControllerId IS NULL
	OPEN CCM_MMDevicePathCursor
	FETCH NEXT FROM CCM_MMDevicePathCursor
	INTO @MMDevice_DeviceId, @MMDevice_newDeviceId, @MMDevice_sourceCommCellGUID, @MMDevice_newOrigCCId,
	@MMDevice_newMediaAgentId, @MMDevice_newDevicePath, @MMDevice_newUserName, @MMDevice_newPassword
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- Set the device as readonly and a special flag for identifying migrated device for CCM and GRC
		IF @MMDevice_newOrigCCId = 2
SET @MMDevice_newDeviceAccess = 6
		ELSE
SET	@MMDevice_newDeviceAccess = (4 | 64)
		--Add DeviceController for Devices migrated without DeviceController in previous import
		INSERT INTO MMDeviceController
		VALUES (@MMDevice_newMediaAgentId, @MMDevice_newDeviceId, 0, 1, 0, 0,
		@MMDevice_newUserName, @MMDevice_newPassword, @MMDevice_newDevicePath, 0, 1, 0, 0, 0,
		@MMDevice_newDeviceAccess, 0, 0, 0)
		IF @@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- MMDeviceController -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		-- Now that the answer has been used to create a mountpath
		-- do not allow the edit of the answer from GuI
		UPDATE CommServ..CCMMountPathAnswers
SET allowEdit = (allowEdit & (~1))
		WHERE SourceDeviceId = @MMDevice_Deviceid
		AND SourceCommCellGUID = @MMDevice_sourceCommcellGUID
		IF	@@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- CCMMountPathAnswers -- UPDATE -- allowEdit'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CommServ..CCMDevicePathAnswers
		SET allowEdit = 0
		WHERE SourceDeviceId = @MMDevice_Deviceid
		AND SourceCommCellGUID = @MMDevice_sourceCommcellGUID
		IF @@ERROR > 0
		BEGIN
			SET @errorCode = 1
			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- CCMDevicePathAnswers -- UPDATE allowEdit'
			GOTO CX_ERROR_EXIT
		END
		-- If Magnetic library license is not consumed on MA then insert entry in CCMClientLicenses
		-- We will consume licenses for the entires in CCMClientLicenses
		IF NOT EXISTS
		(
			SELECT 1 FROM LicUsage
			WHERE CId = @MMDevice_newMediaAgentId
AND AppType = 1020
AND LicType = 84
				AND OpType 	= 'Install'
		)
		IF NOT EXISTS
		(
			SELECT 1 FROM Commserv..CCMClientLicenses
			WHERE new_clientId = @MMDevice_newMediaAgentId
AND AppType = 1020
AND simLicAppType = 84
		)
		BEGIN
			INSERT INTO Commserv..CCMClientLicenses
VALUES(0, @MMDevice_newMediaAgentId, 1020, 0,
84, '', 0, '', '')
			IF @@ERROR > 0
			BEGIN
				SET @errorCode = 1
				SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- CCMClientLicenses -- INSERT'
				GOTO CX_ERROR_EXIT
			END
		END
		FETCH NEXT FROM CCM_MMDevicePathCursor
		INTO @MMDevice_DeviceId, @MMDevice_newDeviceId, @MMDevice_sourceCommCellGUID, @MMDevice_newOrigCCId,
		@MMDevice_newMediaAgentId, @MMDevice_newDevicePath, @MMDevice_newUserName, @MMDevice_newPassword
	END
	CLOSE CCM_MMDevicePathCursor
	DEALLOCATE CCM_MMDevicePathCursor
	----------------------------------------------------------------
	----Check any migrated copies have no data path.
	----If fall back data path is available then add it to the copies
	--DECLARE @Fallback_MediaAgentId  INTEGER
	--DECLARE @Fallback_LibraryId		INTEGER
	--DECLARE @Fallback_DrivePoolId 	INTEGER
	--DECLARE @Fallback_SpareGroupId	INTEGER
	--DECLARE @Fallback_DataPathFlag	INTEGER
	--SET @Fallback_MediaAgentId = isnull((select top 1 id from APP_Client where name = CAST((select value from GXGlobalParam where name = 'DefaultCCMFallBackMediaAgent') as nvarchar(100))),0)
	--SET @Fallback_DrivePoolId  = isnull((select top 1 DrivePoolId from MMDrivePool where DrivePoolName = CAST((select value from GXGlobalParam where name = 'DefaultCCMFallBackDrivePool') as nvarchar(100))),0)
	--SET @Fallback_LibraryId    = isnull((select top 1 LibraryId from MMMasterPool where masterPoolId = (select MasterPoolId from MMDrivePool where DrivePoolId = @Fallback_DrivePoolId)),0)
	--SET @Fallback_SpareGroupId = isnull((select top 1 SpareGroupId from MMSpareGroup where SpareGroupName = CAST((select value from GXGlobalParam where name = 'DefaultCCMFallBackSpareGroup') as nvarchar(100))
	--								AND LibraryId = @Fallback_LibraryId),0)
	--SET @Fallback_DataPathFlag = (MMS2_DEFAULT_FAILOVER | MMS2_ACTIVE_FAILOVER | MMS2_ENABLED_FAILOVER | MMS2_SKIP_INSERTS_BY_DATAPATH_TRIGGER)
	--DECLARE @lt_CopiesNeedDataPath TABLE (copyId integer, SIDBStoreId integer, dedupeFlags integer, flags integer)
	--INSERT INTO @lt_CopiesNeedDataPath
	--SELECT DISTINCT a.id, a.SIDBStoreId, a.dedupeFlags, a.flags
	--FROM ArchGroupCopy a
	--	LEFT OUTER JOIN MMDataPath b ON a.Id = b.copyId
	--WHERE b.dataPathId IS NULL AND a.origCCCommcellId > 2
	--IF(@Fallback_MediaAgentId > 1 AND @Fallback_LibraryId > 0
	--	AND EXISTS (SELECT 1 FROM @lt_CopiesNeedDataPath))
	--BEGIN
	--	IF @Fallback_SpareGroupId = 0
	--	BEGIN
	--		SET @Fallback_SpareGroupId = ISNULL((SELECT TOP 1 SpareGroupId
	--										FROM MMSpareGroup
	--										WHERE LibraryId = @Fallback_LibraryId AND SpareGroupType = 2
	--									 ), 0)
	--	END
	--	IF @Fallback_DrivePoolId = 0
	--	BEGIN
	--		SET @Fallback_DrivePoolId = ISNULL((SELECT TOP 1 a.DrivePoolId
	--										FROM MMDrivePool a INNER JOIN MMMasterPool b ON a.MasterPoolId = b.MasterPoolId
	--										WHERE b.LibraryId = @Fallback_LibraryId AND a.clientId = @Fallback_MediaAgentId
	--									), 0)
	--	END
	--	INSERT INTO MMDataPath (CopyId, DrivePoolId, HostClientId, Flag, SpareGroupId,
	--		ReadinessFlag, Priority, IsHardwareCompressed, ChunkSizeMB, FlushBlockSizeKB, UseHardwareEncryption)
	--	SELECT copyId, @Fallback_DrivePoolId, @Fallback_MediaAgentId,
	--		@Fallback_DataPathFlag,
	--		@Fallback_SpareGroupId, 0, 0, 0, 0, 0, 0
	--	FROM @lt_CopiesNeedDataPath
	--	WHERE (dedupeFlags & CVA_USE_GLOBAL_DEDUP_STORE_FLAG) = 0
	--	IF	@@ERROR > 0
	--	BEGIN
	--		SET @errorCode = 1
	--		SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- MMDatapath -- INSERT'
	--		GOTO CX_ERROR_EXIT
	--	END
	--	--Add data paths to the copies using gdsp
	--	IF EXISTS(SELECT 1 FROM @lt_CopiesNeedDataPath WHERE (dedupeFlags & CVA_USE_GLOBAL_DEDUP_STORE_FLAG) > 0)
	--	BEGIN
	--		--Update the flag of existing data paths
	--		UPDATE MMDataPath
	--		SET flag = e.flag
	--		FROM
	--			(
	--				SELECT a.copyId, c.DrivePoolId, c.HostClientId, c.flag, c.SpareGroupId
	--				FROM @lt_CopiesNeedDataPath a
	--					INNER JOIN archGroupCopy b ON a.SIDBStoreId = b.SIDBStoreId
	--					INNER JOIN MMDataPath c ON b.Id = c.copyId
	--				WHERE (a.dedupeFlags & CVA_USE_GLOBAL_DEDUP_STORE_FLAG) > 0
	--					AND (b.dedupeFlags & CVA_HOST_GLOBAL_DEDUP_STORE_FLAG) > 0
	--			) AS e
	--			INNER JOIN MMDataPath d ON e.copyId = d.copyId AND e.DrivePoolId = d.DrivePoolId
	--				AND e.HostClientId = d.HostClientId AND e.SpareGroupId = d.SpareGroupId
	--		IF	@@ERROR > 0
	--		BEGIN
	--			SET @errorCode = 1
	--			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- MMDatapath -- UPDATE - copies using GDSP'
	--			GOTO CX_ERROR_EXIT
	--		END
	--		INSERT INTO MMDataPath
	--		SELECT DISTINCT a.copyId, c.DrivePoolId, c.HostClientId, (c.flag | MMS2_SKIP_INSERTS_BY_DATAPATH_TRIGGER),
	--			c.SpareGroupId, 0, 0, 0, 0, 0, 0
	--		FROM @lt_CopiesNeedDataPath a
	--			INNER JOIN archGroupCopy b ON a.SIDBStoreId = b.SIDBStoreId
	--			INNER JOIN MMDataPath c ON b.Id = c.copyId
	--			LEFT OUTER JOIN MMDataPath d ON a.copyId = d.copyId AND c.DrivePoolId = d.DrivePoolId
	--				AND c.HostClientId = d.HostClientId AND c.SpareGroupId = d.SpareGroupId
	--		WHERE (a.dedupeFlags & CVA_USE_GLOBAL_DEDUP_STORE_FLAG) > 0
	--			AND (b.dedupeFlags & CVA_HOST_GLOBAL_DEDUP_STORE_FLAG) > 0
	--			AND d.DataPathId IS NULL
	--		IF	@@ERROR > 0
	--		BEGIN
	--			SET @errorCode = 1
	--			SET @errStr = 'ERROR: CCMSetLibrariesAccessible -- MMDatapath -- INSERT - copies using GDSP'
	--			GOTO CX_ERROR_EXIT
	--		END
	--	END
	--	--Set the drivePool for MediaGroup
	--	UPDATE MMMediaGroup
	--	SET DrivePoolId = d.DrivePoolId,
	--		SpareGroupId = d.SpareGroupId,
	--		DataPathId = d.DataPathId
	--	FROM MMMediaGroup a
	--		INNER JOIN archStream b ON a.MediaGroupId = b.MediaGroupId
	--		INNER JOIN @lt_CopiesNeedDataPath c ON b.archGroupCopyId = c.copyId
	--		INNER JOIN MMDataPath d ON c.copyId = d.copyId
	--END
	----------------------------------------------------------------
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@ERROR
	SET @errStr = (SELECT ERROR_MESSAGE())
	goto CX_ERROR_EXIT
END CATCH
CX_ERROR_EXIT:
	IF @errorCode <> 0
	BEGIN
		--ROLLBACK TRANSACTION TRAN_Library_Accesible
		RAISERROR ('%s' , 16, 1, @errStr)
		SELECT	-1, @errStr
		RETURN (-1)
	END
	ELSE
	BEGIN
		--COMMIT	TRANSACTION TRAN_Library_Accesible
		SET @errStr = 'NO_ERROR'
		SELECT	0, @errStr
		RETURN
	END
GO

IF EXISTS (select * from GxQscripts where name = 'CCMSetLibrariesAccessible')
	delete from GxQscripts where name = 'CCMSetLibrariesAccessible'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMSetLibrariesAccessible')
	delete from GXDBVersions where aliasname = 'CCMSetLibrariesAccessible'
GO

insert into GXDBVersions values(2, 'CCMSetLibrariesAccessible',  '00010013004000060000', 'CCMSetLibrariesAccessible', '00010013004000060000')
GO

