

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMSetAnswersXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMSetAnswersXML <<<'

IF EXISTS (select * from sysobjects where name='CCMSetAnswersXML')
	drop procedure CCMSetAnswersXML
IF EXISTS (select * from GxQscripts where name='CCMSetAnswersXML')
	delete from GxQscripts where name = 'CCMSetAnswersXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMSetAnswersXML')
	delete from GXDBVersions where aliasname = 'CCMSetAnswersXML'
GO
print '... Creating Procedure: CCMSetAnswersXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMSetAnswersXML
  @i_answerxml XML
AS
  DECLARE @errorCode int 
  DECLARE @errorString varchar(4000)
SET NOCOUNT ON
SET @errorCode = 0
SET @errorString = 'ERROR: GENERAL ERROR!'
BEGIN TRY
DECLARE	@l_CCMMediatype	TABLE
			(
				MediaTypeId		INT,
				MediaTypeName		VARCHAR(100),
				LibraryName		VARCHAR(100),
				LibraryId		INT,
				MediaAgent		VARCHAR(100),
				DrivePool		VARCHAR(100),
				SpareGroup		VARCHAR(100)
			)
DECLARE @l_DevicePathQestions	TABLE
			(
				sourceDeviceId			INT,
				sourceDeviceName		VARCHAR(100),
				sourceDevicePath		VARCHAR(100),
				targetMediaAgentId		INT,
				targetMediaAgent		VARCHAR(100),
				targetDevicePath		VARCHAR(100),
				targetUserName			VARCHAR(100),
				targetPassword			VARCHAR(100),
				isAnswerExists			INT,
				reservedId				INT,
				reservedString			VARCHAR(100),
				allowEdit				INT
			)
DECLARE @mediaTypeXML XML
DECLARE @commCellNumber	BIGINT
DECLARE @commCellName	VARCHAR(100)
DECLARE	@commCellGuid	VARCHAR(256)
SELECT @commCellNumber = PARAM.value('@commCellNumber','BIGINT'),
		@commCellName = PARAM.value('@commCellName','VARCHAR(100)'),
		@commCellGuid  = PARAM.value('@commcellGUID', 'VARCHAR(256)')
FROM @i_answerxml.nodes('/EVGui_CCMSetAnswersReq/commCell') AS messageXML(param)
if(@commCellNumber = 4294967295 )
BEGIN
	SET @commCellNumber = -1
END
	DECLARE @libraryMountPathAnswers table(id int identity(1,1), sourceMountPathId integer, sourceMountPathName varchar(1024), mountPathType integer,
	sourceDeviceId integer, sourceDeviceName varchar(1024),
	sourceLibraryId integer, sourceLibraryName varchar(1024),
	targetLibraryId integer, targetLibraryName varchar(1024),
	targetMAId integer, targetMAName varchar(1024),
	targetDeviceAccessPath varchar(1024),targetDevicePathUserName varchar(1024),
	targetDevicePathUserPassword varchar(1024)
	)
	INSERT INTO @libraryMountPathAnswers
	SELECT distinct ISNULL ((PARAM.value('mountPath[1]/@mountPathId','INTEGER')),0),
			ISNULL ((PARAM.value('mountPath[1]/@mountPathName','VARCHAR(1024)')),''),
			ISNULL ((PARAM.value('@mountPathType','INTEGER')),0),
			ISNULL ((PARAM.value('device[1]/@id','INTEGER')),0),
		   ISNULL ((PARAM.value('device[1]/@name','VARCHAR(1024)')),''),
			ISNULL ((PARAM.value('sourceLibrary[1]/@libraryId','INTEGER')),0),
		   ISNULL ((PARAM.value('sourceLibrary[1]/@libraryName','VARCHAR(1024)')),''),
		   ISNULL ((PARAM.value('targetLibrary[1]/@libraryId','INTEGER')),0),
		   ISNULL ((PARAM.value('targetLibrary[1]/@libraryName','VARCHAR(1024)')),''),
		   ISNULL ((PARAM.value('targetMediaAgent[1]/@mediaAgentId','INTEGER')),1),
		   ISNULL ((PARAM.value('targetMediaAgent[1]/@mediaAgentName','VARCHAR(1024)')),''),
		   ISNULL ((PARAM.value('accessPathList[1]/@accessPath','VARCHAR(1024)')),''),
		   ISNULL ((PARAM.value('accessPathList[1]/accessPathCredentials[1]/@userName','VARCHAR(1024)')),''),
		   ISNULL ((PARAM.value('accessPathList[1]/accessPathCredentials[1]/@password','VARCHAR(1024)')),'')
	FROM @i_answerxml.nodes('/EVGui_CCMSetAnswersReq/libraryAnswers') AS messageXML(param)
	DECLARE @deviceId int
	DECLARE @password varchar(1024)
	DECLARE @decodedPassword varchar(1024)
	DECLARE PasswordEncodeCursor CURSOR LOCAL FORWARD_ONLY FOR
	SELECT 	a.sourceDeviceId, a.targetDevicePathUserPassword
	FROM	@libraryMountPathAnswers a,
			(SELECT sourceDeviceId, MIN(id) as id FROM @libraryMountPathAnswers GROUP BY sourceDeviceId) b
	WHERE	a.id = b.id AND ISNULL(a.targetDevicePathUserPassword, '') <> ''
	OPEN PasswordEncodeCursor
	FETCH FROM PasswordEncodeCursor INTO @deviceId, @password
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF((CHARINDEX('|#',@password, 1)) >0 )
		BEGIN
			SELECT @decodedPassword = dbo.DecodeInvalidXMLChar( @password )
			SET @decodedPassword = SUBSTRING(@decodedPassword,2,LEN(@decodedPassword))
		END
		ELSE
			SET @decodedPassword=@password
		SET  @decodedPassword = dbo.base64decode(@decodedPassword)
		UPDATE @libraryMountPathAnswers
		SET	targetDevicePathUserPassword = @decodedPassword
		WHERE sourceDeviceId = @deviceId
		FETCH NEXT FROM PasswordEncodeCursor INTO @deviceId, @password
	END
	CLOSE PasswordEncodeCursor
	DEALLOCATE PasswordEncodeCursor
	UPDATE CCMMountPathAnswers
	SET TargetLibraryId = b.targetLibraryId, TargetMountPathName = b.SourceMountPathName,
	TargetMountPathUserName = b.targetDevicePathUserName, TargetMountPathPassword = CASE WHEN b.targetDevicePathUserPassword <> '' THEN b.targetDevicePathUserPassword ELSE TargetMountPathPassword END,
	TargetDeviceMediaAgentId = b.targetMAId
	FROM CCMMountPathAnswers a inner join @libraryMountPathAnswers b
ON a.SourceCommCellGUID = @commCellGuid AND a.SourceMountPathId = b.sourceMountPathId AND (a.allowEdit & 1) > 0
	INSERT INTO CCMMountPathAnswers
	SELECT distinct @commCellNumber, @commCellGuid, @commCellName, 1, 'N/A', b.sourceMountPathId, b.SourceMountPathName,
	b.targetLibraryId, b.SourceMountPathName, b.targetDevicePathUserName, b.targetDevicePathUserPassword, 1,
	b.mountPathType, b.targetMAId, b.sourceDeviceId, b.sourceDeviceName, 0
	FROM @libraryMountPathAnswers b left outer join CCMMountPathAnswers a
	ON a.sourceCommCellGUID = @commCellGuid AND a.SourceMountPathId = b.sourceMountPathId
	where a.sourceMountPathId is null
	UPDATE CCMDevicePathAnswers
	SET TargetMediaAgentId = b.targetMAId, TargetDevicePath = b.targetDeviceAccessPath, TargetDevicePathUserName = b.targetDevicePathUserName,
	TargetDevicePathPassword = CASE WHEN b.targetDevicePathUserPassword <> '' THEN b.targetDevicePathUserPassword ELSE TargetDevicePathPassword END
	FROM CCMDevicePathAnswers a
		inner join @libraryMountPathAnswers b ON a.SourceDeviceId = b.sourceDeviceId AND a.SourceCommCellGUID = @commCellGuid AND allowEdit = 1	 AND b.sourceDeviceId > 0
		inner join (SELECT sourceDeviceId, MIN(id) as id FROM @libraryMountPathAnswers GROUP BY sourceDeviceId) c ON b.id = c.id
	INSERT INTO CCMDevicePathAnswers
	SELECT distinct @commCellNumber, @commCellGuid, @commCellName, b.sourceDeviceId, b.sourceDeviceName, b.targetDeviceAccessPath, b.targetMAId, b.targetDeviceAccessPath,
	b.targetDevicePathUserName, b.targetDevicePathUserPassword, 1 ,0
	FROM  (SELECT sourceDeviceId, max(sourceDeviceName) as sourceDeviceName, max(targetDeviceAccessPath) as targetDeviceAccessPath,
	max(targetMAId) as targetMAId, max(targetDevicePathUserName) as targetDevicePathUserName,
	max(targetDevicePathUserPassword)	as targetDevicePathUserPassword
	  FROM @libraryMountPathAnswers where sourceDeviceId > 0 group by sourceDeviceId) b
	left outer join CCMDevicePathAnswers a
	ON a.sourceCommCellGUID = @commCellGuid AND	a.SourceDeviceId = b.sourceDeviceId
	where a.sourceDeviceId is null
	UPDATE CCMLibraryAnswers
	SET targetMediaAgentId = b.targetMAId, targetLibraryId = b.targetLibraryId, targetLibraryName = b.targetLibraryName, answerGiven = 1
	FROM CCMLibraryAnswers a inner join
	(SELECT sourceLibraryId, MAX(targetMAId) as targetMAId, MAX(targetLibraryId) as targetLibraryId,
	MAX(targetLibraryName) "targetLibraryName" FROM @libraryMountPathAnswers group by sourceLibraryId) b
	ON a.sourceCommCellGUID = @commCellGuid AND a.sourceLibraryId = b.sourceLibraryId AND allowEdit = 1
	INSERT INTO CCMLibraryAnswers
	SELECT distinct @commCellNumber, @commCellGuid, @commCellName, b.sourceLibraryId, b.sourceLibraryName, b.targetMAId, b.targetLibraryId, b.targetLibraryName, 1, 1, 0
	FROM
	(SELECT sourceLibraryId, MAX(sourceLibraryName) as sourceLibraryName, MAX(targetMAId) as targetMAId, MAX(targetLibraryId) as targetLibraryId,
	MAX(targetLibraryName) as targetLibraryName
	 FROM @libraryMountPathAnswers group by sourceLibraryId )b
	left outer join CCMLibraryAnswers a
	ON a.sourceCommCellGUID = @commCellGuid AND a.sourceLibraryId = b.sourceLibraryId
	WHERE a.sourceLibraryId is null
DECLARE @SidbAnswerTab	TABLE
		(
			SourceMediaAgentName	VARCHAR(100),
			SourceIdxAccessPathId	INT,
			SourcePathName			VARCHAR(100),
			TargetMediaAgent		VARCHAR(100),
			TargetMediaAgentId		INT,
			TargetPathName			VARCHAR(100),
			TargetUserName			VARCHAR(100),
			TargetPassword			VARCHAR(100),
			isAnswerExists			INT,
			isGlobal				INT
		)
INSERT	@SidbAnswerTab
	SELECT PARAM.value('@sourceMediaAgent','VARCHAR(1024)'),
			PARAM.value('@sourceAccessPathId','INT'),
			PARAM.value('@sourceAccessPath','VARCHAR(1024)'),
			ISNULL(PARAM.value('@targetMediaAgent'	,'VARCHAR(1024)'),''),
			ISNULL(PARAM.value('@targetMediaAgentId','INT'),0),
    		ISNULL(PARAM.value('@targetPath','VARCHAR(1024)'),''),
			ISNULL(PARAM.value('@targetUserName','VARCHAR(1024)'),''),
			ISNULL(PARAM.value('@targetPasword','VARCHAR(1024)'),''),
			ISNULL(PARAM.value('@isAnswerExists','INT'),0),
			PARAM.value('@isGlobal','INT')
FROM	@i_answerxml.nodes('/EVGui_CCMSetAnswersReq/sidbAnswers') AS QuestionXML(PARAM)
 UPDATE @SidbAnswerTab
	SET SAT.TargetMediaAgentId = APCL.id
FROM @SidbAnswerTab SAT INNER JOIN APP_Client APCL ON APCL.name = SAT.TargetMediaAgent AND (SAT.TargetMediaAgentId = 0 OR SAT.TargetMediaAgentId = 1)
INSERT CCMSIDBPathAnswers
(
	SourceCommCellId,
	SourceCommCellGUID,
	SourceCommCellName,
	SourceMediaAgentName,
	SourceIdxAccessPathId,
	SourcePathName,
	TargetMediaAgentId,
	TargetPathName,
	TargetUserName,
	TargetPasword,
	isGlobal
)
 SELECT DISTINCT @commCellNumber,@commCellGuid, @commCellName,
		SAT.SourceMediaAgentName,SAT.SourceIdxAccessPathId,
		SAT.SourcePathName,SAT.TargetMediaAgentId,
		SAT.TargetPathName,SAT.TargetUserName,SAT.TargetPassword,SAT.isGlobal
 FROM @SidbAnswerTab SAT WHERE SAT.isAnswerExists = 0
UPDATE CCMSIDBPathAnswers
	SET TargetMediaAgentId = SAT.TargetMediaAgentId,
		TargetPathName = SAT.TargetPathName,
		TargetUserName = SAT.TargetUserName,
		TargetPasword = SAT.TargetPassword
FROM @SidbAnswerTab SAT WHERE	SAT.isAnswerExists = 1
							AND CCMSIDBPathAnswers.SourceMediaAgentName = SAT.SourceMediaAgentName
							AND CCMSIDBPathAnswers.SourceCommCellGUID = @commCellGuid
							AND CCMSIDBPathAnswers.SourceCommCellName = @commCellName
							AND CCMSIDBPathAnswers.SourceIdxAccessPathId = SAT.SourceIdxAccessPathId
							AND CCMSIDBPathAnswers.SourcePathName = SAT.SourcePathName
DECLARE @ClientAnswerTab TABLE
			(
				oldClientName nvarchar(1024),
				oldClientHostName nvarchar(1024),
				newClientName nvarchar(1024),
				newClientHostName nvarchar(1024),
				isAnswerExists			INT
			)
INSERT @ClientAnswerTab
	SELECT PARAM.value('@oldClientName','VARCHAR(1024)'),
			PARAM.value('@oldClientHostName','VARCHAR(1024)'),
			ISNULL(PARAM.value('@newClientName','VARCHAR(1024)'),''),
			ISNULL(PARAM.value('@newClientHostName','VARCHAR(1024)'),''),
			ISNULL(PARAM.value('@isAnswerExists','INT'),'')
	FROM	@i_answerXML.nodes('/EVGui_CCMSetAnswersReq/clientAnswers') AS QuestionXML(PARAM)
INSERT CCMClientAnswers
(
	SourceCommCellId,
	SourceCommCellGUID,
	SourceCommCellName,
	OldClientName,
	OldClientHostName,
	NewClientName,
	NewClientHostName
)
	select @commCellNumber, @commCellGuid, @commCellName,CAT.oldClientName,
	CAT.oldClientHostName,CAT.newClientName,CAT.newClientHostName
	FROM @ClientAnswerTab CAT WHERE CAT.isAnswerExists = 0
UPDATE CCMClientAnswers
	SET NewClientName = CAT.newClientName,
		NewClientHostName = CAT.newClientHostName
FROM @ClientAnswerTab CAT WHERE CAT.isAnswerExists = 1
								AND CCMClientAnswers.SourceCommCellGUID = @commCellGuid
								AND CCMClientAnswers.OldClientName = CAT.oldClientName
								AND CCMClientAnswers.OldClientHostName = CAT.oldClientHostName
SET @errorString = 'NO_ERROR'
GOTO SCRIPT_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@ERROR
	SET @errorString = 'Failed to set answers. ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), 'UNKNOWN')
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @errorCode <> 0
	BEGIN
		RAISERROR ('%s' , 16, 1, @errorString)
		SELECT @errorCode, @errorString
		RETURN (-1)
	END
	ELSE
	BEGIN
		SELECT 0, @errorString
		RETURN
	END
GO

IF EXISTS (select * from GxQscripts where name = 'CCMSetAnswersXML')
	delete from GxQscripts where name = 'CCMSetAnswersXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMSetAnswersXML')
	delete from GXDBVersions where aliasname = 'CCMSetAnswersXML'
GO

insert into GXDBVersions values(2, 'CCMSetAnswersXML',  '00000000000000000000', 'CCMSetAnswersXML', '00000000000000000000')
GO

