

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMReadQuestionsXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Stored Precedure: Reads the questions from XML and populates in temp tables
--  +========================================================================+
-- $Id: CCMReadQuestionsXML.sp,v 1.4.40.1 2018/03/20 00:30:35 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMReadQuestionsXML <<<'

IF EXISTS (select * from sysobjects where name='CCMReadQuestionsXML')
	drop procedure CCMReadQuestionsXML
IF EXISTS (select * from GxQscripts where name='CCMReadQuestionsXML')
	delete from GxQscripts where name = 'CCMReadQuestionsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMReadQuestionsXML')
	delete from GXDBVersions where aliasname = 'CCMReadQuestionsXML'
GO
print '... Creating Procedure: CCMReadQuestionsXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMReadQuestionsXML
  @i_QuestionsXML XML,
  @CCNumber BIGINT 			OUTPUT,
  @CCName varchar(1024) 	OUTPUT,
  @CCGuid varchar(36) 	OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN
	/*
	 * Below tables are defined in caller of this stored procedure.
	 *
	IF OBJECT_ID('tempdb..#lt_ClientNameQuestions') IS NOT NULL DROP TABLE #lt_ClientNameQuestions
	CREATE TABLE #lt_ClientNameQuestions	(
												OldClientName 				VARCHAR(1024),
												OldClientHostName 			VARCHAR(1024)
											)
	IF OBJECT_ID('tempdb..#lt_IdxAccessPathQuestions') IS NOT NULL DROP TABLE #lt_IdxAccessPathQuestions
	CREATE TABLE #lt_IdxAccessPathQuestions	(
												SourceSIDBID						INT,
												SourceSIDBName						VARCHAR(1024),
												SourceAccessPathId					INT,
												StoragePoliceName					VARCHAR(1024),
												CopyName							VARCHAR(1024),
												SourceAccessPathMediaAgentName		VARCHAR(1024),
												SourceAccessPath					VARCHAR(1024),
												IsGlobalStoreFlag					INT
											)
	IF OBJECT_ID('tempdb..#lt_DataPathQuestions') IS NOT NULL DROP TABLE #lt_DataPathQuestions
	CREATE TABLE #lt_DataPathQuestions		(
												SourceCopyId						INT,
												StoragePoliceName					VARCHAR(1024),
												CopyName							VARCHAR(1024),
												SourceLibraryId						INT,
												LibraryAliasName_MustInput			VARCHAR(1024),
												SourceHostId						VARCHAR(1024),
												DriveTypeId							INT,
												DrivePoolId							INT,
												Flag								BIGINT
											)
	IF OBJECT_ID('tempdb..#lt_MountPathLibQuestions') IS NOT NULL DROP TABLE #lt_MountPathLibQuestions
	CREATE TABLE #lt_MountPathLibQuestions	(
												mountPathId int,
												mountPathName varchar(512),
												mountPathType int,
												libraryId int,
												libraryName nvarchar(128),
												deviceId int,
												deviceName nvarchar(128)
											)
	IF OBJECT_ID('tempdb..#lt_DevicePathQuestions') IS NOT NULL DROP TABLE #lt_DevicePathQuestions
	CREATE TABLE #lt_DevicePathQuestions	(
												DeviceId 			INT,
												Id 					INT,
												Path 				VARCHAR(1024),
												UserName 			VARCHAR(1024),
												UserPassword 		VARCHAR(2048)
											)
	*/
	SELECT  @CCNumber = ( CAST(REPLACE(REPLACE(REPLACE(col.value('Number[1]','varchar(1024)'),CHAR(10), ''),CHAR(13),''),CHAR(9),'') AS BIGINT) ),
			@CCName = ( REPLACE(REPLACE(REPLACE(col.value('Name[1]','varchar(1024)'),CHAR(10), ''),CHAR(13),''),CHAR(9),'') ),
			@CCGuid	=	(REPLACE(REPLACE(REPLACE(col.value('GUID[1]','varchar(1024)'),CHAR(10), ''),CHAR(13),''),CHAR(9),'') )
	FROM 	@i_QuestionsXML.nodes('/CommserveData/CommCell') paramXML(col)
	INSERT	INTO #lt_ClientNameQuestions
	SELECT	DISTINCT
			REPLACE(REPLACE(REPLACE(col.value('OldClientName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			REPLACE(REPLACE(REPLACE(col.value('OldClientHostName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'')
	FROM 	@i_QuestionsXML.nodes('/CommserveData/Client') paramXML(col)
	WHERE	NOT EXISTS(SELECT 1 FROM #lt_ClientNameQuestions WHERE OldClientName = REPLACE(REPLACE(REPLACE(col.value('OldClientName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''))
	INSERT	#lt_IdxAccessPathQuestions
	SELECT	DISTINCT
			CAST(REPLACE(REPLACE(REPLACE(col.value('SourceSIDBID[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			REPLACE(REPLACE(REPLACE(col.value('SourceSIDBName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			CAST(REPLACE(REPLACE(REPLACE(col.value('SourceAccessPathId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			REPLACE(REPLACE(REPLACE(col.value('StoragePoliceName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			REPLACE(REPLACE(REPLACE(col.value('CopyName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			REPLACE(REPLACE(REPLACE(col.value('SourceAccessPathMediaAgentName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			REPLACE(REPLACE(REPLACE(col.value('SourceAccessPath[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			CAST(REPLACE(REPLACE(REPLACE(col.value('IsGlobalStoreFlag[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT)
	FROM	@i_QuestionsXML.nodes('/CommserveData/AccessPath') paramXML(col)
	WHERE	NOT EXISTS(SELECT 1 FROM #lt_IdxAccessPathQuestions WHERE SourceAccessPathId = CAST(REPLACE(REPLACE(REPLACE(col.value('SourceAccessPathId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT))
	INSERT	INTO #lt_DataPathQuestions
	SELECT	DISTINCT
			CAST(REPLACE(REPLACE(REPLACE(col.value('SourceCopyId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			REPLACE(REPLACE(REPLACE(col.value('StoragePoliceName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			REPLACE(REPLACE(REPLACE(col.value('CopyName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			CAST(REPLACE(REPLACE(REPLACE(col.value('SourceLibraryId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			REPLACE(REPLACE(REPLACE(col.value('LibraryAliasName_MustInput[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			CAST(REPLACE(REPLACE(REPLACE(col.value('SourceHostId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			CAST(REPLACE(REPLACE(REPLACE(col.value('DriveTypeId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			CAST(REPLACE(REPLACE(REPLACE(col.value('DrivePoolId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			CAST(REPLACE(REPLACE(REPLACE(col.value('Flag[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT)
	FROM 	@i_QuestionsXML.nodes('/CommserveData/DataPath') AS paramXML(col)
	WHERE	NOT EXISTS(SELECT 1 FROM #lt_DataPathQuestions
						WHERE SourceCopyId = CAST(REPLACE(REPLACE(REPLACE(col.value('SourceCopyId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT)
						AND SourceLibraryId = CAST(REPLACE(REPLACE(REPLACE(col.value('SourceLibraryId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT)
						AND DrivePoolId = CAST(REPLACE(REPLACE(REPLACE(col.value('DrivePoolId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT))
	INSERT	INTO #lt_MountPathLibQuestions
	SELECT	DISTINCT
			CAST(REPLACE(REPLACE(REPLACE(col.value('MountPathId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			REPLACE(REPLACE(REPLACE(col.value('MountPathName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			CAST(REPLACE(REPLACE(REPLACE(col.value('MountPathType[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			CAST(REPLACE(REPLACE(REPLACE(col.value('LibraryId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			REPLACE(REPLACE(REPLACE(col.value('LibraryName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			CAST(REPLACE(REPLACE(REPLACE(col.value('DeviceId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			REPLACE(REPLACE(REPLACE(col.value('DeviceName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'')
	FROM 	@i_QuestionsXML.nodes('/CommserveData/MountPathQuestion') AS paramXML(col)
	WHERE	NOT EXISTS(SELECT 1 FROM #lt_MountPathLibQuestions WHERE mountPathId = CAST(REPLACE(REPLACE(REPLACE(col.value('MountPathId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT))
	INSERT	INTO #lt_DevicePathQuestions
	SELECT	DISTINCT
			CAST(REPLACE(REPLACE(REPLACE(col.value('../DeviceId[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			CAST(REPLACE(REPLACE(REPLACE(col.value('Id[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT),
			REPLACE(REPLACE(REPLACE(col.value('Path[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			REPLACE(REPLACE(REPLACE(col.value('UserName[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
			REPLACE(REPLACE(REPLACE(col.value('UserPassword[1]','VARCHAR(2048)'),CHAR(13),''),CHAR(10),''),CHAR(9),'')
	FROM 	@i_QuestionsXML.nodes('/CommserveData/MountPathQuestion/DeviceControllerPath') AS paramXML(col)
	WHERE	NOT EXISTS(SELECT 1 FROM #lt_DevicePathQuestions WHERE Id = CAST(REPLACE(REPLACE(REPLACE(col.value('Id[1]','VARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),'') AS INT))
END
GO

IF EXISTS (select * from GxQscripts where name = 'CCMReadQuestionsXML')
	delete from GxQscripts where name = 'CCMReadQuestionsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMReadQuestionsXML')
	delete from GXDBVersions where aliasname = 'CCMReadQuestionsXML'
GO

insert into GXDBVersions values(2, 'CCMReadQuestionsXML',  '00010004004000010000', 'CCMReadQuestionsXML', '00010004004000010000')
GO

