

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMReadQuestionFileXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMReadQuestionFileXML <<<'

IF EXISTS (select * from sysobjects where name='CCMReadQuestionFileXML')
	drop procedure CCMReadQuestionFileXML
IF EXISTS (select * from GxQscripts where name='CCMReadQuestionFileXML')
	delete from GxQscripts where name = 'CCMReadQuestionFileXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMReadQuestionFileXML')
	delete from GXDBVersions where aliasname = 'CCMReadQuestionFileXML'
GO
print '... Creating Procedure: CCMReadQuestionFileXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMReadQuestionFileXML
  @i_ccmguid VARCHAR(256),
  @i_xmlreq XML
AS
  DECLARE @o_mediatypesxml XML
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN
DECLARE @i_ccmnum	INT
DECLARE @mediaTypeTab TABLE	(mediaTypeId INT)
DECLARE @driveTypeOfDP TABLE (driveTypeId INT)
DECLARE @driveType TABLE (driveTypeId INT)
DECLARE @getCmptMediaTypeLst TABLE	(mediaTypeList XML)
DECLARE @l_CCMMergeGetMediaType TABLE
					(
					mediaTypeId		INT,
					mediaType		VARCHAR(100),
					library			VARCHAR(100),
					libraryId		INT,
					mediaAgent		VARCHAR(100),
					drivePool		VARCHAR(100),
					spareGroup		VARCHAR(100) DEFAULT '',
					isDefault 		INT,
					isSelected		INT
					)
DECLARE @o_CCMAnswerMapedMediaTypeList TABLE
					(
					mediaTypeId		INT,
					mediaType		VARCHAR(100),
					library			VARCHAR(100),
					libraryId		INT,
					mediaAgent		VARCHAR(100),
					drivePool		VARCHAR(100),
					spareGroup		VARCHAR(100) DEFAULT '',
					isDefault 		INT,
					isSelected		INT,
					confirm			INT
					)
DECLARE @o_CCMAnswerNoMediaTypeMapedList TABLE
					(
					mediaTypeId		INT,
					mediaType		VARCHAR(100)
					/*library			VARCHAR(100),
					libraryId		INT,
					mediaAgent		VARCHAR(100),
					drivePool		VARCHAR(100),
					spareGroup		VARCHAR(100) DEFAULT '',
					isDefault 		INT,
					isSelected		INT*/
					)
 DECLARE @l_CCMMountPath TABLE
			(
				--SourceCommCellId		INT,
				--SourceCommCellName	VARCHAR
				SourceMediaAgentId		INT,
				SourceMediaAgentName	VARCHAR(100),
				SourceMountPathId		INT,
				SourceMountPathName		VARCHAR(100),
				SourceMountPathType		INT,
				SourceDeviceId			 integer,
				SourceDeviceName		 nvarchar(516),
				TargetMountPathName		VARCHAR(100),
				TargetLibrary			VARCHAR(100),
				TargetLibraryId			INT,
				TargetMountPathUserName	VARCHAR(100),
				TargetMountPathPassword VARCHAR(100),
				allowEdit				INT	 DEFAULT  0,
				isAnswerExists			INT,
				TargetDeviceMediaAgentId	INT,
				TargetDeviceMediaAgentName	 VARCHAR(100),
				confirm						INT
			)
DECLARE @l_SIDB_attrib	TABLE
					(
						sourceStoragePolicy			VARCHAR(250),
						sourceStoragePolicyCopy		VARCHAR(250),
						sourceMediaAgent			VARCHAR(250),
						sourceAccessPath			VARCHAR(500),
						sourceAccessPathId			INT,
						TargetMediaAgent		VARCHAR(100),
						TargetMediaAgentId		INT,
						TargetPathName			VARCHAR(100),
						TargetUserName			VARCHAR(100),
						TargetPassword			VARCHAR(100),
						isAnswerExists				INT,
						isGlobal					INT,
						confirm						INT
					)
DECLARE @l_ClientQuestions	TABLE
							(
								oldClientName			NVARCHAR(1024),
								oldClientHostName		NVARCHAR(1024),
								newClientName			nvarchar(1024),
								newClientHostName		nvarchar(1024),
								isAnswerExists			INT
							)
DECLARE @l_DevicePathQestions	TABLE
(
	sourceDeviceId			INT,
	sourceDeviceName		VARCHAR(100),
	sourceDevicePath		VARCHAR(100),
	targetMediaAgentId		INT,
	targetMediaAgent		VARCHAR(100),
    targetDevicePath		VARCHAR(100),
	targetUserName			VARCHAR(100),
	targetPassword			VARCHAR(100),
	isAnswerExists			INT,
	reservedId				INT,
	reservedString			VARCHAR(100),
	allowEdit				INT,
	confirm					INT
)
DECLARE @o_boolTab TABLE
			(
				isQuestionFileInValid INT,
				isAnyMTypeMapNotFound INT
			)
DECLARE @l_CCNumberInFile			INT
DECLARE @l_CCNameInFile				VARCHAR(256)
DECLARE	@l_CCGuid					VARCHAR(256)
DECLARE @l_MediaTypeListXML			XML
DECLARE @l_mapedCCMMergeMediaType	XML
DECLARE @l_unmapedMediaType			XML
DECLARE @l_mountPathList			XML
DECLARE @l_SIDB_QuestionXMl			XML
DECLARE @l_OtherMediaTypeXML		XML
DECLARE @l_ClientQuestionsXMl		XML
DECLARE @l_DevicePathQuestionsXML	XML
DECLARE @l_CommcellXML				XML
SELECT
@l_CCNumberInFile = (
CAST(REPLACE(REPLACE(REPLACE(col.value('Number[1]','varchar(256)'),CHAR(10), ''),CHAR(13),''),CHAR(9),'') AS INT)
),
@l_CCNameInFile = (
	REPLACE(REPLACE(REPLACE(col.value('Name[1]','varchar(256)'),CHAR(10), ''),CHAR(13),''),CHAR(9),'')
),
@l_CCGuid	=	(
	REPLACE(REPLACE(REPLACE(col.value('GUID[1]','varchar(256)'),CHAR(10), ''),CHAR(13),''),CHAR(9),'')
)
FROM @i_xmlreq.nodes('/CommserveData/CommCell') xml_Questions(col)
IF(@l_CCGuid <> @i_ccmguid)
BEGIN
	INSERT @o_boolTab VALUES(1,0)
	GOTO EXIT_PROC
END
 INSERT @l_CCMMountPath (
				SourceMediaAgentId,
				SourceMediaAgentName,
				SourceMountPathId,
				SourceMountPathName,
				SourceMountPathType,
				SourceDeviceId,
				SourceDeviceName,
				TargetMountPathName,
				TargetLibrary,
				TargetLibraryId,
				TargetMountPathUserName,
				TargetMountPathPassword,
				allowEdit,
				isAnswerExists,
				TargetDeviceMediaAgentId,
				TargetDeviceMediaAgentName,
				confirm
				)
 SELECT REPLACE(REPLACE(REPLACE(col.value('SourceHostId[1]','VARCHAR(512)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		REPLACE(REPLACE(REPLACE(col.value('SourceHostName[1]','VARCHAR(100)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		REPLACE(REPLACE(REPLACE(col.value('SourceMountPathId[1]','VARCHAR(512)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		REPLACE(REPLACE(REPLACE(col.value('SourceMountPathName[1]','VARCHAR(512)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		REPLACE(REPLACE(REPLACE(col.value('MountPathType[1]','VARCHAR(512)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		REPLACE(REPLACE(REPLACE(col.value('SourceDeviceId[1]','VARCHAR(512)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		REPLACE(REPLACE(REPLACE(col.value('SourceDeviceName[1]','VARCHAR(512)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		'','',0,'','',1,0,0,'',0
 FROM @i_xmlreq.nodes('/CommserveData/MountPath') AS i_questionFile(col)
INSERT @l_SIDB_attrib (
						sourceStoragePolicy,
						sourceStoragePolicyCopy,
						sourceMediaAgent,
						sourceAccessPath,
						sourceAccessPathId,
						TargetMediaAgent,
						TargetMediaAgentId,
						TargetPathName,
						TargetUserName,
						TargetPassword,
						isAnswerExists,
						isGlobal,
						confirm
						)
SELECT
	REPLACE(REPLACE(REPLACE(col.value('StoragePoliceName[1]','VARCHAR(250)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
	REPLACE(REPLACE(REPLACE(col.value('CopyName[1]','VARCHAR(250)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
	REPLACE(REPLACE(REPLACE(col.value('SourceAccessPathMediaAgentName[1]','VARCHAR(250)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
	REPLACE(REPLACE(REPLACE(col.value('SourceAccessPath[1]','VARCHAR(250)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
	REPLACE(REPLACE(REPLACE(col.value('SourceAccessPathId[1]','VARCHAR(250)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
	'',0,'','','',0,
	REPLACE(REPLACE(REPLACE(col.value('IsGlobalStoreFlag[1]','VARCHAR(250)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
	0
from @i_xmlreq.nodes('/CommserveData/AccessPath') paramXML(col)
INSERT @l_ClientQuestions (
								oldClientName,
								oldClientHostName,
								newClientName,
								newClientHostName,
								isAnswerExists
							)
SELECT
REPLACE(REPLACE(REPLACE(col.value('OldClientName[1]','NVARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
REPLACE(REPLACE(REPLACE(col.value('OldClientHostName[1]','NVARCHAR(1024)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
'','',0
from @i_xmlreq.nodes('/CommserveData/Client') paramXML(col)
INSERT 	@driveTypeOfDP (driveTypeId)
SELECT DISTINCT
CAST(RTRIM(LTRIM(REPLACE(REPLACE(REPLACE(col.value('.','varchar(1000)'), CHAR(10), ''), CHAR(13), ''), CHAR(9), ''))) AS INT)
		from @i_xmlreq.nodes('/CommserveData/DataPath/DriveTypeId') xml_Questions(col)
INSERT @mediaTypeTab(mediaTypeId)
SELECT
CAST(RTRIM(LTRIM(REPLACE(REPLACE(REPLACE(col.value('.','varchar(1000)'), CHAR(10), ''), CHAR(13), ''), CHAR(9), ''))) AS INT)
		from @i_xmlreq.nodes('/CommserveData/MediaType') xml_Question(col)
UNION
select DISTINCT MMR.mediatypeID from MMRecFmtMedTyp MMR
INNER JOIN @driveTypeOfDP DTP ON MMR.DriveTypeId = DTP.driveTypeId
insert @getCmptMediaTypeLst
 EXEC CCMMergeGetMediaTypeListXML
 select @l_MediaTypeListXML = mediaTypeList from @getCmptMediaTypeLst
INSERT 	@l_CCMMergeGetMediaType
SELECT  0, 0, a.AliasName, a.LibraryId, e.name, c.DrivePoolName, ISNULL(f.SpareGroupName, ''), 0, 0
FROM	MMLibrary a
		INNER JOIN MMMasterPool b ON a.LibraryId = b.LibraryId
		INNER JOIN MMDrivePool c ON b.MasterPoolId = c.MasterPoolId
		INNER JOIN (SELECT ClientId, MIN(DrivePoolId) DrivePoolId FROM MMDrivePool GROUP BY ClientId) d ON c.DrivePoolId = d.DrivePoolId
		INNER JOIN App_Client e ON d.ClientId = e.id AND e.id > 1
		LEFT OUTER JOIN MMSpareGroup f ON a.LibraryId = f.LibraryId AND f.SpareGroupType = 2
INSERT @o_CCMAnswerMapedMediaTypeList
SELECT 	0, 0, '', 0, CL.name, '', '', 0, 0, 0
FROM 	App_Client CL WITH (READUNCOMMITTED), MMHost MA WITH (READUNCOMMITTED)
WHERE	CL.id = MA.clientId AND CL.id > 1 AND CL.specialClientFlags &  0x20 = 0
--SELECT LCCM.*, LCCM.isSelected FROM @l_CCMMergeGetMediaType LCCM
INSERT @o_CCMAnswerNoMediaTypeMapedList
SELECT MTT.mediaTypeId,MDT.MediaTypeName FROM @mediaTypeTab MTT
		INNER JOIN MMMediaType MDT ON MDT.MediaTypeId = MTT.mediaTypeId
		WHERE MTT.mediaTypeId NOT IN (SELECT DISTINCT LCCM.mediaTypeId FROM @l_CCMMergeGetMediaType LCCM )
INSERT @l_DevicePathQestions
				(
					sourceDeviceId,
					sourceDeviceName,
					sourceDevicePath,
					targetMediaAgentId,
					targetMediaAgent,
					targetDevicePath,
					targetUserName,
					targetPassword,
					isAnswerExists,
					reservedId,
					reservedString,
					allowEdit,
					confirm
				)
SELECT
		REPLACE(REPLACE(REPLACE(colDevice.value('SourceDeviceId[1]','VARCHAR(256)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		REPLACE(REPLACE(REPLACE(colDevice.value('SourceDeviceName[1]','VARCHAR(256)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		REPLACE(REPLACE(REPLACE(colDevice.value('SourceDevicePath[1]','VARCHAR(256)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		0,--REPLACE(REPLACE(REPLACE(colDevice.value('TargetMediaAgentId[1]','INT'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		'',--REPLACE(REPLACE(REPLACE(colDevice.value('TargetMediaAgent[1]','VARCHAR(256)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		'',--REPLACE(REPLACE(REPLACE(colDevice.value('TargetDevicePath[1]','VARCHAR(256)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		'',--REPLACE(REPLACE(REPLACE(colDevice.value('TargetUserName[1]','VARCHAR(256)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		'',--REPLACE(REPLACE(REPLACE(colDevice.value('TargetPassword[1]','VARCHAR(256)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		0,--REPLACE(REPLACE(REPLACE(colDevice.value('IsAnswerExists[1]','INT'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		REPLACE(REPLACE(REPLACE(colDevice.value('ReservedId[1]','INT'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		REPLACE(REPLACE(REPLACE(colDevice.value('ReservedString[1]','VARCHAR(256)'),CHAR(13),''),CHAR(10),''),CHAR(9),''),
		1,
		0
FROM @i_xmlreq.nodes('/CommserveData/DevicePath') as devicePathXml(colDevice)
INSERT @o_boolTab
VALUES (
		0,
		(
		CASE
			WHEN exists(SELECT * FROM @o_CCMAnswerNoMediaTypeMapedList)
			THEN
				1
			ELSE
				0
			END
		)
	)
SET @l_CommcellXML =
			(
				SELECT
					@l_CCNumberInFile AS '@commCellNumber',
					@l_CCNameInFile AS '@commCellName',
					@l_CCGuid	AS '@commcellGUID'
				FOR XML PATH('commCell')
			)
SET @l_mapedCCMMergeMediaType	=
		(
		SELECT
     	 cCMMergeMedia.mediaTypeId AS '@mediaTypeId',
		 cCMMergeMedia.mediaType AS '@mediaType',
		 cCMMergeMedia.library AS '@library',
		 cCMMergeMedia.libraryId AS '@libraryId',
		 cCMMergeMedia.mediaAgent AS '@mediaAgent',
		 cCMMergeMedia.drivePool AS '@drivePool',
		 cCMMergeMedia.spareGroup AS '@spareGroup',
		 cCMMergeMedia.isDefault AS '@isDefault',
		 cCMMergeMedia.isSelected AS '@isSelected',
		 cCMMergeMedia.confirm	AS '@confirm'
		 FROM @o_CCMAnswerMapedMediaTypeList cCMMergeMedia ORDER BY cCMMergeMedia.mediaTypeId DESC FOR XML PATH('possibleMaps')
		)
 SET @l_unmapedMediaType =
		(
		SELECT
		 noMap.mediaTypeId AS '@mediaTypeId',
		 noMap.mediaType AS '@mediaType',
		 '' AS '@library',
		 0 AS '@libraryId',
		 '' AS '@mediaAgent',
		 '' AS '@drivePool',
		 '' AS '@spareGroup',
		 0 AS '@isDefault',
		 0 AS '@isSelected'
		 FROM @o_CCMAnswerNoMediaTypeMapedList noMap ORDER BY noMap.mediaTypeId DESC FOR XML PATH('noMediaTypeMaped')
		)
SET @l_OtherMediaTypeXML =
		(
		SELECT
     	 cCMMergeGetMedia.mediaTypeId AS '@mediaTypeId',
		 cCMMergeGetMedia.mediaType AS '@mediaType',
		 cCMMergeGetMedia.library AS '@library',
		 cCMMergeGetMedia.libraryId AS '@libraryId',
		 cCMMergeGetMedia.mediaAgent AS '@mediaAgent',
		 cCMMergeGetMedia.drivePool AS '@drivePool',
		 cCMMergeGetMedia.spareGroup AS '@spareGroup',
		 cCMMergeGetMedia.isDefault AS '@isDefault',
		 cCMMergeGetMedia.isSelected AS '@isSelected'
		 FROM @l_CCMMergeGetMediaType cCMMergeGetMedia WHERE cCMMergeGetMedia.mediaTypeId NOT IN(SELECT mediaTypeId FROM @mediaTypeTab)
		 ORDER BY cCMMergeGetMedia.mediaTypeId DESC FOR XML PATH('otherMediaTypes')
		)
UPDATE @l_CCMMountPath
		SET CMNT.TargetMountPathName  = CCMA.TargetMountPathName,
			CMNT.TargetLibrary = ML.AliasName,
			CMNT.TargetLibraryId = CCMA.TargetLibraryId,
			CMNT.TargetMountPathUserName = CCMA.TargetMountPathUserName,
			CMNT.TargetMountPathPassword = CCMA.TargetMountPathPassword,
			CMNT.TargetDeviceMediaAgentId = CCMA.TargetDeviceMediaAgentId,
			CMNT.allowEdit = CCMA.allowEdit,
			CMNT.isAnswerExists	= 1,
			CMNT.confirm = 1
FROM @l_CCMMountPath CMNT INNER JOIN CCMMountPathAnswers CCMA
									ON CCMA.SourceMountPathId =  CMNT.SourceMountPathId
 						 INNER JOIN MMLibrary ML ON CCMA.TargetLibraryId =ML.LibraryId
 		WHERE			CCMA.SourceCommCellGUID = @l_CCGuid
						AND CCMA.SourceCommCellName = @l_CCNameInFile
						AND CCMA.TargetLibraryId > 0
						AND	 LEN(CCMA.TargetMountPathName) > 0
UPDATE @l_CCMMountPath
		SET CMNT.TargetDeviceMediaAgentName = ACL.name
FROM @l_CCMMountPath CMNT LEFT JOIN	APP_Client ACL ON CMNT.TargetDeviceMediaAgentId = ACL.id
SET @l_mountPathList =
 (
 SELECT
	LCC.SourceMediaAgentName AS '@sourceMediaAgent',
	LCC.sourceMountPathName AS '@sourceMountPath',
	LCC.SourceMediaAgentId	AS '@sourceMediaAgentId',
	LCC.sourceMountPathId  AS '@sourceMountPathId',
	LCC.SourceMountPathType AS '@mountPathType',
	LCC.SourceDeviceId		AS '@sourceDeviceId',
	LCC.SourceDeviceName	AS '@sourceDeviceName',
	LCC.TargetLibrary		AS '@destinationLibrary',
	LCC.TargetLibraryId	AS '@destinationLibraryId',
	LCC.TargetMountPathName AS '@destinationMountPath',
	LCC.TargetMountPathPassword AS '@targetUserName',
	LCC.TargetMountPathUserName AS '@targetPassword',
	LCC.TargetDeviceMediaAgentId AS '@targetDeviceMediaAgentId',
	LCC.TargetDeviceMediaAgentName AS '@targetDeviceMediaAgent',
	LCC.isAnswerExists	AS '@isAnswerExists',
	LCC.allowEdit		AS '@isEditable',
	LCC.confirm			AS '@confirm'
	 from @l_CCMMountPath LCC FOR XML PATH('mountPathMap')
)
UPDATE @l_SIDB_attrib
	SET	SAT.TargetMediaAgentId = CCA.TargetMediaAgentId,
		SAT.TargetMediaAgent = ACL.name,
		SAT.TargetPathName = CCA.TargetPathName,
		SAT.TargetUserName = CCA.TargetUserName,
		SAT.TargetPassword = CCA.TargetPasword,
		SAT.isAnswerExists = 1,
		SAT.confirm = 1
FROM @l_SIDB_attrib SAT INNER JOIN CCMSIDBPathAnswers CCA
						ON CCA.SourceCommCellGUID = @l_CCGuid
							AND CCA.SourceIdxAccessPathId = SAT.SourceAccessPathId,
	APP_Client ACL WHERE ACL.id = CCA.TargetMediaAgentId
SET @l_SIDB_QuestionXMl = 	(
				SELECT
				LSIDB.sourceStoragePolicy AS '@storagePolicy',
				LSIDB.sourceStoragePolicyCopy AS '@storagePolicyCopy',
				LSIDB.sourceMediaAgent	AS	'@sourceMediaAgent',
				LSIDB.sourceAccessPath AS '@sourceAccessPath',
				LSIDB.sourceAccessPathId AS '@sourceAccessPathId',
				LSIDB.TargetMediaAgent AS '@targetMediaAgent',
				LSIDB.TargetMediaAgentId AS	'@targetMediaAgentId',
				LSIDB.TargetPathName	AS '@targetPath',
				LSIDB.TargetUserName	AS '@targetUserName',
				LSIDB.TargetPassword	AS '@targetPassword',
				LSIDB.isAnswerExists	AS '@isAnswerExists',
				LSIDB.isGlobal			AS '@isGlobal',
				LSIDB.confirm			AS '@confirm'
				 from @l_SIDB_attrib LSIDB FOR XML PATH('sidbQuestion')
				 )
UPDATE @l_ClientQuestions
		SET LC.NewClientName = CCA.newClientName,
			LC.NewClientHostName = CCA.newClientHostName,
			LC.isAnswerExists = 1
FROM @l_ClientQuestions LC INNER JOIN CCMClientAnswers CCA
								ON	CCA.SourceCommCellGUID = @l_CCGuid
								AND CCA.OldClientName = LC.oldClientName
								AND CCA.OldClientHostName = LC.oldClientHostName
SET @l_ClientQuestionsXMl =
				(
				SELECT
					LC.oldClientName		AS		'@oldClientName',
					LC.oldClientHostName	AS		'@oldClientHostName',
					LC.newClientName		AS		'@newClientName',
					LC.newClientHostName	AS		'@newClientHostName',
					LC.isAnswerExists		AS		'@isAnswerExists'
				 from @l_ClientQuestions LC FOR XML PATH('clientQuestion')
				 )
UPDATE @l_DevicePathQestions
				SET	DPQ.targetMediaAgentId	=	CDP.TargetMediaAgentId,
					DPQ.targetMediaAgent	=	ACL.name,
					DPQ.targetDevicePath	=	CDP.TargetDevicePath,
					DPQ.targetUserName		=	CDP.TargetDevicePathUserName,
					DPQ.targetPassword		=	CDP.TargetDevicePathPassword,
					DPQ.isAnswerExists		=	1,
					DPQ.allowEdit			=	CDP.allowEdit,
					DPQ.confirm				=	1
FROM	@l_DevicePathQestions DPQ
		INNER JOIN	CCMDevicePathAnswers CDP	ON	CDP.SourceDeviceId =DPQ.sourceDeviceId
		INNER JOIN	App_Client	ACL	ON ACL.id = CDP.TargetMediaAgentId
WHERE CDP.SourceCommCellGUID = @l_CCGuid
	   AND CDP.TargetMediaAgentId > 1
SET @l_DevicePathQuestionsXML =
				(
				SELECT
					DPQ.sourceDeviceId		AS		'@sourceDeviceId',
					DPQ.sourceDeviceName	AS		'@sourceDeviceName',
					DPQ.sourceDevicePath	AS		'@sourceDevicePath',
					DPQ.targetMediaAgentId	AS		'@targetMediaAgentId',
					DPQ.targetMediaAgent	AS		'@targetMediaAgent',
					DPQ.targetDevicePath	AS		'@targetDevicePath',
					DPQ.targetUserName		AS		'@targetUserName',
					DPQ.targetPassword		AS		'@targetPassword',
					DPQ.isAnswerExists		AS		'@isAnswerExists',
					DPQ.reservedId			AS		'@reservedId',
					DPQ.reservedString		AS		'@reservedString',
					DPQ.allowEdit			AS		'@isEditable',
					DPQ.confirm				AS		'@confirm'
				FROM @l_DevicePathQestions DPQ	FOR XML PATH('devicePathQuestion')
				)
---------------------------------------------------------------------------------------------------------------------------------------------
DECLARE @XmlSourceTable table(XmlData xml)
INSERT INTO @XmlSourceTable
SELECT @i_xmlreq
--Populate the list of mount path and its library, device, device controller details that we got from source
DECLARE @l_MountPathDetailsFromSource TABLE
(
	mountPathId integer, mountPathName varchar(512),mountPathType int, libraryId integer,	libraryName nvarchar(128), deviceId integer,
	deviceName nvarchar(128), deviceControllerId integer, deviceControllerPath varchar(1024), userName varchar(1024),
	userPassword varchar(2048)
)
INSERT INTO	@l_MountPathDetailsFromSource
SELECT
	  mpref.value('(MountPathId/text())[1]', 'integer') as MountPathId,
      mpref.value('(MountPathName/text())[1]', 'varchar(512)') as MountPathName,
	mpref.value('(MountPathType/text())[1]', 'varchar(512)') as MountPathType,
      mpref.value('(LibraryId/text())[1]', 'integer') as LibraryId,
	  mpref.value('(LibraryName/text())[1]', 'nvarchar(128)') as LibraryName,
	  mpref.value('(DeviceId/text())[1]', 'integer') as DeviceId,
	  mpref.value('(DeviceName/text())[1]', 'nvarchar(128)') as DeviceName,
	  ISNULL((dcref.value('(Id/text())[1]', 'integer')),0) as DeviceControllerId,
      ISNULL((dcref.value('(Path/text())[1]', 'varchar(1024)')),'') as DeviceControllerPath,
      ISNULL((dcref.value('(UserName/text())[1]', 'varchar(1024)')),'') as UserName,
      ISNULL((dcref.value('(UserPassword/text())[1]', 'varchar(2048)')),'') as UserPassword
FROM
      @XmlSourceTable CROSS APPLY
      XmlData.nodes('//MountPathQuestion') AS MP(mpref) CROSS APPLY
      mpref.nodes('DeviceControllerPath') AS DC(dcref)
--Now we have to process these and set the question xml to be sent over to GUI
--It has the distinct rows for mount paths
DECLARE @l_MountPaths table
(mountPathId integer, mountPathName varchar(512), mountPathType int, libraryId integer, libraryName nvarchar(128),
deviceId integer, deviceName nvarchar(128), answerFlags int)
/*
For each MP/Lib frm above table list the possible targets. If any of the MP of this srcLibrary is already migrated there could
be only one possible target MA/library
If not so then we'll send only possible target MAs(libId and libName will be empty) and the library will be migrated
*/
--link between above table and this table is srcLibraryId
DECLARE @l_PossibleTargetMAs table
(srcLibraryId int, targetMAId integer, targetMAName nvarchar(255),
targetLibraryId int, targetLibraryName nvarchar(128))
--link between MP table and this table is deviceId
DECLARE @l_PossibleDeviceControllerPaths table
(deviceId integer, deviceControllerId integer, deviceControllerPath varchar(1024), userName varchar(1024), userPassword varchar(2048))
INSERT INTO @l_MountPaths
SELECT distinct mountPathId, mountPathName, mountPathType, libraryId, libraryName, deviceId, deviceName, 0
FROM @l_MountPathDetailsFromSource
/*If it is regular mount path and it is already merged
set the mount path name as the target mount path name in the answer table*/
UPDATE @l_MountPaths SET mountPathName = b.TargetMountPathName
FROM @l_MountPaths a inner join CCMMountPathAnswers b
ON a.mountPathId = b.SourceMountPathId AND b.SourceCommCellGUID = @l_CCGuid
AND (b.allowEdit & 1) = 0 AND a.mountPathType = 0
UPDATE @l_MountPaths SET answerFlags = answerFlags | 1
FROM @l_MountPaths a inner join CCMMountPathAnswers b
ON a.mountPathId = b.SourceMountPathId AND b.SourceCommCellGUID = @l_CCGuid AND b.TargetLibraryId > 0
UPDATE @l_MountPaths SET answerFlags = answerFlags | 1
FROM @l_MountPaths a inner join CCMLibraryAnswers b
ON a.libraryId = b.SourceLibraryId AND b.SourceCommCellGUID = @l_CCGuid
UPDATE @l_MountPaths SET answerFlags = answerFlags | 2 WHERE libraryId not in
(
SELECT libraryId FROM @l_MountPaths a WHERE
EXISTS (SELECT * FROM CCMLibraryAnswers where SourceLibraryId = a.libraryId AND SourceCommCellGUID = @l_CCGuid AND allowEdit = 0)
OR EXISTS (SELECT * FROM CCMMountPathAnswers WHERE SourceMountPathId = a.mountPathId AND SourceCommCellGUID = @l_CCGuid AND (allowEdit & 1) = 0)
)
UPDATE @l_MountPaths SET answerFlags = answerFlags | 4
WHERE NOT EXISTS (SELECT * FROM CCMMountPathAnswers where SourceCommCellGUID = @l_CCGuid AND SourceMountPathId = mountPathId AND (allowEdit & 1) = 0)
--For the libraries whose MPs are already mapped we have to use the same library
INSERT INTO @l_PossibleTargetMAs
SELECT distinct a.libraryId,
CASE WHEN b.TargetDeviceMediaAgentId > 0 AND EXISTS (SELECT * FROM MMHost WHERE ClientId = b.TargetDeviceMediaAgentId) THEN b.TargetDeviceMediaAgentId
ELSE c.TargetMediaAgentId END,
(SELECT name FROM APP_Client WHERE id = CASE WHEN b.TargetDeviceMediaAgentId > 0 AND EXISTS (SELECT * FROM MMHost WHERE ClientId = b.TargetDeviceMediaAgentId) THEN b.TargetDeviceMediaAgentId
ELSE c.TargetMediaAgentId END),
b.TargetLibraryId,(SELECT AliasName FROM MMLibrary where libraryId = b.TargetLibraryId)
FROM @l_MountPathDetailsFromSource a inner join CCMMountPathAnswers b
on @l_CCGuid = b.SourceCommCellGUID AND a.mountPathId = b.SourceMountPathId
left outer join CCMDevicePathAnswers c ON b.SourceDeviceId = c.SourceDeviceId AND b.SourceCommCellGUID = @l_CCGuid
WHERE
(EXISTS (SELECT * FROM MMHost WHERE ClientId = b.TargetDeviceMediaAgentId)
OR EXISTS (SELECT * FROM MMHost WHERE ClientId = c.TargetMediaAgentId))
--For the libraries whose MPs are already mapped and allowEdit = 1, all MAs are possible target MAs
INSERT INTO @l_PossibleTargetMAs
SELECT distinct a.libraryId, c.ClientId, c.name, 0, 'CCM_' + a.libraryName
FROM @l_MountPathDetailsFromSource a inner join CCMMountPathAnswers f
ON @l_CCGuid = f.SourceCommCellGUID AND a.mountPathId = f.SourceMountPathId,
(SELECT h.ClientId, cl.name FROM MMHost h INNER JOIN APP_Client cl ON h.ClientId = cl.id WHERE h.ClientId > 1 AND cl.specialClientFlags &  0x20 = 0) c
WHERE NOT EXISTS(SELECT * FROM @l_PossibleTargetMAs WHERE srcLibraryId = a.libraryId AND targetMAId = c.ClientId)
AND NOT EXISTS (SELECT * FROM CCMLibraryAnswers WHERE SourceLibraryId = a.libraryId AND SourceCommCellGUID = @l_CCGuid AND allowEdit = 0)
--For other libraries whose MPs are not migrated before, all MAs are possible target MAs
INSERT INTO @l_PossibleTargetMAs
SELECT distinct a.libraryId, c.ClientId, c.name, 0, 'CCM_' + a.libraryName
FROM @l_MountPathDetailsFromSource a left outer join @l_PossibleTargetMAs b
ON a.libraryId = b.srcLibraryId,
(SELECT h.ClientId, cl.name FROM MMHost h INNER JOIN APP_Client cl ON h.ClientId = cl.id WHERE h.ClientId > 1 AND cl.specialClientFlags &  0x20 = 0) c
WHERE b.srcLibraryId is null
--For devices that are already mapped
INSERT INTO @l_PossibleDeviceControllerPaths
SELECT distinct a.deviceId, a.deviceControllerId, b.TargetDevicePath, b.TargetDevicePathUserName, b.TargetDevicePathPassword
FROM @l_MountPathDetailsFromSource a inner join CCMDevicePathAnswers b
ON @l_CCGuid = b.SourceCommCellGUID AND a.deviceId = b.SourceDeviceId
--For devices that are already mapped and still allowEdit = 1
INSERT INTO @l_PossibleDeviceControllerPaths
SELECT distinct a.deviceId, a.deviceControllerId, a.deviceControllerPath, a.userName, a.userPassword
FROM @l_MountPathDetailsFromSource a inner join CCMDevicePathAnswers b
ON @l_CCGuid = b.SourceCommCellGUID AND a.deviceId = b.SourceDeviceId AND b.allowEdit = 1
left outer join @l_PossibleDeviceControllerPaths c ON a.deviceId = c.deviceId AND a.deviceControllerPath = c.deviceControllerPath
WHERE c.deviceId is null
--For devices that are new
INSERT INTO @l_PossibleDeviceControllerPaths
SELECT  distinct a.deviceId, a.deviceControllerId, a.deviceControllerPath, a.userName, a.userPassword
FROM @l_MountPathDetailsFromSource a left outer join @l_PossibleDeviceControllerPaths b
ON a.deviceId = b.deviceId
WHERE b.deviceId is null
DECLARE @l_MountPathQuestionXML xml
SET @l_MountPathQuestionXML =	(
								SELECT
								a.mountPathType As '@mountPathType',
								a.answerFlags AS '@answerFlags',
								(SELECT distinct libraryId as '@libraryId', libraryName as '@libraryName' FROM
								@l_MountPaths b WHERE b.mountPathId = a.mountPathId FOR XML PATH('sourceLibrary'),TYPE),
								(SELECT distinct b.targetLibraryId as '@libraryId',b.targetLibraryName as '@libraryName' FROM
								@l_PossibleTargetMAs b WHERE b.srcLibraryId = a.libraryId AND b.targetLibraryName <> 'N/A' FOR XML PATH('targetLibrary'),TYPE),
								(SELECT distinct b.targetMAId as '@mediaAgentId', b.targetMAName as '@mediaAgentName' FROM
								@l_PossibleTargetMAs b WHERE b.srcLibraryId = a.libraryId FOR XML PATH('targetMediaAgent'),TYPE),
								(SELECT distinct mountPathId as '@mountPathId', mountPathName '@mountPathName'
								FROM @l_MountPaths b WHERE b.mountPathId = a.mountPathId FOR XML PATH('mountPath'),TYPE),
								(SELECT distinct b.deviceId as '@id', b.deviceName as '@name'
								FROM @l_MountPaths b WHERE b.deviceId = a.deviceId FOR XML PATH('device'),TYPE),
								(SELECT b.deviceControllerPath as '@accessPath', b.deviceControllerId as '@accessPathId',
									(SELECT userName as '@userName',userPassword '@password' FROM @l_PossibleDeviceControllerPaths c WHERE c.deviceControllerId = b.deviceControllerId AND c.deviceControllerPath = b.deviceControllerPath FOR XML PATH('accessPathCredentials'),TYPE)
								FROM @l_PossibleDeviceControllerPaths b WHERE b.deviceId = a.deviceId FOR XML PATH('accessPathList'),TYPE)
							  FROM @l_MountPaths a order by libraryId, deviceName, mountPathName FOR XML PATH('libraryQuestion')
							  )
EXIT_PROC:
SET @o_mediatypesxml =
	(
		SELECT
			  OBT.isQuestionFileInValid AS '@isQuestionFileInValid',
			  OBT.isAnyMTypeMapNotFound AS '@isAnyMTypeMapNotFound',
			  @l_CommcellXML,
			  @l_mapedCCMMergeMediaType ,
			  @l_unmapedMediaType ,
			  @l_OtherMediaTypeXML,
			  @l_mountPathList,
			  @l_SIDB_QuestionXMl,
			  @l_ClientQuestionsXMl,
			  @l_DevicePathQuestionsXML,
			  @l_MountPathQuestionXML
		FROM @o_boolTab OBT FOR XML PATH('EVGui_CCMReadQuestionFileResp')
	)
SELECT 	@o_mediatypesxml
END
GO

IF EXISTS (select * from GxQscripts where name = 'CCMReadQuestionFileXML')
	delete from GxQscripts where name = 'CCMReadQuestionFileXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMReadQuestionFileXML')
	delete from GXDBVersions where aliasname = 'CCMReadQuestionFileXML'
GO

insert into GXDBVersions values(2, 'CCMReadQuestionFileXML',  '00000000000000000000', 'CCMReadQuestionFileXML', '00000000000000000000')
GO

