

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMMergeGetMediaTypeListXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMMergeGetMediaTypeListXML <<<'

IF EXISTS (select * from sysobjects where name='CCMMergeGetMediaTypeListXML')
	drop procedure CCMMergeGetMediaTypeListXML
IF EXISTS (select * from GxQscripts where name='CCMMergeGetMediaTypeListXML')
	delete from GxQscripts where name = 'CCMMergeGetMediaTypeListXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMMergeGetMediaTypeListXML')
	delete from GXDBVersions where aliasname = 'CCMMergeGetMediaTypeListXML'
GO
print '... Creating Procedure: CCMMergeGetMediaTypeListXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMMergeGetMediaTypeListXML
AS
  DECLARE @o_ccm_merge_media XML
SET NOCOUNT ON
--Locale variables
DECLARE @mediaTypeLib TABLE
					(
						mediatypeId		INT,
						mediaTypeName	VARCHAR(100),
						mapLibraryId	INT
					)
DECLARE @libMAMapList TABLE
					(
						LibraryId		INT,
						LibraryName		VARCHAR(100),
						clientId		INT,
						clientName		VARCHAR(100),
						net_HostName	VARCHAR(100),
						DrivePoolName	VARCHAR(100)
					)
DECLARE @o_CCMMergeMedia TABLE
					(
						id				INT identity(1,1),
						mediaTypeId		INT,
						mediaType		VARCHAR(100),
						library			VARCHAR(100),
						libraryId		INT,
						mediaAgent		VARCHAR(100),
						drivePool		VARCHAR(100),
						spareGroup		VARCHAR(100) DEFAULT '',
						isDefault 		INT,
						isSelected		INT
					)
DECLARE @l_mediaTypeIdTab TABLE
					(
						mediaTypeId		INT,
						compatability	INT,
						id				INT,
						isDefault 		INT
					)
DECLARE @o_mediatypelist XML
INSERT INTO @mediaTypeLib(mediaTypeId, mediaTypeName, mapLibraryId)
 SELECT DISTINCT MMR.mediaTypeId, MDT.MediaTypeName, MMP.LibraryId
 FROM MMRecFmtMedtyp MMR
	INNER JOIN MMDrive 	MDR ON MDR.driveTypeId = MMR.driveTypeId
	INNER JOIN MMMasterPool MMP ON MMP.masterPoolID = MDR.masterPoolID
	INNER JOIN MMMediatype	MDT	ON MMR.MediaTypeId = MDT.MediaTypeId
WHERE MMR.MediaTypeId IN
		(
			SELECT DISTINCT MD.MediaTypeId
			from MMMedia MD
			WHERE MD.MediatypeId <> 0
		)
UNION
SELECT MMT.MediaTypeId,MMT.MediaTypeName,MML.LibraryId FROM MMMediaType MMT,MMLibrary MML
		WHERE MML.LibraryTypeId = 3 AND MMT.MediaTypeId = 10001
INSERT @libMAMapList
			(	LibraryId, LibraryName,
				clientId, clientName,net_HostName,DrivePoolName
			)
SELECT DISTINCT
			 MTL.mapLibraryId,MMl.AliasName,
			 CL.id, CL.name, CL.net_HostName, DP.DrivePoolName
from MMDrivePool DP
	INNER JOIN MMMasterPool MP ON DP.MasterPoolId = MP.MasterPoolId
	INNER JOIN APP_Client CL ON	CL.id = DP.ClientId
	INNER JOIN @mediatypeLib MTL ON MP.LibraryId = MTL.mapLibraryId
	INNER JOIN MMLibrary MML ON MML.LibraryId = MP.LibraryId
INSERT @o_CCMMergeMedia
					(
						mediaTypeId,
						mediaType,
						library,
						libraryId,
						mediaAgent,
						drivePool,
						spareGroup,
						isDefault,
						isSelected
					)
SELECT			MTL.mediatypeid,
				MTL.mediaTypeName,
				LMM.LibraryName,
				LMM.LibraryId,
				LMM.clientName,
				LMM.DrivePoolName,
				MS.spareGroupName,
				0,
				0
FROM @mediatypeLib MTL
INNER JOIN @libMAMapList LMM	ON MTL.mapLibraryId = LMM.LibraryId
LEFT JOIN MMSpareGroup MS ON MS.LibraryId = LMM.LibraryId
AND MS.SpareGroupType IN (1,2)
UPDATE @o_CCMMergeMedia
		SET OCM.isSelected = 1,
			OCM.isDefault = 1
 FROM @o_CCMMergeMedia OCM
 INNER JOIN CCMMediaTypeAnswers CCM ON OCM.mediaTypeId = CCM.MediaTypeId
 INNER JOIN MMDrivePool	MD ON MD.DrivePoolName = OCM.DrivePool AND MD.DrivePoolId = CCM.DrivePoolId
 INNER JOIN APP_Client ACL ON ACL.name = OCM.MediaAgent AND ACL.id = CCM.mediaAgentId
 INNER JOIN MMLibrary ML ON ML.AliasName = OCM.Library AND ML.libraryId = OCM.libraryId
 --INNER JOIN MMSpareGroup MS ON (OCM.SpareGroup  = MS.SpareGroupName AND MS.spareGroupId = CCM.sparePoolGroupId)
  ,MMSpareGroup MS  WHERE  (OCM.SpareGroup  = MS.SpareGroupName AND MS.spareGroupId = CCM.sparePoolGroupId)
						OR (CCM.sparePoolGroupId = 0 AND OCM.SpareGroup IS NULL)
 INSERT	@l_mediaTypeIdTab (mediaTypeId,compatability,id,isDefault)
 SELECT  tmp_maps.mediaTypeId,tmp_maps.CompatibilityType,tmp_maps.id,1
 FROM
 (
 SELECT DISTINCT OCM.mediaTypeId,MRM.CompatibilityType,OCM.id,ROW_NUMBER() OVER (PARTITION BY OCM.mediaTypeId ORDER BY MRM.CompatibilityType DESC) ROW_NUM
 FROM  	@o_CCMMergeMedia OCM
		INNER JOIN MMDrivePool MMD ON MMD.DrivePoolName = OCM.drivePool AND OCM.isSelected = 0
		INNER JOIN MMMasterPool MMP ON MMP.MasterPoolId = MMD.MasterPoolId
		LEFT JOIN MMDrive MDR ON MDR.MasterPoolId = MMD.MasterPoolId
		LEFT JOIN MMRecFmtMedTyp MRM ON MRM.MediaTypeId = OCM.mediaTypeId AND MRM.DriveTypeId = MDR.DriveTypeId
 ) AS tmp_maps WHERE tmp_maps.ROW_NUM = 1
UPDATE @l_mediaTypeIdTab
		SET LMT.isDefault = 0
FROM @l_mediaTypeIdTab LMT INNER JOIN  @o_CCMMergeMedia OCM ON OCM.MediaTypeId = LMT.mediaTypeId
							AND	OCM.isSelected = 1
UPDATE  @o_CCMMergeMedia
		SET OCM.isDefault = 1
FROM @o_CCMMergeMedia OCM
	INNER JOIN @l_mediaTypeIdTab LMT ON OCM.MediaTypeId = LMT.mediaTypeId
				AND OCM.id = LMT.id AND LMT.isDefault = 1
SET @o_mediatypelist	=
(
		SELECT
    		cCMMergeMedia.mediaTypeId AS '@mediaTypeId',
		 cCMMergeMedia.mediaType AS '@mediaType',
		 cCMMergeMedia.library AS '@library',
		 cCMMergeMedia.libraryId AS '@libraryId',
		 cCMMergeMedia.mediaAgent AS '@mediaAgent',
		 cCMMergeMedia.drivePool AS '@drivePool',
		 cCMMergeMedia.spareGroup AS '@spareGroup',
		 cCMMergeMedia.isDefault AS '@isDefault',
		 cCMMergeMedia.isSelected AS '@isSelected'
		 FROM @o_CCMMergeMedia cCMMergeMedia ORDER BY cCMMergeMedia.mediaTypeId DESC FOR XML PATH('ccmMergeMedia')
)
 SET  @o_ccm_merge_media = (SELECT @o_mediatypelist for XML PATH('EVGui_CCMMergeMediaResp'))
 SELECT @o_ccm_merge_media
 SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCMMergeGetMediaTypeListXML')
	delete from GxQscripts where name = 'CCMMergeGetMediaTypeListXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMMergeGetMediaTypeListXML')
	delete from GXDBVersions where aliasname = 'CCMMergeGetMediaTypeListXML'
GO

insert into GXDBVersions values(2, 'CCMMergeGetMediaTypeListXML',  '00000000000000000000', 'CCMMergeGetMediaTypeListXML', '00000000000000000000')
GO

