

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMMergeCommservClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCMMergeCommservClient.sp,v $ $Id: CCMMergeCommservClient.sp,v 1.1.2.6.6.3 2021/05/24 18:09:24 pnara Exp $";
--
--  +========================================================================+
--  |      procedure:  CCMMergeCommservClient
--  |
--  | Description:  Merges the Client from the xml
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCMMergeCommservClient')
BEGIN
	print '>>> Drop Stored Procedure: CCMMergeCommservClient <<<'
	drop procedure CCMMergeCommservClient
END
IF EXISTS (select * from GxQscripts where name='CCMMergeCommservClient')
	delete from GxQscripts where name = 'CCMMergeCommservClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMMergeCommservClient')
	delete from GXDBVersions where aliasname = 'CCMMergeCommservClient'
GO
print '... Creating Procedure: CCMMergeCommservClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCMMergeCommservClient
  @i_CommservClientXml xml,
  @i_flags integer
AS
-- Following are the "columns" returned, in the order in which they are returned
EXECUTE AS LOGIN = 'sqladmin_cv'
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @errorCode integer
	DECLARE @errorString varchar(1024)
	DECLARE @App_ClientXml xml
	DECLARE @newOrigCCid integer
	DECLARE @oldOrigCCid integer
	DECLARE @newClientId integer
	DECLARE @ccmParamFlags integer
	SET @newClientId = 0
	SET @ccmParamFlags = 0
	SET @errorCode = -1
	SET @errorString = 'GENERAL ERROR'
	SET @App_ClientXml =  @i_CommservClientXml
	DECLARE @flags integer
	SET @flags = @i_flags
	begin try
	IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Client]'))
		DROP TABLE #CCM_APP_Client
	CREATE TABLE #CCM_APP_Client (
		id					INTEGER NOT NULL,
		name			    nvarchar(255)   NOT NULL,
		simOperatingSystemId		integer NOT NULL,
		net_hostname	    nvarchar(255)   NOT NULL,
		client_password	    nvarchar(255)   NOT NULL,
		refTime				INTEGER NOT NULL,
		modified			INTEGER NOT NULL,
		offlineEntity		integer NOT NULL,
		offlineTimeStamp	INTEGER NOT NULL,
		csHostName			nvarchar(255)   NOT NULL,
		clientDescription	nvarchar(MAX) NOT NULL,
		jobResultDir		nvarchar(255)   NOT NULL,
		clientSkewTime		integer NOT NULL,
		cvdPort             integer NOT NULL,
		evmgrcPort			integer NOT NULL,
		status				integer NOT NULL,
		releaseId			integer NOT NULL,
		spaceCheckFlags		integer NOT NULL,
		ccpId				integer Default 0 NOT NULL,
		ccpTime				INTEGER Default 0 NOT NULL,
		origCCId			integer		DEFAULT		2 NOT NULL,
		GUID				uniqueidentifier ROWGUIDCOL,
		specialClientFlags	integer Default 0 NOT NULL,
		displayName			nvarchar(255) DEFAULT '' NULL,
		)
	IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_CommCell]'))
		DROP TABLE #CCM_APP_CommCell
	CREATE TABLE #CCM_APP_CommCell (
		id					INTEGER NOT NULL,
		number				integer NOT NULL,
		clientId			integer NOT NULL,
		parentId			integer NOT NULL,
		aliasName			nvarchar(256)   NOT NULL,
		flags				integer NOT NULL,
		refTime				INTEGER NOT NULL,
		userName			nvarchar(256)   NOT NULL,
		userPassword		nvarchar(1024)   NOT NULL,
		smtpServer			nvarchar(256)   NOT NULL,
		timeZone			nvarchar(1024)   NOT NULL,
		ipAddress			nvarchar(25)   NOT NULL,
		modified			INTEGER NOT NULL,
		ccOpMode			integer NOT NULL,
		drIpAddress			nvarchar(25)   NOT NULL,
		encNumber			nvarchar(256)   NOT NULL,
		csGUID				nvarchar(40)   NOT NULL,
		type				tinyint default 1 NOT NULL,
		)
	IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[#CCM_APP_Platform]'))
		DROP TABLE #CCM_APP_Platform
	CREATE TABLE #CCM_APP_Platform (
		clientId		integer	NOT NULL,	-- clientId maps to client table
		platformType	integer	NOT NULL,	-- CV Platform Type defines in CVPlatformInfo.h
		install_dir				nvarchar(255) NOT NULL,
		refTime			INTEGER  NOT NULL
		)
    IF OBJECT_ID('tempdb.dbo.#CCM_MAP_CommCell') IS NOT NULL
        DROP TABLE #CCM_MAP_CommCell
    CREATE TABLE #CCM_MAP_CommCell (
        old_id int,
        new_id int,
        number int,
        aliasName nvarchar(512),
        type tinyint,
        csGUID nvarchar(40),
		exist int
        )
	IF OBJECT_ID('tempdb..#CCM_MAP_Client') IS NOT NULL
		DROP TABLE #CCM_MAP_Client
	CREATE TABLE #CCM_MAP_Client
	(
		old_id int,
		new_id int,
		old_name nvarchar(255),
		new_name nvarchar(255),
		old_net_hostname nvarchar(255),
		new_net_hostname nvarchar(255),
		old_origCCcommCellId int,
		new_origCCcommCellId int,
		reuseOldId int,
		exist int
	)
	INSERT INTO #CCM_APP_Client
	SELECT tbl.col.value('@id','integer'),
	       tbl.col.value('@name','nvarchar(255)'),
	       tbl.col.value('@simOperatingSystemId','integer'),
	       tbl.col.value('@net_hostname','nvarchar(255)'),
	       tbl.col.value('@client_password','nvarchar(255)'),
	       tbl.col.value('@refTime', 'integer'),
	       tbl.col.value('@modified', 'integer'),
	       tbl.col.value('@offlineEntity', 'integer'),
	       tbl.col.value('@offlineTimeStamp', 'integer'),
	       tbl.col.value('@csHostName', 'nvarchar(255)'),
	       tbl.col.value('@clientDescription', 'nvarchar(MAX)'),
	       tbl.col.value('@jobResultDir', 'nvarchar(255)'),
	       tbl.col.value('@clientSkewTime', 'integer'),
	       tbl.col.value('@cvdPort', 'integer'),
	       tbl.col.value('@evmgrcPort', 'integer'),
	       tbl.col.value('@status', 'integer'),
	       tbl.col.value('@releaseId', 'integer'),
	       tbl.col.value('@spaceCheckFlags', 'integer'),
	       tbl.col.value('@ccpId', 'integer'),
	       tbl.col.value('@ccpTime', 'integer'),
	       tbl.col.value('@origCCId', 'integer'),
	       tbl.col.value('@GUID', 'uniqueidentifier'),
	       tbl.col.value('@specialClientFlags', 'integer'),
	       ISNULL (tbl.col.value('@displayName', 'nvarchar(255)'), tbl.col.value('@name','nvarchar(255)'))
	FROM   @App_ClientXml.nodes('CommServClientData/APP_Client/row') tbl(col)
	INSERT INTO #CCM_APP_CommCell
	SELECT tbl.col.value('@id','integer'),
	       tbl.col.value('@number','integer'),
	       tbl.col.value('@clientId','integer'),
	       tbl.col.value('@parentId','integer'),
	       tbl.col.value('@aliasName','nvarchar(256)'),
	       tbl.col.value('@flags', 'integer'),
	       tbl.col.value('@refTime', 'integer'),
	       tbl.col.value('@userName', 'nvarchar(256)'),
	       tbl.col.value('@userPassword', 'nvarchar(1024)'),
	       tbl.col.value('@smtpServer', 'nvarchar(256)'),
	       tbl.col.value('@timeZone', 'nvarchar(1024)'),
	       tbl.col.value('@ipAddress', 'nvarchar(25)'),
	       tbl.col.value('@modified', 'integer'),
	       tbl.col.value('@ccOpMode', 'integer'),
	       tbl.col.value('@drIpAddress', 'nvarchar(25)'),
	       tbl.col.value('@encNumber', 'nvarchar(256)'),
	       tbl.col.value('@csGUID', 'nvarchar(40)'),
	       tbl.col.value('@type', 'tinyint')
	FROM   @App_ClientXml.nodes('CommServClientData/APP_CommCell/row') tbl(col)
	INSERT INTO #CCM_APP_Platform
	SELECT tbl.col.value('@clientId','integer'),
				 tbl.col.value('@platformType','integer'),
				 tbl.col.value('@install_dir','nvarchar(255)'),
			 	 tbl.col.value('@refTime','integer')
	FROM   @App_ClientXml.nodes('CommServClientData/APP_Platform/row') tbl(col)
	IF (SELECT count(*) from #CCM_App_Client) > 1
	BEGIN
		SET @errorString = 'Does not support merge of more than one App_Client row'
		RAISERROR ('%%s' , 16, 1, @errorString)
	END
	IF (SELECT count(*) from #CCM_App_Client) < 1
	BEGIN
		SET @errorString = 'No client rows to merge'
		RAISERROR ('%%s' , 16, 1, @errorString)
	END
	--------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM CCM_Merge_CommCell.spb  ----------
	IF EXISTS (SELECT *
FROM #CCM_App_CommCell
WHERE type NOT IN (1,
100,
101,
102,
104,
105,
106,
108,
109
	                              ))
	BEGIN
	    SET @errorString = 'ERROR: CCM_Merge_CommCell -- Unknown Commcell Type in Captured database'
		GOTO CX_ERROR_EXIT
	END
	-- Update CommCell entry created by tape import.
	UPDATE APP_CommCell
	SET parentId = B.parentId,
		aliasName = B.aliasName,
		flags = B.flags,
		refTime = B.refTime,
		userName = B.userName,
		userPassword = B.userPassword,
		smtpServer = B.smtpServer,
		timeZone = B.timeZone,
		ipAddress = B.ipAddress,
		modified = B.modified,
		ccOpMode = B.ccOpMode,
		drIpAddress = B.drIpAddress,
		encNumber = B.encNumber,
		csGUID = B.csGUID,
		type = B.type
FROM APP_CommCell A INNER JOIN #CCM_App_CommCell B ON A.number = B.number
	WHERE A.aliasName LIKE 'TapeImportedCommCell_%'
		AND A.csGUID = ''
		AND B.csGUID <> ''
	IF	@@ERROR > 0
	BEGIN
	    SET @errorString = 'ERROR: CCM_Merge_CommCell -- Update tape import created commcell entry.'
		GOTO CX_ERROR_EXIT
	END
	--Check for duplicate GUID with different number
	/* IF NOT EXISTS (SELECT 1 FROM MMConfigs where name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_DUPLICATE_GUID' and value = 1)
	BEGIN
		IF EXISTS
		(
	*/		--Check in source and destination
			INSERT INTO APP_InvalidGUID(GUID)
			SELECT DISTINCT a.csGUID
FROM #CCM_App_CommCell a INNER JOIN APP_Commcell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	/*	)
		BEGIN
			SET @errorString = 'ERROR: Duplicate GUIDs with different CommcellId found in source and destination CommServes. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following GUIDs are associated with more than one CommCellId'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  b.csGUID
FROM #CCM_App_CommCell a INNER JOIN APP_Commcell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
			GOTO CX_ERROR_EXIT
		END
	*/
	/*	IF EXISTS
		(
	*/		--Check in source and source
			INSERT INTO APP_InvalidGUID(GUID)
			SELECT DISTINCT a.csGUID
FROM #CCM_App_CommCell a INNER JOIN #CCM_App_CommCell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	/*	)
		BEGIN
			SET @errorString = 'ERROR: Duplicate GUIDs with different CommcellId found in source CommServe. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following GUIDs are associated with more than one CommCellId'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  b.csGUID
FROM #CCM_App_CommCell a INNER JOIN #CCM_App_CommCell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
			GOTO CX_ERROR_EXIT
		END
	*/
	/*	IF EXISTS
		(
	*/		--Check in destination and destination
			INSERT INTO APP_InvalidGUID(GUID)
			SELECT DISTINCT a.csGUID
			FROM APP_CommCell a INNER JOIN APP_CommCell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	/*	)
		BEGIN
			SET @errorString = 'ERROR: Duplicate GUIDs with different CommcellId found in destination CommServe. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following GUIDs are associated with more than one CommCellId'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  b.csGUID
			FROM APP_CommCell a INNER JOIN APP_CommCell b
				ON a.csGUID = b.csGUID AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.number <> b.number
				AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
			GOTO CX_ERROR_EXIT
		END
	END
	*/
	--Check for duplicate number with different GUID
	IF NOT EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_DUPLICATE_GUID' and value <> 0)
	BEGIN
		IF EXISTS
		(
			SELECT 1
FROM #CCM_App_CommCell a INNER JOIN APP_Commcell b
				ON a.number = b.number AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND LEN(a.csGUID) > 0 AND a.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.csGUID <> b.csGUID
		)
		BEGIN
			SET @errorString = 'ERROR: Duplicate CommcellId with different GUIDs found in source and destination CommServes. Please contact customer support.'
			SET @errorString = @errorString + CHAR(13) + CHAR(10) + 'Following CommCellId is associated with more than one GUID'
			SELECT @errorString = @errorString + CHAR(13) + CHAR(10) +  CONVERT(varchar, b.number)
FROM #CCM_App_CommCell a INNER JOIN APP_Commcell b
				ON a.number = b.number AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND LEN(a.csGUID) > 0 AND a.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.csGUID <> b.csGUID
			GOTO CX_ERROR_EXIT
		END
	END
/*	Code change to allow merging of different commcells using same license number together
	 Please note that we are checking for value = 2 here as this allows for the following:
	- default: error out if we encounter two commcells with same license but different guids (value not present or == 0)
	- allow merging two commcell's data with different guids but same license together into a single commcell (value == 1)
	   (means that we treat the commcells with same license numbers as the same commcell even if guids are different)
	- allow merging two commcell's data with different guids but same license together where different guids are
		interpreted as different commcells (value == 2 what this update is for)
  */
	IF EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_DUPLICATE_GUID' and value = 2)
	BEGIN
	  /* Change to allow importing data from two different commcells with different guids that have the same license number as
		  two different commcells */
UPDATE  #CCM_App_CommCell
		SET number = -1
FROM #CCM_App_CommCell a INNER JOIN APP_Commcell b
				ON a.number = b.number AND a.type = b.type
WHERE a.type = 1   -- SIMPANA Commcells
				AND LEN(b.csGUID) > 0 AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND LEN(a.csGUID) > 0 AND a.csGUID <> '00000000-0000-0000-0000-000000000000'
				AND a.number <> -1 AND b.number <> -1
				AND a.csGUID <> b.csGUID
	-- Setting the number to -1 in the merge db does the following:
	--     - it updates the incoming entry with same number and different guid to -1 in the merge db
	--     - it gets inserted as such in the mapping table.
	--	   -  the query mapping same numbers together will not hit as numbers are different
	-- 	   -  the query that updates a commcell number from unlicensed to licensed will also not pick this up as
	--         this is licensed in the CSDB but not in the merge db, so everything will work...
	END
	-- GET CommCellId TO BE MERGED
INSERT INTO #CCM_MAP_CommCell
	SELECT DISTINCT id, 0, number, aliasName, type, csGUID, 0
FROM #CCM_App_CommCell
	WHERE number <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	/*PrasadNara 1:56 PM 6/22/2012
	 * RackSpace has many commcells with the same guid 'D3DA843D-9BC8-4396-8782-88D73B6C7DBA', so treat it as invalid guid.
	 */
UPDATE #CCM_MAP_CommCell SET new_id = b.id
FROM #CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.csGUID = b.csGUID
	AND a.type = b.type
AND a.type = 1   -- SIMPANA Commcells
	AND LEN(b.csGUID) > 0
	AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
	AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMPANA 1 - GUID Based'
		GOTO CX_ERROR_EXIT
	END
UPDATE #CCM_MAP_CommCell SET new_id = b.id
FROM #CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.number = b.number
	AND a.type = b.type
AND a.type = 1   -- SIMPANA Commcells
	AND a.new_id = 0
	AND a.number <> -1
	AND b.number <> -1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMPANA 1 - number based'
		GOTO CX_ERROR_EXIT
	END
	-- If commcell no is -1 and CS GUID is 00000000-0000-0000-0000-000000000000
	-- then assume that the data is from current commcell. This is to support
	-- tape catalog of media written with eval licenses
UPDATE  #CCM_MAP_CommCell SET new_id = 2
	WHERE new_id = 0 AND number = -1
	AND csGUID = '00000000-0000-0000-0000-000000000000'
	AND type = 1
UPDATE #CCM_MAP_CommCell SET new_id = b.id
FROM #CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.aliasName = b.aliasName
	AND a.type = b.type
AND a.type IN (100,101,102,104,105,106, 108, 109)   -- Non-SIMPANA Commcells like NetApp, NetBackup etc
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- NON-SIMPANA 1'
		GOTO CX_ERROR_EXIT
	END
	--
	-- PrasadNara 12:28 PM 11/21/2012
	-- Update the commcell number if it is migrated previously with eval license
	-- and migrating it again after applying license.
	--
	UPDATE APP_CommCell
	SET number = a.number
FROM #CCM_MAP_CommCell a INNER JOIN APP_CommCell b
		ON a.new_id = b.id
	WHERE a.number <> -1 AND b.number = -1 AND b.id > 2
		AND NOT EXISTS(SELECT 1 FROM App_CommCell WHERE number = a.number)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- APP_CommCell -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
UPDATE #CCM_MAP_CommCell
	SET exist = 1
	WHERE new_id <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- APP_CommCell -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO APP_CommCell
	SELECT	b.number, 0, b.parentId, b.aliasName, b.flags, b.refTime,
			b.userName, b.userPassword, b.smtpServer, b.timeZone, b.ipAddress,
			b.modified, b.ccOpMode, b.drIpAddress, b.encNumber, b.csGUID, b.type
FROM #CCM_MAP_CommCell a, #CCM_App_CommCell b
	WHERE a.old_id = b.id AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- APP_CommCell -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	/*
UPDATE #CCM_MAP_CommCell SET new_id = b.id
FROM #CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.number = b.number AND a.new_id = 0
	AND a.type = b.type
AND a.type = 1 -- SIMPANA Commcells
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMAPANA -- 2'
		GOTO CX_ERROR_EXIT
	END
	*/
	/*
	Updating the map table for the new rows inserted in destination App_Commcell - based in GUIDs not based on numbers
	change to support migration even with eval License (number will be -1)
	*/
UPDATE #CCM_MAP_CommCell SET new_id = b.id
FROM #CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.csGUID = b.csGUID AND a.new_id = 0
	AND a.type = b.type
AND a.type = 1 -- SIMPANA Commcells
	AND LEN(b.csGUID) > 0
	AND b.csGUID <> '00000000-0000-0000-0000-000000000000'
	AND b.csGUID NOT IN (SELECT CONVERT(varchar(36), GUID) FROM APP_InvalidGUID)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMAPANA -- 2'
		GOTO CX_ERROR_EXIT
	END
	--Update the map table based on number incase of empty GUID
UPDATE #CCM_MAP_CommCell SET new_id = b.id
FROM #CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.number = b.number AND a.new_id = 0
	AND a.type = b.type
AND a.type = 1 -- SIMPANA Commcells
	AND b.id > 1
	AND a.number <> -1
	AND b.number <> -1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- SIMAPANA -- 3'
		GOTO CX_ERROR_EXIT
	END
UPDATE #CCM_MAP_CommCell SET new_id = b.id
FROM #CCM_MAP_CommCell a, APP_CommCell b
	WHERE a.aliasName = b.aliasName AND a.new_id = 0
	AND a.type = b.type
AND a.type IN (100,101,102,104,105,106, 108, 109) -- Non-SIMPANA Commcells like NetApp, NetBackup etc
	AND b.id > 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- UPDATE -- NON-SIMAPANA -- 2'
		GOTO CX_ERROR_EXIT
	END
	--Fail merge incase of new commcell id is 0 or 1
IF EXISTS(SELECT 1 FROM #CCM_MAP_CommCell WHERE new_id = 0 OR new_id = 1)
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_CommCell -- CCM_MAP_CommCell -- new_id is 0 or 1'
		GOTO CX_ERROR_EXIT
	END
    --------------------------------------------------------------------------------------------------
	/* We are not expecting more than one commcell entry in the table so we let it fail if it has more than one entry */
select @newOrigCCid = a.new_id, @oldOrigCCid = a.old_id from #CCM_MAP_CommCell a, #CCM_App_CommCell b where a.old_id = b.id
	IF @newOrigCCid IS NULL OR @newOrigCCid = 0
	BEGIN
			SET @errorCode = -1
			SET @errorString = 'Failed to merge commcell.'
			GOTO CX_ERROR_EXIT
	END
IF EXISTS (SELECT 1 FROM #CCM_MAP_CommCell WHERE new_id = @newOrigCCid AND exist = 0) /* New commcell registration */
	begin
		--set property in grc_commcellprop table based on registration
IF (2 & @flags) > 0
		BEGIN
			INSERT INTO GRC_CommCellProp
VALUES(@newOrigCCid, 27, 2 /*PROPERTY_BOOLEAN*/, 1, 0, '', dbo.getunixtime(getdate()), 0)
		END
ELSE IF (4 & @flags) > 0
		BEGIN
			INSERT INTO GRC_CommCellProp
VALUES(@newOrigCCid, 26, 2 /*PROPERTY_BOOLEAN*/, 1, 0, '', dbo.getunixtime(getdate()), 0)
		END
ELSE IF (8 & @flags) > 0
		BEGIN
			INSERT INTO GRC_CommCellProp
VALUES(@newOrigCCid, 31, 2 /*PROPERTY_BOOLEAN*/, 1, 0, '', dbo.getunixtime(getdate()), 0)
		END
ELSE IF (16 & @flags) > 0
		BEGIN
			INSERT INTO GRC_CommCellProp
VALUES(@newOrigCCid, 33, 2 /*PROPERTY_BOOLEAN*/, 1, 0, '', dbo.getunixtime(getdate()), 0)
		END
	end
	else /* Commcell already registered or commcell already exists */
	begin
		--Do not allow online registration if its already offline registered vice versa.
IF (16 & @flags) > 0
AND EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId IN (27, 26, 31) AND longVal = 1)
		BEGIN
			SET @errorCode = -1
			SET @errorString = 'Offline registration is not allowed since CommCell is already registered online. ADVICE: If online registration is not required then do unregister before doing offline registration.'
			GOTO CX_ERROR_EXIT
		END
ELSE IF (16 & @flags) = 0
AND EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 33 AND longVal = 1)
		BEGIN
			SET @errorCode = -1
			SET @errorString = 'Online registration is not allowed since CommCell is already registered offline. ADVICE: If offline registration is not required then do unregister before doing online registration'
			GOTO CX_ERROR_EXIT
		END
		--set property in grc_commcellprop table based on registration
IF (2 & @flags) > 0
		BEGIN
IF NOT EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 27)
				INSERT INTO GRC_CommCellProp
VALUES(@newOrigCCid, 27, 2 /*PROPERTY_BOOLEAN*/, 1, 0, '', dbo.getunixtime(getdate()), 0)
ELSE IF EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 27 AND longVal = 0)
				UPDATE GRC_CommCellProp
SET longVal = 1 WHERE commcellId = @newOrigCCid AND propId = 27
			--Reset 9.0 registration flag if it was registered in v9 and user re-registering after upgrade
IF EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 31 AND longVal = 1)
				UPDATE GRC_CommCellProp
SET longVal = 0 WHERE commcellId = @newOrigCCid AND propId = 31
		END
ELSE IF (4 & @flags) > 0
		BEGIN
IF NOT EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 26)
				INSERT INTO GRC_CommCellProp
VALUES(@newOrigCCid, 26, 2 /*PROPERTY_BOOLEAN*/, 1, 0, '', dbo.getunixtime(getdate()), 0)
ELSE IF EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 26 AND longVal = 0)
				UPDATE GRC_CommCellProp
SET longVal = 1 WHERE commcellId = @newOrigCCid AND propId = 26
			--Reset 9.0 registration flag if it was registered in v9 and user re-registering after upgrade
IF EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 31 AND longVal = 1)
				UPDATE GRC_CommCellProp
SET longVal = 0 WHERE commcellId = @newOrigCCid AND propId = 31
		END
ELSE IF (8 & @flags) > 0
		BEGIN
IF NOT EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 31)
				INSERT INTO GRC_CommCellProp
VALUES(@newOrigCCid, 31, 2 /*PROPERTY_BOOLEAN*/, 1, 0, '', dbo.getunixtime(getdate()), 0)
ELSE IF EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 31 AND longVal = 0)
				UPDATE GRC_CommCellProp
SET longVal = 1 WHERE commcellId = @newOrigCCid AND propId = 31
		END
ELSE IF (16 & @flags) > 0
		BEGIN
IF NOT EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 33)
				INSERT INTO GRC_CommCellProp
VALUES(@newOrigCCid, 33, 2 /*PROPERTY_BOOLEAN*/, 1, 0, '', dbo.getunixtime(getdate()), 0)
ELSE IF EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 33 AND longVal = 0)
				UPDATE GRC_CommCellProp
SET longVal = 1 WHERE commcellId = @newOrigCCid AND propId = 33
		END
		--Reset disabled flag
IF EXISTS(SELECT 1 FROM GRC_CommCellProp WHERE commcellId = @newOrigCCid AND propId = 30 AND longVal = 1)
			UPDATE GRC_CommCellProp
SET longVal = 0 WHERE commcellId = @newOrigCCid AND propId = 30
	end
	if (@newOrigCCid IS NOT NULL AND @newOrigCCid <> 0)
	begin
		SET @errorString = 'ERROR: GENERAL ERROR!'
		--------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM CCM_Merge_Client.spb  ----------
	DECLARE @tblBeforeMerge TABLE (id INT)
	DECLARE @Merge_To_Same_CommCell int
IF EXISTS (SELECT * FROM #CCM_MAP_CommCell WHERE new_id = 2 and old_id = 2)
		SET @Merge_To_Same_CommCell = 1
	ELSE
		SET @Merge_To_Same_CommCell = 0
	DECLARE	@tmpFileSystemAppType TABLE ( appTypeId integer)
	INSERT	@tmpFileSystemAppType
	SELECT	DISTINCT type FROM APP_idaType WHERE displayName = 'File System'
-- DB: fix changed tabls
DECLARE @dummy_ccpId INTEGER
SET @dummy_ccpId = 0
DECLARE @dummy_ccpTime INTEGER
SET @dummy_ccpTime = 0
DECLARE @dummy_GUID NVARCHAR(max)
SET @dummy_GUID = '00000000-0000-0000-0000-000000000000'
DECLARE @migratedClientFlag INTEGER = 0x20
IF (@ccmParamFlags & 8) = 8
SET @migratedClientFlag = (@migratedClientFlag | 0x200)
	ELSE
SET @migratedClientFlag = (@migratedClientFlag | 0x2)
	DECLARE @l_RowCount int = 0
	DECLARE @l_ErrorCode int = 0
/*
	-------------------------------------------------------------------------------------------------------------------------------------
	     Source Commcell             Destination Commcell           exists            Action
	Name   hostname  origCCId      Name    hostname    oridCCId
	-------------------------------------------------------------------------------------------------------------------------------------
	 A        B         2                                             0        First Time Merge, proceed fine
	 A        B         2           A         B           3           1        Number corresponding to 2 and 3 are same, Remerge usecase
	 A        B         2           A       non-B         3           1        Number corresponding to 2 and 3 are same ???
	 A        B         2         non-A       B           3           1        Number corresponding to 2 and 3 are same ???
	 A        B         2         non-A     non-B         3           1        Merge of a new client, first time merge
	 A        B         2           A         B           3           0        Number corresponding to 2 and 3 are different
	                                                                           ???
     A        B         2           A       non-B         3           0        Number corresponding to 2 and 3 are different
	                                                                           ???
     A        B         2         non-A       B           3           0        Number corresponding to 2 and 3 are different
	                                                                           ???
     A        B         2         non-A     non-B         3           0        Number corresponding to 2 and 3 are different
																			   First time merge, proceed fine
	-------------------------------------------------------------------------------------------------------------------------------------
*/
	-- Merge APP_Client table
UPDATE #CCM_App_Client
	SET    origCCId = 2
	WHERE  origCCId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_Client -- UPDATE -- origCCId'
		GOTO CX_ERROR_EXIT
	END
	IF (@ccmParamFlags & 1) = 1
	BEGIN
		--For GRC mark client as GRC migrated client and set flag if client is uninstalled in source
UPDATE #CCM_App_Client
SET    specialClientFlags = CASE (specialClientFlags & 0x2) WHEN 0 THEN (specialClientFlags | 0x80)
ELSE (specialClientFlags | 0x80 | 0x40) END
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_Client -- UPDATE -- specialClientFlags'
			GOTO CX_ERROR_EXIT
		END
		-- If client is deconfigured on source then set flag.
UPDATE #CCM_App_Client
SET    specialClientFlags = specialClientFlags | 0x40
FROM #CCM_App_Client CL
WHERE CL.status & 0x00002 = 0x00002
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_Client -- UPDATE 2 -- specialClientFlags'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Set csHostName for discovered VMs.
	/*
	DECLARE @csHostName VARCHAR(1024)
	SET @csHostName = ( SELECT net_hostname FROM APP_Client WHERE id = 2 )
UPDATE #CCM_App_Client
	SET csHostName = @csHostName
FROM #CCM_App_Client
WHERE specialClientFlags & 0xB = 0xB
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_DB_APP_CLIENT -- Failed to set csHostName for Discovered VMs'
		GOTO CX_ERROR_EXIT
	END
	*/
	-- GET ClientId TO BE MERGED
INSERT INTO #CCM_MAP_Client
	SELECT DISTINCT id, 0, name, name, net_hostname, net_hostname, origCCId, 0, 0, 0
FROM #CCM_App_Client
	-- Remove the ones has no Client Id. It may come from Tape Import
	WHERE id > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Update the new_origCCcommCellId
	-- old_origCCcommCellId will never have 0 as it is always defaulted to 2
UPDATE #CCM_MAP_Client SET new_origCCcommCellId = ISNULL((SELECT new_id FROM #CCM_MAP_CommCell WHERE old_id = old_origCCcommCellId), (SELECT new_id FROM #CCM_MAP_CommCell WHERE old_id = 2 /*Source CS*/))
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_origCCcommCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE App_Client
	SET --name = mapC.new_name,
		simOperatingSystemId = srcC.simOperatingSystemId,
		--net_hostname = mapC.new_net_hostName,
		client_password = srcC.client_password,
		refTime = srcC.refTime,
		modified = srcC.modified,
		offlineEntity = srcC.offlineEntity,
		offlineTimeStamp = srcC.offlineTimeStamp,
		csHostName = srcC.csHostName,
		clientDescription = srcC.clientDescription,
		jobResultDir = srcC.jobResultDir,
		clientSkewTime = srcC.clientSkewTime,
		cvdPort = srcC.cvdPort,
		evmgrcPort = srcC.evmgrcPort,
		status = srcC.status,
		releaseId = srcC.releaseId,
		spaceCheckFlags = srcC.spaceCheckFlags,
		ccpId = srcC.ccpId,
		ccpTime = srcC.ccpTime,
		origCCId = mapC.new_origCCcommCellId,
		GUID = srcC.GUID,
		specialClientFlags = CASE WHEN @Merge_To_Same_CommCell > 0 THEN srcC.specialClientFlags ELSE (srcC.specialClientFlags | @migratedClientFlag) END
FROM App_Client destC, #CCM_MAP_Client mapC, #CCM_App_Client srcC
	WHERE destC.origCCId = 2
	AND destC.id > 2
	AND (destC.specialClientFlags & 2) > 0
	AND (destC.name = mapC.new_name OR destC.net_hostname = mapC.new_net_hostName)
	AND mapC.old_id = srcC.id
	AND srcC.id  = 2
	AND srcC.origCCId = 2
	AND srcC.net_hostName <> ''
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- Update CommNet DummyClient Row'
		GOTO CX_ERROR_EXIT
	END
	/*
	 *PrasadNara: 10:33 AM 6/20/2012 Set exist based on below conditions
	 * If client guid matches consider that as remerge of same client
	 * If client guid does NOT match but both client Name and Host Name matches then treat it as remerge case only when config param is set or for EDC or for TapeImport
	 * If client guid does NOT match, client name does NOT match, client host name matches consider that as new entry and merge successfully
	 * If client guid does NOT match, client name matches, client host name does NOT match fail saying name conflict
	 * If client guid does NOT match, both client name and client host name does NOT match consider that as new entry and merge successfully
	 */
	--Match with GUID
UPDATE #CCM_MAP_Client SET exist = 1, new_id = b.id
FROM #CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE a.old_id = c.id AND b.GUID = c.GUID
		AND LEN(b.GUID) > 0 AND b.GUID <> '00000000-0000-0000-0000-000000000000'
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE exist matching GUID'
		GOTO CX_ERROR_EXIT
	END
	--Client name and net host name both matches
	IF EXISTS (SELECT 1 FROM MMConfigs where name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_CLIENT_GUID_CONFLICT' and value = 1)
    BEGIN
		-- net_hostname will be empty for client migrated through tape import
UPDATE #CCM_MAP_Client SET exist = 1, new_id = b.id
FROM #CCM_MAP_Client a, APP_Client b
		WHERE a.new_name = b.name
		AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
		AND exist <> 1
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE exist'
			GOTO CX_ERROR_EXIT
		END
	END
	--Match with name and hostname where GUID doesn't exists
UPDATE #CCM_MAP_Client SET exist = 1, new_id = b.id
FROM #CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE a.new_name = b.name
		AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
		AND (LEN(c.GUID) = 0 OR c.GUID = '00000000-0000-0000-0000-000000000000')
		AND exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE exist matching name and hostname'
		GOTO CX_ERROR_EXIT
	END
	UPDATE 	APP_Client
	SET 	name = b.name + '_old_' + CAST(b.id AS NVARCHAR(64)),
			net_hostname = b.net_hostname + '_old_' + CAST(b.id AS NVARCHAR(64))
FROM 	#CCM_MAP_Client a
		INNER JOIN APP_Client b ON a.new_name = b.name
		INNER JOIN APP_ClientProp c ON c.componentNameId = b.id AND c.attrName = 'OwnerCommCellId'
INNER JOIN #CCM_App_Client e ON a.old_id = e.id
INNER JOIN #CCM_MAP_CommCell d ON d.new_id = CAST(c.attrVal AS INT) AND d.old_id = 2
	WHERE	a.exist = 0
		AND e.GUID <> b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new name for index clients.'
		GOTO CX_ERROR_EXIT
	END
	--Update name if it's changed in source
	--Before update check if new name is conflicting with any other existing clients on destination
	IF OBJECT_ID('tempdb..#lt_ClientNameConflict') IS NOT NULL DROP TABLE #lt_ClientNameConflict
	CREATE TABLE #lt_ClientNameConflict (name nvarchar(512), destNetHostName nvarchar(512), destGUID uniqueidentifier, srcNetHostName nvarchar(512), srcGUID uniqueidentifier)
	IF OBJECT_ID('tempdb..#lt_ClientConflict') IS NOT NULL DROP TABLE #lt_ClientConflict
	CREATE TABLE #lt_ClientConflict (oldClientId INT)
	INSERT 	INTO #lt_ClientConflict
	SELECT 	a.old_id
FROM 	#CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE	a.exist = 1
			AND a.old_id = c.id
			AND a.new_id <> b.id
			AND a.new_name = b.name
AND	(b.specialClientFlags & 0x20) > 0
	SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
	IF	@l_ErrorCode > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Existing Client Name Conflict'
		GOTO CX_ERROR_EXIT
	END
	IF @l_RowCount > 0
	BEGIN
UPDATE 	#CCM_MAP_Client
		SET 	new_name = a.new_name + '_CCM_' + CAST(dbo.GetUnixTime(getDate()) AS NVARCHAR(256))
FROM 	#CCM_MAP_Client a INNER JOIN #lt_ClientConflict b ON a.old_Id = b.oldClientId
	END
	--Before updating name check for Host Name and CVD port conflict
	IF NOT EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_ALLOW_CCM_FOR_CLIENTS_WITH_SAME_HOSTNAME_CVDPORT' AND value = 1)
	BEGIN
		INSERT 	INTO #lt_ClientNameConflict
		SELECT 	b.name, b.net_hostname destNetHostName, b.guid destGUID, a.new_net_hostname srcNetHostName, c.guid srcGUID
FROM 	#CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
		WHERE	a.exist = 1
				AND a.old_id = c.id
				AND a.new_id <> b.id
				AND a.new_net_hostname = b.net_hostname
				AND a.new_net_hostname <> ''
				AND c.cvdPort = b.cvdPort
AND	(b.specialClientFlags & 0x20) > 0
		SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
		IF	@l_ErrorCode > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Existing Client HostName and CVD port Conflict'
			GOTO CX_ERROR_EXIT
		END
		IF @l_RowCount > 0
		BEGIN
			SET @errorString = 'ERROR: Client hostname and CVD port conflict. ADVICE: 1. Change the clients host name either on source CommServe or destination CommServe. OR  2. Set "Allow CCM job when multiple clients exists with same host name and cvd port" parameter value to 1 in Media Management configuration when duplicate host name is expected.'
			SELECT 	@errorString = @errorString + CHAR(13) + 'Client [' + name + '] already present with host name ['+ destNetHostName + '] and guid ['+ convert(varchar(50), destGUID) + ']. Importing client host name ['+ srcNetHostName + '] and guid ['+ convert(varchar(50), srcGUID) + '].'
			FROM #lt_ClientNameConflict
			GOTO CX_ERROR_EXIT
		END
	END
IF(1 & @flags) > 0 AND (16 & @flags) = 0
	--Update properties of existing clients
	UPDATE		APP_Client
	SET			name 				= b.new_name,
				net_hostname		= b.new_net_hostname,
				simOperatingSystemId= c.simOperatingSystemId,
				client_password		= c.client_password,
				refTime				= c.refTime,
				modified			= c.modified,
				offlineEntity       = c.offlineEntity,
				offlineTimeStamp	= c.offlineTimeStamp,
				clientDescription	= c.clientDescription,
				jobResultDir		= c.jobResultDir,
				clientSkewTime		= c.clientSkewTime,
				cvdPort				= c.cvdPort,
				evmgrcPort			= c.evmgrcPort,
				releaseId			= c.releaseId,
				spaceCheckFlags		= c.spaceCheckFlags,
				displayName			= c.displayName,
				status				= c.status
				 ,GUID                = c.GUID
,specialClientFlags  = (CASE @newOrigCCid WHEN 2 THEN a.specialClientFlags ELSE (c.specialClientFlags | 0x20 | 0x2) END)
FROM		APP_Client a, #CCM_MAP_Client b, #CCM_App_Client c
	WHERE		b.exist = 1
				AND	a.id = b.new_id AND b.old_id = c.id
AND	(a.specialClientFlags & 0x20) > 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- UPDATE Existing client properties'
		GOTO CX_ERROR_EXIT
	END
	--Check client name conflict
	DELETE #lt_ClientConflict
	INSERT INTO #lt_ClientConflict
	SELECT 	a.old_id
FROM 	#CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE 	a.exist = 0
			AND a.old_id = c.id
			AND a.new_name = b.name
	SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
	IF	@l_ErrorCode > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Client Name Conflict'
		GOTO CX_ERROR_EXIT
	END
	IF @l_RowCount > 0
	BEGIN
UPDATE 	#CCM_MAP_Client
		SET 	new_name = a.new_name + '_CCM_' + CAST(dbo.GetUnixTime(getDate()) AS NVARCHAR(256))
FROM 	#CCM_MAP_Client a INNER JOIN #lt_ClientConflict b ON a.old_Id = b.oldClientId
	END
	--Check for Host Name and CVD port conflict
	IF NOT EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_ALLOW_CCM_FOR_CLIENTS_WITH_SAME_HOSTNAME_CVDPORT' AND value = 1)
	BEGIN
		INSERT 	INTO #lt_ClientNameConflict
		SELECT 	b.name, b.net_hostname destNetHostName, b.guid destGUID, a.new_net_hostname srcNetHostName, c.guid srcGUID
FROM 	#CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
		WHERE	a.exist = 0
				AND a.old_id = c.id
				AND a.new_net_hostname = b.net_hostname
				AND a.new_net_hostname <> ''
				AND c.cvdPort = b.cvdPort
		SELECT @l_ErrorCode = @@ERROR, @l_RowCount = @@ROWCOUNT
		IF	@l_ErrorCode > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- INSERT Existing Client HostName and CVD port Conflict'
			GOTO CX_ERROR_EXIT
		END
		IF @l_RowCount > 0
		BEGIN
			SET @errorString = 'ERROR: Client hostname and CVD port conflict. ADVICE: 1. Change the clients host name either on source CommServe or destination CommServe. OR  2. Set "Allow CCM job when multiple clients exists with same host name and cvd port" parameter value to 1 in Media Management configuration when duplicate host name is expected.'
			SELECT 	@errorString = @errorString + CHAR(13) + 'Client [' + name + '] already present with host name ['+ destNetHostName + '] and guid ['+ convert(varchar(50), destGUID) + ']. Importing client host name ['+ srcNetHostName + '] and guid ['+ convert(varchar(50), srcGUID) + '].'
			FROM #lt_ClientNameConflict
			GOTO CX_ERROR_EXIT
		END
	END
	-- Old client id should be reused if merge to the same commserver and id not being resued
UPDATE	#CCM_MAP_Client SET reuseOldId = 1
FROM	#CCM_MAP_Client
	WHERE	@Merge_To_Same_CommCell > 0
	AND		old_id NOT IN (SELECT id FROM APP_Client)
	AND		exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE reuseOldId'
		GOTO CX_ERROR_EXIT
	END
	SET IDENTITY_INSERT APP_Client ON
	INSERT	INTO APP_Client (
			id, name, simOperatingSystemId, net_hostname,
			client_password, refTime, modified, offlineEntity,
			offlineTimeStamp, csHostName, clientDescription,
			jobResultDir, clientSkewTime, cvdPort, evmgrcPort, status, releaseId,
			spaceCheckFlags,ccpId,ccpTime,origCCId,GUID,specialClientFlags,displayName
			)
	SELECT	a.old_id, a.new_name, b.simOperatingSystemId, a.new_net_hostname, b.client_password, b.refTime,
			b.modified, b.offlineEntity, b.offlineTimeStamp, b.csHostName,
			b.clientDescription, b.jobResultDir, b.clientSkewTime,
			b.cvdPort, b.evmgrcPort, b.status, b.releaseId,
			b.spaceCheckFlags, b.ccpId, b.ccpTime, a.new_origCCcommCellId, b.GUID,
			CASE WHEN @Merge_To_Same_CommCell > 0 THEN b.specialClientFlags ELSE (b.specialClientFlags | @migratedClientFlag) END,
			b.displayName
FROM	#CCM_MAP_Client a, #CCM_App_Client b
	WHERE	a.old_name = b.name AND a.old_net_hostname = b.net_hostname
	AND		a.reuseOldId = 1
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET IDENTITY_INSERT APP_Client OFF
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- INSERT using old_Id'
		GOTO CX_ERROR_EXIT
	END
	SET IDENTITY_INSERT APP_Client OFF
-- DB: Fix Table Change
	INSERT	INTO APP_Client
	SELECT	a.new_name, b.simOperatingSystemId, a.new_net_hostname, b.client_password, b.refTime,
			b.modified, b.offlineEntity, b.offlineTimeStamp, b.csHostName,
			b.clientDescription, b.jobResultDir, b.clientSkewTime,
			b.cvdPort, b.evmgrcPort, b.status, b.releaseId,
			b.spaceCheckFlags, b.ccpId, b.ccpTime, a.new_origCCcommCellId, b.GUID,
			CASE WHEN @Merge_To_Same_CommCell > 0 THEN b.specialClientFlags ELSE (b.specialClientFlags | @migratedClientFlag) END,
			b.displayName
FROM	#CCM_MAP_Client a, #CCM_App_Client b
	WHERE	a.old_name = b.name AND a.old_net_hostname = b.net_hostname
	AND		a.reuseOldId = 0
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_Client -- INSERT creating new_Id'
		GOTO CX_ERROR_EXIT
	END
UPDATE	#CCM_MAP_Client SET new_id = b.id
FROM	#CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE	a.old_id = c.id AND b.GUID = c.GUID
			AND LEN(b.GUID) > 0 AND b.GUID <> '00000000-0000-0000-0000-000000000000'
			AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_id matching GUID'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (SELECT 1 FROM MMConfigs where name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_CLIENT_GUID_CONFLICT' and value = 1)
    BEGIN
UPDATE	#CCM_MAP_Client SET new_id = b.id
FROM	#CCM_MAP_Client a, APP_Client b
		WHERE	a.new_name = b.name AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
			AND a.new_id = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_id'
			GOTO CX_ERROR_EXIT
		END
	END
UPDATE	#CCM_MAP_Client SET new_id = b.id
FROM	#CCM_MAP_Client a, APP_Client b, #CCM_App_Client c
	WHERE	a.old_id = c.id
			AND a.new_name = b.name AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
			AND (LEN(c.GUID) = 0 OR c.GUID = '00000000-0000-0000-0000-000000000000')
			AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_MAP_Client -- UPDATE new_id matching name and hostname'
		GOTO CX_ERROR_EXIT
	END
	/*
	IF EXISTS(SELECT *
FROM   APP_Client a, #CCM_MAP_Client b, #CCM_App_Client c
	          WHERE  b.exist = 1
	          AND    a.id = b.new_id
	          AND    b.old_id = c.id
	          AND    c.releaseId < a.releaseId)
	BEGIN
		SET @errorString = 'ERROR: Source Clients are of older version'
		GOTO CX_ERROR_EXIT
	END
	*/
	----------------------------------------------------------
	-- If the clientId associated with the commcell is not migrated,
	-- reset it to 0
UPDATE #CCM_App_CommCell
	SET clientId = 0
WHERE clientId NOT IN (SELECT old_id FROM #CCM_MAP_Client)
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- CCM_APP_CommCell -- UPDATE -- clientId'
		GOTO CX_ERROR_EXIT
	END
-- Update clientId column of App_Commcell (#CCM_MAP_Client)
	-- for both fresh merge as well as re-merge use cases
	UPDATE APP_CommCell
	SET clientId = d.new_id
FROM APP_CommCell a, #CCM_MAP_CommCell b, #CCM_App_CommCell c, #CCM_MAP_Client d
	WHERE a.id = b.new_id
	  AND b.old_id = c.id
	  AND c.clientId <> 0
	  AND a.id <> 2 --Don't touch the existing default commcell entry
	  AND d.old_id = c.clientId
	  AND d.new_id <> 2 --Don't set clientId 2 to migrated CommCell entries
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Client -- APP_CommCell -- UPDATE clientId'
		GOTO CX_ERROR_EXIT
	END
		--------------------------------------------------------------------------------------------------------------
		/*there should not be more than one client entry in this table for registration */
		SELECT @newClientId = new_id FROM #CCM_MAP_Client
		IF @newClientId IS NULL OR @newClientId = 0
		BEGIN
				SET @errorCode = -1
				SET @errorString = 'Failed to merge client.'
				GOTO CX_ERROR_EXIT
		END
		IF EXISTS(SELECT 1 FROM #CCM_MAP_Client WHERE exist = 0)
		begin
			--Insert App_Platform
			INSERT INTO App_Platform
			SELECT @newClientId,4,srcTbl.install_dir,srcTbl.refTime
			FROM #CCM_APP_Platform srcTbl WHERE srcTbl.platformType = 4 AND srcTbl.clientId = (SELECT id FROM #CCM_App_Client)
			--We are not going to consume any license for this client, so let us deconfigure
			EXEC AppConfDeconf @newClientId,0,0,2,0,''
		end
else if (16 & @flags) = 0   --Do not update existing client entry for offline registration since all entries are dummy.
		begin
			-- Update the existing entry
IF (1 & @flags) > 0
			BEGIN
				/*PrasadNara 11:12 AM 7/5/2012
				 * We are using this cursor for updating name change on all commcells to which MA is pushed as part of library server
				 * So we should update the host name in MMLibraryHostInfo whenever a name chage happens
				 */
				UPDATE MMLibraryHostInfo
				SET	NetHostName = c.name
				FROM MMLibraryHostInfo a, #CCM_MAP_Client b, #CCM_APP_CLIENT c
				WHERE	b.exist = 1
				AND		a.HostClientId = b.new_id AND b.old_id = c.id AND a.NetHostName <> c.name
			END
		end
		-- Set firewall config.
		IF NOT EXISTS(SELECT 1 FROM APP_ClientProp WHERE componentNameId = @newClientId AND attrName = 'Include in Firewall Config' AND modified = 0)
		BEGIN
			INSERT INTO APP_ClientProp
			SELECT @newClientId, 'Include in Firewall Config', 7, '1', DBO.GetUnixTime(GETUTCDATE()), 0, 0
		END
		SET @errorCode = 0
		SET @errorString = 'NO ERROR'
	end
	else
		SET @errorString = 	'App_Commcell Insertion failed'
	end try
	begin catch
		SET @errorCode = -1
		SET @errorString = 'Client Insertion Failed'
		SET @errorString = @errorString +'Error at Line#' + cast(ERROR_LINE() as varchar(128)) +';'+ 'Error Message:' + ERROR_MESSAGE()
	end catch
CX_ERROR_EXIT:
	SELECT @errorCode, @errorString, @newClientId
    SET NOCOUNT OFF
REVERT
GO

IF EXISTS (select * from GxQscripts where name = 'CCMMergeCommservClient')
	delete from GxQscripts where name = 'CCMMergeCommservClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMMergeCommservClient')
	delete from GXDBVersions where aliasname = 'CCMMergeCommservClient'
GO

insert into GXDBVersions values(2, 'CCMMergeCommservClient',  'v1.1.2.6.6.3', 'CCMMergeCommservClient', 'v1.1.2.6.6.3')
GO

