

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMGetStateFileXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: CCMGetStateFileXML.sp,v 1.2.86.1 2018/03/20 00:38:02 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMGetStateFileXML <<<'

IF EXISTS (select * from sysobjects where name='CCMGetStateFileXML')
	drop procedure CCMGetStateFileXML
IF EXISTS (select * from GxQscripts where name='CCMGetStateFileXML')
	delete from GxQscripts where name = 'CCMGetStateFileXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetStateFileXML')
	delete from GXDBVersions where aliasname = 'CCMGetStateFileXML'
GO
print '... Creating Procedure: CCMGetStateFileXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMGetStateFileXML
  @i_podCellGUID varchar(36),
  @i_grcCellGUID varchar(36),
  @i_jobId int
AS
  DECLARE @o_stateFileXML XML
SET NOCOUNT ON
	SELECT	dbo.GetUnixTime(GETUTCDate()) as '@creationTime',
			/* Subclient Track Entity */
			(
				SELECT	subclientId	as '@subclientId',
						trackingId as '@trackingId',
						trackingTime as '@trackingTime'
				FROM 	GRC_SubclientTrackingInfo
				WHERE 	jobId = @i_jobId AND subclientId > 0
				FOR XML PATH ('subclientTrackEntity'), TYPE
			),
			/* End Track Entity */
			(
				SELECT	trackingId as '@trackingId',
						trackingTime as '@trackingTime'
				FROM 	GRC_SubclientTrackingInfo
				WHERE 	jobId = @i_jobId AND subclientId = 0
				FOR XML PATH ('endTrackEntity'), TYPE
			),
			/* Podcell */
			(
				SELECT	@i_podCellGUID as '@csGUID'
				FOR XML PATH ('podcell'), TYPE
			),
			/* GRC */
			(
				SELECT	@i_grcCellGUID as '@csGUID'
				FOR XML PATH ('grc'), TYPE
			)
	FOR XML PATH('App_GRCStateFileInfo')
GO

IF EXISTS (select * from GxQscripts where name = 'CCMGetStateFileXML')
	delete from GxQscripts where name = 'CCMGetStateFileXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetStateFileXML')
	delete from GXDBVersions where aliasname = 'CCMGetStateFileXML'
GO

insert into GXDBVersions values(2, 'CCMGetStateFileXML',  '00010002008600010000', 'CCMGetStateFileXML', '00010002008600010000')
GO

