

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMGetRemoteCCClientsForRestore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCMGetRemoteCCClientsForRestore.sp,v $ $Id: CCMGetRemoteCCClientsForRestore.sp,v 1.5.64.2 2018/03/20 00:37:31 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMGetRemoteCCClientsForRestore <<<'

IF EXISTS (select * from sysobjects where name='CCMGetRemoteCCClientsForRestore')
	drop procedure CCMGetRemoteCCClientsForRestore
IF EXISTS (select * from GxQscripts where name='CCMGetRemoteCCClientsForRestore')
	delete from GxQscripts where name = 'CCMGetRemoteCCClientsForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetRemoteCCClientsForRestore')
	delete from GXDBVersions where aliasname = 'CCMGetRemoteCCClientsForRestore'
GO
print '... Creating Procedure: CCMGetRemoteCCClientsForRestore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMGetRemoteCCClientsForRestore
  @i_commCellId int,
  @i_onlyExistingClients int = 1,  
  @i_remoteClientsList xml = ''  
AS
  DECLARE @o_GetRemoteClientsForRestoreResp XML
	SET NOCOUNT ON
	--@i_onlyExistingClients
	--  0 : Returns remote CommCell clients excluding already added clients on this CS.
	--  1 : Returns only already added remote clients on this CS.
DECLARE @l_csHostName	varchar(255)
DECLARE @l_shortCsHostName	varchar(255)
	DECLARE @lt_ExistingRemoteClients TABLE (clientId int, clientName nvarchar(256))
	DECLARE @lt_AllRemoteClients TABLE (clientId int, clientName nvarchar(256))
	SELECT	@l_csHostName = CL.net_hostname,
			@l_shortCsHostName = CL.name
	FROM	App_Client CL WITH (READUNCOMMITTED)
			INNER JOIN App_CommCell CC WITH (READUNCOMMITTED) ON CL.id = CC.clientId
	WHERE	CC.id = @i_commCellId
	INSERT 	INTO @lt_ExistingRemoteClients
	SELECT	id, name
	FROM	App_Client WITH (READUNCOMMITTED)
	WHERE	( CsHostName = @l_csHostName OR CsHostName = @l_shortCsHostName) AND
(specialClientFlags & 0x200) = 0x200
	IF @i_onlyExistingClients = 1
	BEGIN
		SET @o_GetRemoteClientsForRestoreResp = 	ISNULL (
													(
SELECT	3 AS '@_type_',
																clientId	AS '@clientId',
																clientName AS '@clientName'
														FROM	@lt_ExistingRemoteClients
														FOR XML PATH ('entities'), ROOT('App_GetRemoteClientsForRestoreResp')
													), '<App_GetRemoteClientsForRestoreResp/>')
	END
	ELSE
	BEGIN
		INSERT 	INTO @lt_AllRemoteClients
		SELECT 	ref.value('@clientId', 'INTEGER'), ref.value('@clientName', 'NVARCHAR(256)')
		FROM 	@i_remoteClientsList.nodes('App_GetRemoteClientsForRestoreResp/entities') R ( ref )
		SET @o_GetRemoteClientsForRestoreResp = 	ISNULL (
													(
SELECT	3 AS '@_type_',
																a.clientId	AS '@clientId',
																a.clientName AS '@clientName'
														FROM	@lt_AllRemoteClients a
																LEFT OUTER JOIN @lt_ExistingRemoteClients b ON a.clientName = b.clientName
														WHERE	b.clientId IS NULL
														FOR XML PATH ('entities'), ROOT('App_GetRemoteClientsForRestoreResp')
													), '<App_GetRemoteClientsForRestoreResp/>')
	END
	SELECT @o_GetRemoteClientsForRestoreResp
GO

IF EXISTS (select * from GxQscripts where name = 'CCMGetRemoteCCClientsForRestore')
	delete from GxQscripts where name = 'CCMGetRemoteCCClientsForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetRemoteCCClientsForRestore')
	delete from GXDBVersions where aliasname = 'CCMGetRemoteCCClientsForRestore'
GO

insert into GXDBVersions values(2, 'CCMGetRemoteCCClientsForRestore',  '00010005006400020000', 'CCMGetRemoteCCClientsForRestore', '00010005006400020000')
GO

