

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMGetQuestionsXML_To_90.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: CCMGetQuestionsXML_To_90.sp,v 1.2.86.2 2018/03/20 00:41:21 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMGetQuestionsXML_To_90 <<<'

IF EXISTS (select * from sysobjects where name='CCMGetQuestionsXML_To_90')
	drop procedure CCMGetQuestionsXML_To_90
IF EXISTS (select * from GxQscripts where name='CCMGetQuestionsXML_To_90')
	delete from GxQscripts where name = 'CCMGetQuestionsXML_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetQuestionsXML_To_90')
	delete from GXDBVersions where aliasname = 'CCMGetQuestionsXML_To_90'
GO
print '... Creating Procedure: CCMGetQuestionsXML_To_90'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMGetQuestionsXML_To_90
  @i_dumpSets varchar(max),
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
--- CODE BELOW HERE IS FROM CCMGetQuestionsXML.spb  ----------
  DECLARE @o_CCMQuestionsXML XML
SET NOCOUNT ON
DECLARE		@l_CCNumber					BIGINT
DECLARE		@l_CCName					VARCHAR(128)
DECLARE		@l_CCGuid					VARCHAR(128)
DECLARE		@lt_ClientNameQuestions		TABLE(	OldClientName NVARCHAR(255),
											OldClientHostName NVARCHAR(255)
										)
DECLARE 	@lt_MountPathLibQuestions	TABLE(
											mountPathId int,
											mountPathName varchar(512),
											mountPathType int,
											libraryId int,
											libraryName nvarchar(128),
											deviceId int,
											deviceName nvarchar(128)
										)
DECLARE	@l_DontExportUserCredentials INT = ISNULL((SELECT value FROM MMConfigs WHERE name = 'CCM_CONFIG_SCRUB_USER_CREDENTIALS_FOR_LIBRARIES'), 0)
	------------------------------------------------
	--Get Commcell info
	SELECT	@l_CCName =  aliasName,
			@l_CCNumber = number,
			@l_CCGuid	=	csGUID
	FROM CCM_SOURCE_APP_CommCell WHERE id = 2
	------------------------------------------------
	--Get ClientName questions
	INSERT @lt_ClientNameQuestions
	SELECT DISTINCT old_name, old_net_hostName FROM CCMClientNameMapping WHERE dumpSetName IN (SELECT _ID FROM dbo.CCM_SplitStringByToken(@i_dumpSets, ','))
	-------------------------------------------------
	--Get MountPath questions
	--------------------------------------------------
	--Populate Questions xml
	SET @o_CCMQuestionsXML =
	(
		--CommCell Info
		SELECT (
			SELECT 	@l_CCNumber AS 'Number',
					@l_CCName	  AS 'Name',
					@l_CCGuid   AS 'GUID'
			FOR XML PATH('CommCell'),TYPE
		),
		--ClientName Questions
		(
			SELECT	OldClientName,
					OldClientHostName
			FROM @lt_ClientNameQuestions FOR XML PATH('Client'),TYPE
		),
		--MountPath Questions
		(
			SELECT 	DISTINCT MountPathId as SourceMountPathId,
					dbo.NormalizeForXML(MountPathName) as SourceMountPathName,
					SourceMediaAgentId as SourceHostId,
					dbo.NormalizeForXML(SourceMediaAgentName) as SourceHostName,
					MountPathType as MountPathType,
					SourceDeviceId as SourceDeviceId,
					dbo.NormalizeForXML(SourceDeviceName) as SourceDeviceName
			FROM 	CCMMountPathMapping
			WHERE	dumpSetName IN (SELECT _ID FROM dbo.CCM_SplitStringByToken(@i_dumpSets, ','))
			FOR XML PATH ('MountPath'),TYPE
		),
		--DevicePath Questions
		(
			SELECT 	DISTINCT SourceDeviceId as SourceDeviceId,
					dbo.NormalizeForXML(SourceDeviceName) as SourceDeviceName,
					dbo.NormalizeForXML(SourceDevicePath) as SourceDevicePath
			FROM 	CCMDevicePathMapping
			WHERE 	dumpSetName IN (SELECT _ID FROM dbo.CCM_SplitStringByToken(@i_dumpSets, ','))
			FOR XML PATH ('DevicePath'),TYPE
		)
		FOR XML PATH('CommserveData')
	)
	SELECT @o_CCMQuestionsXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCMGetQuestionsXML_To_90')
	delete from GxQscripts where name = 'CCMGetQuestionsXML_To_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetQuestionsXML_To_90')
	delete from GXDBVersions where aliasname = 'CCMGetQuestionsXML_To_90'
GO

insert into GXDBVersions values(2, 'CCMGetQuestionsXML_To_90',  '00010002008600020000', 'CCMGetQuestionsXML_To_90', '00010002008600020000')
GO

