

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMGetQuestionsXML_To_100.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: CCMGetQuestionsXML_To_100.sp,v 1.1.60.2 2018/03/20 00:43:50 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMGetQuestionsXML_To_100 <<<'

IF EXISTS (select * from sysobjects where name='CCMGetQuestionsXML_To_100')
	drop procedure CCMGetQuestionsXML_To_100
IF EXISTS (select * from GxQscripts where name='CCMGetQuestionsXML_To_100')
	delete from GxQscripts where name = 'CCMGetQuestionsXML_To_100'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetQuestionsXML_To_100')
	delete from GXDBVersions where aliasname = 'CCMGetQuestionsXML_To_100'
GO
print '... Creating Procedure: CCMGetQuestionsXML_To_100'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMGetQuestionsXML_To_100
  @i_dumpSets varchar(max),
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
--- CODE BELOW HERE IS FROM CCMGetQuestionsXML.spb  ----------
  DECLARE @o_CCMQuestionsXML XML
SET NOCOUNT ON
DECLARE		@l_CCNumber					BIGINT
DECLARE		@l_CCName					VARCHAR(128)
DECLARE		@l_CCGuid					VARCHAR(128)
DECLARE		@lt_ClientNameQuestions		TABLE(	OldClientName NVARCHAR(255),
											OldClientHostName NVARCHAR(255)
										)
DECLARE 	@lt_MountPathLibQuestions	TABLE(
											mountPathId int,
											mountPathName varchar(512),
											mountPathType int,
											libraryId int,
											libraryName nvarchar(128),
											deviceId int,
											deviceName nvarchar(128)
										)
DECLARE	@l_DontExportUserCredentials INT = ISNULL((SELECT value FROM MMConfigs WHERE name = 'CCM_CONFIG_SCRUB_USER_CREDENTIALS_FOR_LIBRARIES'), 0)
	------------------------------------------------
	--Get Commcell info
	SELECT	@l_CCName =  aliasName,
			@l_CCNumber = number,
			@l_CCGuid	=	csGUID
	FROM CCM_SOURCE_APP_CommCell WHERE id = 2
	------------------------------------------------
	--Get ClientName questions
	INSERT @lt_ClientNameQuestions
	SELECT DISTINCT old_name, old_net_hostName FROM CCMClientNameMapping WHERE dumpSetName IN (SELECT _ID FROM dbo.CCM_SplitStringByToken(@i_dumpSets, ','))
	-------------------------------------------------
	--Get MountPath questions
	--Handling 	ExportFromLinkedServer
	IF( OBJECT_ID('tempdb.dbo.#l_CCM_SOURCE_MMLibrary') is not null) DROP TABLE #l_CCM_SOURCE_MMLibrary
	SELECT * INTO #l_CCM_SOURCE_MMLibrary
	FROM MMLibrary WHERE 1 = 0
	IF(OBJECTPROPERTY(object_ID('MMLibrary'), 'TableHasIdentity') =1)
		SET IDENTITY_INSERT #l_CCM_SOURCE_MMLibrary ON
	EXEC CCM_Export_CopyTableFromLinkedServer  @i_isExportFromLinkedServer, 'MMLibrary', 'tempdb.dbo.#l_CCM_SOURCE_MMLibrary','', @i_exportDBName, ''
	IF(OBJECTPROPERTY(object_ID('MMLibrary'), 'TableHasIdentity') =1)
		SET IDENTITY_INSERT #l_CCM_SOURCE_MMLibrary OFF
	INSERT @lt_MountPathLibQuestions
	SELECT DISTINCT MPQ.MountPathId,
			MPQ.MountPathName,
			MPQ.MountPathType,
			L.LibraryId,
			L.AliasName,
			MPQ.SourceDeviceId,
			MPQ.SourceDeviceName
	FROM CCMMountPathMapping MPQ
		INNER JOIN CCM_SOURCE_MMMountPath MMP ON MPQ.MountPathId = MMP.MountPathId
		INNER JOIN #l_CCM_SOURCE_MMLibrary L ON MMP.LibraryId = L.LibraryId
	WHERE MPQ.MountPathId > 0 AND MPQ.dumpSetName IN (SELECT _ID FROM dbo.CCM_SplitStringByToken(@i_dumpSets, ','))
	DROP TABLE #l_CCM_SOURCE_MMLibrary
	--------------------------------------------------
	--Populate Questions xml
	SET @o_CCMQuestionsXML =
	(
		--CommCell Info
		SELECT (
			SELECT 	@l_CCNumber AS 'Number',
					@l_CCName	  AS 'Name',
					@l_CCGuid   AS 'GUID'
			FOR XML PATH('CommCell'),TYPE
		),
		--ClientName Questions
		(
			SELECT	OldClientName,
					OldClientHostName
			FROM @lt_ClientNameQuestions FOR XML PATH('Client'),TYPE
		),
		--MountPath Questions
		(
			SELECT 	mountPathId as MountPathId,
					dbo.NormalizeForXML(mountPathName) as MountPathName,
					mountPathType as MountPathType,
					libraryId as LibraryId,
					dbo.NormalizeForXML(libraryName) as LibraryName,
					deviceId as DeviceId,
					dbo.NormalizeForXML(deviceName) as DeviceName,
					(
						SELECT temp.*
						FROM
						(
							SELECT 0 as Id, '' as Path, '' as UserName, '' as UserPassword
							WHERE NOT EXISTS(SELECT * FROM CCM_SOURCE_MMDeviceController WHERE deviceId = mpq.deviceId)
							UNION ALL
							SELECT DeviceControllerId as Id, dbo.NormalizeForXML(Folder) as Path,
								CASE WHEN @l_DontExportUserCredentials > 0 THEN '' ELSE UserName END, CASE WHEN @l_DontExportUserCredentials > 0 THEN '' ELSE dbo.NormalizeForXML(UserPassword) END
							FROM CCM_SOURCE_MMDeviceController WHERE deviceId = mpq.deviceId
						) as temp
						FOR XML PATH ('DeviceControllerPath'),TYPE
					)
			FROM @lt_MountPathLibQuestions mpq FOR XML PATH ('MountPathQuestion'),TYPE
		)
		FOR XML PATH('CommserveData')
	)
	SELECT @o_CCMQuestionsXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCMGetQuestionsXML_To_100')
	delete from GxQscripts where name = 'CCMGetQuestionsXML_To_100'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetQuestionsXML_To_100')
	delete from GXDBVersions where aliasname = 'CCMGetQuestionsXML_To_100'
GO

insert into GXDBVersions values(2, 'CCMGetQuestionsXML_To_100',  '00010001006000020000', 'CCMGetQuestionsXML_To_100', '00010001006000020000')
GO

