

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMGetQuestionsXML_From_90.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: CCMGetQuestionsXML_From_90.sp,v 1.2.88.2 2018/03/20 00:48:14 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMGetQuestionsXML_From_90 <<<'

IF EXISTS (select * from sysobjects where name='CCMGetQuestionsXML_From_90')
	drop procedure CCMGetQuestionsXML_From_90
IF EXISTS (select * from GxQscripts where name='CCMGetQuestionsXML_From_90')
	delete from GxQscripts where name = 'CCMGetQuestionsXML_From_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetQuestionsXML_From_90')
	delete from GXDBVersions where aliasname = 'CCMGetQuestionsXML_From_90'
GO
print '... Creating Procedure: CCMGetQuestionsXML_From_90'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMGetQuestionsXML_From_90
  @i_dumpSets varchar(max),
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
--- CODE BELOW HERE IS FROM CCMGetQuestionsXML.spb  ----------
  DECLARE @o_CCMQuestionsXML XML
SET NOCOUNT ON
DECLARE		@l_CCNumber					BIGINT
DECLARE		@l_CCName					VARCHAR(128)
DECLARE		@l_CCGuid					VARCHAR(128)
DECLARE		@lt_ClientNameQuestions		TABLE(	OldClientName NVARCHAR(255),
											OldClientHostName NVARCHAR(255)
										)
DECLARE 	@lt_MountPathLibQuestions	TABLE(
											mountPathId int,
											mountPathName varchar(512),
											mountPathType int,
											libraryId int,
											libraryName nvarchar(128),
											deviceId int,
											deviceName nvarchar(128)
										)
DECLARE	@l_DontExportUserCredentials INT = ISNULL((SELECT value FROM MMConfigs WHERE name = 'CCM_CONFIG_SCRUB_USER_CREDENTIALS_FOR_LIBRARIES'), 0)
	------------------------------------------------
	--Get Commcell info
	SELECT	@l_CCName =  aliasName,
			@l_CCNumber = number,
			@l_CCGuid	=	csGUID
	FROM CCM_SOURCE_APP_CommCell WHERE id = 2
	------------------------------------------------
	--Get ClientName questions
	INSERT @lt_ClientNameQuestions
	SELECT DISTINCT old_name, old_net_hostName FROM CCMClientNameMapping WHERE dumpSetName IN (SELECT _ID FROM dbo.CCM_SplitStringByToken(@i_dumpSets, ','))
	-------------------------------------------------
	--Get MountPath questions
	--Handling 	ExportFromLinkedServer
	IF( OBJECT_ID('tempdb.dbo.#l_CCM_SOURCE_MMLibrary') is not null) DROP TABLE #l_CCM_SOURCE_MMLibrary
	CREATE TABLE #l_CCM_SOURCE_MMLibrary
	(
		[LibraryId] [int] NOT NULL,
		[LibraryName] [varchar](128) NOT NULL,
		[AliasName] [nvarchar](128) NOT NULL,
		[LibrarySoftState] [int] NOT NULL,
		[LibraryEnabled] [int] NOT NULL,
		[LibraryBroken] [int] NOT NULL,
		[LibraryTypeId] [int] NOT NULL,
		[BarCodeReaderPresent] [int] NOT NULL,
		[LibraryInstallTime] [int] NOT NULL,
		[LowWaterMarkMB] [int] NOT NULL,
		[LibraryLicenseType] [int] NOT NULL,
		[LibraryVendor] [varchar](16) NOT NULL,
		[LibraryModel] [varchar](32) NOT NULL,
		[FirmwareRevision] [varchar](32) NOT NULL,
		[SerialNumber] [varchar](32) NOT NULL,
		[WWNNumber] [varchar](64) NOT NULL,
		[FiberChannelPort] [int] NOT NULL,
		[NumberOfMounts] [int] NOT NULL,
		[LastServiceTime] [int] NOT NULL,
		[DriveCount] [int] NOT NULL,
		[BaseAddress] [int] NOT NULL,
		[ExternalGUID] [varchar](33) NOT NULL,
		[PrivateData] [varchar](256) NOT NULL,
		[LibraryAttribute] [int] NOT NULL,
		[MountTimeoutSec] [int] NOT NULL,
		[UnmountTimeoutSec] [int] NOT NULL,
		[NumberOfSoftErrors] [int] NOT NULL,
		[NumberOfHardErrors] [int] NOT NULL,
		[DefaultMediaTypeId] [int] NOT NULL,
		[InventoryInProgress] [int] NOT NULL,
		[IsConvertedToSited] [int] NOT NULL,
		[LastFullInventoryTime] [int] NOT NULL,
		[InventoryJobId_h] [int] NOT NULL,
		[InventoryJobId_l] [int] NOT NULL,
		[LibraryStatusReason] [int] NOT NULL,
		[OfflineTimeStamp] [int] NOT NULL,
		[UseWithinDaysInSec] [int] NOT NULL,
		[DriveCleanIntervalInSec] [int] NOT NULL,
		[VMSDirection] [int] NOT NULL,
		[CacheMountPeriodInSec] [int] NOT NULL,
		[StdAlnMedRetentionTime] [int] NOT NULL,
		[SlotBaseAddress] [int] NOT NULL,
		[NumberOfMailSlots] [int] NOT NULL,
		[TURIntervalInSec] [int] NOT NULL,
		[ConfigParams] [varchar](256) NOT NULL,
		[Descript] [nvarchar](max) NOT NULL,
		[StdAlnChkIntervalInSec] [int] NOT NULL,
		[StdAlnNextChkTime] [int] NOT NULL,
		[ReadRetryIntervalInSec] [int] NOT NULL,
		[ReadRetryAttempts] [int] NOT NULL,
		[RestrictActivity] [int] NOT NULL,
		[LibraryStatusEventId] [int] NOT NULL,
		[StartVMSElementAddress] [int] NOT NULL,
		[ExtendedAttributes] [int] NOT NULL,
		[ThresholdPercentage] [int] NOT NULL,
		[ThresholdVariation] [int] NOT NULL,
		[LibrarySubType] [int] NOT NULL,
		[VTLType] [int] NOT NULL,
		[origCCId] [int] NOT NULL,
		[origLibraryId] [int] NOT NULL
	)
	EXEC CCM_Export_CopyTableFromLinkedServer  @i_isExportFromLinkedServer, 'MMLibrary', 'tempdb.dbo.#l_CCM_SOURCE_MMLibrary',
				'LibraryId, LibraryName,AliasName,LibrarySoftState,LibraryEnabled,LibraryBroken,LibraryTypeId,BarCodeReaderPresent,LibraryInstallTime,LowWaterMarkMB,LibraryLicenseType, LibraryVendor, LibraryModel,
				FirmwareRevision, SerialNumber, WWNNumber,FiberChannelPort, NumberOfMounts, LastServiceTime, DriveCount, BaseAddress,ExternalGUID, PrivateData, LibraryAttribute,MountTimeoutSec, UnmountTimeoutSec,
				NumberOfSoftErrors, NumberOfHardErrors,  DefaultMediaTypeId,InventoryInProgress, IsConvertedToSited,LastFullInventoryTime, InventoryJobId_h, InventoryJobId_l,LibraryStatusReason, OfflineTimeStamp,
				UseWithinDaysInSec, DriveCleanIntervalInSec,VMSDirection, CacheMountPeriodInSec, StdAlnMedRetentionTime,SlotBaseAddress, NumberOfMailSlots,TURIntervalInSec, ConfigParams, Descript, StdAlnChkIntervalInSec,
				StdAlnNextChkTime,ReadRetryIntervalInSec, ReadRetryAttempts, RestrictActivity, LibraryStatusEventId, StartVMSElementAddress, ExtendedAttributes, ThresholdPercentage, ThresholdVariation,
				LibrarySubType, VTLType, origCCId,origLibraryId',
				@i_exportDBName, ''
	INSERT @lt_MountPathLibQuestions
	SELECT DISTINCT MPQ.MountPathId,
			MPQ.MountPathName,
			MPQ.MountPathType,
			L.LibraryId,
			L.AliasName,
			MPQ.SourceDeviceId,
			MPQ.SourceDeviceName
	FROM CCMMountPathMapping MPQ
		INNER JOIN CCM_SOURCE_MMMountPath MMP ON MPQ.MountPathId = MMP.MountPathId
		INNER JOIN #l_CCM_SOURCE_MMLibrary L ON MMP.LibraryId = L.LibraryId
	WHERE MPQ.MountPathId > 0 AND MPQ.dumpSetName IN (SELECT _ID FROM dbo.CCM_SplitStringByToken(@i_dumpSets, ','))
	DROP TABLE #l_CCM_SOURCE_MMLibrary
	--------------------------------------------------
	--Populate Questions xml
	SET @o_CCMQuestionsXML =
	(
		--CommCell Info
		SELECT (
			SELECT 	@l_CCNumber AS 'Number',
					@l_CCName	  AS 'Name',
					@l_CCGuid   AS 'GUID'
			FOR XML PATH('CommCell'),TYPE
		),
		--ClientName Questions
		(
			SELECT	OldClientName,
					OldClientHostName
			FROM @lt_ClientNameQuestions FOR XML PATH('Client'),TYPE
		),
		--MountPath Questions
		(
			SELECT 	mountPathId as MountPathId,
					dbo.NormalizeForXML(mountPathName) as MountPathName,
					mountPathType as MountPathType,
					libraryId as LibraryId,
					dbo.NormalizeForXML(libraryName) as LibraryName,
					deviceId as DeviceId,
					dbo.NormalizeForXML(deviceName) as DeviceName,
					(
						SELECT temp.*
						FROM
						(
							SELECT 0 as Id, '' as Path, '' as UserName, '' as UserPassword
							WHERE NOT EXISTS(SELECT * FROM CCM_SOURCE_MMDeviceController WHERE deviceId = mpq.deviceId)
							UNION ALL
							SELECT DeviceControllerId as Id, dbo.NormalizeForXML(Folder) as Path,
								CASE WHEN @l_DontExportUserCredentials > 0 THEN '' ELSE UserName END, CASE WHEN @l_DontExportUserCredentials > 0 THEN '' ELSE dbo.NormalizeForXML(UserPassword) END
							FROM CCM_SOURCE_MMDeviceController WHERE deviceId = mpq.deviceId
						) as temp
						FOR XML PATH ('DeviceControllerPath'),TYPE
					)
			FROM @lt_MountPathLibQuestions mpq FOR XML PATH ('MountPathQuestion'),TYPE
		)
		FOR XML PATH('CommserveData')
	)
	SELECT @o_CCMQuestionsXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCMGetQuestionsXML_From_90')
	delete from GxQscripts where name = 'CCMGetQuestionsXML_From_90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetQuestionsXML_From_90')
	delete from GXDBVersions where aliasname = 'CCMGetQuestionsXML_From_90'
GO

insert into GXDBVersions values(2, 'CCMGetQuestionsXML_From_90',  '00010002008800020000', 'CCMGetQuestionsXML_From_90', '00010002008800020000')
GO

