

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMGetQuestionsXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: CCMGetQuestionsXML.sp,v 1.8.60.3 2018/03/20 00:38:23 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMGetQuestionsXML <<<'

IF EXISTS (select * from sysobjects where name='CCMGetQuestionsXML')
	drop procedure CCMGetQuestionsXML
IF EXISTS (select * from GxQscripts where name='CCMGetQuestionsXML')
	delete from GxQscripts where name = 'CCMGetQuestionsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetQuestionsXML')
	delete from GXDBVersions where aliasname = 'CCMGetQuestionsXML'
GO
print '... Creating Procedure: CCMGetQuestionsXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMGetQuestionsXML
  @i_dumpSets varchar(max),
  @i_captureToVersion varchar(10),
  @i_isExportFromLinkedServer int,
  @i_exportDBName varchar(1024)
AS
  DECLARE @o_CCMQuestionsXML XML
SET NOCOUNT ON
	DECLARE @errorString varchar(1024)
	SET @errorString = 'ERROR: GENERAL ERROR!'
	--
	-- Get the capture DB releaseId. if release is less than 9.0 then fail the job
	--
	DECLARE @l_releaseId int
	SELECT @l_releaseId = releaseId FROM CCM_SOURCE_APP_Client WHERE Id = 2
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCMGetQuestsXML -- Failed to get CommServ release'
		GOTO CX_ERROR_EXIT
	END
	IF @l_releaseId < 14
	BEGIN
		SET @errorString  = 'ERROR: Capture from releases prior to 9.0 are not supported'
		GOTO CX_ERROR_EXIT
	END
	IF @l_releaseId = 14
		EXEC CCMGetQuestionsXML_From_90 @i_dumpSets
	ELSE
	BEGIN
IF @i_captureToVersion = '9.0'
			EXEC CCMGetQuestionsXML_To_90 @i_dumpSets, @i_isExportFromLinkedServer, @i_exportDBName
ELSE IF @i_captureToVersion = '10'
			EXEC CCMGetQuestionsXML_To_100 @i_dumpSets, @i_isExportFromLinkedServer, @i_exportDBName
		ELSE
			EXEC CCMGetQuestionsXML_Default @i_dumpSets, @i_isExportFromLinkedServer, @i_exportDBName
	END
	RETURN (0)
CX_ERROR_EXIT:
RAISERROR ('%s' , 16, 1, @errorString)
SELECT ''
RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCMGetQuestionsXML')
	delete from GxQscripts where name = 'CCMGetQuestionsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetQuestionsXML')
	delete from GXDBVersions where aliasname = 'CCMGetQuestionsXML'
GO

insert into GXDBVersions values(2, 'CCMGetQuestionsXML',  '00010008006000030000', 'CCMGetQuestionsXML', '00010008006000030000')
GO

