

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMGetExportXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCMGetExportXML')
BEGIN
	print '>>> Drop Stored Procedure: CCMGetExportXML <<<'
	drop procedure CCMGetExportXML
END
IF EXISTS (select * from GxQscripts where name='CCMGetExportXML')
	delete from GxQscripts where name = 'CCMGetExportXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetExportXML')
	delete from GXDBVersions where aliasname = 'CCMGetExportXML'
GO
print '... Creating Procedure: CCMGetExportXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMGetExportXML
  @i_entities xml = ''
AS
  DECLARE @r_CCEXportxml XML
SET NOCOUNT ON
BEGIN
DECLARE		@CCNumber				BIGINT
DECLARE		@CCName					VARCHAR(128)
DECLARE		@CCGuid					VARCHAR(128)
DECLARE	 @l_DevicePathQestions		TABLE(
											SourceDeviceId			INT,
											SourceDeviceName		VARCHAR(1024),
											SourceDevicePath		VARCHAR(1024),
											targetMediaAgentId		INT,
											targetMediaAgent		VARCHAR(256),
											targetDevicePath		VARCHAR(1024),
											targetUserName			VARCHAR(256),
											targetPassword			VARCHAR(256),
											isAnswerExists			INT,
											reservedId				INT,
											reservedString			VARCHAR(100)
										)
DECLARE @l_MountPathLibQuestions table (
										mountPathId int,
										mountPathName varchar(512),
										mountPathType int,
										libraryId int,
										libraryName nvarchar(128),
										deviceId int,
										deviceName nvarchar(1024)
								)
DECLARE @l_EntitiesTab			TABLE(
										EntityId			INT,
										EntityType			INT,
										IsExclude			INT,
										clientId			INT
									)
DECLARE @l_Subclients 			TABLE(	subclientId INT	)
DECLARE @l_MountPaths 			TABLE(	MountPathId INT, MediaSideId INT, LibraryId INT, MountPathTypeId INT, MountPathName varchar(1024) )
	INSERT 	INTO @l_EntitiesTab
	SELECT 	CASE entity.value('@_type_', 'INT')
WHEN 3 THEN entity.value('@clientId', 'INT')
WHEN 4 THEN entity.value('@applicationId', 'INT')
WHEN 5 THEN entity.value('@instanceId', 'INT')
WHEN 6 THEN entity.value('@backupsetId', 'INT')
WHEN 7 THEN entity.value('@subclientId', 'INT')
			ELSE  0
			END,
			entity.value('@_type_', 'INT'),
			ISNULL(entity.value('(flags/@exclude)[1]', 'INT'), 0),
			ISNULL(entity.value('@clientId', 'INT'), 0)
	FROM	@i_entities.nodes('/EVGui_GetCCMExportInfo/entities') AS entities(entity)
	IF NOT EXISTS(SELECT 1 FROM @l_EntitiesTab)
		INSERT INTO @l_EntitiesTab VALUES (0, 1, 0, 0)
	INSERT 	INTO @l_Subclients
	SELECT 	DISTINCT a.id
	FROM	APP_Application a WITH (READUNCOMMITTED), @l_EntitiesTab b
	WHERE 	b.IsExclude = 0
			AND b.EntityType in (1, 2, 72)
			OR
			(
				(b.clientId = 0 OR b.clientId = a.clientId)
				AND
				(
					CASE b.EntityType
WHEN 3 THEN a.clientId
WHEN 4 THEN a.appTypeId
WHEN 5 THEN a.instance
WHEN 6 THEN a.backupset
WHEN 7 THEN a.id
					END
				) = b.EntityId
			)
	DELETE 	@l_Subclients
	FROM	@l_Subclients c, APP_Application a WITH (READUNCOMMITTED), @l_EntitiesTab b
	WHERE   c.subclientId = a.id
			AND b.IsExclude = 1
			AND
			(
				(b.clientId = 0 OR b.clientId = a.clientId)
				AND
				(
					CASE b.EntityType
WHEN 3 THEN a.clientId
WHEN 4 THEN a.appTypeId
WHEN 5 THEN a.instance
WHEN 6 THEN a.backupset
WHEN 7 THEN a.id
					END
				) = b.EntityId
			)
	INSERT	INTO @l_MountPaths
	SELECT	DISTINCT f.MountPathId, f.MediaSideId, f.LibraryId, f.MountPathTypeId, f.MountPathName
	FROM	@l_Subclients a
			INNER JOIN archFile b WITH (READUNCOMMITTED) ON a.subclientId = b.appId
			INNER JOIN archChunkMapping c WITH (READUNCOMMITTED) ON b.id = c.archFileId AND b.commcellId = c.commcellId
			INNER JOIN archChunk d WITH (READUNCOMMITTED) ON c.archChunkId = d.id AND c.chunkCommcellId = d.commcellId
			INNER JOIN MMVolume e WITH (READUNCOMMITTED) ON d.volumeId = e.volumeId
			INNER JOIN MMMountPath f WITH (READUNCOMMITTED) ON e.MediaSideId = f.MediaSideId
	INSERT	INTO @l_MountPaths
	SELECT	MountPathId, MediaSideId, LibraryId, MountPathTypeId, MountPathName
	FROM	MMMountPath  WITH (READUNCOMMITTED)
	WHERE	LibraryId IN (SELECT LibraryId FROM @l_MountPaths)
			AND MountPathId NOT IN (SELECT MountPathId FROM  @l_MountPaths)
	/*INSERT	INTO @l_MountPaths
	SELECT 	DISTINCT d.MountPathId, d.MediaSideId, d.LibraryId, d.MountPathTypeId, d.MountPathName
	FROM	@l_MountPaths a
			INNER JOIN MMVolume b WITH (READUNCOMMITTED) ON a.MediaSideId = b.MediaSideId
			INNER JOIN MMVolume c WITH (READUNCOMMITTED) ON b.SIDBStoreId = c.SIDBStoreId AND b.SIDBStoreId > 0
			INNER JOIN MMMountPath d WITH (READUNCOMMITTED) ON c.MediaSideId = d.MediaSideId
			LEFT OUTER JOIN @l_MountPaths e ON d.MountPathId = e.MountPathId
	WHERE	e.MountPathId IS NULL
	*/
	SELECT	@CCName =  aliasName,
			@CCNumber = number,
			@CCGuid	=	csGUID
	FROM 	APP_CommCell WHERE id = 2
	INSERT	INTO @l_MountPathLibQuestions
	SELECT 	mp.MountPathId, mp.MountPathName, mp.MountPathTypeId, lib.LibraryId ,lib.AliasName, dev.DeviceId, dev.AliasName
	FROM 	MMLibrary lib  WITH (READUNCOMMITTED)
			INNER JOIN @l_MountPaths mp ON lib.LibraryId = mp.LibraryId
			LEFT OUTER JOIN MMMountPathToStorageDevice mpd  WITH (READUNCOMMITTED) ON mp.MountPathId = mpd.MountPathId
			LEFT OUTER JOIN MMDevice dev WITH (READUNCOMMITTED) ON dev.DeviceId = isnull(mpd.DeviceId,0)
	WHERE	mp.MountPathId > 0
	INSERT @l_DevicePathQestions	(
						SourceDeviceId,
						SourceDeviceName,
						SourceDevicePath
					)
	SELECT DISTINCT
		MD.DeviceId,
		MD.AliasName,
		''
	FROM MMMountPathToStorageDevice	MPS  WITH (READUNCOMMITTED)
		INNER JOIN @l_MountPaths MMP ON MMP.MountPathId = MPS.MountPathId
		INNER JOIN MMDevice	MD	WITH (READUNCOMMITTED) ON MD.DeviceId = MPS.DeviceId
	WHERE MMP.MountPathTypeId > 0
	UPDATE @l_DevicePathQestions
		SET sourceDevicePath = MDC.Folder
	FROM @l_DevicePathQestions LDP
	INNER JOIN MMDeviceController MDC WITH (READUNCOMMITTED) ON MDC.DeviceId = LDP.sourceDeviceId
	SET @r_CCEXportxml =
		(
		SELECT (
					SELECT 	@CCNumber AS 'Number',
							@CCName	  AS 'Name',
							@CCGuid   AS 'GUID'
					FOR XML PATH('CommCell'),TYPE
				),
				(
					SELECT 	mountPathId as MountPathId,
							dbo.NormalizeForXML(mountPathName) as MountPathName,
							mountPathType as MountPathType,
							libraryId as LibraryId,
							dbo.NormalizeForXML(libraryName) as LibraryName,
							deviceId as DeviceId,
							dbo.NormalizeForXML(deviceName) as DeviceName,
							(
								SELECT temp.*
								FROM
								(
									SELECT 0 as Id, '' as Path, '' as UserName, '' as UserPassword WHERE NOT EXISTS(SELECT * FROM MMDeviceController WITH (READUNCOMMITTED) WHERE deviceId = mpq.deviceId)
									UNION ALL
									SELECT DeviceControllerId as Id, dbo.NormalizeForXML(Folder) as Path, dbo.NormalizeForXML(UserName) AS UserName, dbo.NormalizeForXML(UserPassword) AS UserPassword FROM MMDeviceController WITH (READUNCOMMITTED) WHERE deviceId = mpq.deviceId
								) as temp
								FOR XML PATH ('DeviceControllerPath'),TYPE
							)
					FROM @l_MountPathLibQuestions mpq FOR XML PATH ('MountPathQuestion'),TYPE
				)
		FOR XML PATH('CommserveData')
	)
	SELECT @r_CCEXportxml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCMGetExportXML')
	delete from GxQscripts where name = 'CCMGetExportXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetExportXML')
	delete from GXDBVersions where aliasname = 'CCMGetExportXML'
GO

insert into GXDBVersions values(2, 'CCMGetExportXML',  '00000000000000000000', 'CCMGetExportXML', '00000000000000000000')
GO

