

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMGetCloudLibraryInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCMGetCloudLibraryInfo.sp,v $ $Id: CCMGetCloudLibraryInfo.sp,v 1.1.2.4 2018/08/23 14:37:55 aselvanayagam Exp $";
-- =============================================
-- Author:		Prasad Nara
-- Create date: 05/02/2016
-- Description:	Returns cloud bucket, vendor type, username and password
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCMGetCloudLibraryInfo <<<'

IF EXISTS (select * from sysobjects where name='CCMGetCloudLibraryInfo')
	drop procedure CCMGetCloudLibraryInfo
IF EXISTS (select * from GxQscripts where name='CCMGetCloudLibraryInfo')
	delete from GxQscripts where name = 'CCMGetCloudLibraryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetCloudLibraryInfo')
	delete from GXDBVersions where aliasname = 'CCMGetCloudLibraryInfo'
GO
print '... Creating Procedure: CCMGetCloudLibraryInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMGetCloudLibraryInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_CommCellGUID varchar(40)
AS
  DECLARE @o_deviceType INTEGER
  DECLARE @o_rootFolder varchar(1024)
  DECLARE @o_userName varchar(1024)
  DECLARE @o_password varchar(2048)
SET XACT_ABORT ON
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @l_CommCellId INT = (SELECT TOP 1 id FROM App_CommCell WHERE csGUID = @i_CommCellGUID)
DECLARE @l_LibraryId INT = ISNULL((SELECT longVal FROM GRC_CommCellProp WHERE commCellId = @l_CommCellId AND PropId = 38 /*GRC_CLOUD_LIBRARY_ID*/), 0)
	IF OBJECT_ID('tempdb.dbo.#deviceControllerTable') IS NOT NULL
    DROP TABLE #deviceControllerTable
	CREATE TABLE #deviceControllerTable
	(
		deviceTypeId INT,
		folder VARCHAR(1024),
		userName VARCHAR(1024),
		userPassword VARCHAR(2048),
		credentialAssocId INT
	)
IF @l_LibraryId > 0
BEGIN
	INSERT INTO #deviceControllerTable
	SELECT  TOP 1 D.DeviceTypeId, DC.Folder, DC.UserName, DC.UserPassword, DC.CredentialAssocId
	FROM	MMMountPath MP WITH (READUNCOMMITTED), MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED),
			MMDevice D WITH (READUNCOMMITTED), MMDeviceController DC WITH(READUNCOMMITTED)
	WHERE	MP.LibraryId = @l_LibraryId
			AND MP.MountPathId = MPSD.MountPathId
			AND MPSD.DeviceId = D.DeviceId
			AND D.DeviceId = DC.DeviceId
	ORDER BY DC.DeviceControllerId
	-- Update user name and password for entries that use credentials
	EXEC MMS2GetDeviceControllerCredentials '#deviceControllerTable', 'credentialAssocId', 'userName', 'userPassword'
	SELECT @o_deviceType = DC.deviceTypeId, @o_rootFolder = DC.folder, @o_userName = DC.userName, @o_password = DC.userPassword FROM #deviceControllerTable DC
	IF OBJECT_ID('tempdb.dbo.#deviceControllerTable') IS NOT NULL
    DROP TABLE #deviceControllerTable
END
ELSE
BEGIN
SET @o_deviceType = ISNULL((SELECT longVal FROM GRC_CommCellProp WHERE commCellId = @l_CommCellId AND PropId = 34 /*GRC_CLOUD_VENDOR_TYPE_ID*/), 0)
SET @o_rootFolder = ISNULL((SELECT stringVal FROM GRC_CommCellProp WHERE commCellId = @l_CommCellId AND PropId = 37 /*GRC_CLOUD_ROOT_FOLDER*/), '')
SET @o_userName = ISNULL((SELECT stringVal FROM GRC_CommCellProp WHERE commCellId = @l_CommCellId AND PropId = 35 /*GRC_CLOUD_USER_NAME*/), '')
SET @o_password = ISNULL((SELECT stringVal FROM GRC_CommCellProp WHERE commCellId = @l_CommCellId AND PropId = 36 /*GRC_CLOUD_USER_PASSWORD*/), '')
END
SELECT @o_deviceType, @o_rootFolder, @o_userName, @o_password
GO

IF EXISTS (select * from GxQscripts where name = 'CCMGetCloudLibraryInfo')
	delete from GxQscripts where name = 'CCMGetCloudLibraryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetCloudLibraryInfo')
	delete from GXDBVersions where aliasname = 'CCMGetCloudLibraryInfo'
GO

insert into GXDBVersions values(2, 'CCMGetCloudLibraryInfo',  '00010001000200040000', 'CCMGetCloudLibraryInfo', '00010001000200040000')
GO

