

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMGetClientsListXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: CCMGetClientsListXML.sp,v 1.5.14.4 2019/03/27 00:46:22 kbora Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCMGetClientsListXML')
BEGIN
	print '>>> Drop Stored Procedure: CCMGetClientsListXML <<<'
	drop procedure CCMGetClientsListXML
END
IF EXISTS (select * from GxQscripts where name='CCMGetClientsListXML')
	delete from GxQscripts where name = 'CCMGetClientsListXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetClientsListXML')
	delete from GXDBVersions where aliasname = 'CCMGetClientsListXML'
GO
print '... Creating Procedure: CCMGetClientsListXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMGetClientsListXML
  @ccRestoreClients INT
AS
  DECLARE @o_ClientsListXML XML
SET NOCOUNT ON
	DECLARE @errorString varchar(1024)
	SET @errorString = 'ERROR: GENERAL ERROR!'
	DECLARE @tempVMList TABLE ( clientId int)
	INSERT	INTO @tempVMList
	SELECT	DISTINCT prop.componentNameId
	FROM		App_ClientProp prop INNER JOIN APP_Client CL ON prop.componentNameId = CL.id
	WHERE		prop.attrName='Virtual Client' and prop.modified = 0 AND prop.attrVal = '1'
			-- If CCM client, then return the virtual client also so that we can atleast configure it.
			-- This issue was, migrated SQL cluster client is not being returned to name change because it is virtual client.
AND CL.specialClientFlags & 0x20 = 0
	INSERT	INTO @tempVMList
	SELECT	DISTINCT componentNameId
	FROM		App_ClientProp
	WHERE		attrName='Virtual Entity Flags' and modified = 0 AND
	(convert(int,attrVal) & 0x2 = 0x2)
	INSERT INTO @tempVMList
	SELECT CL.id
	FROM APP_Client CL
WHERE CL.specialClientFlags & 0xB = 0xB
	AND NOT EXISTS (SELECT 1 FROM @tempVMList WHERE clientId = CL.id)
	AND NOT EXISTS (SELECT 1 FROM App_ClientProp WHERE componentNameId = CL.id AND attrName LIKE 'IndexingV2%') -- If indexing property exists then it is VSA discovered client but has backups (child VM).
	--
	-- Get clients pointing to this CommServe.
	--
SELECT 	3 AS '@_type_',
			CL.id AS '@clientId',
			dbo.normalizeforxml(CL.name) AS '@clientName',
			CL.GUID AS '@clientGUID'
	FROM	App_Client CL WITH (READUNCOMMITTED)
WHERE	(CL.specialClientFlags & 0x20) = 0 AND CL.id > 1 AND CL.releaseId >= 16
			AND
			(
				@ccRestoreClients = 0
				OR
				(
					(  -- Filter out the virtual client for now
						NOT EXISTS (SELECT 1 FROM @tempVMList WHERE clientId = CL.id)
						-- Filter out Cluster CS Physical Nodes
						AND NOT EXISTS (SELECT 1 FROM APP_VMToPMMap WHERE VMClientId = 2 AND PMClientId = CL.id)
						-- Filter out index server clients
AND NOT EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = CL.id AND attrName = 'Index Server Type'  AND attrVal = 15 AND modified = 0)
            		)
					AND CL.id > 2
				)
			)
	FOR XML PATH('entities'), ROOT('App_GetRemoteClientsForRestoreResp')
	RETURN (0)
CX_ERROR_EXIT:
RAISERROR ('%s' , 16, 1, @errorString)
SELECT ''
RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCMGetClientsListXML')
	delete from GxQscripts where name = 'CCMGetClientsListXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetClientsListXML')
	delete from GXDBVersions where aliasname = 'CCMGetClientsListXML'
GO

insert into GXDBVersions values(2, 'CCMGetClientsListXML',  '00010005001400040000', 'CCMGetClientsListXML', '00010005001400040000')
GO

