

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCMGetCSTreeXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCMGetCSTreeXML.sp,v $ $Id: CCMGetCSTreeXML.sp,v 1.12.14.8 2018/10/22 19:46:40 pankajkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCMGetCSTreeXML')
BEGIN
	print '>>> Drop Stored Procedure: CCMGetCSTreeXML <<<'
	drop procedure CCMGetCSTreeXML
END
IF EXISTS (select * from GxQscripts where name='CCMGetCSTreeXML')
	delete from GxQscripts where name = 'CCMGetCSTreeXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetCSTreeXML')
	delete from GXDBVersions where aliasname = 'CCMGetCSTreeXML'
GO
print '... Creating Procedure: CCMGetCSTreeXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCMGetCSTreeXML
  @i_xml XML
AS
  DECLARE @r_xml XML
SET NOCOUNT ON
DECLARE @csDBName VARCHAR(256)
DECLARE	@isExportFromOtherSQL	INT
DECLARE @nonPrintableChars VARCHAR(256) = 	'%['
                          + CHAR(0)+CHAR(1)+CHAR(2)+CHAR(3)+CHAR(4)
                          + CHAR(5)+CHAR(6)+CHAR(7)+CHAR(8)+CHAR(9)
                          + CHAR(10)+CHAR(11)+CHAR(12)+CHAR(13)+CHAR(14)
                          + CHAR(15)+CHAR(16)+CHAR(17)+CHAR(18)+CHAR(19)
                          + CHAR(20)+CHAR(21)+CHAR(22)+CHAR(23)+CHAR(24)
                          + CHAR(25)+CHAR(26)+CHAR(27)+CHAR(28)+CHAR(29)
                          + CHAR(30)+CHAR(31)+CHAR(127)
                          + ']%'
SELECT
	@csDBName = PARAM.value('@commServDbName', 'VARCHAR(256)'),
	@isExportFromOtherSQL = ISNULL(PARAM.value('@isExportFromOtherSQLInstance', 'INT'), 0)
FROM @i_xml.nodes('/EVGui_getCCMCommCellInfoReq') AS csDbXml(PARAM)
set @csDBName = '['+@csDBName+'].dbo.'
IF(@isExportFromOtherSQL = 1)
BEGIN
	set @csDBName = 'CCM_Export_LinkedServer.'+ @csDBName
END
if(OBJECT_ID('OTHER_CS_DB_APP_Application') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_APP_Application')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_APP_Application FOR '+@csDBName+'APP_Application')
if(OBJECT_ID('OTHER_CS_DB_MMHost') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_MMHost')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_MMHost FOR '+@csDBName+'MMHost')
IF(OBJECT_ID('OTHER_CS_DB_APP_BackupSetName') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_APP_BackupSetName')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_APP_BackupSetName FOR '+@csDBName+'APP_BackupSetName')
IF(OBJECT_ID('OTHER_CS_DB_APP_CommCell') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_APP_CommCell')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_APP_CommCell FOR '+@csDBName+'APP_CommCell')
IF(OBJECT_ID('OTHER_CS_DB_APP_ClientGroup') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_APP_ClientGroup')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_APP_ClientGroup FOR '+@csDBName+'APP_ClientGroup')
IF(OBJECT_ID('OTHER_CS_DB_APP_Client') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_APP_Client')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_APP_Client FOR '+@csDBName+'APP_Client')
IF(OBJECT_ID('OTHER_CS_DB_APP_iDAType') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_APP_iDAType')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_APP_iDAType FOR '+@csDBName+'APP_iDAType')
IF(OBJECT_ID('OTHER_CS_DB_APP_InstanceName') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_APP_InstanceName')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_APP_InstanceName FOR '+@csDBName+'APP_InstanceName')
IF(OBJECT_ID('OTHER_CS_DB_APP_AppTypeGroupAssoc') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_APP_AppTypeGroupAssoc')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_APP_AppTypeGroupAssoc FOR '+@csDBName+'APP_AppTypeGroupAssoc')
if(OBJECT_ID('OTHER_CS_DB_SimInstalledPackages') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_SimInstalledPackages')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_SimInstalledPackages FOR '+@csDBName+'SimInstalledPackages')
if(OBJECT_ID('OTHER_CS_DB_APP_ClientProp') is not null)
BEGIN
	EXEC('DROP SYNONYM OTHER_CS_DB_APP_ClientProp')
END
EXEC('CREATE SYNONYM OTHER_CS_DB_APP_ClientProp FOR '+@csDBName+'APP_ClientProp')
DECLARE @SQLString nvarchar(MAX)
SET @SQLString = N'
DECLARE @r_xml	XML
DECLARE @clntAppTypes TABLE
		(
			clientId	integer,
			appTypeId	integer
		)
DECLARE @clntInstances TABLE
		(
			clientId	integer,
			appTypeId	integer,
			instance	integer
		)
DECLARE @clntBkpSet TABLE
		(
			clientId	integer,
			instance	integer,
			backupSet	integer
		)
DECLARE	@clntGrpXML		XML
DECLARE @clntEntity		XML
INSERT @clntAppTypes
SELECT DISTINCT
		APL.clientId,APL.appTypeId
FROM OTHER_CS_DB_APP_Application APL
INNER JOIN OTHER_CS_DB_APP_AppTypeGroupAssoc ATA ON ATA.appTypeId= APL.appTypeId
INNER JOIN OTHER_CS_DB_APP_iDAType IDA ON IDA.type = APL.appTypeId
 where ATA.appGroupId <> 132	--APPGRP_COMMCELL_MIGRATION_UNSUPPORTED_APPTYPES
 and ATA.typeOfGroup = 0
INSERT @clntInstances
SELECT DISTINCT
		clientId, appTypeId, instance
FROM OTHER_CS_DB_APP_Application
INSERT @clntBkpSet
SELECT DISTINCT
		clientId,instance, backupSet
FROM OTHER_CS_DB_APP_Application APL
INNER JOIN OTHER_CS_DB_APP_BackupSetName BKP ON APL.backupset = BKP.id
WHERE BKP.name  not in (''DR-BackupSet'',''Indexing BackupSet'')
SET @clntEntity	=
(
SELECT
	ACL.id AS ''@clientId'',
	dbo.normalizeforxml(ACL.name) AS ''@clientName'',
	dbo.normalizeforxml(ACL.net_hostName) AS ''@clientHostName'',
	ISNULL((select count(MMH.ClientId) from OTHER_CS_DB_MMHost MMH
			WHERE MMH.ClientId = ACL.id),0 ) AS ''@isMediaAgent'',
(
SELECT
(
SELECT
	dbo.normalizeforxml(iDAType.name) AS ''@appTypename'',
	iDAType.type AS ''@appTypeId'',
 (
SELECT
(
  SELECT
	dbo.normalizeforxml(INSTN.name)	AS ''@instanceName'',
	INSTN.id	AS ''@instanceId'',
	(
SELECT
(
	SELECT
		dbo.normalizeforxml(BSN.name)  AS ''@backupSetName'',
		BSN.id	  AS ''@backupsetId'',
		(
			SELECT
				dbo.normalizeforxml(SCLT.subclientName) AS ''@subclientName'',
				SCLT.id AS ''@subclientId''
			FROM OTHER_CS_DB_APP_Application SCLT
			WHERE SCLT.backupSet = BSN.id
				  AND SCLT.clientId = ACL.id
				  AND SCLT.instance = INSTN.id
				  AND (SCLT.subclientStatus & (2|4|16|32)) = 0
				  FOR XML PATH(''subclientList''),TYPE
		) FROM	OTHER_CS_DB_APP_BackupSetName BSN  WHERE BSN.id = CLTIBS.backupSet
			FOR XML PATH(''backupSetList''),TYPE
		) FROM @clntBkpSet CLTIBS WHERE CLTIBS.instance = INSTN.id AND CLTIBS.clientId = ACL.id
			FOR XML PATH(''''),TYPE
	) FROM OTHER_CS_DB_APP_InstanceName INSTN WHERE INSTN.id = CLTIN.instance
			FOR XML PATH(''instanceList''),TYPE
	) FROM @clntInstances CLTIN  WHERE CLTIN.clientId = ACL.id AND CLTIN.appTypeId = iDAType.type
			FOR XML PATH(''''),TYPE
 ) FROM OTHER_CS_DB_APP_iDAType iDAType WHERE iDAType.type = SCLOUT.appTypeId
			FOR XML PATH(''appTypeEntityList''),TYPE
 ) FROM @clntAppTypes SCLOUT WHERE SCLOUT.clientId = ACL.id
			FOR XML PATH(''''),TYPE
) FROM OTHER_CS_DB_APP_Client	ACL WHERE ACL.id  > 1 AND (ACL.specialClientFlags & (0x20 |  CONVERT(INT,0x1))) = 0
		AND NOT EXISTS (SELECT 1 FROM OTHER_CS_DB_APP_ClientProp WHERE componentNameId = ACL.id AND attrName = ''Index Server Type'' AND attrVal = ''15'')	-- skip indexing clients
		 GROUP BY ACL.id, ACL.name, ACL.net_hostname
			FOR XML PATH(''clientEntityLst''),TYPE
)
SET @clntGrpXML =
		(
			SELECT
				CLGRP.id AS ''@clientGroupId'',
				dbo.normalizeforxml(CLGRP.name) AS ''@clientGroupName''
			FROM	OTHER_CS_DB_APP_ClientGroup CLGRP
					FOR XML PATH(''clientComputerGrp''),TYPE
		)
SET @r_xml =
(
	SELECT
		dbo.normalizeforxml(APCC.aliasName) AS ''@commcellName'',
		APCC.number AS ''@commcellNumber'',
		2 AS ''@commcellId'',
		@clntEntity,
		@clntGrpXML
	FROM OTHER_CS_DB_APP_CommCell APCC
	WHERE APCC.id = 2
			FOR XML PATH(''EVGui_CCMCommCellInfo'')
)
EXEC(''DROP SYNONYM OTHER_CS_DB_APP_Application'')
EXEC(''DROP SYNONYM OTHER_CS_DB_MMHost'')
EXEC(''DROP SYNONYM OTHER_CS_DB_APP_BackupSetName'')
EXEC(''DROP SYNONYM OTHER_CS_DB_APP_CommCell'')
EXEC(''DROP SYNONYM OTHER_CS_DB_APP_ClientGroup'')
EXEC(''DROP SYNONYM OTHER_CS_DB_APP_Client'')
EXEC(''DROP SYNONYM OTHER_CS_DB_APP_iDAType'')
EXEC(''DROP SYNONYM OTHER_CS_DB_APP_InstanceName'')
EXEC(''DROP SYNONYM OTHER_CS_DB_APP_AppTypeGroupAssoc'')
EXEC(''DROP SYNONYM OTHER_CS_DB_SimInstalledPackages'')
EXEC(''DROP SYNONYM OTHER_CS_DB_APP_ClientProp'')
SELECT @r_xml
'
EXEC sp_executesql @SQLString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCMGetCSTreeXML')
	delete from GxQscripts where name = 'CCMGetCSTreeXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCMGetCSTreeXML')
	delete from GXDBVersions where aliasname = 'CCMGetCSTreeXML'
GO

insert into GXDBVersions values(2, 'CCMGetCSTreeXML',  '00010012001400080000', 'CCMGetCSTreeXML', '00010012001400080000')
GO

