

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/BuildSubTaskOptionProc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/BuildSubTaskOptionProc.sp,v $ $Id: BuildSubTaskOptionProc.sp,v 1.3 2011/09/26 14:55:49 sbonilla Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 03/15/2010
-- Description:	Build subt task options
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: BuildSubTaskOptionProc <<<'

IF EXISTS (select * from sysobjects where name='BuildSubTaskOptionProc')
	drop procedure BuildSubTaskOptionProc
IF EXISTS (select * from GxQscripts where name='BuildSubTaskOptionProc')
	delete from GxQscripts where name = 'BuildSubTaskOptionProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BuildSubTaskOptionProc')
	delete from GXDBVersions where aliasname = 'BuildSubTaskOptionProc'
GO
print '... Creating Procedure: BuildSubTaskOptionProc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure BuildSubTaskOptionProc
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @taskId INTEGER,
  @subTaskId INTEGER,
  @optionType INTEGER,
  @bitOption BIGINT OUTPUT
AS
BEGIN
	DECLARE @bitLOption		VARBINARY(MAX)
	DECLARE @bitHOption		VARBINARY(MAX)
	DECLARE @maxBit			INT
	DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
	DECLARE @optionTbl		TABLE (optionId INT, optVal INT)
	DECLARE @optionIdTbl	TABLE (optionId INT)
	DECLARE @defVal			INT
	DECLARE	@bitVal			INT
	DECLARE @count			INT
	SET @count = 0
	SET @bitLOption = 0
	SET @bitHOption = 0
	SET @bitOption = 0
	SET @maxBit = (SELECT TOP (1) bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal DESC)
	INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal
	WHILE @count <= @maxBit
	BEGIN
		DELETE @optionIdTbl
		INSERT INTO @optionIdTbl SELECT optionId FROM @staticTbl WHERE bitVal = @count
		SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
		SET @bitVal = ISNULL((SELECT TOP(1) value FROM TM_SubTaskOptions WITH (READUNCOMMITTED) WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND
								[subTaskId] = @subTaskId), @bitVal)
		IF @bitVal != 0
			IF @count < 31
				SET @bitLOption = @bitLOption + POWER(2, @count)
			ELSE
				SET @bitHOption = @bitHOption + POWER(2, @count-31)
		SET @count = @count + 1
	END
	EXEC GetBigIntFromIntProc @bitHOption, @bitLOption, @bitOption OUTPUT
END
GO

IF EXISTS (select * from GxQscripts where name = 'BuildSubTaskOptionProc')
	delete from GxQscripts where name = 'BuildSubTaskOptionProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BuildSubTaskOptionProc')
	delete from GXDBVersions where aliasname = 'BuildSubTaskOptionProc'
GO

insert into GXDBVersions values(2, 'BuildSubTaskOptionProc',  '00010003000000000000', 'BuildSubTaskOptionProc', '00010003000000000000')
GO

