

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/BuildSubTaskExtOptionProc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/BuildSubTaskExtOptionProc.sp,v $ $Id: BuildSubTaskExtOptionProc.sp,v 1.3 2011/09/26 14:55:49 sbonilla Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 03/15/2010
-- Description:	Build extended subtask options options
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: BuildSubTaskExtOptionProc <<<'

IF EXISTS (select * from sysobjects where name='BuildSubTaskExtOptionProc')
	drop procedure BuildSubTaskExtOptionProc
IF EXISTS (select * from GxQscripts where name='BuildSubTaskExtOptionProc')
	delete from GxQscripts where name = 'BuildSubTaskExtOptionProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BuildSubTaskExtOptionProc')
	delete from GXDBVersions where aliasname = 'BuildSubTaskExtOptionProc'
GO
print '... Creating Procedure: BuildSubTaskExtOptionProc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure BuildSubTaskExtOptionProc
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @taskId INTEGER,
  @subTaskId INTEGER,
  @optionType INTEGER,
  @sOption VARCHAR(MAX) OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @maxBit			INT
	DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
	DECLARE @defVal			INT
	DECLARE	@bitVal			INT
	DECLARE @count			INT
	SET @count = 0
	SET @sOption = ''
	SET @maxBit = (SELECT MAX(bitVal) FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType)
	INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType
	WHILE @count <= @maxBit
	BEGIN
		SET @bitVal = ISNULL((SELECT TOP(1) value FROM TM_SubTaskOptions WITH (READUNCOMMITTED) WHERE optionId IN (SELECT optionId FROM @staticTbl WHERE bitVal = @count) AND
								[subTaskId] = @subTaskId), 3)
		IF @bitVal = 3
			SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
		SET @sOption = @sOption + CAST(@bitVal AS CHAR(1))
		SET @count = @count + 1
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'BuildSubTaskExtOptionProc')
	delete from GxQscripts where name = 'BuildSubTaskExtOptionProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BuildSubTaskExtOptionProc')
	delete from GXDBVersions where aliasname = 'BuildSubTaskExtOptionProc'
GO

insert into GXDBVersions values(2, 'BuildSubTaskExtOptionProc',  '00010003000000000000', 'BuildSubTaskExtOptionProc', '00010003000000000000')
GO

