

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/BuildJobOptionProc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/BuildJobOptionProc.sp,v $ $Id: BuildJobOptionProc.sp,v 1.1 2010/03/17 15:26:14 sbonilla Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 03/15/2010
-- Description:	Build job options
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: BuildJobOptionProc <<<'

IF EXISTS (select * from sysobjects where name='BuildJobOptionProc')
	drop procedure BuildJobOptionProc
IF EXISTS (select * from GxQscripts where name='BuildJobOptionProc')
	delete from GxQscripts where name = 'BuildJobOptionProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BuildJobOptionProc')
	delete from GXDBVersions where aliasname = 'BuildJobOptionProc'
GO
print '... Creating Procedure: BuildJobOptionProc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure BuildJobOptionProc
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @jobId BIGINT,
  @optionType INTEGER,
  @bitOption BIGINT OUTPUT
AS
BEGIN
	DECLARE @bitLOption		VARBINARY(MAX)
	DECLARE @bitHOption		VARBINARY(MAX)
	DECLARE @maxBit			INT
	DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
	DECLARE @optionTbl		TABLE (optionId INT, optVal INT)
	DECLARE @optionIdTbl	TABLE (optionId INT)
	DECLARE @defVal			INT
	DECLARE	@bitVal			INT
	DECLARE @count			INT
	DECLARE @taskId		INT
	DECLARE @subTaskId	INT
	DECLARE @refTime	INT
	SET @count = 0
	SET @bitLOption = 0
	SET @bitHOption = 0
	SET @bitOption = 0
	SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created from TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WHERE jobId=@jobId)
	SET @maxBit = (SELECT TOP (1) bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal DESC)
	INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal
	WHILE @count <= @maxBit
	BEGIN
		DELETE @optionIdTbl
		INSERT INTO @optionIdTbl SELECT optionId FROM @staticTbl WHERE bitVal = @count
		SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
		IF @jobId != 0
		BEGIN
			SET @bitVal = ISNULL((SELECT TOP 1 value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND
					(jobId=@jobId OR (jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime)))), @bitVal)
		END
		IF @bitVal != 0
			IF @count < 31
				SET @bitLOption = @bitLOption + POWER(2, @count)
			ELSE
				SET @bitHOption = @bitHOption + POWER(2, @count-31)
		SET @count = @count + 1
	END
	EXEC GetBigIntFromIntProc @bitHOption, @bitLOption, @bitOption OUTPUT
END
GO

IF EXISTS (select * from GxQscripts where name = 'BuildJobOptionProc')
	delete from GxQscripts where name = 'BuildJobOptionProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BuildJobOptionProc')
	delete from GXDBVersions where aliasname = 'BuildJobOptionProc'
GO

insert into GXDBVersions values(2, 'BuildJobOptionProc',  '00010001000000000000', 'BuildJobOptionProc', '00010001000000000000')
GO

