

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/BLRGetReplicationStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='BLRGetReplicationStats')
BEGIN
	print '>>> Drop Stored Procedure: BLRGetReplicationStats <<<'
	drop procedure BLRGetReplicationStats
END
IF EXISTS (select * from GxQscripts where name='BLRGetReplicationStats')
	delete from GxQscripts where name = 'BLRGetReplicationStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BLRGetReplicationStats')
	delete from GXDBVersions where aliasname = 'BLRGetReplicationStats'
GO
print '... Creating Procedure: BLRGetReplicationStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure BLRGetReplicationStats
  @i_xmlString XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @o_xmlString XML
	DECLARE		@i_userId   		INT = 0
	DECLARE		@i_pairId			INT = 0
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	SET @i_userId = ISNULL((select ref.value('@userId','INT') FROM @i_xmlString.nodes('/BlockReplication_BLRPairStatsReq/processinginstructioninfo/user')  R(ref)),0)
	SET @i_pairId = ISNULL((select ref.value('@pairId','INT') FROM @i_xmlString.nodes('/BlockReplication_BLRPairStatsReq')  R(ref)),0)
	--Get list of instances user has visibility to
EXEC dbo.sec_getIdaObjectsForUser @i_userId, 3, 0, 1, '#getIdaObjects'
	SET @o_xmlString =
	(
		SELECT	BPS.pairId AS '@id',
				BPS.repDataDeltaActual / (BPS.[timeStamp] - LAG(BPS.[timeStamp]) OVER(ORDER BY BPS.id)) AS '@repDataDeltaActual',
				BPS.repDataDeltaComp / (BPS.[timeStamp] - LAG(BPS.[timeStamp]) OVER(ORDER BY BPS.id)) AS '@repDataDeltaComp',
				BPS.ioDelta / (BPS.[timeStamp] - LAG(BPS.[timeStamp]) OVER(ORDER BY BPS.id)) AS '@ioDelta',
				BPS.repSetSize AS '@repSetSize',
				BPS.sizeInRpStore AS '@sizeInRpStore',
				BPS.retention AS '@retention',
				BPS.iopsDelta AS '@iopsDelta',
				(SELECT BPS.timeStamp as '@time'
                FOR XML PATH('timeStamp'), TYPE)
		FROM	BlrPair BP
			INNER JOIN #getIdaObjects sec
				ON BP.headClientId = sec.clientId
			INNER JOIN HistoryDB.dbo.BlrPairStats BPS
				ON BP.id = BPS.pairId AND BP.id = @i_pairId
		WHERE timeStamp > (dbo.GetUnixTime(GETUTCDATE())-(2 * 24 * 3600))
		ORDER BY BPS.timeStamp ASC
		FOR XML PATH('statsList'), ROOT('BlockReplication_BlockReplicationInfo')
	)
	IF (@o_xmlString IS NULL)
		SET @o_xmlString = '<BlockReplication_BlockReplicationInfo />'
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
SELECT @o_xmlString AS 'o_xmlString'
GO

IF EXISTS (select * from GxQscripts where name = 'BLRGetReplicationStats')
	delete from GxQscripts where name = 'BLRGetReplicationStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BLRGetReplicationStats')
	delete from GXDBVersions where aliasname = 'BLRGetReplicationStats'
GO

insert into GXDBVersions values(2, 'BLRGetReplicationStats',  '00000000000000000000', 'BLRGetReplicationStats', '00000000000000000000')
GO

