

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/BLRGetEligibleClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/BLRGetEligibleClients.sp,v $ $Id: BLRGetEligibleClients.sp,v 1.1.2.6 2020/07/15 21:11:19 stelagamsetti Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='BLRGetEligibleClients')
BEGIN
	print '>>> Drop Stored Procedure: BLRGetEligibleClients <<<'
	drop procedure BLRGetEligibleClients
END
IF EXISTS (select * from GxQscripts where name='BLRGetEligibleClients')
	delete from GxQscripts where name = 'BLRGetEligibleClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BLRGetEligibleClients')
	delete from GXDBVersions where aliasname = 'BLRGetEligibleClients'
GO
print '... Creating Procedure: BLRGetEligibleClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure BLRGetEligibleClients
  @i_xmlString XML
AS
  DECLARE @o_responseXML XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @userId INT = ISNULL((SELECT @i_xmlString.value('(/EVGui_BLREligibleClientReq/@userId)[1]','INT')), 0)
	DECLARE @BLRPackageId INT = 755
	-- Do the security check here. We will not be doing it later within loop for client List table.
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects
	(
		clientId INT,
		appTypeId INT,
		instanceID INT,
		backupsetId INT,
		subclientId INT
	)
EXEC sec_getIdaObjectsForUser @userId, 3, 0, 1, '#getIdaObjects'
	DELETE	#getIdaObjects
	FROM	#getIdaObjects sec
		LEFT OUTER JOIN simInstalledPackages SI
			ON sec.clientId = SI.ClientId
		AND SI.OpType IN ('Install', 'Reinstall', 'Release Upgrade', 'Package Sync') AND SI.simPackageID = @BLRPackageId
	WHERE	SI.ClientId IS NULL
	IF OBJECT_ID('tempdb.dbo.#driveList') IS NOT NULL
		DROP TABLE #driveList;
	CREATE TABLE #driveList
       (
              clientId             	INT,
              drive                	NVARCHAR(256),
              pathDefinedAs 		INT
       )
       INSERT INTO   #driveList
       SELECT P.headClientId, D.srcPath , 1 as pathDefinedAs -- This should be same as EVGui.x--> enum PathDefinedAs
       FROM   BlrPair P
              INNER JOIN BlrDisk D
                     ON P.id = D.pairId
       UNION
       SELECT P.tailClientId, D.dstPath, 2 as pathDefinedAs   -- This should be same as EVGui.x--> enum PathDefinedAs
       FROM   BlrPair P
              INNER JOIN BlrDisk D
                     ON P.id = D.pairId
	--=================================================================================================
	  -- Additionally also include the paths used as mount path from Perm Mount page,
	  -- purpose to add these paths is, if a path is being used as mount path ( destination path ) from perm mount, and if that perm mount job is
	  --     still in progress, that same path cannot be used in any pair ( add or edit ) until job is completed.
	  -- This path will be available for use ( on add or edit replication pair ) only after this perm mount job is completed.
	  IF OBJECT_ID('tempdb.dbo.#tmp') IS NOT NULL
				   DROP TABLE #tmp;
	  CREATE TABLE #tmp (val XML)
	  INSERT INTO #tmp
	  SELECT CAST(T.value AS XML)
	  FROM   JMJobInfo J INNER JOIN TM_JobOptions T
				ON J.opType = 135 and T.optionId = 737962015 AND J.jobId = T.jobId
	  INSERT INTO #driveList
	  SELECT
			 c.client.value('@dstProxyClientId', 'int') as 'clientId',
			 m.mp.value('@mountPath', 'NVARCHAR(MAX)') as 'mountPath' ,
			 3 as pathDefinedAs ---This should be same as EVGui.x--> enum PathDefinedAs
	  FROM  #tmp r
				CROSS APPLY r.val.nodes('/operations') c(client)
				CROSS APPLY c.client.nodes('fsMountInfo/mountPathPairs') m(mp)
	  WHERE  c.client.value('@dstProxyClientId', 'int') IS NOT NULL AND m.mp.value('@mountPath', 'NVARCHAR(MAX)') IS NOT NULL;
	  IF OBJECT_ID('tempdb.dbo.#tmp') IS NOT NULL
			DROP TABLE #tmp;
  --=================================================================================================
	--=================================================================================================
	--also include paths those are configured with RP Store for this client,
	--need to add validation for this path on front end side
	--do not allow to use rp store path OR the volume of rp store path as destination path or perm mount path
	INSERT INTO #driveList
	SELECT
		  MMDC.ClientId, MMDC.Folder,  4 AS pathDefinedAs ---This should be same as EVGui.x--> enum PathDefinedAs
	FROM
		  MMMountPath MP
		  INNER JOIN MMMountPathToStorageDevice MPSD ON MPSD.MountPathId = MP.MountPathId
		  INNER JOIN MMDeviceController MMDC ON MMDC.DeviceId = MPSD.DeviceId
		  INNER JOIN MMRPStoreConfig MMRP ON MPSD.MountPathId = MMRP.currMountPathId
	--also include path where commvault is installed,
	--need to add validation for this path on front end side
	--do not allow to use commvault installed path OR the commvault installed path as destination path or perm mount path
	INSERT INTO #driveList
	SELECT
		  componentNameId, attrVal, 5 AS pathDefinedAs ---This should be same as EVGui.x--> enum PathDefinedAs
	FROM
		  APP_ClientProp
	WHERE
		  attrName = 'Patch Local Location' and modified = 0;
	--=================================================================================================
	DELETE #driveList
	FROM   #driveList D
		LEFT OUTER JOIN #getIdaObjects sec
			ON D.clientId = sec.clientId
	WHERE  sec.clientId IS NULL OR ISNULL(D.drive, N'') = N''
       SET @o_responseXML =
       (
              SELECT
                     (SELECT
								(
									SELECT
										D.drive AS 'drivesInPair/@path',
										D.pathDefinedAs AS  'drivesInPair/@pathDefinedAs'
									FROM #driveList D
									WHERE
										D.clientId = R.clientID
									FOR XML PATH (''), type
								),
                                  R.clientId AS 'client/@clientId',
                                  C.name AS 'client/@clientName'
                           FROM #getIdaObjects AS R
                                  INNER JOIN APP_Client C ON R.clientId = C.id
                           FOR XML PATH('eligibleClients'), TYPE)
                     FOR XML PATH(''), ROOT('EVGui_BLREligibleClientsResp')
       )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @o_responseXML = '<EVGui_BLREligibleClientsResp />'
END CATCH
IF @o_responseXML IS NULL
	SET @o_responseXML = '<EVGui_BLREligibleClientsResp/>'
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
    DROP TABLE #getIdaObjects
IF OBJECT_ID('tempdb.dbo.#driveList') IS NOT NULL
	DROP TABLE #driveList
SELECT @o_responseXML AS o_xmlString
GO

IF EXISTS (select * from GxQscripts where name = 'BLRGetEligibleClients')
	delete from GxQscripts where name = 'BLRGetEligibleClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BLRGetEligibleClients')
	delete from GXDBVersions where aliasname = 'BLRGetEligibleClients'
GO

insert into GXDBVersions values(2, 'BLRGetEligibleClients',  '00010001000200060000', 'BLRGetEligibleClients', '00010001000200060000')
GO

