

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/BLRFSSetParentBackupJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  Author: Sergio Bonilla
--  Date:   12/28/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/BLRFSSetParentBackupJobs.sp,v $ $Id: BLRFSSetParentBackupJobs.sp,v 1.1.2.3 2018/10/16 19:47:29 stelagamsetti Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='BLRFSSetParentBackupJobs')
BEGIN
	print '>>> Drop Stored Procedure: BLRFSSetParentBackupJobs <<<'
	drop procedure BLRFSSetParentBackupJobs
END
IF EXISTS (select * from GxQscripts where name='BLRFSSetParentBackupJobs')
	delete from GxQscripts where name = 'BLRFSSetParentBackupJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BLRFSSetParentBackupJobs')
	delete from GXDBVersions where aliasname = 'BLRFSSetParentBackupJobs'
GO
print '... Creating Procedure: BLRFSSetParentBackupJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure BLRFSSetParentBackupJobs
  @iXML XML
AS
  DECLARE @oXML XML
DECLARE @idoc INT
EXEC sp_xml_preparedocument @idoc OUTPUT, @iXML
IF object_id('tempdb.dbo.#parentJobs') is not null DROP TABLE #parentJobs
CREATE TABLE #parentJobs (
		subclientId			INT,
		ParentAppId			INT,
		ParentBackupId		INT,
		ParentCommCellId	INT
		)
INSERT INTO #parentJobs(subclientId, ParentAppId, ParentBackupId, ParentCommCellId)
SELECT DISTINCT *
FROM OPENXML(@idoc, '//Ida_SetBLRSubclientParentJobs/jobsList', 0)
WITH(
    subclientId			INT	'../@BLRSubclientId',
	ParentAppId			INT	'@ParentAppId',
	ParentBackupId		INT	'@ParentBackupId',
	ParentCommCellId	INT	'@ParentCommCellId')
DECLARE @activeIndexCopyJobId	INT = 0
DECLARE	@activeIndexCopyCCId	INT = 0
DECLARE @blrSCId INT = 0
SET @blrSCId = (SELECT @iXML.value('(/Ida_SetBLRSubclientParentJobs/@BLRSubclientId)[1]','INT'))
SELECT @activeIndexCopyJobId = J.jobId, @activeIndexCopyCCId = J.commCellId FROM JMBkpJobInfo J (NOLOCK) WHERE J.applicationId = @blrSCId AND (J.bkpAttributesEx & 0x1000000000000 /*JMBKP_EX_BLR_INDEX_COPY_JOB*/) <> 0
INSERT	INTO BlrParentAppMap (BLRAppId, ParentAppId, IndexCopyJobId, IndexCopyCommcellId, ParentFullCycleNum, flags)
SELECT	P.subclientId, P.ParentAppId, @activeIndexCopyJobId, @activeIndexCopyCCId, J.fullCycleNum, 0
FROM	#parentJobs P
	INNER JOIN JMBkpStats J (NOLOCK)
		ON P.ParentCommCellId = J.commCellId AND P.ParentBackupId = J.jobId
	LEFT OUTER JOIN BlrParentAppMap B
		ON B.BLRAppId = P.subclientId AND B.ParentAppId = P.ParentAppId
WHERE	B.IndexCopyJobId IS NULL
	AND	ISNULL(P.subclientId, 0) > 0
	AND ISNULL(P.ParentAppId, 0) > 0
	AND ISNULL(P.ParentBackupId, 0) > 0
SELECT '<Ida_GenericResp />'
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'BLRFSSetParentBackupJobs')
	delete from GxQscripts where name = 'BLRFSSetParentBackupJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='BLRFSSetParentBackupJobs')
	delete from GXDBVersions where aliasname = 'BLRFSSetParentBackupJobs'
GO

insert into GXDBVersions values(2, 'BLRFSSetParentBackupJobs',  '00010001000200030000', 'BLRFSSetParentBackupJobs', '00010001000200030000')
GO

