

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchUpdateVTLChunkInfo.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchUpdateVTLChunkInfo.sp                                   */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchUpdateVTLChunkInfo.sp,v $ $Id: ArchUpdateVTLChunkInfo.sp,v 1.1.4.5 2020/06/16 17:03:32 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchUpdateVTLChunkInfo')
BEGIN
	print '>>> Drop Stored Procedure: ArchUpdateVTLChunkInfo <<<'
	drop procedure ArchUpdateVTLChunkInfo
END
IF EXISTS (select * from GxQscripts where name='ArchUpdateVTLChunkInfo')
	delete from GxQscripts where name = 'ArchUpdateVTLChunkInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchUpdateVTLChunkInfo')
	delete from GXDBVersions where aliasname = 'ArchUpdateVTLChunkInfo'
GO
print '... Creating Procedure: ArchUpdateVTLChunkInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchUpdateVTLChunkInfo
  @i_Xml xml OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
IF object_id('tempdb.dbo.#tempAFC') IS NOT NULL DROP TABLE #tempAFC
CREATE TABLE #tempChunk (archChunkId BIGINT, chunkCommcellId INT, fileMarkerNo INT, physicalOffset BIGINT, physicalSize BIGINT, logicalOffset BIGINT, logicalSize BIGINT)
CREATE TABLE #tempAFC (archFileId INT, commCellId INT, archCopyId INT)
BEGIN TRY
	INSERT INTO #tempChunk
	SELECT ISNULL(ref.value('@chunkId', 'BIGINT'), 0), ISNULL(ref.value('@commcellId', 'INT'),0),  ISNULL(ref.value('@fileMarkerNo', 'INT'),0),
	ISNULL(ref.value('@physicalOffset', 'BIGINT'), 0),  ISNULL(ref.value('@physicalSize', 'BIGINT'),0),
    ISNULL(ref.value('@logicalOffset', 'BIGINT'), ISNULL(ref.value('@physicalOffset', 'BIGINT'),0)),
	ISNULL(ref.value('@logicalSize', 'BIGINT'), ISNULL(ref.value('@physicalSize', 'BIGINT'),0))
	FROM   @i_Xml.nodes('MediaManager_ArchUpdateVTLChunkInfoReq/chunkList') R ( ref )
	UPDATE	AC
	SET		fileMarkerNo = TC.fileMarkerNo, physicalSize = TC.physicalSize, logicalSize = TC.logicalSize
	FROM	archChunk AC, #tempChunk TC
	WHERE	AC.id = TC.archChunkId
			AND AC.commCellId = TC.chunkCommCellId
	UPDATE	ACM
	SET		physicalOffset = TC.physicalOffset, physicalSize = TC.physicalSize,
			logicalOffset = TC.logicalOffset, logicalSize = TC.logicalSize,
			dedupedSize = TC.physicalSize, unCompSize = TC.physicalSize
	OUTPUT	INSERTED.archFileId, INSERTED.commCellId, INSERTED.archCopyId INTO #tempAFC
	FROM	archChunkMapping ACM, #tempChunk TC
	WHERE	ACM.archChunkId = TC.archChunkId
			AND ACM.chunkCommCellId = TC.chunkCommCellId
	UPDATE	AFC
	SET		physicalSize = tAFC.physicalSize, logicalSize = tAFC.logicalSize
	FROM	archFileCopy AFC,
			(	SELECT ACM.archFileId, ACM.CommCellId, ACM.archCopyID, SUM(ACM.physicalSize) physicalSize, SUM(ACM.logicalSize) logicalSize
				FROM	(SELECT	DISTINCT archFileId, commCellId, archCopyId
						FROM	#tempAFC) T,
						archChunkMapping ACM
				WHERE	T.archFileId = ACM.archFileId
						AND T.commCellId = ACM.commCellId
						AND T.archCopyId = ACM.archCopyId
						AND ACM.chunkNumber > 0
				GROUP BY ACM.archFileId, ACM.CommCellId, ACM.archCopyID) tAFC
	WHERE	AFC.archFileId = tAFC.archFileId
			AND AFC.commCellId = tAFC.commCellId
			AND AFC.archCopyId = tAFC.archCopyId
	SET @i_Xml = (	SELECT	0 AS 'errorCode',
								'' AS 'errorString'
						FOR XML PATH('MediaManager_ArchUpdateVTLChunkInfoResp'), TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @i_Xml = (	SELECT	ERROR_NUMBER() AS 'errorCode',
								ERROR_MESSAGE() AS 'errorString'
						FOR XML PATH('MediaManager_ArchUpdateVTLChunkInfoResp'), TYPE)
	;THROW;
END CATCH
END_OF_PROC:
IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
IF object_id('tempdb.dbo.#tempAFC') IS NOT NULL DROP TABLE #tempAFC
GO

IF EXISTS (select * from GxQscripts where name = 'ArchUpdateVTLChunkInfo')
	delete from GxQscripts where name = 'ArchUpdateVTLChunkInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchUpdateVTLChunkInfo')
	delete from GXDBVersions where aliasname = 'ArchUpdateVTLChunkInfo'
GO

insert into GXDBVersions values(2, 'ArchUpdateVTLChunkInfo',  '00010001000400050000', 'ArchUpdateVTLChunkInfo', '00010001000400050000')
GO

