

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchUpdateSPEEAssoc.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchUpdateSPEEAssoc.sp,v $ $Id: ArchUpdateSPEEAssoc.sp,v 1.2.40.2 2017/02/10 21:21:45 sjohnson Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   ArchUpdateSPEEAssoc   - update Entity client association if search engine is changed on storage property
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchUpdateSPEEAssoc <<<'

IF EXISTS (select * from sysobjects where name='ArchUpdateSPEEAssoc')
	drop procedure ArchUpdateSPEEAssoc
IF EXISTS (select * from GxQscripts where name='ArchUpdateSPEEAssoc')
	delete from GxQscripts where name = 'ArchUpdateSPEEAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchUpdateSPEEAssoc')
	delete from GXDBVersions where aliasname = 'ArchUpdateSPEEAssoc'
GO
print '... Creating Procedure: ArchUpdateSPEEAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchUpdateSPEEAssoc
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT = 1,
  @i_oldCloudId INT,
  @i_newCloudId INT
AS
  DECLARE @o_lastError INT =0
DECLARE @nowTime DATETIME = GETUTCDATE()
DECLARE @nodeDetails TABLE (t_cloudId INT, t_nodeClientId INT)
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
BEGIN TRY
BEGIN TRAN
--get cloudid-clientid association
INSERT INTO  @nodeDetails  (t_cloudId , t_nodeClientId )
SELECT S.CloudId, S.ClientId
FROM DM2SearchServerCoreInfo S WITH (NOLOCK)
WHERE S.CloudId = @i_newCloudId
--update flags for oldcloud to 1 for future refernces
--UPDATE EntityExtractionRule
--SET modifiedTime = @nowTime,
	--flags =1
--WHERE cloudId = @i_oldCloudId
SET @o_lastError = @@ERROR
IF @o_lastError <> 0
	GOTO TRANS_EXIT
--update new cloud already exist, just update the flags to 0
--IF EXISTS (SELECT * FROM EntityExtractionRule WITH (NOLOCK) WHERE CloudId = @i_newCloudId AND flags =1)
--BEGIN
--	UPDATE EntityExtractionRule
--	SET modifiedTime =@nowTime,
--	flags =0
--	WHERE cloudId = @i_newCloudId
--END
--ELSE
--BEGIN
	--else, insert rows into table for newcloud
	--INSERT INTO EntityExtractionRule (EntityID, commcellId , ClientId , subClientId , appTypeId, UserID,  CreationTime, NumItemsProcessed, TotalEntitiesFound, TotalDocsFound, SolrRefTime, Enabled, Flags, cloudId, nodeClientID, ModiFiedTime)
	--SELECT ER.EntityID, ER.commcellId , ER.ClientId , ER.subClientId , ER.appTypeId, @i_userId,  @nowTime, 0, 0, 0, '1970-01-01T00:00:00Z', 1, 0, @i_newCloudId, t_nodeClientID, 0
	--FROM EntityExtractionRule ER
		--	CROSS JOIN @nodeDetails T
	--WHERE cloudId = @i_oldCloudId  AND flags = 1
--END
--SET @o_lastError = @@ERROR
--IF @o_lastError <> 0
	--GOTO TRANS_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ERROR_PROCEDURE() + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_lastError = @@ERROR
END CATCH
TRANS_EXIT:
IF @o_lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
  --------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT @o_lastError
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'ArchUpdateSPEEAssoc')
	delete from GxQscripts where name = 'ArchUpdateSPEEAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchUpdateSPEEAssoc')
	delete from GXDBVersions where aliasname = 'ArchUpdateSPEEAssoc'
GO

insert into GXDBVersions values(2, 'ArchUpdateSPEEAssoc',  '00010002004000020000', 'ArchUpdateSPEEAssoc', '00010002004000020000')
GO

