

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchUpdateEncKeyByClientAndCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchUpdateEncKeyByClientAndCopy.sp,v $ $Id: ArchUpdateEncKeyByClientAndCopy.sp,v 1.1.2.4 2019/06/28 04:12:52 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchUpdateEncKeyByClientAndCopy')
BEGIN
	print '>>> Drop Stored Procedure: ArchUpdateEncKeyByClientAndCopy <<<'
	drop procedure ArchUpdateEncKeyByClientAndCopy
END
IF EXISTS (select * from GxQscripts where name='ArchUpdateEncKeyByClientAndCopy')
	delete from GxQscripts where name = 'ArchUpdateEncKeyByClientAndCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchUpdateEncKeyByClientAndCopy')
	delete from GXDBVersions where aliasname = 'ArchUpdateEncKeyByClientAndCopy'
GO
print '... Creating Procedure: ArchUpdateEncKeyByClientAndCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchUpdateEncKeyByClientAndCopy
  @commCellId integer,
  @archCopyId integer,
  @clientId integer,
  @archFileId integer,
  @encRSA integer,
  @encKeyType integer,
  @encKey varchar(1024),
  @origEncKeyId integer = 0,
  @SIDBStoreId integer = 0
AS
  DECLARE @o_encKeyId integer = 0;
  DECLARE @errorCode integer
DECLARE @DedupeFlags	integer = 0
DECLARE @RowCount		integer = 0
DECLARE @l_encRSA		tinyint = 0
DECLARE @l_encKeyType	int = -1
DECLARE @l_encKey		varchar(1024)
DECLARE @l_encKeyId	integer = 0
DECLARE @l_clientId integer = 0
SET @l_clientId = @clientId
SELECT	@DedupeFlags = DedupeFlags
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @archCopyId
SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
IF	(@errorCode <> 0)
BEGIN
    GOTO ERR_EXIT
END
IF (@RowCount = 0)
BEGIN
	SET	@errorCode = -1
	GOTO ERR_EXIT
END
IF @archFileId > 0
BEGIN
    SELECT @l_clientId = app.clientId
    FROM	ArchFile archfile WITH (NOLOCK), ArchFileCopy filecopy WITH (NOLOCK), App_Application app WITH (NOLOCK)
    WHERE	archfile.Id = filecopy.ArchFileId AND archfile.commcellId = filecopy.commcellId
    AND		archfile.appId = app.Id
    AND		filecopy.ArchFileId = @archFileId
    AND		filecopy.commCellId = @commcellId
    AND		filecopy.archCopyId = @archCopyId
    SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
    IF	(@errorCode <> 0)
    BEGIN
        GOTO ERR_EXIT
    END
    IF (@RowCount = 0)
    BEGIN
        SET	@errorCode = -3
        GOTO ERR_EXIT
    END
END
DECLARE @dependentCopyId integer = @archCopyId
EXEC ArchEncKeyGetDependentCopy @archCopyId, @dependentCopyId OUTPUT, @errorCode OUTPUT
IF @origEncKeyId > 0
AND EXISTS (SELECT 1 FROM ArchGroupCopy WITH (NOLOCK) WHERE Id = @dependentCopyId AND DedupeFlags & 262144 > 0)
AND EXISTS (SELECT 1 FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMCONFIG_ENABLE_ENCRYPTION_SHARING_BASED_ON_CLIENT' and value > 0)
BEGIN
    -- Based on given encKeyId, check if entry exists for given client and copy Id
    -- If not, insert a new key for the client and copy
    SET @l_encKeyId = 0
    SELECT	TOP 1 @l_encKeyId = encKeyId, @l_encKeyType = encKeyType, @l_encKey = encKey, @l_encRSA = @encRSA
    FROM	ArchEncKeys WITH (NOLOCK)
    WHERE	clientId = @l_clientId
    AND		archCopyId = @dependentCopyId
    AND		encKeyType = @encKeyType
    AND		encRSA = @encRSA
    AND		origEncKeyId = @origEncKeyId
    IF @l_encKeyId = 0
    BEGIN
        INSERT INTO ArchEncKeys (clientId, archCopyId, encRSA, encKeyType, encKey, isActive, createTime, expiredTime, origEncKeyId)
        SELECT  @l_clientId, @dependentCopyId, @encRSA, @encKeyType, @encKey, 0, createTime, expiredTime, @origEncKeyId
        FROM    ArchEncKeys WITH (NOLOCK)
        WHERE   encKeyId = @origEncKeyId
        SELECT @l_encKeyId = SCOPE_IDENTITY(), @errorCode = @@ERROR, @RowCount = @@ROWCOUNT
        IF	(@errorCode <> 0)
        BEGIN
            GOTO ERR_EXIT
        END
    END
END
ERR_EXIT:
SELECT @l_encKeyId, @errorCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'ArchUpdateEncKeyByClientAndCopy')
	delete from GxQscripts where name = 'ArchUpdateEncKeyByClientAndCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchUpdateEncKeyByClientAndCopy')
	delete from GXDBVersions where aliasname = 'ArchUpdateEncKeyByClientAndCopy'
GO

insert into GXDBVersions values(2, 'ArchUpdateEncKeyByClientAndCopy',  '00010001000200040000', 'ArchUpdateEncKeyByClientAndCopy', '00010001000200040000')
GO

