

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchSetArchFileOracleBackupPieceOffSet.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  SetArchFileOracleBackupPieceOffSet.sp                                   */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchSetArchFileOracleBackupPieceOffSet.sp,v $ $Id: ArchSetArchFileOracleBackupPieceOffSet.sp,v 1.1.2.1 2019/12/04 23:15:14 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchSetArchFileOracleBackupPieceOffSet')
BEGIN
	print '>>> Drop Stored Procedure: ArchSetArchFileOracleBackupPieceOffSet <<<'
	drop procedure ArchSetArchFileOracleBackupPieceOffSet
END
IF EXISTS (select * from GxQscripts where name='ArchSetArchFileOracleBackupPieceOffSet')
	delete from GxQscripts where name = 'ArchSetArchFileOracleBackupPieceOffSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchSetArchFileOracleBackupPieceOffSet')
	delete from GXDBVersions where aliasname = 'ArchSetArchFileOracleBackupPieceOffSet'
GO
print '... Creating Procedure: ArchSetArchFileOracleBackupPieceOffSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchSetArchFileOracleBackupPieceOffSet
  @i_Xml xml OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	/*
	DECLARE @i_Xml xml = N'<SetArchFileOracleBackupPieceOffSetReq>
									<archFileList archFileId="10" commcellId="2" instanceId= "1">
										<backupPieceList backupPiece="backupPiece1" offSet= "0" />
										<backupPieceList backupPiece="backupPiece2" offSet= "20" />
									</archFileList>
									<archFileList archFileId="20" commcellId="2" instanceId= "1">
										<backupPieceList backupPiece="backupPiece1" offSet= "0" />
										<backupPieceList backupPiece="backupPiece2" offSet= "20" />
									</archFileList>
								</SetArchFileOracleBackupPieceOffSetReq>'
	*/
	IF OBJECT_ID('tempdb.dbo.#archFileOracleBackupPieceTemp') IS NOT NULL DROP TABLE #archFileOracleBackupPieceTemp
	CREATE TABLE #archFileOracleBackupPieceTemp (
		archFileId		INTEGER	NOT NULL,
		commCellId		INTEGER	NOT NULL,
		instanceId		INTEGER	NOT NULL,
		backupPiece		NVARCHAR(512)	NOT NULL,
		offset			BIGINT	NOT NULL,
	)
	CREATE CLUSTERED INDEX archFileOracleBackupPieceTemp_archFileId_commCellId_instanceId_idx ON #archFileOracleBackupPieceTemp(archFileId, commCellId, instanceId)
	BEGIN TRY
		BEGIN TRAN
		INSERT INTO #archFileOracleBackupPieceTemp
		SELECT	af.value('@archFileId', 'INT') archFileId,
				af.value('@commcellId', 'INT') commcellId,
				af.value('@instanceId', 'INT') instanceId,
				bp.value('@backupPiece', 'NVARCHAR(512)') backupPiece,
				bp.value('@offSet', 'BIGINT') offSet
		FROM	@i_Xml.nodes('//MediaManager_SetArchFileOracleBackupPieceOffSetReq/archFileList/backupPieceList') bp(bp) -- Backupup Piece List
				CROSS APPLY bp.nodes('..') af(af) -- Archive File List
		INSERT INTO archFileOracleBackupPiece(archFileId, commcellId, instanceId, backupPiece, offSet)
		SELECT *
		FROM	#archFileOracleBackupPieceTemp
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
		SET @i_Xml = (	SELECT	ERROR_NUMBER() AS 'errorCode',
									ERROR_MESSAGE() AS 'errorString'
							FOR XML PATH('MediaManager_SetArchFileOracleBackupPieceOffSetResp'), TYPE)
		IF @@TRANCOUNT > 0
            ROLLBACK TRAN
		;THROW
	END CATCH
	IF @@TRANCOUNT > 0
        COMMIT TRAN
	SET @i_Xml = (	SELECT	0 AS 'errorCode',
								'' AS 'errorString'
						FOR XML PATH('MediaManager_SetArchFileOracleBackupPieceOffSetResp'), TYPE)
	IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
GO

IF EXISTS (select * from GxQscripts where name = 'ArchSetArchFileOracleBackupPieceOffSet')
	delete from GxQscripts where name = 'ArchSetArchFileOracleBackupPieceOffSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchSetArchFileOracleBackupPieceOffSet')
	delete from GXDBVersions where aliasname = 'ArchSetArchFileOracleBackupPieceOffSet'
GO

insert into GXDBVersions values(2, 'ArchSetArchFileOracleBackupPieceOffSet',  '00010001000200010000', 'ArchSetArchFileOracleBackupPieceOffSet', '00010001000200010000')
GO

