

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchSaveEncKeyByClientAndCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchSaveEncKeyByClientAndCopy.sp,v $ $Id: ArchSaveEncKeyByClientAndCopy.sp,v 1.1.2.3 2019/06/28 04:12:49 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchSaveEncKeyByClientAndCopy')
BEGIN
	print '>>> Drop Stored Procedure: ArchSaveEncKeyByClientAndCopy <<<'
	drop procedure ArchSaveEncKeyByClientAndCopy
END
IF EXISTS (select * from GxQscripts where name='ArchSaveEncKeyByClientAndCopy')
	delete from GxQscripts where name = 'ArchSaveEncKeyByClientAndCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchSaveEncKeyByClientAndCopy')
	delete from GXDBVersions where aliasname = 'ArchSaveEncKeyByClientAndCopy'
GO
print '... Creating Procedure: ArchSaveEncKeyByClientAndCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchSaveEncKeyByClientAndCopy
  @commCellId integer,
  @archCopyId integer,
  @clientId integer,
  @encRSA integer,
  @encType integer,
  @encKeyLen integer,
  @encKeyType integer,
  @encKey varchar(1024),
  @encKeyId integer = 0,
  @archFileId integer,
  @isUpdateArchEncKeysOnly integer = 0
AS
  DECLARE @o_encKeyId integer = 0;
  DECLARE @errorCode integer
DECLARE @SIDBStoreId	integer = 0
DECLARE @DedupeFlags	integer = 0
DECLARE @RowCount		integer = 0
DECLARE @l_encRSA		tinyint = 0
DECLARE @l_encKeyType	int = -1
DECLARE @l_encKey		varchar(1024)
DECLARE @l_encKeyId	integer = 0
DECLARE @l_clientId integer = 0
DECLARE @l_origEncKeyid integer = 0
SET @l_encKeyId = @encKeyId
SET @l_clientId = @clientId
SELECT	@DedupeFlags = DedupeFlags
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @archCopyId
SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
IF	(@errorCode <> 0)
BEGIN
    GOTO ERR_EXIT
END
IF (@RowCount = 0)
BEGIN
	SET	@errorCode = -1
	GOTO ERR_EXIT
END
-- Client id always passed for backup. And it will not for auxcopy.
IF @l_clientId = 0 OR NOT EXISTS (SELECT Id FROM App_Client WITH (NOLOCK) WHERE Id = @l_clientId)
BEGIN
    SELECT @l_clientId = app.clientId
    FROM	ArchFile archfile WITH (NOLOCK), App_Application app WITH (NOLOCK)
    WHERE	archfile.appId = app.Id
    AND     archfile.commcellId = @commcellId
    AND		archfile.Id = @archFileId
    SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
    IF	(@errorCode <> 0)
    BEGIN
        GOTO ERR_EXIT
    END
    IF (@RowCount = 0)
    BEGIN
        SET	@errorCode = -3
        GOTO ERR_EXIT
    END
END
DECLARE @dependentCopyId integer = @archCopyId
EXEC ArchEncKeyGetDependentCopy @archCopyId, @dependentCopyId OUTPUT, @errorCode OUTPUT
IF EXISTS (SELECT 1 FROM ArchGroupCopy WITH (NOLOCK) WHERE Id = @dependentCopyId AND @DedupeFlags & 262144 > 0)
AND EXISTS (SELECT 1 FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMCONFIG_ENABLE_ENCRYPTION_SHARING_BASED_ON_CLIENT' and value > 0)
BEGIN
    IF @l_encKeyId = 0
    BEGIN
        DECLARE @now smalldatetime = GETUTCDATE()
        UPDATE  ArchEncKeys SET isActive = 0, expiredTime = dbo.GETUNIXTIME(@now)
        WHERE	clientId = @l_clientId
        AND		archCopyId = @dependentCopyId
        AND     encKeyType = @encKeyType
        AND		encRSA = @encRSA
        AND		isActive = 1
        --AND		expiredTime = 0
        INSERT INTO ArchEncKeys (clientId, archCopyId, encRSA, encKeyType, encKey, isActive, createTime, expiredTime, origEncKeyId)
        VALUES (@l_clientId, @dependentCopyId, @encRSA, @encKeyType, @encKey, 1, dbo.GETUNIXTIME(@now), 0, 0)
        SELECT @l_encKeyId = SCOPE_IDENTITY(), @errorCode = @@ERROR, @RowCount = @@ROWCOUNT
        IF	(@errorCode <> 0)
        BEGIN
            GOTO ERR_EXIT
        END
    END
    --SET @encRSA = 0
    SET	@encKeyType = 0
    SET	@encKey = ''
END
SET @o_encKeyId = @l_encKeyId
ERR_EXIT:
SELECT @o_encKeyId, @errorCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'ArchSaveEncKeyByClientAndCopy')
	delete from GxQscripts where name = 'ArchSaveEncKeyByClientAndCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchSaveEncKeyByClientAndCopy')
	delete from GXDBVersions where aliasname = 'ArchSaveEncKeyByClientAndCopy'
GO

insert into GXDBVersions values(2, 'ArchSaveEncKeyByClientAndCopy',  '00010001000200030000', 'ArchSaveEncKeyByClientAndCopy', '00010001000200030000')
GO

