

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchPruneHistoryAuditClientGroupAssoc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchPruneHistoryAuditClientGroupAssoc.sp,v $ $Id: ArchPruneHistoryAuditClientGroupAssoc.sp,v 1.1.2.1 2020/01/22 23:44:08 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchPruneHistoryAuditClientGroupAssoc')
BEGIN
	print '>>> Drop Stored Procedure: ArchPruneHistoryAuditClientGroupAssoc <<<'
	drop procedure ArchPruneHistoryAuditClientGroupAssoc
END
IF EXISTS (select * from GxQscripts where name='ArchPruneHistoryAuditClientGroupAssoc')
	delete from GxQscripts where name = 'ArchPruneHistoryAuditClientGroupAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchPruneHistoryAuditClientGroupAssoc')
	delete from GXDBVersions where aliasname = 'ArchPruneHistoryAuditClientGroupAssoc'
GO
print '... Creating Procedure: ArchPruneHistoryAuditClientGroupAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchPruneHistoryAuditClientGroupAssoc
-- Input arguments
  @inRetentionDays INT
AS
  DECLARE @numberRowsAged INT = 0;
BEGIN
	SET NOCOUNT ON
	IF OBJECT_ID('HistoryDB..Audit_ClientGroupAssoc') IS NOT NULL
	BEGIN
		DECLARE @pruneTime INT = dbo.GetUnixTime(DATEADD(day, -@inRetentionDays, GETUTCDATE()))
		-- Delete all rows older than prune time
		-- Should not need batch deletion here with small row size
		DELETE FROM HistoryDB..Audit_ClientGroupAssoc
		WHERE
			createdTime <= @pruneTime
		SET @numberRowsAged = @@ROWCOUNT
	END
	SELECT @numberRowsAged numberRowsAged
END
GO

IF EXISTS (select * from GxQscripts where name = 'ArchPruneHistoryAuditClientGroupAssoc')
	delete from GxQscripts where name = 'ArchPruneHistoryAuditClientGroupAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchPruneHistoryAuditClientGroupAssoc')
	delete from GXDBVersions where aliasname = 'ArchPruneHistoryAuditClientGroupAssoc'
GO

insert into GXDBVersions values(2, 'ArchPruneHistoryAuditClientGroupAssoc',  '00010001000200010000', 'ArchPruneHistoryAuditClientGroupAssoc', '00010001000200010000')
GO

