

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchPickJobOnCopyForRefresh.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchPickJobOnCopyForRefresh')
BEGIN
	print '>>> Drop Stored Procedure: ArchPickJobOnCopyForRefresh <<<'
	drop procedure ArchPickJobOnCopyForRefresh
END
IF EXISTS (select * from GxQscripts where name='ArchPickJobOnCopyForRefresh')
	delete from GxQscripts where name = 'ArchPickJobOnCopyForRefresh'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchPickJobOnCopyForRefresh')
	delete from GXDBVersions where aliasname = 'ArchPickJobOnCopyForRefresh'
GO
print '... Creating Procedure: ArchPickJobOnCopyForRefresh'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchPickJobOnCopyForRefresh
  @i_PickJobReq XML,
  @i_storagePolicyId integer,
  @i_copyId integer
AS
  DECLARE @o_retVal INTEGER;
  DECLARE @o_tranCopyId INTEGER;
  DECLARE @o_jobs VARCHAR(MAX);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
DECLARE @tranCopyId INT = -1
DECLARE @jobs VARCHAR(MAX) ;
DECLARE @i_modifyTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @retVal INT = 0
DECLARE @retValDB INT = -1
DECLARE @pickJob INT = (SELECT ISNULL ((PARAM.value('@pickJob','INTEGER')),0) FROM @i_PickJobReq.nodes('/MediaManager_PickJobReq') AS messageXML(param))
DECLARE @OutputTbl TABLE (retVal int, tranCopyId int)
IF (OBJECT_ID('tempdb..#lt_Jobs') IS NOT NULL) 		DROP TABLE #lt_Jobs
	CREATE TABLE #lt_Jobs (jobId int, commCellId int)
IF (OBJECT_ID('tempdb..#pickedJobs') IS NOT NULL)	DROP TABLE #pickedJobs
	CREATE TABLE #pickedJobs (jobId int, commCellId int)
IF (OBJECT_ID('tempdb..#tempJDS') IS NOT NULL)		DROP TABLE #tempJDS
	CREATE TABLE #tempJDS (jobId int, archGrpId int, archGrpCopyId int, dataType int, status int, disabled int, appId int, commCellId int)
INSERT INTO #lt_Jobs
SELECT
		ISNULL ((PARAM.value('@jobId','INTEGER')),0),
		ISNULL ((PARAM.value('@commCellId','INTEGER')),0)
FROM @i_PickJobReq.nodes('/MediaManager_PickJobReq/jobEntityList') AS messageXML(param)
-- Validity check
-- If copy is dedupe or not
IF NOT EXISTS (
SELECT 1 FROM archGroupCopy  WITH (READUNCOMMITTED)
WHERE id = @i_copyId
AND ((dedupeFlags & 262144) > 0)
)
BEGIN
		SET @retVal = 1
		GOTO PROC_EXIT
	END
-- pick only jobs in mag
INSERT INTO #pickedJobs
SELECT DISTINCT J.jobId,J.commCellId
	FROM archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),#lt_Jobs J
	WHERE AFC.mediaType = 10001
	AND AF.commCellId = AFC.commCellId
	AND AF.commCellId = J.commCellId
	AND AFC.archCopyId = @i_copyId
	AND AF.jobId = J.jobId
IF EXISTS (
SELECT TOP 1 1
	FROM archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),#lt_Jobs J
	WHERE AFC.mediaType <> 10001
	AND AF.commCellId = AFC.commCellId
	AND AF.commCellId = J.commCellId
	AND AFC.archCopyId = @i_copyId
	AND AF.jobId = J.jobId
)
	SET @retVal = 2
IF NOT EXISTS (SELECT 1 FROM #pickedJobs)
	BEGIN
		SET @retVal = 3 --None of jobs picked are on magnetic
		GOTO PROC_EXIT
	END
IF @pickJob = 1			-- When we pick jobs
BEGIN
-- checks if the dp to write to is tape
IF EXISTS ( SELECT TOP 1 1
	FROM archGroupCopy AGC WITH (NOLOCK), MMDataPath DP WITH (NOLOCK)
	WHERE AGC.id = DP.CopyId
		AND DP.SpareGroupId <> 0
		AND AGC.id = @i_copyId
		)
	BEGIN
		SET @retVal = 4 --if the data path for the copy is tape
		GOTO PROC_EXIT
	END
-- Do not allow picking of bad jobs
DELETE J
FROM #pickedJobs J
INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
ON JDS.jobId = J.jobId
WHERE JDS.archGrpCopyId = @i_copyId
AND JDS.disabled & 64 > 0
IF @@ROWCOUNT > 0
	SET @retVal = 5
DELETE J
FROM #pickedJobs J,archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK), IdxSIDBStore S WITH (NOLOCK)
WHERE ACM.jobId = J.jobId
AND ACM.archCopyId = @i_copyId
AND ACM.archChunkId = AC.id
AND ACM.chunkCommCellId = AC.commCellId
AND AC.volumeId = V.VolumeId
AND V.SIDBStoreId = S.SIDBStoreId
AND S.SealedTime = 0
IF @@ROWCOUNT > 0
BEGIN
		SET @retVal = 6 --one or more jobs picked are on an active store
END
IF NOT EXISTS (SELECT 1 FROM #pickedJobs)
BEGIN
		GOTO PROC_EXIT
END
BEGIN TRANSACTION
	-- Enable Media Refresh
	UPDATE archGroupCopy
SET flags |= 33554432
	WHERE id = @i_copyId
AND flags & 33554432 = 0
	SET @retValDB = @@ERROR
    IF (@retValDB <> 0)
    BEGIN
        GOTO PROC_EXIT
    END
	-- Create transitive copy the first time
	IF NOT EXISTS ( SELECT 1 FROM archCopyMediaRefreshProp WHERE copyId = @i_copyId)
	BEGIN
		INSERT INTO @OutputTbl
		EXEC ArchTransitiveCopyCreate @i_copyId,0,0,0,0
		IF ((SELECT retVal FROM @OutputTbl) = 0)
			SELECT @tranCopyId = tranCopyId FROM @OutputTbl
	END
	IF @tranCopyId = -1
		SET @tranCopyId = (SELECT targetCopyId from archCopyMediaRefreshProp where copyId = @i_copyId)
	ELSE
		INSERT INTO archCopySIDBStore
		SELECT @tranCopyId,SIDBStoreId,0,0,0,0
		FROM archCopySIDBStore CS
		WHERE CS.CopyId = @i_copyId
AND ((CS.Flags & 4) > 0)
	-- Update entry to have details of SIDB store etc
	UPDATE AGCD
	SET SIDBStoreId = AGCS.SIDBStoreId, dedupeFlags = AGCS.dedupeFlags, SIDBSnapIntervalHours = AGCS.SIDBSnapIntervalHours, sealStoreTaskId = AGCS.sealStoreTaskId
	, nDataInstance = AGCS.nDataInstance, DDBLimitExtensionTimeStamp = AGCS.DDBLimitExtensionTimeStamp, DDBLimitExtensionTimeStampEncrypted = AGCS.DDBLimitExtensionTimeStampEncrypted
	FROM archGroupCopy AGCD, archGroupCopy AGCS
	WHERE AGCD.id = @tranCopyId
	AND AGCD.sourceCopyId = AGCS.id
	-- Create entry into JDS the first time or update the next time onwards
	INSERT INTO #tempJDS
	SELECT JDS.jobId, archGrpId, @tranCopyId, dataType, status, disabled, appId, JDS.commCellId
	FROM   JMJobDataStats JDS WITH (NOLOCK), #pickedJobs J
	WHERE  JDS.jobId = J.jobId AND archGrpCopyId = @i_copyId AND JDS.commCellId = J.commCellId
		AND status = 100
	SET @retValDB = @@ERROR
	IF (@retValDB <> 0)
	BEGIN
		GOTO PROC_EXIT
	END
	MERGE JMJobDataStats T
	USING #tempJDS S
	ON (S.jobId = T.jobId AND S.archGrpCopyId = T.archGrpCopyId AND S.dataType = T.dataType)
	WHEN MATCHED
		THEN UPDATE
SET    T.status = 101, T.disabled = (CASE WHEN T.disabled & 1 > 0 THEN T.disabled  & ~1 ELSE T.disabled  | 0 END),
					T.auxCopyStatus = 101
	WHEN NOT MATCHED BY TARGET
		THEN INSERT
			VALUES( S.jobId, S.archGrpId, S.archGrpCopyId, S.dataType, 74, 0, 101, 0, S.appId, S.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1 );
	SET @retValDB = @@ERROR
    IF (@retValDB <> 0)
    BEGIN
        GOTO PROC_EXIT
    END
END
ELSE
BEGIN			-- When we unpick jobs
SET @tranCopyId = (SELECT targetCopyId from archCopyMediaRefreshProp where copyId = @i_copyId)
--check if they are not in partially refreshed state and not unpick them
BEGIN TRANSACTION
DELETE J
FROM #pickedJobs J
INNER JOIN JMJobDataStats JDS
ON J.jobId = JDS.jobId
WHERE JDS.archGrpCopyId = @tranCopyId
	AND JDS.status IN (102,103)
-- disable jobs picked for unpick from JDS
UPDATE JDS
SET disabled |= 1 --DO NOT COPY
FROM JMJobDataStats JDS
INNER JOIN #pickedJobs J
ON JDS.jobId = J.jobId
WHERE JDS.archGrpCopyId = @tranCopyId
SET @retValDB = @@ERROR
    IF (@retValDB <> 0)
    BEGIN
        GOTO PROC_EXIT
    END
END
	PROC_EXIT:
    IF (@retValDB = 0)
	BEGIN
		COMMIT TRANSACTION
		SELECT @jobs = COALESCE(@jobs + ', ', '') + CAST(jobId AS varchar(10))
		FROM #pickedJobs
	END
	ELSE IF (@retValDB > 0)
		ROLLBACK TRANSACTION
	IF (OBJECT_ID('tempdb..#lt_Jobs') IS NOT NULL)		DROP TABLE #lt_Jobs
	IF (OBJECT_ID('tempdb..#tempJDS') IS NOT NULL)		DROP TABLE #tempJDS
	IF (OBJECT_ID('tempdb..#pickedJobs') IS NOT NULL)	DROP TABLE #pickedJobs
	SELECT @retVal, @tranCopyId,@jobs
	RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'ArchPickJobOnCopyForRefresh')
	delete from GxQscripts where name = 'ArchPickJobOnCopyForRefresh'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchPickJobOnCopyForRefresh')
	delete from GXDBVersions where aliasname = 'ArchPickJobOnCopyForRefresh'
GO

insert into GXDBVersions values(2, 'ArchPickJobOnCopyForRefresh',  '00000000000000000000', 'ArchPickJobOnCopyForRefresh', '00000000000000000000')
GO

