

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchPerformStartOver.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchPerformStartOver')
BEGIN
	print '>>> Drop Stored Procedure: ArchPerformStartOver <<<'
	drop procedure ArchPerformStartOver
END
IF EXISTS (select * from GxQscripts where name='ArchPerformStartOver')
	delete from GxQscripts where name = 'ArchPerformStartOver'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchPerformStartOver')
	delete from GXDBVersions where aliasname = 'ArchPerformStartOver'
GO
print '... Creating Procedure: ArchPerformStartOver'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchPerformStartOver
  @i_StoragePolicyId integer        
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorMsg NVARCHAR(MAX)
  DECLARE @appId INTEGER
  DECLARE @clientName NVARCHAR (255)
  DECLARE @appTypeName NVARCHAR (255)
  DECLARE @instanceName NVARCHAR (255)
  DECLARE @backupsetName NVARCHAR (255)
  DECLARE @subclientName NVARCHAR(MAX)
  DECLARE @appTypeId INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @errorCode = 0
SET @errorMsg = ''
DECLARE @currentTime                INTEGER
SET     @currentTime                    = dbo.GetUnixTime(GETUTCDATE())
IF OBJECT_ID('tempdb.dbo.#tempApp') IS NOT NULL DROP TABLE #tempApp
CREATE TABLE #tempApp (appId INT PRIMARY KEY(AppId))
IF OBJECT_ID('tempdb.dbo.#tempStartOverSP') IS NOT NULL DROP TABLE #tempStartOverSP
CREATE TABLE #tempStartOverSP (storagePolicyId INT, primaryCopyId INT PRIMARY KEY(storagePolicyId))
CREATE INDEX  tempStartOverSP_IX1 on #tempStartOverSP (primaryCopyId)
IF OBJECT_ID('tempdb.dbo.#tempFullSPsApp') IS NOT NULL DROP TABLE #tempFullSPsApp
CREATE TABLE #tempFullSPsApp (appId INT, fullCycleNUm INT, PRIMARY KEY(AppId))
/*
	--Fetch list of effected clients
	* CPP layer will take care of calling stored proc with proper Storage Policy id
		* Means, if user performed Start-Over on dependent copy, then it is CPP layer job to find and call it with GDSP Id
	Now, we will need to take care of below cases.
	1) Clients directly writing to that storage policy
		* will take care of start-over on non-dedupe case and normal-dedupe case
	2) If it is a GDSP, find dependent primary copies(dont worry about secondary copies, backups run on primary copy only) and find clients writing to those storagePolicies
		* will take care of GDSP base case
	3) If it is a incremental policy for any other full Storage POlicy, then consider clients of full storage policies which have used this incremental policies
		* incremnetal base case
	4) If it is GDSP then perform incemental case on each and every dependent primary copies
	Approach:
	1) Find the storage policies on which start-over is performed
		* Inputted storage policy
		* Storage Policies whose primary copy is dependent on GDSP
	2) Consider all clients associated to above fetched storagePolicies
	--	Incremental case
	3) Now for List of storage Policies, if any of them are incremental policies, then fetch Full SPs.
	4) For all Full SPs, consider only those clients which have jobs on incremental policies, in latest cycle only(fetched in step 1)
*/
;WITH startOverstoragePolicyId_CTE(storagePolicyId, primaryCopyId) --step 1 of Approach
AS (
	--Fetch passed SP and any SP whose primary copy using this GDSP
	SELECT AG.id, AG.defaultCopy
	FROM archGroup AG WITH (NOLOCK)
		INNER JOIN archCopyToGlobalPolicy ACTGP (NOLOCK) ON ACTGP.globalPolicyId = @i_storagePolicyId AND ACTGP.copyID = AG.defaultCopy -- consider only primary Copies
	UNION
	SELECT @i_storagePolicyId, AG.defaultCopy
	FROM archGroup AG (NOLOCK)
	WHERE AG.id = @i_storagePolicyId
)
INSERT INTO #tempStartOverSP
	SELECT DISTINCT storagePolicyId, primaryCopyId FROM  startOverstoragePolicyId_CTE C
INSERT INTO #tempApp
	SELECT DISTINCT(APP.id)
	FROM APP_APPLICATION APP (NOLOCK)
		INNER JOIN #tempStartOverSP  SP ON SP.storagePolicyId = APP.dataArchGrpID OR SP.storagePolicyId = APP.logArchGrpID
;WITH fullStoragePolicies_CTE(storagePolicyId) -- step3 of approach
AS (
	SELECT AG.id
	FROM archGroup AG (NOLOCK)
		INNER JOIN #tempStartOverSP SP ON SP.storagePolicyId = AG.incrSP
	WHERE AG.incrSP > 0
),
fullSPsApps_CTE(appID)
AS (
	SELECT DISTINCT(APP.id)
	FROM APP_APPLICATION APP (NOLOCK)
		INNER JOIN fullStoragePolicies_CTE  SP 			ON SP.storagePolicyId = APP.dataArchGrpID OR SP.storagePolicyId = APP.logArchGrpID
)
INSERT INTO #tempFullSPsApp
	SELECT APP.appID, ISNULL(SCP.attrVal,0)
	FROM fullSPsApps_CTE APP
		LEFT JOIN App_subclientprop SCP (NOLOCK)		ON SCP.componentNameId = APP.appID
														AND SCP.cs_attrname = CHECKSUM(N'sys:full cycle num')
														AND SCP.attrname = N'sys:full cycle num'
														AND SCP.modified = 0
--filter out already selected sub-clients
DELETE F
FROM #tempFullSPsApp F
	INNER JOIN #tempApp A ON A.appId = F.appId
IF EXISTS( SELECT TOP 1 1 FROM #tempFullSPsApp)
BEGIN
	;WITH affectedAPPs_CTE(appId)
	AS (
		SELECT DISTINCT A.appID
		FROM JMBkpStats BS WITH (NOLOCK)
			INNER JOIN JMJobDataStats JDS (NOLOCK) ON JDS.jobid = BS.jobID AND JDS.commCellId = BS.commcellId
			INNER JOIN #tempStartOverSP SOSP ON SOSP.primaryCopyId = JDS.archGrpCopyId
			INNER JOIN #tempFullSPsApp A ON A.appId = JDS.appId AND A.fullCycleNum = BS.fullCycleNum
		WHERE JDS.status <> 1000 --exclude all pruned jobs  -- CVCopyDataState::PRUNED
		UNION
		SELECT DISTINCT A.appID
		FROM JMAdminJobStatsTable AJST WITH (NOLOCK)
			INNER JOIN JMJobDataStats JDS (NOLOCK) ON JDS.jobid = AJST.jobID AND JDS.commCellId = AJST.commcellId
			INNER JOIN #tempStartOverSP SOSP ON SOSP.primaryCopyId = JDS.archGrpCopyId
			INNER JOIN #tempFullSPsApp A ON A.appId = JDS.appId AND A.fullCycleNum = AJST.fullCycleNum
		WHERE JDS.status <> 1000 --exclude all pruned jobs  -- CVCopyDataState::PRUNED
	)
	INSERT INTO #tempApp
		SELECT DISTINCT(AppId)
		FROM affectedAPPs_CTE
END
BEGIN TRY
	BEGIN TRAN
		--Mark next backup for full
		DELETE SCP
		FROM APP_SubClientProp SCP
			INNER JOIN #tempApp APP ON APP.appId = SCP.componentNameId
		WHERE SCP.attrName = N'sys:last full'
			AND SCP.cs_attrName = CHECKSUM(N'sys:last full')
		--Set the reason, for clearing out last full backup time
		UPDATE SCP
		SET SCP.modified = @currentTime
		FROM APP_SubClientProp SCP
			INNER JOIN #tempApp APP ON APP.appId = SCP.ComponentNameId
		WHERE SCP.attrName = N'Reason last backup time cleared'
			AND SCP.cs_attrName = CHECKSUM(N'Reason last backup time cleared') AND SCP.modified = 0
		INSERT INTO APP_SubClientProp
			SELECT  APP.AppId,
					'Reason last backup time cleared', --attrName,
					7, 				--attrType
					44,				--attrVal, CV_CLEAR_START_OVER =44
					@currentTime,
					0,
					0
			FROM #tempApp APP
	COMMIT TRAN
END TRY
BEGIN CATCH
	IF @@TRANCOUNT > 0
		ROLLBACK TRAN
	SET @errorCode = 1
	SET @errorMsg = N'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
    ERROR CODE: ' + CAST(ISNULL(ERROR_NUMBER(), 0) AS VARCHAR) + '
    PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '') + '
    ERROR LINE NO: ' + CAST(ISNULL(ERROR_LINE(), 0) AS VARCHAR)  + '
    ERROR MESSAGE: ' + ISNULL(ERROR_MESSAGE(), '')
END CATCH
IF(@errorCode = 0)
BEGIN
	SELECT @errorCode, @errorMsg, T.appID, C.name, IDA.displayName, I.name, BS.name, A.subclientName, A.appTypeId
	FROM #tempApp T
		INNER JOIN APP_Application A WITH(NOLOCK) ON A.id = T.appId
		INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = A.clientId
		INNER JOIN APP_BackupSetName BS WITH(NOLOCK) ON BS.id = A.backupSet
		INNER JOIN APP_iDAType IDA WITH(NOLOCK) ON IDA.type = A.appTypeId
		INNER JOIN APP_InstanceName I WITH(NOLOCK) ON I.id = A.instance
END
ELSE
BEGIN
	SELECT @errorCode, @errorMsg, 0, '', '', '', '', '', 0
END
IF OBJECT_ID('tempdb.dbo.#tempApp') IS NOT NULL DROP TABLE #tempApp
IF OBJECT_ID('tempdb.dbo.#tempStartOverSP') IS NOT NULL DROP TABLE #tempStartOverSP
IF OBJECT_ID('tempdb.dbo.#tempFullSPsApp') IS NOT NULL DROP TABLE #tempFullSPsApp

IF EXISTS (select * from GxQscripts where name = 'ArchPerformStartOver')
	delete from GxQscripts where name = 'ArchPerformStartOver'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchPerformStartOver')
	delete from GXDBVersions where aliasname = 'ArchPerformStartOver'
GO

insert into GXDBVersions values(2, 'ArchPerformStartOver',  '00000000000000000000', 'ArchPerformStartOver', '00000000000000000000')
GO

