

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchModifyAuxCopySchedules.sp] ---------- 

--#include "AppMgr/AppMgrDefines.h"
--#include "AppMgr/AppTypeDefs.h"
/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchModifyAuxCopySchedules.sp                */
/*                                                                            */
/*  Description :  Stored procedure to check if subclient is eligible		  */
/*				   for selective copy						      			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchModifyAuxCopySchedules.sp,v $ $Id: ArchModifyAuxCopySchedules.sp,v 1.1.2.7 2019/12/27 13:06:28 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchModifyAuxCopySchedules')
BEGIN
	print '>>> Drop Stored Procedure: ArchModifyAuxCopySchedules <<<'
	drop procedure ArchModifyAuxCopySchedules
END
IF EXISTS (select * from GxQscripts where name='ArchModifyAuxCopySchedules')
	delete from GxQscripts where name = 'ArchModifyAuxCopySchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchModifyAuxCopySchedules')
	delete from GXDBVersions where aliasname = 'ArchModifyAuxCopySchedules'
GO
print '... Creating Procedure: ArchModifyAuxCopySchedules'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchModifyAuxCopySchedules
AS
  DECLARE @retVal INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @l_currentTime INT = dbo.GetUnixTime(GetDate())
	DECLARE @l_taskId INT = 0
	DECLARE @l_subTaskId INT = 0
	DECLARE @l_archGroupId INT = 0
	DECLARE @l_archGroupCopyId INT = 0
	DECLARE @l_srcMediaAgentId INT = 0
	DECLARE @l_returnValue INT = 1
	-- None of these temp tables should ever exist when this procedure is called!
	IF OBJECT_ID('tempdb.dbo.#assocTblOutputFromGetAdminEntity') IS NOT NULL
			DROP TABLE #assocTblOutputFromGetAdminEntity
	CREATE TABLE #assocTblOutputFromGetAdminEntity ( policyId INT,  copyId INT, srmReportSet INT, srmReportType INT, trackingPolicyId INT,  mediaAgentId INT, agentLessPolicyId INT, workFlowId INT, sidbStoreId INT, libraryId INT, logMonitoringPolicyId INT,
								entityId INT , entityType INT, dataSourceId INT,
								 clientGroupId INT DEFAULT 0,
								 clientId INT DEFAULT 0,
								 appTypeId INT DEFAULT 0,
								 instanceId INT DEFAULT 0,
								 backupsetId INT DEFAULT 0,
								 appId INT DEFAULT 0,
								 exclude INT DEFAULT 0,
								 workflowOption NVARCHAR(MAX)
								 PRIMARY KEY (policyId, copyId))
	IF OBJECT_ID('tempdb.dbo.#CopyMAVersion') IS NOT NULL
			DROP TABLE #CopyMAVersion
	CREATE TABLE #CopyMAVersion ( copyId INT , OlderMAExist INT, PRIMARY KEY (CopyId))
	-- Enable batching by default on auxiliary copy schedules with use scalable resource option selected
	BEGIN TRY
		IF OBJECT_ID('tempdb.dbo.#subTaskIdTbl') IS NOT NULL
			DROP TABLE #subTaskIdTbl
		CREATE TABLE #subTaskIdTbl
		(
			subTaskId INT,
			taskID INT,
			optUseScalableResourceExist INT,
			markUseScalableResource INT,
			PRIMARY KEY (subTaskId)
		)
		INSERT INTO #subTaskIdTbl
		SELECT	TS.subTaskId, TS.taskId, (CASE WHEN TSO.value IS NULL THEN 0 ELSE 1 END), 0
		FROM	TM_SubTask TS WITH (READUNCOMMITTED)
					LEFT OUTER JOIN TM_SubTaskOptions TSO WITH (READUNCOMMITTED)
ON TS.subTaskId = TSO.subTaskId AND TSO.optionId = 449788653 /*449788653*/
WHERE	TS.operationType = 4003
				AND (TSO.value = 0 OR TSO.value IS NULL)
		DELETE	TS
		FROM	#subTaskIdTbl TS, TM_TASK T WITH (READUNCOMMITTED)
		WHERE	TS.taskId = T.taskId
				AND T.deleted = 1
		DECLARE taskCursor CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
			SELECT	subTaskId, taskId
			FROM	#subTaskIdTbl
		OPEN taskCursor
		FETCH NEXT FROM taskCursor
			INTO @l_subTaskId, @l_taskId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DELETE FROM #assocTblOutputFromGetAdminEntity
			SET @l_returnValue = 1
			SET @l_srcMediaAgentId = 0
			SELECT	@l_srcMediaAgentId = CAST(value AS INT)
			FROM	TM_SubTaskOptions TSO WITH (READUNCOMMITTED)
			WHERE	TSO.SubTaskId = @l_subTaskId
AND optionId = 1564054677
			DECLARE @l_srcMediaAgentVersion INT = 0
			SELECT	@l_srcMediaAgentVersion = CL.releaseId
			FROM	APP_Client CL WITH (NOLOCK)
			WHERE	CL.id = @l_srcMediaAgentId
					AND @l_srcMediaAgentId > 0
			-- if srcMediaAgent is selected and version is less than V11 then use old auxcopy
			IF (@l_srcMediaAgentId > 0 AND @l_srcMediaAgentVersion < 16)
			BEGIN
				SET @l_returnValue = 0
				BREAK
			END
			ELSE
			BEGIN
				EXEC	TM_GetAdminEntity @l_taskId, @l_subTaskId
				DECLARE entityCursor CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
					SELECT	policyId, copyId
					FROM	#assocTblOutputFromGetAdminEntity
				OPEN entityCursor
				FETCH NEXT FROM entityCursor
					INTO @l_archGroupId, @l_archGroupCopyId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					DECLARE @srcCopyIds TABLE (CopyId INT, ArchGroupId integer, isSnapCopy INT)
					--Return false If any of the selected copy is Snap Copy
					DECLARE @returnTable TABLE (
						errorCode INT,	-- newly added for error code.
						id		  INT, -- -- copy id
						policyName VARCHAR(1024),
						copyName VARCHAR(1024),
						archGroupId INT,
						srcCopyId INT,
						copyStartTime INT,
						copyType INT,
						spFlags INT,
						copyFlags INT,
						copyFlagsExt INT,
						copyLevel INT,
						deferredDays INT,
					----  startReadTime INT,
					   markCopiedTime INT,
						maxMultiplex INT,
						dedupeFlags INT,
						encType INT,
						encKeyLen INT,
						isSnapCopy INT,
						isMirrorCopy INT,
						isNasCopy INT,
						isActive INT,
						hasOlderMediaAgent INT Default 0)
					INSERT INTO @returnTable (	errorCode, id, policyName, copyName,
												archGroupId, srcCopyId, copyStartTime, copyType, spFlags, copyFlags, copyFlagsExt,
												copyLevel, deferredDays, markCopiedTime, maxMultiplex,
												dedupeFlags, encType, encKeyLen, isSnapCopy, isMirrorCopy, isNasCopy, isActive)
					EXEC archGetCopyProperties @l_archGroupCopyId, @l_archGroupId
					INSERT INTO @srcCopyIds
					SELECT	srcCopyId, archGroupId, isSnapCopy
					FROM	@returnTable
					INTERSECT
					SELECT	id, archGroupId, isSnapCopy
					FROM	@returnTable
					IF EXISTS (SELECT	*
								FROM	@srcCopyIds R, archGroupControlHost H WITH (READUNCOMMITTED)
								WHERE	R.isSnapCopy = 1
										AND R.archGroupId = H.ArchGroupId)
					BEGIN
						SET @l_returnValue = 0
						BREAK
					END
					-- Check if on the Source Copy mediaagents have MA < V11
					IF (@l_srcMediaAgentId = 0)
					BEGIN
						IF EXISTS ( SELECT 1
									FROM	@srcCopyIds S, #CopyMAVersion M
									WHERE	S.CopyId = M.copyId
											AND M.OlderMAExist = 1)
						BEGIN
							SET @l_returnValue = 0
							BREAK
						END
						DELETE  S
						FROM	@srcCopyIds S, #CopyMAVersion M
						WHERE	S.CopyId = M.copyId
						IF EXISTS (	SELECT	*
									FROM	@srcCopyIds R, MMDataPath DPath WITH (NOLOCK), MMDrivepool DPool WITH (NOLOCK), APP_Client CL WITH (NOLOCK)
									WHERE	DPath.copyId = R.CopyId
											AND DPath.DrivePoolId = DPool.DrivePoolId
											AND DPool.ClientId = CL.id
											AND CL.releaseId < 16
									)
						BEGIN
							INSERT INTO #CopyMAVersion
							SELECT 	S.CopyId, 1
							FROM	@srcCopyIds S
							SET @l_returnValue = 0
							BREAK
						END
						ELSE
						BEGIN
							INSERT INTO #CopyMAVersion
							SELECT 	S.CopyId, 0
							FROM	@srcCopyIds S
						END
					END
					FETCH NEXT FROM entityCursor
						INTO @l_archGroupId, @l_archGroupCopyId
				END
				CLOSE entityCursor
				DEALLOCATE entityCursor
			END
			IF (@l_returnValue = 1)
			BEGIN
				UPDATE	#subTaskIdTbl
				SET		markUseScalableResource = 1
				WHERE	subTaskId = @l_subTaskId
			END
			FETCH NEXT FROM taskCursor
				INTO @l_subTaskId, @l_taskId
		END
		CLOSE taskCursor
		DEALLOCATE taskCursor
		DELETE FROM #subTaskIdTbl
		WHERE	markUseScalableResource = 0
		BEGIN TRAN
		INSERT INTO TM_SubTaskOptions
SELECT	TS.subTaskId, 449788653, 7, 1
		FROM	#subTaskIdTbl TS
		WHERE	TS.optUseScalableResourceExist = 0
		UPDATE	TSO
		SET		value = 1
		FROM	TM_SubTaskOptions TSO, #subTaskIdTbl TS
		WHERE	TSO.subTaskId = TS.subTaskId
AND TSO.optionId = 449788653
		DECLARE @value INT = 1
		UPDATE	TSXO
		SET		xmlValue.modify('replace value of (/TMMsg_JobOption/backupOpts/mediaOpt/auxcopyJobOption/@useScallableResourceManagement)[1] with sql:variable("@value")')
		FROM	TM_SubTaskXMLOptions TSXO, #subTaskIdTbl TS
		WHERE	TSXO.subTaskId = TS.subTaskId
				AND TSXO.xmlValue.exist('/TMMsg_JobOption/backupOpts/mediaOpt/auxcopyJobOption/@useScallableResourceManagement') = 1
		UPDATE	TSXO
		SET		xmlValue.modify('insert attribute useScallableResourceManagement {sql:variable("@value")} as first into (/TMMsg_JobOption/backupOpts/mediaOpt/auxcopyJobOption)[1]')
		FROM	TM_SubTaskXMLOptions TSXO, #subTaskIdTbl TS
		WHERE	TSXO.subTaskId = TS.subTaskId
				AND TSXO.xmlValue.exist('/TMMsg_JobOption/backupOpts/mediaOpt/auxcopyJobOption/@useScallableResourceManagement') = 0
		 -- Age of job XML options
		 UPDATE TM_JobXMLOptions
		 SET	modified = @l_currentTime
		 FROM	TM_JobXMLOptions
				INNER JOIN #subTaskIdTbl subTaskTble ON subTaskTble.subTaskId = TM_JobXMLOptions.subTaskId AND modified = 0
		INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)
		SELECT	0,TM_JobXMLOptions.xmlValue,TM_JobXMLOptions.taskId,TM_JobXMLOptions.subTaskId,0,@l_currentTime, 0
		FROM	#subTaskIdTbl subTaskTble
				INNER JOIN TM_JobXMLOptions ON subTaskTble.subTaskId = TM_JobXMLOptions.subTaskId AND modified=@l_currentTime
		UPDATE TM_JobXMLOptions
		SET		xmlValue.modify('replace value of (/TMMsg_JobOption/backupOpts/mediaOpt/auxcopyJobOption/@useScallableResourceManagement)[1] with sql:variable("@value")')
		FROM	TM_JobXMLOptions
				INNER JOIN #subTaskIdTbl subTaskTble ON subTaskTble.subTaskId = TM_JobXMLOptions.subTaskId AND modified=0
		WHERE	TM_JobXMLOptions.xmlValue.exist('/TMMsg_JobOption/backupOpts/mediaOpt/auxcopyJobOption/@useScallableResourceManagement') = 1
		UPDATE TM_JobXMLOptions
		SET		xmlValue.modify('insert attribute useScallableResourceManagement {sql:variable("@value")} as first into (/TMMsg_JobOption/backupOpts/mediaOpt/auxcopyJobOption)[1]')
		FROM	TM_JobXMLOptions
				INNER JOIN #subTaskIdTbl subTaskTble ON subTaskTble.subTaskId = TM_JobXMLOptions.subTaskId AND modified=0
		WHERE	TM_JobXMLOptions.xmlValue.exist('/TMMsg_JobOption/backupOpts/mediaOpt/auxcopyJobOption/@useScallableResourceManagement') = 0
		-- -- Age of job options
		UPDATE TM_JobOptions
		SET modified = @l_currentTime
		FROM TM_JobOptions
		INNER JOIN #subTaskIdTbl subTaskTble ON
		subTaskTble.subTaskId = TM_JobOptions.subTaskId
AND TM_JobOptions.optionID = 449788653
		AND TM_JobOptions.modified = 0
		AND TM_JobOptions.jobId = 0
		INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)
SELECT 0,449788653, 7, '1', taskId,subTaskId,0,@l_currentTime,0
		FROM #subTaskIdTbl subTaskTble
		-- COMMIT TRAN
		COMMIT TRANSACTION
		SELECT 0
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
		SELECT ERROR_NUMBER()
		;THROW
	END CATCH;
	if object_id('tempdb.dbo.#assocTblOutputFromGetAdminEntity') is not null
			DROP TABLE #assocTblOutputFromGetAdminEntity
GO

IF EXISTS (select * from GxQscripts where name = 'ArchModifyAuxCopySchedules')
	delete from GxQscripts where name = 'ArchModifyAuxCopySchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchModifyAuxCopySchedules')
	delete from GXDBVersions where aliasname = 'ArchModifyAuxCopySchedules'
GO

insert into GXDBVersions values(2, 'ArchModifyAuxCopySchedules',  '00010001000200070000', 'ArchModifyAuxCopySchedules', '00010001000200070000')
GO

