

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchMarkNextBackupFullForDVFailedSCs.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchMarkNextBackupFullForDVFailedSCs.sp					  */
/*                                                                            */
/*  Description :  Stored procedure to Mark next backup as full on subclients */
/*				   when data verification fails on job from last cycle		  */
/*                 1. On primary copy										  */
/*                 2. On Auxiliary copy if job not present on any other copy  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchMarkNextBackupFullForDVFailedSCs.sp,v $ $Id: ArchMarkNextBackupFullForDVFailedSCs.sp,v 1.1.2.5 2020/09/27 01:17:05 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchMarkNextBackupFullForDVFailedSCs')
BEGIN
	print '>>> Drop Stored Procedure: ArchMarkNextBackupFullForDVFailedSCs <<<'
	drop procedure ArchMarkNextBackupFullForDVFailedSCs
END
IF EXISTS (select * from GxQscripts where name='ArchMarkNextBackupFullForDVFailedSCs')
	delete from GxQscripts where name = 'ArchMarkNextBackupFullForDVFailedSCs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchMarkNextBackupFullForDVFailedSCs')
	delete from GXDBVersions where aliasname = 'ArchMarkNextBackupFullForDVFailedSCs'
GO
print '... Creating Procedure: ArchMarkNextBackupFullForDVFailedSCs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchMarkNextBackupFullForDVFailedSCs
  @i_generatedTimeStamp INT,	
  @i_callerType INT	= 0 /* 1 - MM Admin Thread, 0 - Non MM Admin Thread*/
AS
  DECLARE @retVal INTEGER;
  DECLARE @o_generatedTimeStamp INT;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	/*
	Mark next job full when any job in last cycle is marked as DV failed
	1. On primary copy OR
	2. On Secondary copy when job not exist on any other copy with valid state
	*/
	BEGIN TRY
		DECLARE @currentTime 				INTEGER
		DECLARE @attrType 					INTEGER
		DECLARE	@attrName						VARCHAR(1024)
		DECLARE	@attrVal						VARCHAR(1024)
		DECLARE @resetCount		 			INTEGER
		DECLARE @errorCode					INTEGER
		DECLARE @markJobsFull				INTEGER = 0
		DECLARE @lastFullCycleNumXML			XML
		DECLARE @l_retVal INT = 0
		DECLARE @QueryId INT = 0
		/* Output Table
		CREATE TABLE #ArchMarkNextBackupFullForDVFailedSCs_Output (retVal    INTEGER, timeStamp INT)
		*/
		IF OBJECT_ID('tempdb.dbo.#QS_MarkJobsOnCopy_Output') IS NOT NULL DROP TABLE #QS_MarkJobsOnCopy_Output
		CREATE TABLE #QS_MarkJobsOnCopy_Output(Msg NVARCHAR(MAX))
		SET 	@currentTime 					= dbo.GetUnixTime(GETUTCDATE())
		SET 	@attrType							= 7
		SET 	@attrName							= 'Reason last backup time cleared'
SET 	@attrVal							= '43'
		SET		@resetCount 					= 0
		SET		@errorCode						= 0
		DECLARE @fullCycleNumAttrName NVARCHAR(1024) = N'sys:full cycle num'
		DECLARE @csFullCycleNumAttrName INT = CHECKSUM(@fullCycleNumAttrName)
		DECLARE @lastFullAttrName NVARCHAR(1024) = N'sys:last full'
		DECLARE @csLastFullAttrName INT = CHECKSUM(@lastFullAttrName)
		DECLARE @lastBkpTimeClearedAttrName NVARCHAR(1024) = N'Reason last backup time cleared'
		DECLARE @csLastBkpTimeClearedAttrName INT = CHECKSUM(@lastBkpTimeClearedAttrName)
		DECLARE @checkSumAssociatedSP INTEGER = CHECKSUM(N'Associated subclient Policy')
		DECLARE @checkSumIsTurboSC INTEGER = CHECKSUM(N'Is Turbo Subclient')
		DECLARE @checkSumFirstTurboJobId INTEGER = CHECKSUM(N'First Turbo Job Id')
		IF OBJECT_ID('tempdb.dbo.#appInfo') IS NOT NULL DROP TABLE #appInfo
		IF OBJECT_ID('tempdb.dbo.#appJobInfo') IS NOT NULL DROP TABLE #appJobInfo
		if OBJECT_ID('tempdb.dbo.#tblTurboAppId') IS NOT NULL DROP TABLE #tblTurboAppId
		IF OBJECT_ID('tempdb..#jobsToProcess') IS NOT NULL DROP TABLE #jobsToProcess
		CREATE TABLE #appInfo (appId INT, lastFullCycleNum INT, markFull INT PRIMARY KEY(AppId))
		CREATE TABLE #appJobInfo (appId INT, lastFullCycleNum INT, jobId INT, commCellId INT, archGroupCopyId INT, archGroupId INT, isPrimaryCopy INT PRIMARY KEY(AppId, jobId, CommCellId, archGroupCopyId))
		CREATE TABLE #tblTurboAppId(appId int, PRIMARY KEY (appId))
		CREATE TABLE #jobsToProcess (jobId INTEGER, commCellId INTEGER, archGrpCopyId INTEGER, Primary Key (jobId, commCellId, archGrpCopyId) WITH (ignore_dup_key = ON))
		/*
			Output tables
			CREATE TABLE #appIdList (AppId INT PRIMARY KEY (AppId))
			CREATE TABLE #libraryList (LibraryName NVARCHAR(128), MountPathName NVARCHAR(1024))
		*/
		SELECT	@markJobsFull = value
		FROM	MMConfigs WITH (READCOMMITTED)
		WHERE	name = 'MMCONFIG_MARK_NEXT_BKP_FULL_FOR_DV_FAILED_SUBCLIENTS'
		SELECT	@QueryId = Q.QueryId
		FROM	NTQueryList Q WITH (READUNCOMMITTED)
		WHERE	Q.queryName = 'Data Verification Failure Detected Custom Rule'
		IF (@QueryId = 0)
		BEGIN
			SET @l_retVal = -1
			GOTO PROC_EXIT;
		END
		/*If Caller is MM Thread then MMCONFIG_MARK_NEXT_BKP_FULL_FOR_DV_FAILED_SUBCLIENTS is not enabled and if there exist one alert enabled then exit */
		IF ( (@i_callerType = 1) AND (@i_generatedTimeStamp = 0) AND ((@markJobsFull = 0) OR
			EXISTS (SELECT	QM.QueryId
						FROM	NTNotificationQueryMapping QM WITH (READUNCOMMITTED), NTnotificationRule R WITH (READUNCOMMITTED)
						WHERE	QM.QueryId = @QueryId
								AND QM.NtNotificationId = R.id
								AND (R.status & 1 /*NT_STATUS_DISABLED */) = 0)) )
		BEGIN
			SET @l_retVal = -2
			GOTO PROC_EXIT;
		END
		IF (@i_generatedTimeStamp = 0)
		BEGIN
			-- Do not consider the DR Subclient and Online CI Subclient
			/*Do not force full for log subclient of lotus notes DB. They run forever incremental*/
			INSERT INTO #appInfo
			SELECT	componentNameId, CAST(attrVal AS BIGINT), 0
			FROM	App_Application A  WITH (READUNCOMMITTED),App_SubClientProp PROP WITH (READUNCOMMITTED)
			WHERE	A.appTypeId NOT IN (1000, 93)
					AND 	(
A.appTypeId NOT IN(59, 77)
OR A.subclientStatus & 0x0080 = 0
							)
					AND A.id = PROP.componentNameId
					AND PROP.modified = 0
					AND PROP.cs_attrName = @csFullCycleNumAttrName
					AND PROP.attrName = @fullCycleNumAttrName
					AND PROP.attrVal != '0'
AND (A.subclientStatus & 0x00002) = 0
AND (A.subclientStatus & 0x00004) = 0
			/*Do not force full for OnePass subclients*/
			INSERT INTO #tblTurboAppId
			SELECT  DISTINCT T.componentNameId
			FROM	APP_Application APP WITH (READUNCOMMITTED), App_SubclientProp T WITH (READUNCOMMITTED), App_SubclientProp T1 WITH (READUNCOMMITTED)
			WHERE	T.attrName = N'Associated subclient Policy'
					AND	T.cs_attrName = @checkSumAssociatedSP
					AND CAST(T.attrVal AS INT) = APP.Id
					AND	APP.appTypeId = 1030
					AND T.modified = 0
					AND APP.Id = T1.componentNameId
					AND T1.attrName = N'Is Turbo Subclient'
					AND T1.cs_attrName = @checkSumIsTurboSC
					AND T1.attrVal = '1'
					AND T1.modified = 0
			UNION
			SELECT DISTINCT T.componentNameId
			FROM   App_SubclientProp T WITH (READUNCOMMITTED)
			WHERE	T.attrName = N'Is Turbo Subclient'
					AND	T.cs_attrName = @checkSumIsTurboSC
					AND T.attrVal = '1'
					AND T.modified = 0
			DELETE #tblTurboAppId
			WHERE appId NOT IN (    SELECT DISTINCT T.componentNameId
									FROM    App_SubclientProp T WITH (READUNCOMMITTED)
									WHERE   T.attrName = N'First Turbo Job Id'
										AND     T.cs_attrName = @checkSumFirstTurboJobId
										AND     CAST(T.attrVal AS INT) != 0
										AND     T.modified = 0
								)
			DELETE	FROM APP
			FROM	#appInfo APP, #tblTurboAppId TA
			WHERE	APP.AppId = TA.AppId
			-- Reset only those appId for which attrVal is not reset by any other process
			DELETE	FROM APP
			FROM	#appInfo APP LEFT OUTER JOIN APP_SubClientProp PROP
			ON	APP.appId = PROP.componentNameId
			AND	PROP.attrName = @lastFullAttrName
			AND	PROP.cs_attrName = @csLastFullAttrName
			AND	PROP.modified = 0
			WHERE PROP.componentNameId IS NULL
			OR 		PROP.attrVal 	= '0'
			OR 		PROP.attrVal 	= ''
			-- Remove the subclients for deconfigured clients
			DELETE	APP
			FROM	#appInfo APP
					INNER JOIN APP_Application A WITH (READUNCOMMITTED) ON APP.AppId = A.id
					INNER JOIN APP_Client C WITH (READUNCOMMITTED) ON A.ClientId = C.Id
WHERE	(C.Status & 0x00002) = 0x00002
			-- Remove backup activity disabled subclients
			DELETE	#appInfo
			WHERE	dbo.JMIsOpTypeEnabled(4 /*BACKUP*/, 7 /* SUBCLIENT_ENTITY  */, AppId, 0) = 0
			-- Get Data Verification failed jobs in the last full cycle for subclients
			INSERT INTO #appJobInfo
			SELECT	DISTINCT A.appId, A.lastFullCycleNum, JBS.jobId, JBS.commCellId, JDS.archGrpCopyId, JDS.archGrpId, 0
			FROM	#appInfo A, JMBkpStats JBS WITH (READUNCOMMITTED), JMJobDataStats JDS WITH (READUNCOMMITTED)
			WHERE	A.appId = JBS.AppId
					AND A.lastFullCycleNum = JBS.fullCycleNum
					AND JBS.jobId = JDS.jobId
					AND JBS.commCellId = JDS.commCellId
					AND JDS.dataType = 1
					AND JDS.archCheckStatus = 6 /*ACS_FAILED*/
AND	(JDS.disabled & 2048 = 0 OR JDS.disabled & 64 > 0)
AND	JDS.disabled & 256 = 0
			GROUP BY A.appId, A.lastFullCycleNum, JBS.jobId, JBS.commCellId, JDS.archGrpCopyId, JDS.archGrpId
			UPDATE	A
			SET		markFull = 1
			FROM	#appInfo A, #appJobInfo AJ, archGroup AG
			WHERE	A.appId = AJ.AppId
					AND AJ.archGroupId = AG.id
					AND AJ.archGroupCopyId = AG.defaultCopy
			DELETE FROM AJ
			FROM	#appJobInfo AJ, #appInfo A
			WHERE	AJ.AppId = A.appId
					AND A.markFull = 1
			DELETE FROM #appJobInfo
			WHERE EXISTS (SELECT	TOP 1 JobID
							FROM	JMJobDataStats JDS WITH (READUNCOMMITTED)
							WHERE	JDS.JobId = #appJobInfo.jobId
									AND JDS.commCellId = #appJobInfo.commCellId
									AND JDS.archGrpCopyId != #appJobInfo.archGroupCopyId
									AND JDS.dataType = 1
									AND JDS.Status = 100
									AND JDS.archCheckStatus != 6 /*ACS_FAILED*/
AND	JDS.disabled & 64 = 0
AND	JDS.disabled & 256 = 0
						  )
			UPDATE	A
			SET		markFull = 1
			FROM	#appInfo A, #appJobInfo AJ
			WHERE	AJ.AppId = A.appId
			DELETE FROM #appJobInfo
			DELETE FROM #appInfo
			WHERE	markFull = 0
		END
		ELSE
		BEGIN
			SELECT	TOP 1 @lastFullCycleNumXML = CAST(stringVal AS XML)
			FROM	APP_ComponentProp WITH (READUNCOMMITTED)
WHERE	componentType = 20
					AND ComponentId = @QueryId
AND propertyTypeId = 1
					AND Created = @i_generatedTimeStamp
			INSERT INTO #appInfo
			SELECT  ref.value('@AppId', 'INT'),ref.value('@lastFullCycleNum', 'INT'), 1
			FROM    @lastFullCycleNumXML.nodes('/SCs/SC') R ( ref )
			DELETE  A
			FROM	#appInfo A  WITH (READUNCOMMITTED),App_SubClientProp PROP WITH (READUNCOMMITTED)
			WHERE	A.AppId = PROP.componentNameId
					AND PROP.modified = 0
					AND PROP.cs_attrName = @csFullCycleNumAttrName
					AND PROP.attrName = @fullCycleNumAttrName
					AND CAST(PROP.attrVal AS INT) > A.lastFullCycleNum
			SELECT	@markJobsFull = 1
		END
		-- Reset only those appId for which attrVal is not reset by any other process
		DELETE	FROM APP
		FROM	#appInfo APP LEFT OUTER JOIN APP_SubClientProp PROP WITH (READUNCOMMITTED)
		ON	APP.appId = PROP.componentNameId
		AND	PROP.attrName = @lastFullAttrName
		AND	PROP.cs_attrName = @csLastFullAttrName
		AND	PROP.modified = 0
		WHERE PROP.componentNameId IS NULL
		OR 		PROP.attrVal 	= '0'
		OR 		PROP.attrVal 	= ''
		-- Get Data Verification failed jobs in the last full cycle for subclients
		INSERT INTO #appJobInfo
		SELECT	DISTINCT A.appId, A.lastFullCycleNum, JBS.jobId, JBS.commCellId, JDS.archGrpCopyId, JDS.archGrpId, 0
		FROM	#appInfo A, JMBkpStats JBS WITH (READUNCOMMITTED), JMJobDataStats JDS WITH (READUNCOMMITTED)
		WHERE	A.appId = JBS.AppId
				AND A.lastFullCycleNum = JBS.fullCycleNum
				AND JBS.jobId = JDS.jobId
				AND JBS.commCellId = JDS.commCellId
				AND JDS.dataType = 1
				AND JDS.archCheckStatus = 6 /*ACS_FAILED*/
AND	(JDS.disabled & 2048 = 0 OR JDS.disabled & 64 > 0)
AND	JDS.disabled & 256 = 0
		GROUP BY A.appId, A.lastFullCycleNum, JBS.jobId, JBS.commCellId, JDS.archGrpCopyId, JDS.archGrpId
		IF OBJECT_ID('tempdb.dbo.#libraryList') IS NOT NULL
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#mediaList') IS NOT NULL DROP TABLE #mediaList
			CREATE TABLE #mediaList (MediaId INT PRIMARY KEY(MediaId))
			INSERT INTO #mediaList
			SELECT	DISTINCT MV.MediaId
			FROM	#appJobInfo J
					INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON J.jobId = ACM.jobId AND J.commCellId = ACM.commCellId AND J.archGroupCopyId = ACM.archCopyId
					INNER JOIN archChunk AC WITH (READUNCOMMITTED) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
					INNER JOIN MMVolume MV WITH (READUNCOMMITTED) ON AC.volumeId = MV.VolumeId
			INSERT INTO #libraryList
			SELECT	DISTINCT L.AliasName, ISNULL(MP.MountPathName, '')
			FROM	#mediaList T
					INNER JOIN MMMedia M WITH (READUNCOMMITTED) ON T.MediaId = M.MediaId
					INNER JOIN MMLibrary L WITH (READUNCOMMITTED) ON M.LibraryId = L.LibraryId
					LEFT OUTER JOIN MMS2getMountPathNameGUIView MP WITH (READUNCOMMITTED) ON M.MediaId = MP.MediaId
			IF OBJECT_ID('tempdb.dbo.#mediaList') IS NOT NULL DROP TABLE #mediaList
		END
		IF (@markJobsFull = 1)
		BEGIN
			DELETE	APP_SubClientProp
			FROM 	APP_SubClientProp PROP, #appInfo APP
			WHERE	PROP.ComponentNameId = APP.appId
			AND		PROP.attrName = @lastFullAttrName
			AND		PROP.cs_attrName = @csLastFullAttrName
			AND		modified 	= 0
			AND		attrVal 	!= '0'
			AND		attrVal 	!= ''
			UPDATE	APP_SubClientProp
			SET 	modified = @currentTime
			FROM 	APP_SubClientProp PROP, #appInfo APP
			WHERE	PROP.ComponentNameId = APP.appId
			AND		PROP.attrName = @lastBkpTimeClearedAttrName
			AND		PROP.cs_attrName = @csLastBkpTimeClearedAttrName
			AND		PROP.modified = 0
			INSERT INTO APP_SubClientProp
			SELECT 	APP.AppId, @attrName, @attrType, @attrVal, @currentTime, 0, 0
			FROM 	#appInfo APP
			BEGIN TRY
				--mark jobs bad
				WHILE EXISTS (SELECT 1 FROM #appJobInfo)
				BEGIN
					TRUNCATE TABLE #jobsToProcess
					--Pick jobs to retain and mark bad
					;WITH CTE
					AS (
								SELECT TOP 5000 *
								FROM #appJobInfo
								ORDER BY archGroupCopyId, jobId
							)
					DELETE FROM CTE
					OUTPUT DELETED.JobId, DELETED.commCellId, DELETED.archGroupCopyId INTO #jobsToProcess
					DECLARE @l_copyId INT
					--Batching by copy
					DECLARE COPYLIST_CURSOR CURSOR LOCAL FOR
					SELECT DISTINCT archGrpCopyId FROM #jobsToProcess
					OPEN COPYLIST_CURSOR
					FETCH NEXT FROM COPYLIST_CURSOR INTO @l_copyId
					WHILE (@@FETCH_STATUS = 0)
					BEGIN
						DECLARE @opMsgId        INT = 0
						DECLARE @opEvMsgId      INT = 0
						DECLARE @opId           INT = 0
						DECLARE @paramMsgId     INT = 0
						DECLARE @UserId                 INT = 1    --Assume admin user
						DECLARE @spName NVARCHAR(1024) = ''
						DECLARE @copyName NVARCHAR(1024) = ''
						DECLARE @l_archGroupId INT = 0
						SELECT @spName = AG.name, @copyName = AGC.name, @l_archGroupId = AG.id
						FROM   archGroup AG WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED)
						WHERE   AG.id = AGC.archGroupId
						AND AGC.id = @l_copyId
						DECLARE @jobList nvarchar(max) = NULL
						SELECT @jobList = COALESCE(@jobList+', ' ,'') + CAST(jobId as varchar(10))
						FROM #jobsToProcess
						WHERE archGrpCopyId = @l_copyId
						EXEC QS_MarkJobsOnCopy @spName, @copyName, 'markJobsBad', @jobList
						FETCH NEXT FROM COPYLIST_CURSOR INTO @l_copyId
					END
					CLOSE COPYLIST_CURSOR
					DEALLOCATE COPYLIST_CURSOR
				END
			END TRY
			BEGIN CATCH
				IF (CURSOR_STATUS('global', 'COPYLIST_CURSOR') >= -1) OR (CURSOR_STATUS('local', 'COPYLIST_CURSOR') >= -1)
				BEGIN
					IF (CURSOR_STATUS('global', 'COPYLIST_CURSOR') >= 0) OR (CURSOR_STATUS('local', 'COPYLIST_CURSOR') >= 0)
					BEGIN
						CLOSE COPYLIST_CURSOR
					END
					DEALLOCATE COPYLIST_CURSOR
				END
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
				SELECT ERROR_NUMBER()
				;THROW
			END CATCH
		END
		IF OBJECT_ID('tempdb.dbo.#appIdList') IS NOT NULL
		BEGIN
			INSERT INTO #appIdList
			SELECT	DISTINCT A.AppId
			FROM	#appInfo A
		END
		IF (@i_generatedTimeStamp = 0)
		BEGIN
			SET @lastFullCycleNumXML = (SELECT	A.appId AS '@AppId',
												A.lastFullCycleNum AS '@lastFullCycleNum'
										FROM	#appInfo A
										ORDER BY appId
										FOR XML PATH('SC'), ROOT ('SCs'))
			INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)
VALUES (20, @QueryId, 1, 1, 0, 0, CAST(@lastFullCycleNumXML AS NVARCHAR(MAX)), @currentTime, 0)
			;WITH APP_ComponentProp_DeleteCTE
			AS (
				SELECT *, ROW_NUMBER () OVER (ORDER BY created DESC) RowNum
				FROM APP_ComponentProp P WITH (READUNCOMMITTED)
WHERE	componentType = 20
						AND ComponentId = @QueryId
AND propertyTypeId = 1
			)
			DELETE FROM APP_ComponentProp_DeleteCTE
			WHERE	RowNum > 10
		END
PROC_EXIT:
		IF OBJECT_ID('tempdb.dbo.#ArchMarkNextBackupFullForDVFailedSCs_Output') IS NOT NULL
		BEGIN
			INSERT INTO #ArchMarkNextBackupFullForDVFailedSCs_Output
			SELECT @l_retVal, @currentTime
		END
		ELSE
		BEGIN
			SELECT @l_retVal, @currentTime
		END
		IF OBJECT_ID('tempdb.dbo.#appInfo') IS NOT NULL DROP TABLE #appInfo
		IF OBJECT_ID('tempdb.dbo.#appJobInfo') IS NOT NULL DROP TABLE #appJobInfo
		if OBJECT_ID('tempdb.dbo.#tblTurboAppId') IS NOT NULL DROP TABLE #tblTurboAppId
		IF OBJECT_ID('tempdb..#jobsToProcess') IS NOT NULL DROP TABLE #jobsToProcess
		if OBJECT_ID('tempdb.dbo.#QS_MarkJobsOnCopy_Output') IS NOT NULL DROP TABLE #QS_MarkJobsOnCopy_Output
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT ERROR_NUMBER(), 0
		;THROW
	END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'ArchMarkNextBackupFullForDVFailedSCs')
	delete from GxQscripts where name = 'ArchMarkNextBackupFullForDVFailedSCs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchMarkNextBackupFullForDVFailedSCs')
	delete from GXDBVersions where aliasname = 'ArchMarkNextBackupFullForDVFailedSCs'
GO

insert into GXDBVersions values(2, 'ArchMarkNextBackupFullForDVFailedSCs',  '00010001000200050000', 'ArchMarkNextBackupFullForDVFailedSCs', '00010001000200050000')
GO

