

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchIsStubbingAllowed.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchIsStubbingAllowed.sp,v $";
--	+===================================================================+
--	|  					  ArchIsStubbingAllowed							|
--	|		Check if stubbing is allowed for redundancy					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchIsStubbingAllowed')
BEGIN
	print '>>> Drop Stored Procedure: ArchIsStubbingAllowed <<<'
	drop procedure ArchIsStubbingAllowed
END
IF EXISTS (select * from GxQscripts where name='ArchIsStubbingAllowed')
	delete from GxQscripts where name = 'ArchIsStubbingAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchIsStubbingAllowed')
	delete from GXDBVersions where aliasname = 'ArchIsStubbingAllowed'
GO
print '... Creating Procedure: ArchIsStubbingAllowed'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchIsStubbingAllowed
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE	@o_xml				XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @iArchGrpId			INT = 0
	DECLARE @isStubbingAllowed	INT = 1
	DECLARE @r_IsGlusterOrCloud INT = 0
	DECLARE @r_copyCount INT = 0
	-- READ THE XML
	SELECT	@iArchGrpId = ISNULL((ref.value('@storagePolicyId', 'INT')), 0)
	FROM	@i_xmlString.nodes ('App_StubbingAllowedByStoragePolicyReq/storagePolicy') R(ref)
	IF NOT EXISTS (SELECT 1 FROM archGroup WHERE id = @iArchGrpId)
	BEGIN
		SET @isStubbingAllowed = 0
		SET @errorCode = 1
		SET @errorString = 'Storage policy with id ' + CAST(@iArchGrpId AS VARCHAR(16)) + ' does not exist.'
		GOTO PROC_END
	END
	SELECT	@r_IsGlusterOrCloud = 1
	FROM	MMMountPath MP WITH(NOLOCK) INNER JOIN MMDrivePool MDP WITH(NOLOCK) on MP.MasterPoolid = MDP.MasterPoolId
		INNER JOIN MMDataPath DP on MDP.DrivePoolId = DP.DrivePoolId
		INNER JOIN archGroup AG on AG.defaultCopy = DP.CopyId
	WHERE	AG.id = @iArchGrpId
AND	(MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/ OR (MP.Attribute & 64 > 0))
	SELECT @r_copyCount = COUNT(1) FROM archGroupCopy WHERE archGroupId = @iArchGrpId AND isSnapCopy = 0
	IF @r_copyCount <= 1 AND @r_IsGlusterOrCloud <> 1
		SET @isStubbingAllowed	= 0
PROC_END:
   SET @o_xml = (SELECT @isStubbingAllowed AS '@isStubbingAllowed',
						@errorCode AS 'error/@errorCode',
						@errorString AS 'error/@errorMessage'
   FOR XML PATH ('App_StubbingAllowedByStoragePolicyResp' ))
SELECT @o_xml  as 'o_xmlString'
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ArchIsStubbingAllowed')
	delete from GxQscripts where name = 'ArchIsStubbingAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchIsStubbingAllowed')
	delete from GXDBVersions where aliasname = 'ArchIsStubbingAllowed'
GO

insert into GXDBVersions values(2, 'ArchIsStubbingAllowed',  '00000000000000000000', 'ArchIsStubbingAllowed', '00000000000000000000')
GO

