

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchIsSelectiveCopySupportedForSubclient.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchIsSelectiveCopySupportedForSubclient.sp                */
/*                                                                            */
/*  Description :  Stored procedure to check if subclient is eligible		  */
/*				   for selective copy						      			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchIsSelectiveCopySupportedForSubclient.sp,v $ $Id: ArchIsSelectiveCopySupportedForSubclient.sp,v 1.1.2.3 2018/03/20 20:05:22 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchIsSelectiveCopySupportedForSubclient <<<'

IF EXISTS (select * from sysobjects where name='ArchIsSelectiveCopySupportedForSubclient')
	drop procedure ArchIsSelectiveCopySupportedForSubclient
IF EXISTS (select * from GxQscripts where name='ArchIsSelectiveCopySupportedForSubclient')
	delete from GxQscripts where name = 'ArchIsSelectiveCopySupportedForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchIsSelectiveCopySupportedForSubclient')
	delete from GXDBVersions where aliasname = 'ArchIsSelectiveCopySupportedForSubclient'
GO
print '... Creating Procedure: ArchIsSelectiveCopySupportedForSubclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchIsSelectiveCopySupportedForSubclient
  @i_flags INTEGER
AS
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	/*
	Table has to be created before calling this stored procedure
	unSupported1 is for reasons to ignore always for selective copy
	unSupported2 is specific for oracle/sap agents to be checked only in certain conditions. Check caller code for details
	CREATE TABLE #tmpAppIdList(appId int, unSupportedAlways int, unSupportedDB int, isCWEjobValid int, Primary Key(appId))
	*/
	/*
	Reasons -
	EdgeDriveSubClient
	DDB SubClient
	Index SubClient
	Log Cmdline SubClient
	Cmd Line SubClient
	Oracle OnDemand SubClient
	*/
	DECLARE @l_checkSumDDBSubclient INT = CHECKSUM(N'DDB Backup')
	DECLARE @l_checkSumIndexSubclient INT = CHECKSUM(N'Index SubClient')
	DECLARE @l_checkSumMSSQLSubclient INT = CHECKSUM(N'mssql subclient type')
UPDATE T SET unSupportedAlways = CASE WHEN (App.subclientStatus & (CONVERT(INT, 0x20000) | CONVERT(INT, 0x1000)) > 0)
								OR PROP1.id IS NOT NULL
								OR PROP2.id IS NOT NULL
								OR PROP3.id IS NOT NULL
								-- Take jobs only from the default subclient for SQL iDAs
OR ( (App.subclientStatus & 0x00008 = 0) AND App.AppTypeId IN (4, 16, 70) )
								THEN 1 ELSE 0 END,
unSupportedDB = CASE WHEN (Ins.Status & 0x0800 = 0x0800)
OR (App.subclientStatus & 0x0040 = 0x0040)
				 						THEN 1 ELSE 0 END,
				 isCWEjobValid = IDAT.isCWEjobValid
	FROM #tmpAppIdList T INNER JOIN App_Application App WITH(NOLOCK) ON T.appId = App.id
	 	INNER JOIN App_InstanceName Ins WITH(NOLOCK) ON App.instance = Ins.id
	 	INNER JOIN App_iDAType IDAT WITH(NOLOCK) ON App.appTypeId = IDAT.type
		LEFT OUTER JOIN APP_SubClientProp PROP1 WITH (NOLOCK) ON App.id = PROP1.componentNameId AND PROP1.cs_attrName = @l_checkSumDDBSubclient AND PROP1.attrName = 'DDB Backup' AND PROP1.attrVal = N'1' AND PROP1.modified = 0
		LEFT OUTER JOIN APP_SubClientProp PROP2 WITH (NOLOCK) ON App.id = PROP2.componentNameId AND PROP2.cs_attrName = @l_checkSumIndexSubclient AND PROP2.attrName = 'Index SubClient' AND PROP2.attrVal = N'1' AND PROP2.modified = 0
		-- Exclude FFG subclients for SQL iDAs from selective copies since 6.1
LEFT OUTER JOIN APP_SubClientProp PROP3 WITH (NOLOCK) ON App.appTypeId = 81 AND App.id = PROP3.componentNameId AND PROP3.cs_attrName = @l_checkSumMSSQLSubclient AND PROP3.attrName = 'mssql subclient type' AND PROP3.attrVal = N'2' AND PROP3.modified = 0
GO

IF EXISTS (select * from GxQscripts where name = 'ArchIsSelectiveCopySupportedForSubclient')
	delete from GxQscripts where name = 'ArchIsSelectiveCopySupportedForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchIsSelectiveCopySupportedForSubclient')
	delete from GXDBVersions where aliasname = 'ArchIsSelectiveCopySupportedForSubclient'
GO

insert into GXDBVersions values(2, 'ArchIsSelectiveCopySupportedForSubclient',  '00010001000200030000', 'ArchIsSelectiveCopySupportedForSubclient', '00010001000200030000')
GO

